/*
 * Decompiled with CFR 0.152.
 */
package util;

import gui.editor.DataEditor;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import path.ResPath;
import util.Debug;
import util.FileUtils;
import util.JavaVMOptions;

public class ProgramInfo {
    private static boolean SIMULATE_PUBLIC_IN_NETBEANS = false;
    private static HashMap<String, String> info = new HashMap();
    private static boolean is_public = false;
    private static boolean is_saving_enabled = true;
    private static String version_num = "8.1";

    public static boolean isPublic() {
        return is_public;
    }

    public static boolean isSavingEnabled() {
        return is_saving_enabled;
    }

    public static void setSavingEnabled(boolean new_status) {
        is_saving_enabled = new_status;
    }

    public static boolean put(String key, String value) {
        if (info.containsKey(key)) {
            info.put(key, value);
            return true;
        }
        Debug.print("WARNING: attempted to add an unknown ProgramInfo key: " + key + " with value: " + value);
        return false;
    }

    public static String get(String key) {
        return info.get(key);
    }

    public static File getDir(String key) {
        File dir = new File(info.get(key));
        return dir;
    }

    private ProgramInfo() {
    }

    static {
        info.put("TSC_VERSION", "");
        info.put("TSC_VERSION_NUMBER", "");
        info.put("TSC_MEM_AVAILABLE_BYTES", "");
        info.put("TSC_JVM_VERSION", "");
        info.put("TSC_ICON_FILENAME", "");
        info.put("TSC_LICENSEE", "");
        info.put("TSC_ICON_FILENAME", "");
        info.put("TSC_WEBSITE_URL", "");
        info.put("TSC_WEBSITE_USERNAME", "");
        info.put("TSC_WEBSITE_PASSWORD", "");
        info.put("TSC_NOTICE_TEXT", "");
        info.put("TSC_DEFAULT_DATAPACK", "");
        info.put("TSC_BASE_SQLITE_DATABASE", "");
        info.put("SERVER_NEW_SETTINGS", "");
        info.put("SERVER_TEMP_SETTINGS", "");
        info.put("SERVER_USED_SETTINGS", "");
        info.put("SERVER_OUTPUT_SETTINGS", "");
        info.put("SERVER_PDF_OUTPUT", "");
        info.put("SERVER_PDF_TEMP", "");
        info.put("SERVER_DATAPACKS", "");
        info.put("SERVER_COL_PACKS", "");
        info.put("SERVER_COL_OUTPUT", "");
        try {
            is_public = !JavaVMOptions.isJar() && SIMULATE_PUBLIC_IN_NETBEANS ? true : !DataEditor.doIExist();
        }
        catch (ClassNotFoundException cnfe) {
            is_public = true;
        }
        catch (NoClassDefFoundError e) {
            is_public = true;
        }
        is_saving_enabled = true;
        ProgramInfo.put("TSC_MEM_AVAILABLE_BYTES", "" + Runtime.getRuntime().maxMemory());
        ProgramInfo.put("TSC_JVM_VERSION", System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        ProgramInfo.put("TSC_VERSION_NUMBER", version_num);
        if (is_public) {
            ProgramInfo.put("TSC_VERSION", ProgramInfo.get("TSC_VERSION_NUMBER"));
        } else {
            ProgramInfo.put("TSC_VERSION", "PRO" + ProgramInfo.get("TSC_VERSION_NUMBER"));
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            ProgramInfoHandler handler = new ProgramInfoHandler();
            reader.setContentHandler(handler);
            reader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            reader.parse(new InputSource(FileUtils.getInputStream(ResPath.getPath("settings_xml.versioninfo"))));
        }
        catch (Exception e) {
            Debug.critical("Unable to read " + ResPath.getPath("settings_xml.versioninfo") + ".  Exception was: " + e.toString());
            throw new RuntimeException(e.toString());
        }
        if (!FileUtils.doesFileExist(ProgramInfo.get("TSC_ICON_FILENAME"))) {
            ProgramInfo.put("TSC_ICON_FILENAME", "");
        }
    }

    protected static class ProgramInfoHandler
    implements ContentHandler {
        String tempText;
        boolean accumulateText = false;

        protected ProgramInfoHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("keyval")) {
                String key = attributes.getValue("key");
                String value = attributes.getValue("value");
                ProgramInfo.put(key, value);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

