/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.TransectColumn;
import model.TransectPolygonData;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class TransectPolygonDataStorage
extends DataStorage {
    public static void insert(TransectPolygonData data) {
        Query query = new Query("INSERT INTO #.transect_polygons       (id, data_id, transect_columns_id, patterns_id, deleted )       VALUES (NULL, :data_id, :transect_column_id, :pattern_id, :deleted) ");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("transect_column_id", data.getColumn().getIdentifier().getId());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setInt("pattern_id", data.getPattern().getIdentifier().getId());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(TransectPolygonData data) {
        Query query = new Query("UPDATE #.transect_polygons       SET transect_columns_id = :transect_column_id,         patterns_id = :pattern_id       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("transect_column_id", data.getColumn().getIdentifier().getId());
        query.setInt("pattern_id", data.getPattern().getIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT patterns_id, deleted, last_modified, creation_date              FROM #.transect_polygons             WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(TransectColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.transect_polygons as transectpoly ON ( data.id = transectpoly.data_id )       WHERE transectpoly.transect_columns_id = :transect_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted         AND NOT transectpoly.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("transect_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

