/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.Datapack;
import model.ModelIdentifier;
import model.storage.Query;
import model.storage.Storage;
import model.util.SourceResult;

public class DatapackStorage
extends Storage {
    public static void insert(Datapack datapack) {
        Query query = new Query("INSERT INTO #.datapacks       (id, parent_id, name, format_version,         date, age_units, default_chronostrat,        chart_title, deleted)       VALUES (NULL, :parent_id, :name, :format_version,         :date, :age_units, :default_chronostrat,         :chart_title, :deleted)");
        query.useDatabase(datapack.getIdentifier().getDatabase());
        if (datapack.hasParent()) {
            query.setInt("parent_id", datapack.getParent().getIdentifier().getId());
        } else {
            query.setNull("parent_id");
        }
        query.setString("name", datapack.getName());
        query.setDouble("format_version", datapack.getFormatVersion());
        query.setString("date", datapack.getDate());
        query.setString("age_units", datapack.getAgeUnits());
        query.setString("default_chronostrat", datapack.getDefaultChronostrat());
        query.setString("chart_title", datapack.getChartTitle());
        query.setBoolean("deleted", datapack.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(Datapack datapack) {
        Query query = new Query("UPDATE #.datapacks       SET parent_id = :parent_id, name = :name,         format_version = :format_version,         date = :date, age_units = :age_units,         default_chronostrat = :default_chronostrat,        chart_title = :chart_title,         deleted = :deleted       WHERE id = :id");
        query.useDatabase(datapack.getIdentifier().getDatabase());
        if (datapack.hasParent()) {
            query.setInt("parent_id", datapack.getParent().getIdentifier().getId());
        } else {
            query.setNull("parent_id");
        }
        query.setString("name", datapack.getName());
        query.setDouble("format_version", datapack.getFormatVersion());
        query.setString("date", datapack.getDate());
        query.setString("age_units", datapack.getAgeUnits());
        query.setString("default_chronostrat", datapack.getDefaultChronostrat());
        query.setString("chart_title", datapack.getChartTitle());
        query.setBoolean("deleted", datapack.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        Query query = new Query("SELECT '#' as database, parent_id, name,         format_version, date, age_units,         default_chronostrat, chart_title,         deleted, creation_date,         last_modified       FROM #.datapacks       WHERE id = :id");
        for (ModelIdentifier id : ids) {
            query.setInt("id", id.getId());
            query.useDatabase(id.getDatabase());
            results.addAll(query.executeQuery());
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByTitle(String name) {
        Query query = new Query("SELECT '#' AS database, col.id AS id       FROM #.datapacks       WHERE col.name LIKE :name         AND NOT deleted ");
        query.setString("name", name);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

