/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.ModelIdentifier;
import model.storage.Query;
import model.storage.Storage;
import model.util.SourceResult;

public class DataStorage
extends Storage {
    private static int count = 0;

    public static void insert(Data data) {
        if (data.getBeginAge() > data.getEndAge()) {
            data.setBeginAge(0.0);
        }
        Query query = new Query("INSERT INTO #.data         (id, begin_age, end_age, uncertainty, priority,         popup, deleted)       VALUES (NULL, :begin_age, :end_age, :uncertainty,         :priority, :popup, :deleted)");
        query.useDatabase(data.getDataIdentifier().getDatabase());
        query.setDouble("begin_age", data.getBeginAge());
        query.setDouble("end_age", data.getEndAge());
        query.setString("uncertainty", data.getUncertainty());
        query.setInt("priority", data.getPriority());
        query.setString("popup", data.getPopup());
        query.setBoolean("deleted", data.isDataDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(Data data) {
        Query query = new Query("UPDATE #.data       SET begin_age = :begin_age, end_age = :end_age,         uncertainty = :uncertainty, priority = :priority,         popup = :popup       WHERE id = :id");
        query.useDatabase(data.getDataIdentifier().getDatabase());
        query.setInt("id", data.getDataIdentifier().getId());
        query.setDouble("begin_age", data.getBeginAge());
        query.setDouble("end_age", data.getEndAge());
        query.setString("uncertainty", data.getUncertainty());
        query.setInt("priority", data.getPriority());
        query.setString("popup", data.getPopup());
        query.executeUpdate();
        query.close();
    }

    public static SourceResult load(ModelIdentifier id) {
        ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
        ids.add(id);
        List<SourceResult> list = DataStorage.load(ids);
        if (list.isEmpty()) {
            return new SourceResult();
        }
        return list.get(0);
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        Query query = new Query("SELECT begin_age, end_age, uncertainty, priority,         popup, deleted, last_modified, creation_date       FROM #.data       WHERE id = :id");
        for (ModelIdentifier id : ids) {
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            results.addAll(query.executeQuery());
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(Column col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, id       FROM #.data       WHERE columns_id = :column_id         AND begin_age >= :begin_age         AND end_age <= :end_age        AND NOT deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        return query.executeQuery();
    }
}

