/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.TransectPolygonData;
import model.storage.Storage;
import model.storage.TransectLineStorage;
import model.util.SourceResult;

public class TransectLine {
    private ModelIdentifier identifier = null;
    private TransectPolygonData polygon = null;
    private double startAge = 0.0;
    private double endAge = 0.0;
    private double startWidth = 0.0;
    private double endWidth = 0.0;
    private String type = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public TransectLine(String database) {
        this.setIdentifier(new ModelIdentifier(0, database, 24));
    }

    protected TransectLine(TransectPolygonData polygon, ModelIdentifier identifier, SourceResult result) {
        this.setPolygon(polygon);
        this.setIdentifier(identifier);
        this.setStartAge(result.getDouble("start_age"));
        this.setEndAge(result.getDouble("end_age"));
        this.setStartWidth(result.getDouble("start_width"));
        this.setEndWidth(result.getDouble("end_width"));
        this.setType(result.getString("type"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    public final void save() {
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            TransectLineStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            TransectLineStorage.update(this);
        }
    }

    public TransectPolygonData getPolygon() {
        return this.polygon;
    }

    public final void setPolygon(TransectPolygonData polygon) {
        this.polygon = polygon;
    }

    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public double getStartWidth() {
        return this.startWidth;
    }

    public final void setStartWidth(double startWidth) {
        this.startWidth = startWidth;
    }

    public double getEndWidth() {
        return this.endWidth;
    }

    public final void setEndWidth(double endWidth) {
        this.endWidth = endWidth;
    }

    public double getStartAge() {
        return this.startAge;
    }

    public final void setStartAge(double startAge) {
        this.startAge = startAge;
    }

    public double getEndAge() {
        return this.endAge;
    }

    public final void setEndAge(double endAge) {
        this.endAge = endAge;
    }

    public String getType() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static List<TransectLine> getById(TransectPolygonData polygon, List<ModelIdentifier> ids) {
            ArrayList<TransectLine> transectLineData = new ArrayList<TransectLine>();
            List<SourceResult> results = TransectLineStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                transectLineData.add(new TransectLine(polygon, ids.get(i), results.get(i)));
            }
            return transectLineData;
        }

        public static List<TransectLine> getByPolygon(TransectPolygonData polygon) {
            List<SourceResult> results = TransectLineStorage.findByPolygon(polygon);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 24);
            return Factory.getById(polygon, ids);
        }
    }
}

