/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.ModelIdentifier;
import model.TransectPolygonData;
import model.TransectTextData;
import model.storage.Storage;
import model.storage.TransectColumnStorage;
import model.util.SourceResult;

public class TransectColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public TransectColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 22));
    }

    public TransectColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            TransectColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            TransectColumnStorage.update(this);
        }
    }

    public List<TransectPolygonData> getPolygonByAge(double startAge, double endAge) {
        return TransectPolygonData.Factory.getByAge(this, startAge, endAge);
    }

    public List<TransectTextData> getTextByAge(double startAge, double endAge) {
        return TransectTextData.Factory.getByAge(this, startAge, endAge);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static List<TransectColumn> getByTitle(String title) {
            List<SourceResult> results = TransectColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 22);
            return Factory.getByIdentifiers(ids);
        }

        public static TransectColumn getByIdentifier(ModelIdentifier id) {
            List<Object> transectColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            transectColumns = Factory.getByIdentifiers(ids);
            if (transectColumns.isEmpty()) {
                return null;
            }
            return (TransectColumn)transectColumns.get(0);
        }

        public static List<TransectColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<TransectColumn> transectColumns = new ArrayList<TransectColumn>();
            List<SourceResult> results = TransectColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                transectColumns.add(new TransectColumn(ids.get(i), results.get(i)));
            }
            return transectColumns;
        }
    }
}

