/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.util.SourceResult;

public class ModelIdentifier {
    public static final int COLUMN = 1;
    public static final int DATA = 2;
    public static final int BLANK_COLUMN = 3;
    public static final int BLOCK_COLUMN = 4;
    public static final int BLOCK_DATA = 5;
    public static final int CHRON_COLUMN = 6;
    public static final int CHRON_DATA = 7;
    public static final int EVENT_COLUMN = 8;
    public static final int EVENT_DATA = 9;
    public static final int FACIES_COLUMN = 10;
    public static final int FACIES_DATA = 11;
    public static final int FREEHAND_COLUMN = 12;
    public static final int FREEHAND_IMAGE_DATA = 13;
    public static final int FREEHAND_POLYGON_DATA = 14;
    public static final int FREEHAND_POINT = 15;
    public static final int POINT_COLUMN = 16;
    public static final int POINT_DATA = 17;
    public static final int RANGE_COLUMN = 18;
    public static final int RANGE_DATA = 19;
    public static final int SEQUENCE_COLUMN = 20;
    public static final int SEQUENCE_DATA = 21;
    public static final int TRANSECT_COLUMN = 22;
    public static final int TRANSECT_POLYGON_DATA = 23;
    public static final int TRANSECT_LINE = 24;
    public static final int TRANSECT_TEXT_DATA = 25;
    public static final int PATTERN = 26;
    public static final int DATAPACK = 27;
    private int id = 0;
    private String database = "";
    private int type = 0;

    public ModelIdentifier(int id, String database, int type) {
        this.id = id;
        this.database = database;
        this.type = type;
    }

    public boolean isColumn() {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    public boolean isData() {
        switch (this.type) {
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 4: {
                return "Block";
            }
            case 6: {
                return "Chron";
            }
            case 8: {
                return "Event";
            }
            case 10: {
                return "Facies";
            }
            case 12: {
                return "Freehand";
            }
            case 16: {
                return "Point";
            }
            case 18: {
                return "Range";
            }
            case 20: {
                return "Sequence";
            }
            case 3: 
            case 22: {
                return "Blank";
            }
        }
        return "";
    }

    public String toString() {
        return "id: " + this.id + " database: " + this.database + " type: " + this.type;
    }

    public static class Factory {
        public static ModelIdentifier translateSourceResult(SourceResult result, int type) {
            ArrayList<SourceResult> results = new ArrayList<SourceResult>();
            results.add(result);
            List<ModelIdentifier> ids = Factory.translateSourceResult(results, type);
            if (ids.isEmpty()) {
                return null;
            }
            return ids.get(0);
        }

        public static List<ModelIdentifier> translateSourceResult(List<SourceResult> results, int type) {
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            String idKey = "id";
            if (results == null) {
                return ids;
            }
            if (type == 1) {
                idKey = "columns_id";
            }
            for (SourceResult result : results) {
                ids.add(new ModelIdentifier(result.getInt(idKey), result.getString("database"), type));
            }
            return ids;
        }
    }
}

