/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.ChronColumn;
import model.Column;
import model.Data;
import model.ModelIdentifier;
import model.storage.ChronDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class ChronData
extends Data {
    private ModelIdentifier identifier = null;
    private String polarity = "";
    private String label = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public ChronData(ChronColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 7));
    }

    public ChronData(ChronColumn c, ModelIdentifier id, SourceResult result) {
        super((Column)c, result);
        this.setIdentifier(id);
        this.setPolarity(result.getString("polarity"));
        this.setLabel(result.getString("label"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            ChronDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            ChronDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getPolarity() {
        return this.polarity;
    }

    public String getLabel() {
        return this.label;
    }

    public final void setPolarity(String polarity) {
        this.polarity = polarity;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static ChronData getByIdentifier(ChronColumn c, ModelIdentifier id) {
            List<Object> chronData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            chronData = Factory.getByIdentifiers(c, ids);
            if (chronData.isEmpty()) {
                return null;
            }
            return (ChronData)chronData.get(0);
        }

        public static List<ChronData> getByIdentifiers(ChronColumn c, List<ModelIdentifier> ids) {
            ArrayList<ChronData> chronData = new ArrayList<ChronData>();
            List<SourceResult> results = ChronDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                chronData.add(new ChronData(c, ids.get(i), results.get(i)));
            }
            return chronData;
        }

        public static List<ChronData> getByAge(ChronColumn c, double top, double bottom) {
            List<SourceResult> results = ChronDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 7);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

