/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import datastore.DataColumn;
import datastore.DataColumnChangeEvent;
import datastore.DataColumnChangeListener;
import datastore.MetaColumn;
import gui.tree.DataColumnTreePanel;
import gui.tree.NodeChangeEvent;
import gui.tree.TreeNodeChangeEventListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class DataColumnTreeNode
extends DefaultMutableTreeNode
implements DataColumnChangeListener {
    public DataColumn col;
    public DataColumnTreePanel panel;
    protected Vector changeListeners = new Vector();

    public DataColumnTreeNode(DataColumn col) {
        this.col = col;
        this.panel = new DataColumnTreePanel();
        this.panel.setNode(this);
        this.panel.setToColumn(col);
        col.addCheckBoxPanel(this.panel);
        col.addChangeListener(this);
    }

    public void createChildNodes() {
        if (this.col instanceof MetaColumn) {
            MetaColumn mc = (MetaColumn)this.col;
            Iterator<DataColumn> iter = mc.getSubColumns();
            while (iter.hasNext()) {
                DataColumn c = iter.next();
                DataColumnTreeNode nn = new DataColumnTreeNode(c);
                nn.changeListeners = this.changeListeners;
                this.add(nn);
                NodeChangeEvent evt = new NodeChangeEvent(3, this, this.getIndex(nn));
                this.fireChange(evt);
                nn.createChildNodes();
            }
        }
    }

    @Override
    public void DataColumnChanged(DataColumnChangeEvent evt) {
        NodeChangeEvent e = null;
        if (evt.getSource() != this.col) {
            System.out.println("DataColunTreeNode change event not for this column.");
            return;
        }
        int type = 1;
        block0 : switch (evt.getType()) {
            case 4: {
                type = 1;
                break;
            }
            case 3: {
                type = 1;
                this.panel.setChecked(this.col.isSelected());
                break;
            }
            case 2: {
                type = 2;
                switch (evt.getStructChangeType()) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        MetaColumn mc = (MetaColumn)this.col;
                        for (int i = evt.structFrom; i <= evt.structTo; ++i) {
                            DataColumnTreeNode nn = new DataColumnTreeNode(mc.getColumnByIndex(i));
                            nn.changeListeners = this.changeListeners;
                            if (i >= this.getChildCount()) {
                                this.add(nn);
                            } else {
                                this.insert(nn, i);
                            }
                            e = new NodeChangeEvent(3, this, this.getIndex(nn));
                            this.fireChange(e);
                            nn.createChildNodes();
                        }
                        return;
                    }
                    case 2: {
                        for (int i = evt.structFrom; i <= evt.structTo; ++i) {
                            this.remove(i);
                            e = new NodeChangeEvent(4, this, i);
                            this.fireChange(e);
                        }
                        return;
                    }
                    case 3: {
                        MutableTreeNode n = (MutableTreeNode)this.getChildAt(evt.structFrom);
                        this.insert(n, evt.structTo);
                        break block0;
                    }
                }
                System.out.println("DataColumnTreeNode received unknown struct event: " + evt.getStructChangeType());
                break;
            }
            default: {
                System.out.println("DataColumnTreeNode received unknown event: " + evt.getType());
            }
        }
        if (e == null) {
            e = new NodeChangeEvent(type, this, 0);
        }
        this.fireChange(e);
    }

    protected void fireChange(NodeChangeEvent e) {
        for (TreeNodeChangeEventListener l : this.changeListeners) {
            l.TreeNodeChanged(e);
        }
    }

    public void addChangeListener(TreeNodeChangeEventListener c) {
        this.changeListeners.add(c);
    }
}

