/*
 * Decompiled with CFR 0.152.
 */
package gui.transect;

import datastore.Coloring;
import datastore.Datastore;
import datastore.TransectColumn;
import gui.ActionDialog;
import gui.ErrorHandler;
import gui.ExtensionFileFilter;
import gui.ModifyTextField;
import gui.RichText;
import gui.StringWrappingInfo;
import gui.TSCColumnPreview;
import gui.TSCFont;
import gui.TSCSVGUserAgent;
import gui.TSCreator;
import gui.transect.TransectLoaderSVGUserAgent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.DefaultPointsHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsParser;
import org.apache.batik.parser.TransformListParser;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import util.FileUtils;
import util.Point;
import util.Util;

public class TemplateLoader
extends JDialog
implements ActionListener {
    private JButton bCancel;
    private JPanel buttons;
    private ModifyTextField tMergDist;
    private JLabel jLabel4;
    private JButton bSave;
    private ModifyTextField tTitle;
    private JButton generatePreview;
    private JPanel previewOptions;
    private TSCColumnPreview previewSVGPanel;
    private JPanel previewPanel;
    private ModifyTextField tAgeSpacing;
    private JCheckBox cbSnapXGrid;
    private ModifyTextField tWidth;
    private JLabel jLabel7;
    private JEditorPane lNotes;
    private ModifyTextField tXSpacing;
    private JCheckBox cbSnapAgeGrid;
    private ModifyTextField tBaseAge;
    private ModifyTextField tTopAge;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JButton bAddCol;
    private JPanel options;
    private JLabel jLabel5;
    private JLabel tNumPolys = null;
    private JLabel jLabel6;
    protected DOMImplementation impl;
    protected SVGDocument doc;
    protected SVGGraphics2D g;
    protected TransectColumn transCol = new TransectColumn("Transect");
    protected boolean isColValid = false;
    protected Datastore db;
    protected double topAge = 0.0;
    protected double baseAge = 100.0;
    protected double mergeDistance = 4.0;
    protected double gridX = 5.0;
    protected double gridY = 0.2;
    protected boolean useXGrid = true;
    private JScrollPane jScrollPane1;
    private JEditorPane popupEditor;
    private ButtonGroup textSizeRadioGroup;
    private JRadioButton radioKeepBoth;
    private JRadioButton radioKeepOnlyY;
    private JRadioButton radioKeepFonts;
    private JLabel jLabel8;
    protected boolean useAgeGrid = true;
    protected double clipSX = Double.NaN;
    protected double clipSY;
    protected double clipEX;
    private JLabel popupWarning;
    private JScrollPane jScrollPane2;
    protected double clipEY;
    protected Vector parsedPointsSVG = new Vector();
    protected Vector mergedPointsSVG = new Vector();
    protected Map pointsParsedToMerged = new HashMap();
    protected Map pointsMergedtoCol = new HashMap();
    protected Vector polygonsSVG = new Vector();
    protected Vector textSVG = new Vector();
    protected Vector labelsSVG = new Vector();
    protected Vector styleLines = new Vector();
    protected TransectColumn.Polygon popupEditingPoly = null;
    protected TemplatePolygon popupEditingPolySVG = null;

    public TemplateLoader(JFrame frame) {
        super(frame);
        this.initGUI();
        this.initializeGraphicsContext(null);
    }

    public TemplateLoader(JFrame frame, String filename, Datastore db) {
        super(frame);
        this.db = db;
        this.initializeGraphicsContext(filename);
        ActionDialog ad = new ActionDialog("Loading Transect Template SVG...");
        try {
            ad.setVisible(true);
            this.parseTransectSVG(filename);
            ad.setVisible(false);
            this.initGUI();
            this.setTitle("Transect Template Loader - " + filename);
            this.setVisible(true);
            this.generatePreview.doClick();
        }
        catch (Exception e) {
            ad.setVisible(false);
            ErrorHandler.showError(e, null, "Error loading file!", 64);
            this.dispose();
        }
    }

    protected final void initializeGraphicsContext(String filename) {
        if (filename == null) {
            this.impl = SVGDOMImplementation.getDOMImplementation();
            this.doc = (SVGDocument)this.impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
            this.g = new SVGGraphics2D(this.doc);
        } else {
            try {
                SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
                this.doc = f.createSVGDocument(FileUtils.getURLExternOnly(filename).toString());
                this.g = new SVGGraphics2D(this.doc);
            }
            catch (IOException e) {
                System.out.println("Can't build SVG Doc from actual template, using default.");
                this.initializeGraphicsContext(null);
            }
        }
    }

    private void initGUI() {
        try {
            this.options = new JPanel();
            GridBagLayout optionsLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.options, "West");
            this.options.setBorder(BorderFactory.createTitledBorder("Options"));
            optionsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 1.0};
            optionsLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 20, 7, 62, 7, 20, 7, 20, 7, 20, 7, 20, -1, 7, 20, 7, 7, 20, 7};
            optionsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            optionsLayout.columnWidths = new int[]{88, 7, 39, 7, 23, 7};
            this.options.setLayout(optionsLayout);
            this.options.setPreferredSize(new Dimension(460, 370));
            this.jLabel1 = new JLabel();
            this.options.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Top Age:");
            this.jLabel2 = new JLabel();
            this.options.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Base Age:");
            this.jLabel3 = new JLabel();
            this.options.add((Component)this.jLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText("Title:");
            this.tTitle = new ModifyTextField(true, false);
            this.options.add((Component)this.tTitle, new GridBagConstraints(2, 4, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tTitle.setText(this.transCol.getName());
            this.tTitle.addActionListener(this);
            this.jLabel4 = new JLabel();
            this.options.add((Component)this.jLabel4, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel4.setText("point merge distance:");
            this.jLabel5 = new JLabel();
            this.options.add((Component)this.jLabel5, new GridBagConstraints(4, 8, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel5.setText("<html>If two points are less than this distance apart in the original SVG file, they are assumed to be the same point.</html>");
            this.jLabel6 = new JLabel();
            this.options.add((Component)this.jLabel6, new GridBagConstraints(0, 21, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel6.setText("# of polygons found:");
            this.tNumPolys = new JLabel();
            this.options.add((Component)this.tNumPolys, new GridBagConstraints(2, 21, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tNumPolys.setText("" + this.transCol.polygons.size());
            this.tMergDist = new ModifyTextField(true, false);
            this.options.add((Component)this.tMergDist, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tMergDist.setText("" + this.mergeDistance);
            this.tMergDist.addActionListener(this);
            this.tTopAge = new ModifyTextField(true, false);
            this.options.add((Component)this.tTopAge, new GridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tTopAge.setText("" + this.topAge);
            this.tTopAge.addActionListener(this);
            this.tBaseAge = new ModifyTextField(true, false);
            this.options.add((Component)this.tBaseAge, new GridBagConstraints(2, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tBaseAge.setText("" + this.baseAge);
            this.tBaseAge.addActionListener(this);
            this.cbSnapXGrid = new JCheckBox();
            this.options.add((Component)this.cbSnapXGrid, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.cbSnapXGrid.setText("Snap X to grid:");
            this.cbSnapXGrid.setSelected(this.useXGrid);
            this.cbSnapXGrid.addActionListener(this);
            this.cbSnapAgeGrid = new JCheckBox();
            this.options.add((Component)this.cbSnapAgeGrid, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.cbSnapAgeGrid.setSelected(this.useAgeGrid);
            this.cbSnapAgeGrid.setText("Snap Ages to grid:");
            this.cbSnapAgeGrid.addActionListener(this);
            this.tXSpacing = new ModifyTextField(true, false);
            this.options.add((Component)this.tXSpacing, new GridBagConstraints(2, 10, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tXSpacing.setText("" + this.gridX);
            this.tXSpacing.setEnabled(this.useXGrid);
            this.tXSpacing.addActionListener(this);
            this.tAgeSpacing = new ModifyTextField(true, false);
            this.options.add((Component)this.tAgeSpacing, new GridBagConstraints(2, 12, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tAgeSpacing.setText("" + this.gridY);
            this.tAgeSpacing.setEnabled(this.useAgeGrid);
            this.tAgeSpacing.addActionListener(this);
            this.generatePreview = new JButton();
            this.options.add((Component)this.generatePreview, new GridBagConstraints(5, 21, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.options.add((Component)this.getJScrollPane2(), new GridBagConstraints(0, 23, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.generatePreview.setText("Apply Changes");
            this.generatePreview.addActionListener(this);
            this.jLabel7 = new JLabel();
            this.options.add((Component)this.jLabel7, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel7.setText("Column Width:");
            this.tWidth = new ModifyTextField(true, false);
            this.options.add((Component)this.tWidth, new GridBagConstraints(2, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tWidth.setText("" + this.transCol.getMyWidth());
            this.tWidth.addActionListener(this);
            this.jLabel8 = new JLabel();
            this.options.add((Component)this.jLabel8, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel8.setText("Text Labels:");
            this.radioKeepFonts = new JRadioButton();
            this.options.add((Component)this.radioKeepFonts, new GridBagConstraints(2, 14, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.radioKeepFonts.setText("Keep original font size");
            this.getTextSizeRadioGroup().add(this.radioKeepFonts);
            this.radioKeepFonts.addActionListener(this);
            this.radioKeepOnlyY = new JRadioButton();
            this.options.add((Component)this.radioKeepOnlyY, new GridBagConstraints(2, 16, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.radioKeepOnlyY.setText("Preserve vertical size only");
            this.getTextSizeRadioGroup().add(this.radioKeepOnlyY);
            this.radioKeepOnlyY.addActionListener(this);
            this.radioKeepBoth = new JRadioButton();
            this.options.add((Component)this.radioKeepBoth, new GridBagConstraints(2, 19, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.radioKeepBoth.setText("Preserve both vertical and horizontal size");
            this.getTextSizeRadioGroup().add(this.radioKeepBoth);
            this.radioKeepBoth.setSelected(true);
            this.radioKeepBoth.addActionListener(this);
            this.buttons = new JPanel();
            GridBagLayout buttonsLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.buttons, "South");
            buttonsLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            buttonsLayout.rowHeights = new int[]{7, 7, 7};
            buttonsLayout.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            buttonsLayout.columnWidths = new int[]{7, 7, 7, 7, 7, 7, 7};
            this.buttons.setLayout(buttonsLayout);
            this.bCancel = new JButton();
            this.buttons.add((Component)this.bCancel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bCancel.setText("Cancel");
            this.bCancel.addActionListener(this);
            this.bAddCol = new JButton();
            this.buttons.add((Component)this.bAddCol, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bAddCol.setText("Add Column");
            this.bAddCol.setEnabled(this.isColValid);
            this.bAddCol.addActionListener(this);
            this.bSave = new JButton();
            this.buttons.add((Component)this.bSave, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bSave.setText("Save as Datafile...");
            this.bSave.setEnabled(this.isColValid);
            this.bSave.addActionListener(this);
            this.previewPanel = new JPanel();
            BorderLayout previewPanelLayout = new BorderLayout();
            this.previewPanel.setLayout(previewPanelLayout);
            this.getContentPane().add((Component)this.previewPanel, "Center");
            this.previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
            this.previewSVGPanel = new TSCColumnPreview(this.transCol, (TSCSVGUserAgent)new TransectLoaderSVGUserAgent(this));
            this.previewPanel.add((Component)this.previewSVGPanel, "Center");
            this.previewSVGPanel.setRecenterOnRedraw(true);
            this.previewOptions = new JPanel();
            BorderLayout previewOptionsLayout = new BorderLayout();
            this.previewOptions.setLayout(previewOptionsLayout);
            this.previewPanel.add((Component)this.previewOptions, "South");
            this.previewOptions.setBorder(BorderFactory.createTitledBorder("Popup"));
            this.previewOptions.setPreferredSize(new Dimension(320, 116));
            this.previewOptions.add((Component)this.getJScrollPane1(), "Center");
            this.previewOptions.add((Component)this.getPopupWarning(), "South");
            this.setSize(760, 760);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void readDialog() {
        this.topAge = Util.parseDoubleLax(this.tTopAge.getText(), this.topAge);
        this.baseAge = Util.parseDoubleLax(this.tBaseAge.getText(), this.baseAge);
        if (this.topAge > this.baseAge) {
            double temp = this.topAge;
            this.topAge = this.baseAge;
            this.baseAge = temp;
        }
        this.tTopAge.setText("" + this.topAge);
        this.tBaseAge.setText("" + this.baseAge);
        String title = this.tTitle.getText().trim();
        if (title.length() == 0) {
            title = "Transect";
        }
        this.transCol.setName(title);
        double width = Math.abs(Util.parseDoubleLax(this.tWidth.getText(), this.transCol.getMyWidth()));
        this.transCol.setWidth(width);
        this.tWidth.setText("" + width);
        this.mergeDistance = Math.abs(Util.parseDoubleLax(this.tMergDist.getText(), this.mergeDistance));
        this.tMergDist.setText("" + this.mergeDistance);
        this.gridX = Math.abs(Util.parseDoubleLax(this.tXSpacing.getText(), this.gridX));
        this.tXSpacing.setText("" + this.gridX);
        this.gridY = Math.abs(Util.parseDoubleLax(this.tAgeSpacing.getText(), this.gridY));
        this.tAgeSpacing.setText("" + this.gridY);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.bCancel) {
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.cbSnapXGrid) {
            this.useXGrid = this.cbSnapXGrid.isSelected();
            this.tXSpacing.setEnabled(this.useXGrid);
            this.generatePreview.setEnabled(true);
        } else if (ae.getSource() == this.cbSnapAgeGrid) {
            this.useAgeGrid = this.cbSnapAgeGrid.isSelected();
            this.tAgeSpacing.setEnabled(this.useAgeGrid);
            this.generatePreview.setEnabled(true);
        } else if (ae.getSource() == this.generatePreview) {
            this.generatePreview.setEnabled(false);
            this.readDialog();
            this.fillTransectCol();
            this.previewSVGPanel.settings.topAge = this.topAge;
            this.previewSVGPanel.settings.baseAge = this.baseAge;
            this.previewSVGPanel.settings.doPopups = true;
            this.isColValid = this.transCol.isValid();
            this.bAddCol.setEnabled(this.isColValid);
            this.bSave.setEnabled(this.isColValid);
            this.transCol.setDrawErrors(true);
            this.transCol.drawPopupIDs = true;
            this.previewSVGPanel.draw();
            this.previewSVGPanel.setRecenterOnRedraw(false);
        } else if (ae.getSource() == this.bSave && this.isColValid) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription("TSCreator datafiles (*.txt)");
            eff.addExtension("txt", true);
            chooser.setFileFilter(eff);
            if (TSCreator.fileChooserPath != null) {
                chooser.setCurrentDirectory(TSCreator.fileChooserPath);
            }
            if ((returnVal = chooser.showSaveDialog(this)) == 0) {
                ActionDialog ad = new ActionDialog("Saving Transect...");
                try {
                    ad.setVisible(true);
                    String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "txt");
                    TSCreator.fileChooserPath = chooser.getCurrentDirectory();
                    BufferedWriter bw = new BufferedWriter(new FileWriter(absolutePath));
                    this.db.writeHeader(bw);
                    this.transCol.write(bw);
                    bw.close();
                }
                catch (IOException e) {
                    ErrorHandler.showError(e, null, "Error", 3);
                }
                ad.setVisible(false);
            }
        } else if (ae.getSource() == this.bAddCol && this.isColValid) {
            this.transCol.setDrawErrors(false);
            this.transCol.drawPopupIDs = false;
            this.db.addColumn(this.transCol);
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() instanceof ModifyTextField) {
            this.generatePreview.setEnabled(true);
            if (ae.getSource() == this.tWidth) {
                this.previewSVGPanel.setRecenterOnRedraw(true);
            }
        } else if (ae.getSource() instanceof JRadioButton) {
            this.generatePreview.setEnabled(true);
        }
    }

    public void previewPopupActivated(int id) {
        TransectColumn.Polygon poly2 = null;
        if (id >= 0) {
            for (TransectColumn.Polygon poly2 : this.transCol.polygons) {
                if (poly2.id == id) break;
                poly2 = null;
            }
        }
        this.popupEditingPoly = poly2;
        TemplatePolygon polySVG2 = null;
        if (id >= 0) {
            for (TemplatePolygon polySVG2 : this.polygonsSVG) {
                if (polySVG2.id == id) break;
                polySVG2 = null;
            }
        }
        this.popupEditingPolySVG = polySVG2;
        if (this.popupEditor == null) {
            return;
        }
        if (this.popupEditingPoly == null || this.popupEditingPolySVG == null) {
            this.popupEditor.setEnabled(false);
            this.popupEditor.setText("");
        } else {
            this.popupEditor.setEnabled(true);
            this.popupEditor.setContentType("text/plain");
            this.popupEditor.setText(this.popupEditingPoly.popup);
        }
    }

    public final void parseTransectSVG(String filename) throws Exception {
        this.topAge = Double.NaN;
        this.baseAge = Double.NaN;
        XMLReader reader = XMLReaderFactory.createXMLReader();
        TransectHandler handler = new TransectHandler();
        reader.setContentHandler(handler);
        reader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        reader.parse(new InputSource(FileUtils.getInputStream(filename, false)));
        this.parseTextLabels();
        if (Double.isNaN(this.topAge)) {
            throw new Exception("Top age not found or is invalid.");
        }
        if (Double.isNaN(this.baseAge)) {
            throw new Exception("Base age not found or is invalid.");
        }
        if (this.topAge > this.baseAge) {
            throw new Exception("Top Age (" + this.topAge + ") is bigger than base age (" + this.baseAge + ").");
        }
        if (Double.isNaN(this.clipSX)) {
            throw new Exception("Red clipping rectangle not found.");
        }
    }

    protected void doPointMerging() {
        this.mergedPointsSVG.clear();
        for (Point pParse : this.parsedPointsSVG) {
            Point pMerge = null;
            for (Point p : this.mergedPointsSVG) {
                if (!(p.distance(pParse) <= this.mergeDistance)) continue;
                p.x = (p.x + pParse.x) / 2.0;
                p.y = (p.y + pParse.y) / 2.0;
                pMerge = p;
                break;
            }
            if (pMerge == null) {
                double x = pParse.x;
                double y = pParse.y;
                if (Math.abs(x - this.clipSX) <= this.mergeDistance) {
                    x = this.clipSX;
                }
                if (Math.abs(x - this.clipEX) <= this.mergeDistance) {
                    x = this.clipEX;
                }
                if (Math.abs(y - this.clipSY) <= this.mergeDistance) {
                    y = this.clipSY;
                }
                if (Math.abs(y - this.clipEY) <= this.mergeDistance) {
                    y = this.clipEY;
                }
                pMerge = new Point(x, y);
                this.mergedPointsSVG.add(pMerge);
            }
            this.pointsParsedToMerged.put(pParse, pMerge);
        }
    }

    protected void fillTransectCol() {
        this.transCol.points.clear();
        this.transCol.lines.clear();
        this.transCol.polygons.clear();
        this.doPointMerging();
        this.toColCoords();
        this.applyGrid();
        boolean polyStarted = false;
        for (TemplatePolygon polySVG : this.polygonsSVG) {
            TransectColumn transectColumn = this.transCol;
            transectColumn.getClass();
            TransectColumn.Polygon poly = transectColumn.new TransectColumn.Polygon(polySVG);
            polyStarted = false;
            for (Point pSVG : polySVG.pointsSVG) {
                Point mergedP = (Point)this.pointsParsedToMerged.get(pSVG);
                if (mergedP == null) {
                    System.out.println("This error shouldn't happen: Can't find merged point corresponding to parsed point!");
                    continue;
                }
                Point p = (Point)this.pointsMergedtoCol.get(mergedP);
                if (p == null) {
                    System.out.println("This error shouldn't happen: Can't find transCol.point corresponding to merged point!");
                    continue;
                }
                if (polyStarted) {
                    poly.genLineTo(p, null);
                    continue;
                }
                poly.genStart(p);
                polyStarted = true;
            }
            poly.genClose(null);
            if (poly.lines.size() < 3) continue;
            this.transCol.polygons.add(poly);
        }
        this.applyStyleLines();
        if (this.tNumPolys != null) {
            this.tNumPolys.setText("" + this.transCol.polygons.size());
        }
        this.fillColTextLabels();
    }

    protected void parseTextLabels() {
        this.labelsSVG.clear();
        for (TemplateText text : this.textSVG) {
            if (text.pointSVG != null && text.pointSVG.getX() >= this.clipSX && text.pointSVG.getX() <= this.clipEX && text.pointSVG.getY() >= this.clipSY && text.pointSVG.getY() <= this.clipEY) {
                this.labelsSVG.add(text);
                continue;
            }
            int colon = text.s.indexOf(58);
            if (colon < 1 || colon > text.s.length() - 2) continue;
            String key = text.s.substring(0, colon);
            String value = text.s.substring(colon + 1);
            if (key.equalsIgnoreCase("Top Age")) {
                this.topAge = Util.parseDouble(value, Double.NaN);
                value = "" + this.topAge;
            } else if (key.equalsIgnoreCase("Base Age")) {
                this.baseAge = Util.parseDouble(value, Double.NaN);
                value = "" + this.baseAge;
            }
            System.out.println("Found: " + key + " => " + value);
        }
    }

    protected void fillColTextLabels() {
        this.transCol.textLabels.clear();
        for (TemplateText text : this.labelsSVG) {
            if (text.s.startsWith("popup:")) {
                String popup = text.s.substring(6).trim();
                text.point = new Point(text.pointSVG);
                this.toColCoords(text.point);
                TransectColumn.Polygon poly = this.transCol.getPolygonForPoint(new Point(text.point));
                if (poly == null) {
                    System.out.println("Unknown polygon for popup: " + popup);
                    continue;
                }
                if (poly.popup != null) continue;
                poly.popup = popup;
                continue;
            }
            text.point = new Point(text.pointSVG);
            this.toColCoords(text.point);
            text.text = new RichText(text.s, this.transCol.fileInfo);
            StringWrappingInfo swi = new StringWrappingInfo(this.g, text.text, text.font, 1);
            swi.useOriginalLineBreaks();
            double clipWidth = this.clipEX - this.clipSX;
            double clipHeight = this.clipEY - this.clipSY;
            double ageRange = this.baseAge - this.topAge;
            if (this.radioKeepBoth.isSelected()) {
                double textWidth = swi.getWidth();
                text.widthFrac = textWidth / clipWidth;
            } else {
                text.widthFrac = 0.0;
            }
            if (this.radioKeepBoth.isSelected() || this.radioKeepOnlyY.isSelected()) {
                double textHeight = swi.getHeight();
                text.ageSpread = textHeight / clipHeight * ageRange;
            } else {
                text.ageSpread = 0.0;
            }
            text.ageSpread *= text.ageFactor;
            text.widthFrac *= text.widthFactor;
            this.transCol.textLabels.add(text);
        }
    }

    protected void applyStyleLines() {
        for (TransectColumn.Line style : this.styleLines) {
            Point a = new Point(style.a);
            Point b = new Point(style.b);
            this.toColCoords(a);
            this.toColCoords(b);
            TransectColumn transectColumn = this.transCol;
            transectColumn.getClass();
            TransectColumn.Line styleColCoord = transectColumn.new TransectColumn.Line(a, b);
            for (TransectColumn.Line l : this.transCol.lines) {
                if (!l.intersects(styleColCoord)) continue;
                l.setStyle(style);
            }
        }
    }

    protected Point getParsePoint(double x, double y) {
        Point p = new Point(x, y);
        this.parsedPointsSVG.add(p);
        return p;
    }

    protected void toColCoords() {
        double transWidth = this.transCol.xHigh - this.transCol.xLow;
        double clipWidth = this.clipEX - this.clipSX;
        double clipHeight = this.clipEY - this.clipSY;
        double ageRange = this.baseAge - this.topAge;
        for (Point pSVG : this.mergedPointsSVG) {
            double x = (pSVG.x - this.clipSX) / clipWidth * transWidth + (double)this.transCol.xLow;
            double y = (pSVG.y - this.clipSY) / clipHeight * ageRange + this.topAge;
            Point p = new Point(x, y);
            this.transCol.points.add(p);
            this.pointsMergedtoCol.put(pSVG, p);
        }
    }

    public void toColCoords(Point p) {
        double transWidth = this.transCol.xHigh - this.transCol.xLow;
        double clipWidth = this.clipEX - this.clipSX;
        double clipHeight = this.clipEY - this.clipSY;
        double ageRange = this.baseAge - this.topAge;
        p.x = (p.x - this.clipSX) / clipWidth * transWidth + (double)this.transCol.xLow;
        p.y = (p.y - this.clipSY) / clipHeight * ageRange + this.topAge;
    }

    protected void applyGrid() {
        for (Point p : this.transCol.points) {
            double frac;
            double numGrids;
            if (this.useXGrid) {
                numGrids = p.x / this.gridX;
                frac = numGrids - Math.floor(numGrids);
                numGrids = frac < 0.5 ? Math.floor(numGrids) : Math.ceil(numGrids);
                p.x = numGrids * this.gridX;
                if (p.x < (double)this.transCol.xLow && p.x > (double)this.transCol.xLow - this.gridX) {
                    p.x = this.transCol.xLow;
                }
                if (p.x > (double)this.transCol.xHigh && p.x < (double)this.transCol.xHigh + this.gridX) {
                    p.x = this.transCol.xHigh;
                }
            }
            if (!this.useAgeGrid) continue;
            numGrids = p.y / this.gridY;
            frac = numGrids - Math.floor(numGrids);
            numGrids = frac < 0.5 ? Math.floor(numGrids) : Math.ceil(numGrids);
            p.y = numGrids * this.gridY;
            if (p.y < this.topAge && p.y > this.topAge - this.gridY) {
                p.y = this.topAge;
            }
            if (!(p.y > this.baseAge) || !(p.y < this.baseAge + this.gridY)) continue;
            p.y = this.baseAge;
        }
        for (int i = 0; i < this.transCol.points.size(); ++i) {
            Point p;
            p = (Point)this.transCol.points.get(i);
            for (int j = i + 1; j < this.transCol.points.size(); ++j) {
                Point p2 = (Point)this.transCol.points.get(j);
                if (!(p.distanceSquared(p2) < 1.0E-6)) continue;
                this.transCol.points.remove(j);
                TemplateLoader.replaceMapValue(this.pointsMergedtoCol, p2, p);
            }
        }
    }

    public static void replaceMapValue(Map map, Object oldVal, Object newVal) {
        for (Object key : map.keySet()) {
            Object v = map.get(key);
            if (!v.equals(oldVal)) continue;
            map.put(key, newVal);
        }
    }

    private ButtonGroup getTextSizeRadioGroup() {
        if (this.textSizeRadioGroup == null) {
            this.textSizeRadioGroup = new ButtonGroup();
        }
        return this.textSizeRadioGroup;
    }

    private JEditorPane getPopupEditor() {
        if (this.popupEditor == null) {
            this.popupEditor = new JEditorPane();
            this.popupEditor.setText("");
            this.popupEditor.setEnabled(false);
            this.popupEditor.setEditable(true);
            this.popupEditor.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (TemplateLoader.this.popupEditingPoly != null) {
                        TemplateLoader.this.popupEditingPoly.popup = TemplateLoader.this.popupEditor.getText();
                    }
                    if (TemplateLoader.this.popupEditingPolySVG != null) {
                        TemplateLoader.this.popupEditingPolySVG.popup = TemplateLoader.this.popupEditor.getText();
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.popupEditor;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setPreferredSize(new Dimension(310, 19));
            this.jScrollPane1.setViewportView(this.getPopupEditor());
        }
        return this.jScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.lNotes = new JEditorPane();
            this.jScrollPane2.setViewportView(this.lNotes);
            this.lNotes.setContentType("text/html");
            this.lNotes.setEditable(false);
            this.lNotes.setBackground(null);
            this.lNotes.setText("<html><strong>Notes:</strong><br><strong>If there are any errors in the template, adding and saving are disabled. Errors include:</strong><br><ul><li>Intersections. If two lines intersect they are colored <font color=" + Coloring.getHTMLColor(TransectColumn.LINE_INTERSECT_ERROR_COLOR) + ">red</font>.</li><li>Overlap. If three or more polygons use the same line it is colored <font color=" + Coloring.getHTMLColor(TransectColumn.THREE_SIDED_LINE_ERROR_COLOR) + ">orange</font>.</li></ul>If a polygon doesn't border anything, the border is colored <font color=" + Coloring.getHTMLColor(TransectColumn.ONE_SIDED_LINE_ERROR_COLOR) + ">green</font>. This is not an error, it is useful to make sure that there are no unexpected gaps between polygons. There should be a green outline only around the outer edge of the polygons. If you notice some green lines inside a region that should be solid, then there is an error in the template. This can probably be fixed by increasing the merge distance, but might require fixing the template.<br><br>If there are errors it is worth increasing the merge distance and grid options. If they do not solve the problem, the template must be drawn more accurately. This means polygon points close together, no crossing polygons, etc.<br></html>");
            this.lNotes.setOpaque(false);
        }
        return this.jScrollPane2;
    }

    private JLabel getPopupWarning() {
        if (this.popupWarning == null) {
            this.popupWarning = new JLabel();
            this.popupWarning.setText("Applying changes may lose custom popup");
        }
        return this.popupWarning;
    }

    protected class TransectHandler
    implements ContentHandler {
        String tempText;
        boolean accumulateText = false;
        TemplateText accumText = null;
        int ignore = 0;
        Map patternMap = new HashMap();

        protected TransectHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("pattern")) {
                ++this.ignore;
                String href = attributes.getValue("xlink:href");
                if (href != null && href.length() > 0) {
                    String actualPattern = null;
                    actualPattern = href.replaceAll("^url\\(\\#", "").replaceAll("^\\#", "").replaceAll("\\)$", "");
                    String id = attributes.getValue("id");
                    String mapped = null;
                    while ((mapped = (String)this.patternMap.get(actualPattern)) != null) {
                        System.out.println("doubly mapped pattern: " + mapped);
                        actualPattern = mapped;
                    }
                    System.out.println("Mapped pattern: " + id + " => \t" + actualPattern);
                    if (id != null) {
                        this.patternMap.put(id, actualPattern);
                    }
                }
            } else if (qName.equalsIgnoreCase("rect")) {
                if (this.ignore > 0) {
                    return;
                }
                AffineTransform at = this.getTransformFromAttribs(attributes);
                double x = Util.parseDouble(attributes.getValue("x"), Double.NaN);
                double y = Util.parseDouble(attributes.getValue("y"), Double.NaN);
                double width = Util.parseDouble(attributes.getValue("width"), Double.NaN);
                double height = Util.parseDouble(attributes.getValue("height"), Double.NaN);
                Point p1 = new Point(x, y);
                Point p3 = new Point(x + width, y + height);
                this.transformPoint(at, p1);
                this.transformPoint(at, p3);
                String pattern = this.getPatternFromAttribs(attributes);
                if (pattern != null) {
                    TemplatePolygon poly = new TemplatePolygon();
                    poly.patternFill = pattern;
                    Point p2 = new Point(x, y + height);
                    this.transformPoint(at, p2);
                    Point p4 = new Point(x + width, y);
                    this.transformPoint(at, p4);
                    Point p = TemplateLoader.this.getParsePoint(p1.x, p1.y);
                    poly.pointsSVG.add(p);
                    p = TemplateLoader.this.getParsePoint(p2.x, p2.y);
                    poly.pointsSVG.add(p);
                    p = TemplateLoader.this.getParsePoint(p3.x, p3.y);
                    poly.pointsSVG.add(p);
                    p = TemplateLoader.this.getParsePoint(p4.x, p4.y);
                    poly.pointsSVG.add(p);
                    TemplateLoader.this.polygonsSVG.add(poly);
                } else {
                    TemplateLoader.this.clipSX = p1.x;
                    TemplateLoader.this.clipSY = p1.y;
                    TemplateLoader.this.clipEX = p3.x;
                    TemplateLoader.this.clipEY = p3.y;
                }
            } else if (qName.equalsIgnoreCase("polygon")) {
                if (this.ignore > 0) {
                    return;
                }
                final TemplatePolygon poly = new TemplatePolygon();
                String pattern = this.getPatternFromAttribs(attributes);
                if (pattern == null) {
                    pattern = "";
                }
                poly.patternFill = pattern;
                String pointStr = attributes.getValue("points");
                if (pointStr == null || pointStr.length() == 0) {
                    System.out.println("A polygon with no points.");
                    return;
                }
                PointsParser pp = new PointsParser();
                DefaultPointsHandler ph = new DefaultPointsHandler(){

                    @Override
                    public void point(float x, float y) throws ParseException {
                        Point p = TemplateLoader.this.getParsePoint(x, y);
                        poly.pointsSVG.add(p);
                    }
                };
                pp.setPointsHandler(ph);
                pp.parse(pointStr);
                TemplateLoader.this.polygonsSVG.add(poly);
            } else if (qName.equalsIgnoreCase("text")) {
                this.accumulateText = true;
                double x = 0.0;
                double y = 0.0;
                AffineTransform at = null;
                String fontSize = "12";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getLocalName(i).compareToIgnoreCase("x") == 0 || attributes.getQName(i).compareToIgnoreCase("x") == 0) {
                        x = Util.parseDouble(attributes.getValue(i), 0.0);
                    }
                    if (attributes.getLocalName(i).compareToIgnoreCase("y") == 0 || attributes.getQName(i).compareToIgnoreCase("y") == 0) {
                        y = Util.parseDouble(attributes.getValue(i), 0.0);
                    }
                    at = this.getTransformFromAttribs(attributes);
                    if (attributes.getLocalName(i).compareToIgnoreCase("font-size") != 0 && attributes.getQName(i).compareToIgnoreCase("font-size") != 0) continue;
                    fontSize = attributes.getValue(i);
                }
                if (at != null) {
                    Point2D.Double pIn = new Point2D.Double(x, y);
                    Point2D pOut = at.transform(pIn, null);
                    x = pOut.getX();
                    y = pOut.getY();
                }
                this.accumText = new TemplateText();
                if (x != 0.0 && y != 0.0) {
                    this.accumText = new TemplateText();
                    this.accumText.pointSVG = new Point(x, y);
                    this.accumText.font = new TSCFont("font-size: " + fontSize);
                    if (at != null) {
                        Point2D scaleTest = new Point2D.Double(1.0, 1.0);
                        scaleTest = at.transform(scaleTest, null);
                        this.accumText.widthFactor = Math.abs(at.getScaleX());
                        this.accumText.ageFactor = Math.abs(at.getScaleY());
                    }
                }
                TemplateLoader.this.textSVG.add(this.accumText);
            } else if (qName.equalsIgnoreCase("polyline") || qName.equalsIgnoreCase("path")) {
                if (this.ignore > 0) {
                    return;
                }
                String pointStr = qName.equalsIgnoreCase("polyline") ? attributes.getValue("points") : attributes.getValue("d");
                if (pointStr == null || pointStr.length() == 0) {
                    System.out.println("A polyline/path with no points.");
                    return;
                }
                AffineTransform at = this.getTransformFromAttribs(attributes);
                Vector P = new Vector();
                boolean smooth = this.parsePoints(pointStr, P, at);
                if (P.size() < 2) {
                    System.out.println("A polyline/path with less than 2 points.");
                    return;
                }
                Point start = (Point)P.get(0);
                Point end = (Point)P.get(P.size() - 1);
                String pattern = this.getPatternFromAttribs(attributes);
                if (pattern != null) {
                    TemplatePolygon poly = new TemplatePolygon();
                    poly.patternFill = pattern;
                    for (Point p : P) {
                        p = TemplateLoader.this.getParsePoint(p.x, p.y);
                        poly.pointsSVG.add(p);
                    }
                    TemplateLoader.this.polygonsSVG.add(poly);
                } else {
                    TransectColumn transectColumn = TemplateLoader.this.transCol;
                    transectColumn.getClass();
                    TransectColumn.Line l = transectColumn.new TransectColumn.Line(start, end);
                    String style = "";
                    style = smooth ? style + "wavy" : style + "lapping";
                    l.setStyle(style);
                    TemplateLoader.this.styleLines.add(l);
                    System.out.println("Found style line: " + style + "\n" + l.toString());
                }
            }
        }

        public AffineTransform getTransformFromAttribs(Attributes attributes) {
            AffineTransform at = null;
            String transform = attributes.getValue("transform");
            if (transform == null || transform.length() == 0) {
                return null;
            }
            try {
                TransformListParser p = new TransformListParser();
                AWTTransformProducer tp = new AWTTransformProducer();
                p.setTransformListHandler(tp);
                p.parse(transform);
                at = tp.getAffineTransform();
            }
            catch (ParseException pe) {
                return null;
            }
            return at;
        }

        public void transformPoint(AffineTransform at, Point p) {
            if (at == null) {
                return;
            }
            Point2D atp = at.transform(new Point2D.Double(p.x, p.y), null);
            p.x = atp.getX();
            p.y = atp.getY();
        }

        public String getPatternFromAttribs(Attributes attributes) {
            String fill = attributes.getValue("fill");
            if (fill == null) {
                fill = attributes.getValue("style");
            }
            if (fill != null) {
                return this.getPatternFromFill(fill);
            }
            return null;
        }

        public String getPatternFromFill(String fill) {
            Pattern regexPat = Pattern.compile("url\\(\\#([^\\)]*)\\)");
            Matcher matcher = regexPat.matcher(fill);
            if (matcher.find()) {
                String parsed = matcher.group().replaceAll("^url\\(\\#", "").replaceAll("\\)$", "");
                String pattern = (String)this.patternMap.get(parsed);
                if (pattern == null) {
                    pattern = parsed;
                }
                if (pattern == null || pattern.length() == 0) {
                    return null;
                }
                return pattern;
            }
            return null;
        }

        public boolean parsePoints(String pointStr, Vector P, AffineTransform transform) {
            boolean smooth = false;
            Point last = null;
            PointStrTokenizer tok = new PointStrTokenizer(pointStr);
            char mode = 'M';
            String s = tok.nextToken();
            while (s != null) {
                char c = s.charAt(0);
                if (Character.isLetter(c)) {
                    mode = c;
                    s = s.substring(1);
                }
                boolean relative = Character.isLowerCase(mode);
                double relX = 0.0;
                double relY = 0.0;
                if (relative && last != null) {
                    relX = last.x;
                    relY = last.y;
                }
                switch (Character.toUpperCase(mode)) {
                    case 'C': {
                        tok.nextToken();
                        s = tok.nextToken();
                        smooth = true;
                    }
                    case 'Q': 
                    case 'S': {
                        tok.nextToken();
                        s = tok.nextToken();
                        smooth = true;
                    }
                    case 'T': {
                        smooth = true;
                    }
                    case 'L': 
                    case 'M': {
                        double x = Util.parseDouble(s, Double.NaN);
                        s = tok.nextToken();
                        double y = Util.parseDouble(s, Double.NaN);
                        if (Double.isNaN(x) || Double.isNaN(y)) break;
                        Point p = new Point(x + relX, y + relY);
                        this.transformPoint(transform, p);
                        P.add(p);
                        last = p;
                        break;
                    }
                    case 'H': {
                        if (last == null) break;
                        double x = Util.parseDouble(s, Double.NaN);
                        Point p = new Point(last);
                        this.transformPoint(transform, p);
                        p.x = x + relX;
                        break;
                    }
                    case 'V': {
                        if (last == null) break;
                        double y = Util.parseDouble(s, Double.NaN);
                        Point p = new Point(last);
                        this.transformPoint(transform, p);
                        p.y = y + relY;
                        break;
                    }
                    case 'Z': {
                        break;
                    }
                }
                s = tok.nextToken();
            }
            return smooth;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.tempText = this.accumulateText && this.tempText != null ? this.tempText + new String(ch, start, length) : new String(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("pattern")) {
                --this.ignore;
            } else if (qName.equalsIgnoreCase("text")) {
                this.accumulateText = false;
                if (this.ignore > 0) {
                    return;
                }
                if (this.tempText == null) {
                    return;
                }
                this.tempText = this.tempText.trim();
                if (this.accumText != null) {
                    String outS = "found text: ";
                    if (this.accumText.pointSVG != null) {
                        outS = outS + " at (" + this.accumText.pointSVG.getX() + ", " + this.accumText.pointSVG.getY() + "): ";
                    }
                    outS = outS + this.tempText;
                    this.accumText.s = this.tempText;
                }
                this.tempText = null;
                this.accumText = null;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }

        protected class PointStrTokenizer {
            String str;
            int i = 0;

            public PointStrTokenizer(String s) {
                this.str = s;
            }

            public String nextToken() {
                String ret = "";
                if (this.str == null || this.str.length() == 0) {
                    return null;
                }
                boolean haveSomething = false;
                while (this.i < this.str.length()) {
                    char c = this.str.charAt(this.i);
                    if (Character.isDigit(c) || c == '.') {
                        ret = ret + c;
                        haveSomething = true;
                        ++this.i;
                        continue;
                    }
                    if (Character.isLetter(c) || c == '-') {
                        if (haveSomething) break;
                        ret = ret + c;
                        ++this.i;
                        continue;
                    }
                    if (haveSomething) break;
                    ++this.i;
                }
                if (ret.length() == 0) {
                    return null;
                }
                return ret;
            }
        }
    }

    protected class TemplateText
    extends TransectColumn.TextLabel {
        public Point pointSVG = null;
        public String s = null;
        public double widthFactor = 1.0;
        public double ageFactor = 1.0;
    }

    protected class TemplatePolygon
    extends TransectColumn.Polygon {
        public Vector pointsSVG = new Vector();
    }
}

