/*
 * Decompiled with CFR 0.152.
 */
package gui.settings;

import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.Unit;
import datastore.ZoneColumn;
import gui.Language;
import gui.ModifyTextField;
import gui.TSCreator;
import gui.settings.SelectedTimes;
import gui.settings.TimesSelectChangeListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TimesPanel
extends JPanel
implements ItemListener,
ActionListener {
    public JPanel topBasePanel;
    public JLabel jLabel1;
    public JRadioButton topStageRadio;
    public JLabel jLabel4;
    public ButtonGroup bottomButtonGroup;
    public ButtonGroup topButtonGroup;
    public JCheckBox skipEmptyColumnsCheck;
    public ModifyTextField unitsPerMaTF;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JPanel vertScalePanel;
    public JComboBox baseStage;
    public ModifyTextField baseMY;
    public JRadioButton baseMYRadio;
    public JRadioButton baseStageRadio;
    public JComboBox topStage;
    public ModifyTextField topMY;
    public JRadioButton topMYRadio;
    public TimesSelectChangeListener listener = null;
    public Unit unit = null;
    protected SelectedTimes st = null;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new TimesPanel(null, new Unit(Language.translate("Ma", true))));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public TimesPanel(TimesSelectChangeListener l, Unit u) {
        this.listener = l;
        this.unit = u;
        if (this.unit == null) {
            this.unit = new Unit("x");
        }
        this.initGUI();
    }

    public void populate(Datastore ds) {
        this.populate(ds, this.unit);
    }

    public void populate(Datastore ds, Unit u) {
        DataColumn intervalCol = null;
        if (u != null) {
            this.unit = u;
        }
        String[] intervalColNames = this.unit.getIntervalColNames();
        for (int i = 0; intervalColNames != null && i < intervalColNames.length && (intervalCol = ds.getColumnByName(this.unit, intervalColNames[i])) == null; ++i) {
        }
        this.topStage.removeAllItems();
        this.baseStage.removeAllItems();
        String unitName = this.unit.getName();
        this.topMYRadio.setText(unitName + ": ");
        this.baseMYRadio.setText(unitName + ": ");
        if (intervalCol != null && intervalCol.data.size() > 0 && intervalCol instanceof ZoneColumn) {
            this.topStageRadio.setText(Language.translate(intervalCol.getName() + " Name", true));
            this.baseStageRadio.setText(Language.translate(intervalCol.getName() + " Name", true));
            Iterator stages = intervalCol.getDrawingData();
            double top = Double.NaN;
            boolean addPresent = true;
            while (stages.hasNext()) {
                Datapoint dataP = (Datapoint)stages.next();
                if (dataP.breaker || Double.isNaN(top)) {
                    double d = top = this.unit.isNegated() ? -dataP.baseAge : dataP.baseAge;
                    if (!addPresent || this.unit.isNegated() || !this.unit.getFirstWord().equalsIgnoreCase("Myr") && !this.unit.getFirstWord().equalsIgnoreCase("Ma")) continue;
                    Datapoint present = new Datapoint();
                    present.baseAge = 0.0;
                    present.label = "Present (0 " + unitName + ")";
                    present.parameter = this.topStage;
                    this.topStage.addItem(present);
                    addPresent = false;
                    continue;
                }
                Datapoint boxTopP = new Datapoint();
                Datapoint boxBaseP = new Datapoint();
                boxTopP.baseAge = top;
                boxBaseP.baseAge = this.unit.isNegated() ? -dataP.baseAge : dataP.baseAge;
                boxTopP.label = dataP.label + " (" + top + " " + unitName + " top)";
                boxBaseP.label = dataP.label + " (" + boxBaseP.baseAge + " " + unitName + " base)";
                boxTopP.parameter = this.topStage;
                boxBaseP.parameter = this.baseStage;
                this.topStage.addItem(boxTopP);
                this.baseStage.addItem(boxBaseP);
                top = boxBaseP.baseAge;
            }
            this.topStage.setEnabled(true);
            this.baseStage.setEnabled(true);
            this.topStageRadio.setEnabled(true);
            this.baseStageRadio.setEnabled(true);
            if (ds.setTopToUnitAge) {
                this.topMYRadio.setSelected(true);
            } else {
                this.topStageRadio.setSelected(true);
            }
            if (ds.setBaseToUnitAge) {
                this.baseMYRadio.setSelected(true);
            } else {
                this.baseStageRadio.setSelected(true);
            }
        } else {
            this.topStage.setEnabled(false);
            this.baseStage.setEnabled(false);
            this.topStageRadio.setEnabled(false);
            this.baseStageRadio.setEnabled(false);
        }
        if (!this.topStageRadio.isSelected() && !this.topMYRadio.isSelected()) {
            if (this.topStageRadio.isEnabled()) {
                this.topStageRadio.setSelected(true);
            } else {
                this.topMYRadio.setSelected(true);
            }
        }
        if (!this.baseStageRadio.isSelected() && !this.baseMYRadio.isSelected()) {
            if (this.baseStageRadio.isEnabled()) {
                this.baseStageRadio.setSelected(true);
            } else {
                this.baseMYRadio.setSelected(true);
            }
        }
        TSCreator.settings.changedDefaultTopAge = false;
        TSCreator.settings.changedDefaultBaseAge = false;
    }

    private void initGUI() {
        String units = this.unit.getName();
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
            thisLayout.rowHeights = new int[]{7, 25, 7, 20};
            thisLayout.columnWeights = new double[]{0.1};
            thisLayout.columnWidths = new int[]{7};
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(600, 250));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.topBasePanel = new JPanel();
            GridBagLayout topBasePanelLayout = new GridBagLayout();
            topBasePanelLayout.columnWidths = new int[]{7, 57, 45, 72, 7};
            topBasePanelLayout.rowHeights = new int[]{7, 7, 7, 13, 7, 20, -1};
            topBasePanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0};
            topBasePanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            this.add((Component)this.topBasePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.topBasePanel.setLayout(topBasePanelLayout);
            this.jLabel1 = new JLabel();
            this.topBasePanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText(Language.translate("Top of Interval", true));
            this.topStageRadio = new JRadioButton();
            this.topBasePanel.add((Component)this.topStageRadio, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.topStageRadio.setText(Language.translate("Age/Stage Name", true));
            this.topStageRadio.addItemListener(this);
            this.getTopButtonGroup().add(this.topStageRadio);
            this.topMYRadio = new JRadioButton();
            this.topBasePanel.add((Component)this.topMYRadio, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.topMYRadio.setText(units);
            this.topMYRadio.addItemListener(this);
            this.getTopButtonGroup().add(this.topMYRadio);
            this.topMY = new ModifyTextField(true, true);
            this.topBasePanel.add((Component)this.topMY, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.topMY.addActionListener(this);
            DefaultComboBoxModel<String> topStageModel = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.topStage = new JComboBox();
            this.topBasePanel.add((Component)this.topStage, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.topStage.setModel(topStageModel);
            this.topStage.addItemListener(this);
            this.jLabel2 = new JLabel();
            this.topBasePanel.add((Component)this.jLabel2, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText(Language.translate("Base of Interval", true));
            this.baseStageRadio = new JRadioButton();
            this.topBasePanel.add((Component)this.baseStageRadio, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.baseStageRadio.setText(Language.translate("Age/Stage Name", true));
            this.baseStageRadio.addItemListener(this);
            this.getBottomButtonGroup().add(this.baseStageRadio);
            this.baseMYRadio = new JRadioButton();
            this.topBasePanel.add((Component)this.baseMYRadio, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.baseMYRadio.setText(units);
            this.baseMYRadio.addItemListener(this);
            this.getBottomButtonGroup().add(this.baseMYRadio);
            this.baseMY = new ModifyTextField(true, true);
            this.topBasePanel.add((Component)this.baseMY, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.baseMY.addActionListener(this);
            DefaultComboBoxModel<String> baseStageModel = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.baseStage = new JComboBox();
            this.topBasePanel.add((Component)this.baseStage, new GridBagConstraints(3, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.baseStage.setModel(baseStageModel);
            this.baseStage.addItemListener(this);
            this.vertScalePanel = new JPanel();
            this.add((Component)this.vertScalePanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout vertScalePanelLayout = new GridBagLayout();
            vertScalePanelLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            vertScalePanelLayout.rowHeights = new int[]{7, 7, 7};
            vertScalePanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 1.0};
            vertScalePanelLayout.columnWidths = new int[]{7, 48, 7, 7};
            this.vertScalePanel.setLayout(vertScalePanelLayout);
            this.jLabel3 = new JLabel();
            this.vertScalePanel.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText(Language.translate("Vertical Scale:", true));
            this.unitsPerMaTF = new ModifyTextField(true, true);
            this.vertScalePanel.add((Component)this.unitsPerMaTF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.unitsPerMaTF.setText("1");
            this.unitsPerMaTF.addActionListener(this);
            this.unitsPerMaTF.setPreferredSize(new Dimension(40, 22));
            this.unitsPerMaTF.setSize(40, 22);
            this.jLabel4 = new JLabel();
            this.vertScalePanel.add((Component)this.jLabel4, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel4.setText(Language.translate("cm per data unit (eg. 1 cm per Myr)", true));
            this.skipEmptyColumnsCheck = new JCheckBox();
            this.vertScalePanel.add((Component)this.skipEmptyColumnsCheck, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.skipEmptyColumnsCheck.setText(Language.translate("Gray out (and do not draw) columns which do not have data on the selected time interval", true));
            this.skipEmptyColumnsCheck.setSelected(true);
            this.skipEmptyColumnsCheck.addItemListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ButtonGroup getTopButtonGroup() {
        if (this.topButtonGroup == null) {
            this.topButtonGroup = new ButtonGroup();
        }
        return this.topButtonGroup;
    }

    private ButtonGroup getBottomButtonGroup() {
        if (this.bottomButtonGroup == null) {
            this.bottomButtonGroup = new ButtonGroup();
        }
        return this.bottomButtonGroup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this.topMY) {
            this.topMYRadio.setSelected(true);
            this.baseMYRadio.setSelected(true);
            this.listener.timesChanged(0, this.unit);
        } else if (source == this.baseMY) {
            this.baseMYRadio.setSelected(true);
            this.topMYRadio.setSelected(true);
            this.listener.timesChanged(0, this.unit);
        } else if (source == this.unitsPerMaTF) {
            this.listener.timesChanged(2, this.unit);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.listener == null) {
            return;
        }
        Object item = e.getItem();
        if (item == this.topStage || item == this.baseStage) {
            this.listener.timesChanged(0, this.unit);
        } else if (item instanceof Datapoint) {
            this.listener.timesChanged(0, this.unit);
        } else if (item == this.skipEmptyColumnsCheck) {
            this.listener.timesChanged(1, this.unit);
        } else if (item == this.topStageRadio || item == this.baseStageRadio) {
            this.listener.timesChanged(0, this.unit);
        } else if (item == this.topMYRadio || item == this.baseMYRadio) {
            this.listener.timesChanged(0, this.unit);
        }
    }

    public SelectedTimes getSelectedTimes() {
        if (this.st == null) {
            this.st = new SelectedTimes(this, true);
        } else {
            this.st.setToTP(this, true);
        }
        return this.st;
    }
}

