/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import datastore.BlockSeriesMetaColumn;
import datastore.DataColumn;
import datastore.EventColumn;
import datastore.MetaColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.SequenceColumn;
import datastore.ZoneColumn;
import datastore.editor.DataSeries;
import datastore.editor.DatapointTableModel;
import datastore.editor.GroupingSteward;
import gui.TSCAction;
import gui.editor.DataEditor;
import gui.editor.GroupingPanel;
import gui.editor.MetaColumnEditor;
import gui.editor.SpreadSheet;
import gui.editor.SpreadSheetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ColumnDataEditor
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    DataColumn col;
    JComponent singlePanel = null;
    JTabbedPane tabs = null;
    DataEditor parent;
    SpreadSheet sheetInFocus = null;

    public ColumnDataEditor() {
        this.setLayout(new BorderLayout());
        this.parent = null;
    }

    public ColumnDataEditor(DataColumn c, DataEditor parent) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        this.setColumn(c);
    }

    public final void setColumn(DataColumn c) {
        MetaColumnEditor mce;
        if (this.singlePanel != null && this.singlePanel instanceof MetaColumnEditor && (mce = (MetaColumnEditor)this.singlePanel).isInMovingMode()) {
            mce.setMoveToColumn(c);
        }
        this.removeAll();
        this.tabs = null;
        this.singlePanel = null;
        this.sheetInFocus = null;
        this.col = c;
        if (c == null) {
            this.singlePanel = new JPanel();
            this.singlePanel.setPreferredSize(new Dimension(400, 300));
            this.add((Component)this.singlePanel, "Center");
        } else if (!c.isEditable()) {
            this.singlePanel = new JLabel("<html><center>" + c.getNoEditMessage() + "</center></html>");
            this.add((Component)this.singlePanel, "Center");
        } else if (c instanceof ZoneColumn || c instanceof EventColumn || c instanceof SequenceColumn || c instanceof PointColumn || c instanceof RangeColumn || c instanceof BlockSeriesMetaColumn && !((BlockSeriesMetaColumn)c).treatAsRegularMetaColumn()) {
            if (this.col.getNumSeries() == 1) {
                DataSeries series = this.col.getSeriesModel(0);
                this.singlePanel = this.getGroupingPanel(series);
                this.add((Component)this.singlePanel, "Center");
            } else {
                this.tabs = new JTabbedPane();
                for (int s = 0; s < this.col.getNumSeries(); ++s) {
                    DataSeries series = this.col.getSeriesModel(s);
                    this.tabs.addTab(this.col.getSeriesName(s), this.getGroupingPanel(series));
                }
                this.add((Component)this.tabs, "Center");
            }
        } else if (c instanceof MetaColumn) {
            this.singlePanel = new MetaColumnEditor((MetaColumn)c, this.parent.getTreeModel());
            this.add((Component)this.singlePanel, "Center");
        } else {
            this.singlePanel = new JPanel();
            this.add((Component)this.singlePanel, "Center");
        }
        this.doLayout();
        this.validate();
        this.repaint();
        this.parent.cutAction.setEnabled(this.getCanCut());
        this.parent.copyAction.setEnabled(this.getCanCopy());
    }

    protected JComponent getGroupingPanel(DataSeries series) {
        if (series.isSingle()) {
            DatapointTableModel model = new DatapointTableModel(series.getSingle());
            SpreadSheet sheet = new SpreadSheet(model);
            sheet.enableRowInsertRemove();
            sheet.addFocusListener(this);
            sheet.setExtraMenuActions(this.getSheetActions());
            model.registerEditorsAndRenderers(sheet);
            this.sheetInFocus = sheet;
            return new SpreadSheetPanel(sheet);
        }
        GroupingPanel panel = new GroupingPanel(series, this);
        panel.setLayout(new BoxLayout(panel, 1));
        Iterator iter = series.groupingIterator();
        while (iter.hasNext()) {
            GroupingSteward g = (GroupingSteward)iter.next();
            panel.add(g);
        }
        return new JScrollPane(panel);
    }

    public TSCAction[] getSheetActions() {
        TSCAction[] ret = new TSCAction[]{this.parent.cutAction, this.parent.copyAction, this.parent.pasteAction};
        return ret;
    }

    @Override
    public void focusGained(FocusEvent fe) {
        if (fe.getSource() instanceof SpreadSheet) {
            this.sheetInFocus = (SpreadSheet)fe.getSource();
        }
        this.parent.cutAction.setEnabled(this.getCanCut());
        this.parent.copyAction.setEnabled(this.getCanCopy());
    }

    @Override
    public void focusLost(FocusEvent fe) {
        this.parent.cutAction.setEnabled(this.getCanCut());
        this.parent.copyAction.setEnabled(this.getCanCopy());
    }

    public boolean getCanCut() {
        return this.getCanCopy();
    }

    public boolean getCanCopy() {
        return this.sheetInFocus != null && this.sheetInFocus.getWorkingCellRow() != -1;
    }

    public boolean getCanPaste() {
        Transferable clipboardContents;
        if (this.sheetInFocus == null || this.sheetInFocus.getWorkingCellRow() == -1) {
            return false;
        }
        try {
            clipboardContents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        }
        catch (Exception e) {
            return false;
        }
        return clipboardContents != null && clipboardContents.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public void cut() {
        if (this.sheetInFocus == null) {
            return;
        }
        this.sheetInFocus.toClipboard(false);
    }

    public void copy() {
        if (this.sheetInFocus == null) {
            return;
        }
        this.sheetInFocus.toClipboard(true);
    }

    public void paste() {
        Transferable clipboardContents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        if (clipboardContents != null && clipboardContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String clipString = clipboardContents.getTransferData(DataFlavor.stringFlavor).toString();
                Object[][] cells = SpreadSheet.stringToCells(clipString);
                if (this.sheetInFocus != null) {
                    this.sheetInFocus.setCells(cells, this.sheetInFocus.getWorkingCellRow(), this.sheetInFocus.getWorkingCellColumn());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

