/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.DataColumn;
import datastore.RangeColumn;
import datastore.loader.ParseException;
import datastore.loader.RichTextParser;
import gui.ErrorHandler;
import gui.UnicodeInputStream;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import util.FileUtils;
import util.Util;

public class RichText {
    String orig;
    boolean parsed;
    Vector lines = new Vector();
    public DataColumn.FileInfo fileInfo = null;
    protected static char[] breakChars = new char[]{' ', ',', '/', '\\', '*'};

    public RichText(String s, DataColumn.FileInfo fileInfo) {
        this(s, true, fileInfo);
    }

    public RichText(String s, boolean parse, DataColumn.FileInfo fileInfo) {
        this.orig = s == null ? "" : s;
        this.parsed = parse;
        this.fileInfo = fileInfo;
        this.restore();
    }

    public RichText(String s, boolean parse, DataColumn.FileInfo fileInfo, RangeColumn rCol) {
        this.orig = s == null ? "" : s;
        this.parsed = parse;
        this.fileInfo = fileInfo;
        if (rCol.speciesPhenonTreeDrawing && this.orig.contains("|")) {
            String tmp = new String(this.orig);
            this.orig = this.orig.split(" ")[0];
            if (tmp.contains(" <")) {
                tmp = tmp.split(" <")[1];
                this.orig = this.orig + " <" + tmp;
            }
        }
        this.restore();
    }

    public String getSourceText() {
        return this.orig;
    }

    public RichText(RichText other) {
        this(other.orig, other.parsed, other.fileInfo);
    }

    public final void restore() {
        this.lines = new Vector();
        if (this.parsed && this.orig.length() > 0) {
            ByteArrayInputStream in = new ByteArrayInputStream(this.orig.getBytes());
            String enc = "UTF-8";
            UnicodeInputStream uin = new UnicodeInputStream(in, enc);
            try {
                new RichTextParser(in).parseRichText(this);
                this.matchTags();
            }
            catch (ParseException e) {
                ErrorHandler.printException(e, "parse failed:\n" + e.toString() + "\nstring:\n" + this.orig + "\nendstring");
            }
        } else {
            Line l = new Line();
            l.addElement(new StringElement(this.orig));
            this.lines.add(l);
        }
    }

    protected void matchTags() {
        EndTagElement end;
        Stack s;
        BeginTagElement begin;
        Element e;
        int i;
        Line l = this.getLine(0);
        HashMap<String, Stack<BeginTagElement>> types = new HashMap<String, Stack<BeginTagElement>>();
        for (i = 0; i < l.elements.size(); ++i) {
            e = (Element)l.elements.get(i);
            if (e instanceof BeginTagElement) {
                begin = (BeginTagElement)e;
                if (begin.needsEnd) {
                    s = (Stack)types.get(begin.tagName);
                    if (s == null) {
                        s = new Stack();
                        types.put(begin.tagName, s);
                    }
                    s.push(begin);
                }
                if (!(e instanceof ImageTag)) continue;
                ((ImageTag)e).calculate();
                continue;
            }
            if (!(e instanceof EndTagElement)) continue;
            end = (EndTagElement)e;
            s = (Stack)types.get(end.tagName);
            if (s == null || s.size() == 0) {
                l.elements.set(i, new StringElement(end.codeString()));
                continue;
            }
            BeginTagElement begin2 = (BeginTagElement)s.pop();
            begin2.endTag = end;
        }
        s = new Stack();
        for (i = 0; i < l.elements.size(); ++i) {
            e = (Element)l.elements.get(i);
            if (e instanceof BeginTagElement) {
                begin = (BeginTagElement)e;
                if (begin.needsEnd && begin.endTag == null) {
                    l.elements.set(i, new StringElement(begin.codeString()));
                    continue;
                }
                if (!begin.needsEnd) continue;
                s.push(begin);
                continue;
            }
            if (e instanceof EndTagElement) {
                end = (EndTagElement)e;
                s.pop();
                continue;
            }
            if (!(e instanceof StringElement)) continue;
            StringElement string = (StringElement)e;
            string.openTags.addAll(s);
        }
    }

    public static BeginTagElement getBeginTag(String tagname, DataColumn.FileInfo fileInfo) {
        if (tagname.compareToIgnoreCase("img") == 0) {
            return new ImageTag(fileInfo);
        }
        if (tagname.compareToIgnoreCase("a") == 0) {
            return new BeginTagElement(tagname);
        }
        return null;
    }

    public Line getLine(int i) {
        return (Line)this.lines.get(i);
    }

    public String getVis(int i) {
        return ((Line)this.lines.get(i)).getVisibleString();
    }

    public int getNumLines() {
        return this.lines.size();
    }

    public String getOriginalString() {
        return this.orig;
    }

    public void setOriginalString(String s) {
        this.orig = s;
    }

    public void splitOnNewlines(double maxHeight, FontMetrics fm, Graphics g) {
        double totalHeight = 0.0;
        if (maxHeight > 0.0) {
            for (int i = 0; i < this.lines.size(); ++i) {
                totalHeight += this.getLine(i).getHeight();
            }
        }
        CutInfo ci1 = new CutInfo();
        CutInfo ci2 = new CutInfo();
        for (int i = 0; i < this.lines.size() && (maxHeight <= 0.0 || totalHeight < maxHeight); ++i) {
            Line l = this.getLine(i);
            Iterator iter = l.elements.iterator();
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                if (!(e instanceof BeginTagElement)) continue;
                BeginTagElement tag = (BeginTagElement)e;
                if (tag.tagName.compareToIgnoreCase("br") != 0) continue;
                l.getCutInfo(tag, ci1, ci2, fm, g);
                double newHeight = totalHeight - l.getHeight() + ci1.height + ci2.height;
                if (!(newHeight <= maxHeight)) continue;
                iter.remove();
                Line rest = new Line();
                while (iter.hasNext()) {
                    e = (Element)iter.next();
                    iter.remove();
                    rest.addElement(e);
                }
                this.lines.insertElementAt(rest, i + 1);
                l.calculateBounds(fm, g, i != 0);
                rest.calculateBounds(fm, g, true);
                totalHeight = newHeight;
                break;
            }
            int newline = l.getNewline();
            double oldLHeight = l.getHeight();
            Line rest = l.splitVisibleLine(newline, false, i == 0, fm, g);
            if (rest == null) continue;
            totalHeight = totalHeight - oldLHeight + l.getHeight() + rest.getHeight();
        }
    }

    void insertAfter(Line curLine, Line newLine) {
        int i = this.lines.indexOf(curLine);
        this.lines.add(i + 1, newLine);
    }

    public void addElement(Element e) {
        if (this.lines.size() == 0) {
            this.lines.add(new Line());
        }
        Line l = (Line)this.lines.get(this.lines.size() - 1);
        l.addElement(e);
    }

    public static int getBreak(String s, int start) {
        int ret = s.indexOf(breakChars[0], start);
        for (int i = 1; i < breakChars.length; ++i) {
            int index = s.indexOf(breakChars[i], start);
            if (index < 0 || index > s.length() - 2) continue;
            ret = Math.min(ret, index + 1);
        }
        return ret;
    }

    public static int getLastBreak(String s, int start) {
        int ret = s.lastIndexOf(breakChars[0], start);
        for (int i = 1; i < breakChars.length; ++i) {
            int index = s.lastIndexOf(breakChars[i], start);
            if (index < 0 || index > s.length() - 2) continue;
            ret = Math.max(ret, index + 1);
        }
        return ret;
    }

    public static class EndTagElement
    extends Element {
        String tagName;

        public EndTagElement(String tag) {
            this.tagName = tag;
        }

        public String codeString() {
            return "</" + this.tagName + ">";
        }
    }

    public static class ImageTag
    extends BeginTagElement {
        double height = -1.0;
        URL source = null;
        String align = "bottom";
        boolean isValid = false;
        DataColumn.FileInfo fileInfo = null;
        double aboveText = 0.0;

        public ImageTag(DataColumn.FileInfo fileInfo) {
            super("img");
            this.width = -1.0;
            this.fileInfo = fileInfo;
        }

        @Override
        public String visibleString() {
            return "*";
        }

        public void calculate() {
            Iterator attribIter = this.attributes.keySet().iterator();
            String sourceS = null;
            while (attribIter.hasNext()) {
                String key = attribIter.next().toString();
                String value = this.attributes.get(key).toString();
                if (key.compareToIgnoreCase("width") == 0) {
                    this.width = Util.parseLengthUnits(value, this.width);
                    continue;
                }
                if (key.compareToIgnoreCase("height") == 0) {
                    this.height = Util.parseLengthUnits(value, this.height);
                    continue;
                }
                if (key.compareToIgnoreCase("src") == 0) {
                    sourceS = value;
                    continue;
                }
                if (key.compareToIgnoreCase("align") != 0) continue;
                this.align = value;
            }
            this.source = FileUtils.getAbsoluteImageURL(sourceS, this.fileInfo);
            Dimension imgDims = null;
            if (this.source != null) {
                imgDims = Util.getImageDimensions(this.source);
            }
            if (this.height == -1.0 && this.width > 0.0 && imgDims != null) {
                double pxWidth = imgDims.width;
                double pxHeight = imgDims.height;
                this.height = pxHeight * this.width / pxWidth;
            } else if (this.width == -1.0 && this.height > 0.0 && imgDims != null) {
                double pxWidth = imgDims.width;
                double pxHeight = imgDims.height;
                this.width = pxWidth * this.height / pxHeight;
            } else if (this.width == -1.0 && this.height == -1.0 && imgDims != null) {
                this.width = imgDims.width;
                this.height = imgDims.height;
            }
            if (this.width <= 0.0 || this.height <= 0.0 || this.source == null) {
                this.isValid = false;
                return;
            }
            this.computeAboveText(5.0);
            this.isValid = true;
        }

        public void computeAboveText(double ascent) {
            this.aboveText = this.align.compareToIgnoreCase("middle") == 0 ? this.height / 2.0 : (this.align.compareToIgnoreCase("top") == 0 ? ascent : this.height);
        }
    }

    public static class BeginTagElement
    extends Element {
        String tagName;
        boolean meaningful = false;
        boolean needsEnd = false;
        EndTagElement endTag = null;
        Map attributes = new HashMap();
        String styleChanges = null;

        public BeginTagElement(String tag) {
            this.tagName = tag;
            if (this.tagName.compareToIgnoreCase("a") == 0) {
                this.meaningful = true;
                this.needsEnd = true;
                this.styleChanges = "text-decoration: underline;";
                this.setAttribute("xlink:show", "other");
                this.setAttribute("visibility", "visible");
            } else if (this.tagName.compareToIgnoreCase("br") == 0) {
                this.meaningful = true;
                this.needsEnd = false;
            } else if (this.tagName.compareToIgnoreCase("img") == 0) {
                this.meaningful = true;
                this.needsEnd = false;
            }
        }

        public boolean isMeaningful() {
            return this.meaningful;
        }

        public void setAttribute(String attrib, String value) {
            this.attributes.put(attrib, value);
        }

        @Override
        public String visibleString() {
            if (this.tagName.compareToIgnoreCase("br") == 0) {
                return "\n";
            }
            return super.visibleString();
        }

        public String codeString() {
            String ret = "<" + this.tagName;
            for (Object key : this.attributes.keySet()) {
                Object value = this.attributes.get(key);
                ret = ret + " " + key.toString() + "=\"" + value.toString() + "\"";
            }
            return ret + ">";
        }
    }

    public static class StringElement
    extends Element {
        public String s;
        public List openTags = new Vector();

        public StringElement(String s) {
            this.s = s;
        }

        @Override
        public String visibleString() {
            return this.s;
        }

        @Override
        public Element splitVisible(int where, boolean trim, boolean trimRestInitialNewline) {
            if (where >= this.s.length()) {
                return null;
            }
            String rest = this.s.substring(where);
            this.s = this.s.substring(0, where);
            if (trim) {
                while (this.s.length() > 0 && this.s.charAt(this.s.length() - 1) == ' ') {
                    this.s = this.s.substring(0, this.s.length() - 1);
                }
                while (rest.length() > 0 && rest.charAt(0) == ' ') {
                    rest = rest.substring(1);
                }
            }
            if (trimRestInitialNewline) {
                if (rest.length() > 0 && rest.startsWith("\r")) {
                    rest = rest.substring(1);
                }
                if (rest.length() > 0 && rest.startsWith("\n")) {
                    rest = rest.substring(1);
                }
            }
            StringElement ret = new StringElement(rest);
            return ret;
        }
    }

    public static class Element {
        double width = 0.0;

        public String visibleString() {
            return "";
        }

        public Element splitVisible(int where, boolean trim, boolean trimRestInitialNewline) {
            return null;
        }
    }

    public class Line {
        List elements = new Vector(5);
        String cachedVisible = null;
        double width = -1.0;
        double ascent = -1.0;
        double descent = -1.0;

        public Line splitVisibleLine(int where, boolean trim, boolean amIFirst, FontMetrics fm, Graphics g) {
            if (where <= 0) {
                return null;
            }
            this.cachedVisible = null;
            int splitStartIndex = 0;
            String vis = "";
            int lastVisLength = 0;
            for (Element e : this.elements) {
                ++splitStartIndex;
                lastVisLength = vis.length();
                if ((vis = vis + e.visibleString()).length() - 1 >= where) {
                    if ((e = e.splitVisible(where - lastVisLength, trim, true)) == null) break;
                    this.elements.add(splitStartIndex, e);
                    break;
                }
                if (vis.length() != where) continue;
                trim = false;
                break;
            }
            if (splitStartIndex >= this.elements.size()) {
                return null;
            }
            Line rest = new Line();
            while (splitStartIndex < this.elements.size()) {
                rest.addElement((Element)this.elements.remove(splitStartIndex));
            }
            RichText.this.insertAfter(this, rest);
            this.calculateBounds(fm, g, !amIFirst);
            rest.calculateBounds(fm, g, true);
            return rest;
        }

        public int getNewline() {
            String s = this.getVisibleString();
            s = s.replaceAll("\r\n", "\n");
            s = s.replace('\r', '\n');
            int i = s.indexOf(10);
            return i;
        }

        public int getBreak() {
            return RichText.getBreak(this.getVisibleString(), 0);
        }

        public int getBreak(int start) {
            return RichText.getBreak(this.getVisibleString(), start);
        }

        public int getLastBreak() {
            String s = this.getVisibleString();
            return RichText.getLastBreak(s, s.length());
        }

        public int getLastBreak(int start) {
            String s = this.getVisibleString();
            return RichText.getLastBreak(s, start);
        }

        public String getVisibleString() {
            if (this.cachedVisible != null) {
                return this.cachedVisible;
            }
            Iterator iter = this.elements.iterator();
            String ret = "";
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                ret = ret + e.visibleString();
            }
            this.cachedVisible = ret;
            return ret;
        }

        public void addElement(Element e) {
            this.elements.add(e);
            this.cachedVisible = null;
        }

        public void calculateBounds(FontMetrics fm, Graphics gContext, boolean addSpacingToHeight) {
            this.width = 0.0;
            this.ascent = fm.getAscent();
            this.descent = 0.0;
            for (Object o : this.elements) {
                if (o instanceof StringElement) {
                    StringElement se = (StringElement)o;
                    Rectangle2D rect = fm.getStringBounds(se.visibleString(), gContext);
                    se.width = rect.getWidth();
                    this.width += se.width;
                    this.descent = Math.max(this.descent, rect.getHeight() - (double)fm.getAscent());
                    continue;
                }
                if (!(o instanceof ImageTag)) continue;
                ImageTag imgTag = (ImageTag)o;
                imgTag.computeAboveText(fm.getAscent());
                this.ascent = Math.max(this.ascent, imgTag.aboveText);
                this.descent = Math.max(this.descent, imgTag.height - imgTag.aboveText);
                this.width += imgTag.width;
            }
            if (addSpacingToHeight) {
                this.ascent += (double)fm.getLeading();
            }
        }

        public double getHeight() {
            return this.ascent + this.descent;
        }

        public void getCutInfo(int cutPoint, CutInfo firstOut, CutInfo secondOut, FontMetrics fm, Graphics gContext) {
            int charCount = 0;
            boolean justLookingAtSecond = false;
            if (firstOut == null) {
                firstOut = new CutInfo();
            }
            if (secondOut == null) {
                secondOut = new CutInfo();
            }
            firstOut.clear();
            secondOut.clear();
            for (Element o : this.elements) {
                justLookingAtSecond = charCount >= cutPoint;
                if (o instanceof StringElement) {
                    Rectangle2D rect;
                    StringElement se = (StringElement)o;
                    String vis = se.visibleString();
                    if (charCount + vis.length() <= cutPoint) {
                        charCount += vis.length();
                        firstOut.width += se.width;
                        rect = fm.getStringBounds(vis, gContext);
                        firstOut.height = Math.max(firstOut.height, rect.getHeight());
                        firstOut.visibleString = firstOut.visibleString + vis;
                        continue;
                    }
                    if (!justLookingAtSecond) {
                        int viscut = cutPoint - charCount;
                        String sub = vis.substring(0, viscut);
                        rect = fm.getStringBounds(sub, gContext);
                        firstOut.width += rect.getWidth();
                        firstOut.height = Math.max(firstOut.height, rect.getHeight());
                        charCount += viscut;
                        firstOut.visibleString = firstOut.visibleString + sub;
                        secondOut.visibleString = vis.substring(viscut);
                        rect = fm.getStringBounds(secondOut.visibleString, gContext);
                        secondOut.height = rect.getHeight();
                        secondOut.width = rect.getWidth();
                        continue;
                    }
                    charCount += vis.length();
                    secondOut.width += se.width;
                    rect = fm.getStringBounds(vis, gContext);
                    secondOut.height = Math.max(secondOut.height, rect.getHeight());
                    secondOut.visibleString = secondOut.visibleString + vis;
                    continue;
                }
                if (!(o instanceof ImageTag)) continue;
                ImageTag imgTag = (ImageTag)o;
                if (!justLookingAtSecond) {
                    firstOut.width += imgTag.width;
                    ++charCount;
                    firstOut.height = Math.max(firstOut.height, imgTag.height);
                    firstOut.visibleString = firstOut.visibleString + imgTag.visibleString();
                    continue;
                }
                secondOut.width += imgTag.width;
                ++charCount;
                secondOut.height = Math.max(secondOut.height, imgTag.height);
                secondOut.visibleString = secondOut.visibleString + imgTag.visibleString();
            }
        }

        public void getCutInfo(Element cutElement, CutInfo firstOut, CutInfo secondOut, FontMetrics fm, Graphics gContext) {
            if (firstOut == null) {
                firstOut = new CutInfo();
            }
            if (secondOut == null) {
                secondOut = new CutInfo();
            }
            firstOut.clear();
            secondOut.clear();
            CutInfo accumulator = firstOut;
            for (Element o : this.elements) {
                if (o == cutElement) {
                    accumulator = secondOut;
                    continue;
                }
                if (o instanceof StringElement) {
                    StringElement se = (StringElement)o;
                    String vis = se.visibleString();
                    accumulator.width += se.width;
                    Rectangle2D rect = fm.getStringBounds(vis, gContext);
                    accumulator.height = Math.max(accumulator.height, rect.getHeight());
                    accumulator.visibleString = accumulator.visibleString + vis;
                    continue;
                }
                if (!(o instanceof ImageTag)) continue;
                ImageTag imgTag = (ImageTag)o;
                accumulator.width += imgTag.width;
                accumulator.height = Math.max(accumulator.height, imgTag.height);
                accumulator.visibleString = accumulator.visibleString + imgTag.visibleString();
            }
        }

        public void scaleNonText(double factor) {
            for (Object o : this.elements) {
                if (!(o instanceof ImageTag)) continue;
                ImageTag imgTag = (ImageTag)o;
                imgTag.height *= factor;
                imgTag.width *= factor;
                imgTag.aboveText *= factor;
            }
        }
    }

    public static class CutInfo {
        double width;
        double height;
        String visibleString;

        public void clear() {
            this.width = 0.0;
            this.height = 0.0;
            this.visibleString = "";
        }
    }
}

