/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.TSCreator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import path.ResPath;
import util.FileUtils;

public class Language {
    private static int SELECTED_LANGUAGE = 0;
    private static String[] languages;
    private static HashMap<String, Integer> optionalLanguages;
    private static HashMap<String, String[]> translations;
    private static final InputStream languageInfo;

    private Language() {
    }

    public static String[] getLanguages() {
        return languages;
    }

    public static void setLanguage(String lang) {
        SELECTED_LANGUAGE = optionalLanguages.get(lang.toUpperCase());
        if (SELECTED_LANGUAGE == -1) {
            SELECTED_LANGUAGE = optionalLanguages.get("ENGLISH");
        }
    }

    public static String translate(String label, boolean yes) {
        String translatedLabel;
        if (!translations.containsKey(label) || (translatedLabel = translations.get(label)[SELECTED_LANGUAGE]) == null || !yes) {
            System.out.print(label);
            return label;
        }
        return translatedLabel;
    }

    public static JMenu languageSelectionPanel() {
        JMenu mLang = new JMenu(Language.translate("Language", true));
        ButtonGroup group = new ButtonGroup();
        mLang.setMnemonic('0');
        String[] languages = Language.getLanguages();
        for (int i = 0; i < languages.length; ++i) {
            JRadioButtonMenuItem lang = new JRadioButtonMenuItem(languages[i].toLowerCase());
            lang.setMnemonic(49 + i);
            lang.setSelected(i == SELECTED_LANGUAGE);
            lang.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Language.setLanguage(ae.getActionCommand());
                    TSCreator.curCreator.clearData();
                    TSCreator.tscFrame.dispose();
                    TSCreator.curCreator.removeAll();
                    TSCreator.curCreator = null;
                    TSCreator.startTSC();
                }
            });
            group.add(lang);
            mLang.add((Component)lang, i);
        }
        return mLang;
    }

    static {
        optionalLanguages = new HashMap();
        translations = new HashMap();
        languageInfo = FileUtils.getInputStream(ResPath.getPath("settings_xml.language_info"));
        try {
            String strRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(languageInfo, "UTF-8"));
            while ((strRead = reader.readLine()) != null) {
                String[] values = strRead.split("\t", -1);
                String rowType = values[0];
                if (rowType.equalsIgnoreCase("COMMENT")) continue;
                if (rowType.equalsIgnoreCase("LANGUAGES")) {
                    languages = new String[values.length - 1];
                    for (int i = 1; i < values.length; ++i) {
                        optionalLanguages.put(values[i].toUpperCase(), i - 1);
                        Language.languages[i - 1] = values[i];
                    }
                    continue;
                }
                if (!rowType.equalsIgnoreCase("LABELINFO")) continue;
                String[] lang = new String[values.length - 1];
                for (int i = 1; i < values.length; ++i) {
                    lang[i - 1] = values[i];
                }
                if (lang.length != optionalLanguages.size()) {
                    throw new Exception("File not parsable: " + ResPath.getFilename("settings_xml.language_info"));
                }
                if (translations.containsKey(lang[optionalLanguages.get("ENGLISH")])) continue;
                translations.put(lang[optionalLanguages.get("ENGLISH")], lang);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }
}

