/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ModifyTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.svg.SVGDocument;
import util.Util;

public class ImageSizeDialog
extends JDialog
implements ActionListener {
    private JLabel sizeLabel;
    private JLabel widthLabel;
    private JButton cancel;
    private JButton ok;
    private JPanel buttonPanel;
    private ButtonGroup unitGroup;
    private JLabel heightLabel;
    private ModifyTextField heightTF;
    private ModifyTextField widthTF;
    private JPanel textPanel;
    private JRadioButton unitInch;
    private JRadioButton unitCM;
    private JPanel unitSelectPanel;
    protected SVGDocument doc;
    protected ImageInfo ii;

    public ImageSizeDialog(JFrame frame, SVGDocument doc) {
        super(frame);
        this.doc = doc;
        this.initGUI();
        this.initData();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Image Size");
            this.setDefaultCloseOperation(2);
            this.setModal(true);
            this.setPreferredSize(new Dimension(264, 152));
            this.sizeLabel = new JLabel();
            this.getContentPane().add((Component)this.sizeLabel, "North");
            this.sizeLabel.setText("Size in SVG units: 0 x 0");
            this.sizeLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.buttonPanel = new JPanel();
            GridBagLayout buttonPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            buttonPanelLayout.rowWeights = new double[]{0.1};
            buttonPanelLayout.rowHeights = new int[]{7};
            buttonPanelLayout.columnWeights = new double[]{1.0, 0.1, 0.1};
            buttonPanelLayout.columnWidths = new int[]{7, 7, 7};
            this.buttonPanel.setLayout(buttonPanelLayout);
            this.buttonPanel.add((Component)this.getOk(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.buttonPanel.add((Component)this.getCancel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.unitSelectPanel = new JPanel();
            BoxLayout unitSelectPanelLayout = new BoxLayout(this.unitSelectPanel, 1);
            this.unitSelectPanel.setLayout(unitSelectPanelLayout);
            this.getContentPane().add((Component)this.unitSelectPanel, "East");
            this.unitSelectPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.unitCM = new JRadioButton();
            this.unitSelectPanel.add(this.unitCM);
            this.unitCM.setText("cm");
            this.unitCM.addActionListener(this);
            this.unitInch = new JRadioButton();
            this.unitSelectPanel.add(this.unitInch);
            this.unitInch.setText("inches");
            this.unitInch.addActionListener(this);
            this.textPanel = new JPanel();
            GridBagLayout textPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.textPanel, "Center");
            textPanelLayout.rowWeights = new double[]{0.1, 0.1};
            textPanelLayout.rowHeights = new int[]{7, 7};
            textPanelLayout.columnWeights = new double[]{0.0, 1.0};
            this.textPanel.setLayout(textPanelLayout);
            this.textPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.widthLabel = new JLabel();
            this.textPanel.add((Component)this.widthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.widthLabel.setText("Width: ");
            this.widthTF = new ModifyTextField();
            this.textPanel.add((Component)this.widthTF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.widthTF.setText("100");
            this.widthTF.addActionListener(this);
            this.heightLabel = new JLabel();
            this.textPanel.add((Component)this.heightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.heightLabel.setText("Height: ");
            this.heightTF = new ModifyTextField();
            this.textPanel.add((Component)this.heightTF, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.heightTF.setText("200");
            this.heightTF.addActionListener(this);
            this.setSize(264, 152);
            this.unitGroup = this.getUnitGroup();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private ButtonGroup getUnitGroup() {
        if (this.unitGroup == null) {
            this.unitGroup = new ButtonGroup();
            this.unitGroup.add(this.unitCM);
            this.unitGroup.add(this.unitInch);
        }
        return this.unitGroup;
    }

    private JButton getOk() {
        if (this.ok == null) {
            this.ok = new JButton();
            this.ok.setText("OK");
            this.ok.addActionListener(this);
        }
        return this.ok;
    }

    private JButton getCancel() {
        if (this.cancel == null) {
            this.cancel = new JButton();
            this.cancel.setText("Cancel");
            this.cancel.addActionListener(this);
        }
        return this.cancel;
    }

    private void initData() {
        if (this.doc == null) {
            this.sizeLabel.setText("ERROR");
            this.ok.setEnabled(false);
        }
        this.ii = new ImageInfo(this.doc);
        this.widthTF.setText("" + this.ii.unitWidth);
        this.heightTF.setText("" + this.ii.unitHeight);
        this.sizeLabel.setText("Size in SVG units:  " + this.ii.svgWidth + " x " + this.ii.svgHeight);
        if (this.ii.unit == 1) {
            this.unitCM.setSelected(true);
        } else {
            this.unitInch.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.cancel) {
            this.dispose();
        } else if (ae.getSource() == this.ok) {
            if (this.ii.unitWidth > 0.001 && this.ii.unitHeight > 0.001) {
                this.ii.convertTo(1);
                this.doc.getRootElement().setAttributeNS(null, "width", "" + this.ii.unitWidth + "cm");
                this.doc.getRootElement().setAttributeNS(null, "height", "" + this.ii.unitHeight + "cm");
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Please enter widths and heights greater than zero.", "Error", 0);
            }
        } else if (ae.getSource() == this.widthTF) {
            String s = this.widthTF.getText();
            this.ii.unitWidth = Util.parseDoubleLax(s, 0.0);
            this.ii.unitHeight = this.ii.unitWidth / this.ii.aspect;
            this.heightTF.setText("" + this.ii.unitHeight);
        } else if (ae.getSource() == this.heightTF) {
            String s = this.heightTF.getText();
            this.ii.unitHeight = Util.parseDoubleLax(s, 0.0);
            this.ii.unitWidth = this.ii.unitHeight * this.ii.aspect;
            this.widthTF.setText("" + this.ii.unitWidth);
        } else if (ae.getSource() == this.unitCM) {
            this.ii.convertTo(1);
            this.widthTF.setText("" + this.ii.unitWidth);
            this.heightTF.setText("" + this.ii.unitHeight);
        } else if (ae.getSource() == this.unitInch) {
            this.ii.convertTo(2);
            this.widthTF.setText("" + this.ii.unitWidth);
            this.heightTF.setText("" + this.ii.unitHeight);
        }
    }

    public static class ImageInfo {
        protected double svgWidth;
        protected double svgHeight;
        protected double aspect = 1.0;
        protected double unitWidth;
        protected double unitHeight;
        protected int unit = 1;
        public static final int CM = 1;
        public static final int INCH = 2;

        public ImageInfo() {
        }

        public ImageInfo(SVGDocument doc) {
            NamedNodeMap attribs = doc.getRootElement().getAttributes();
            String width = attribs.getNamedItem("width").getNodeValue();
            this.unitWidth = Util.parseDoubleLax(width, 10.0);
            String height = attribs.getNamedItem("height").getNodeValue();
            this.unitHeight = Util.parseDoubleLax(height, 10.0);
            String viewbox = attribs.getNamedItem("viewBox").getNodeValue();
            StringTokenizer tok = new StringTokenizer(viewbox);
            String x = tok.nextToken();
            String y = tok.nextToken();
            width = tok.nextToken();
            height = tok.nextToken();
            this.svgWidth = Util.parseDoubleLax(width, 10.0);
            this.svgHeight = Util.parseDoubleLax(height, 10.0);
            this.aspect = this.svgWidth / this.svgHeight;
        }

        public void convertTo(int unitTo) {
            switch (this.unit) {
                case 1: {
                    if (unitTo != 2) break;
                    this.unitWidth /= 2.54;
                    this.unitHeight /= 2.54;
                    break;
                }
                case 2: {
                    if (unitTo != 1) break;
                    this.unitWidth *= 2.54;
                    this.unitHeight *= 2.54;
                }
            }
            this.unit = unitTo;
        }
    }
}

