/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.TSCreator;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ErrorHandler
extends JDialog {
    public static final int NORMAL = 1;
    public static final int SUCCESS = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int INFO = 5;
    public static final int DEBUG = 6;
    public static final boolean isProgrammerMode = false;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ErrorHandler inst = new ErrorHandler(frame);
                inst.setVisible(true);
            }
        });
    }

    public ErrorHandler(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setSize(400, 300);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static void showError(String message, String title, int level) {
        ErrorHandler.showError(null, message, title, level);
    }

    public static void showError(Exception e, String message, String title, int level) {
        if (e != null) {
            ErrorHandler.printException(e, message);
        }
        String text = "";
        if (message != null) {
            text = text + message + "\n";
        }
        if (e != null) {
            text = text + "Exception message: " + e.getLocalizedMessage() + "\n";
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String string = sw.toString();
        }
        if (TSCreator.autoSaveFile == null) {
            ErrorHandler.messageBox(text, title, level);
        } else {
            TSCreator.exit();
        }
    }

    public static void messageBox(String text, String title, int type) {
        int outType;
        switch (type) {
            case 2: {
                outType = 1;
                break;
            }
            case 4: {
                outType = 2;
                break;
            }
            case 3: {
                outType = 0;
                break;
            }
            default: {
                outType = -1;
            }
        }
        JOptionPane.showMessageDialog(null, text, title, outType);
    }

    public static void printException(Exception e) {
        ErrorHandler.printException(e, null);
    }

    public static void printException(Exception e, String message) {
        if (message != null) {
            System.out.println(message);
        }
        e.printStackTrace(System.out);
    }

    public static void log(String s) {
        ErrorHandler.log(s, 1);
    }

    public static void log(String s, int type) {
        System.out.println(s);
    }
}

