/*
 * Decompiled with CFR 0.152.
 */
package datastore.rasc;

import gui.editor.SpreadSheetTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class DictionaryData
extends SpreadSheetTableModel {
    public static final int NUM_ENTRIES = 998;
    public static final int NULL = -1;
    JTableHeader header = null;
    MouseHandler mouseListener = new MouseHandler();
    public int numUE = 0;
    public int numMH = 0;
    public boolean UEDisabled = false;
    public boolean MHDisabled = false;

    public DictionaryData() {
        this.data.ensureCapacity(998);
        this.columnNames.add("Fossil #");
        this.columnNames.add("Fossil Name");
        this.columnNames.add("Nickname");
        this.columnNames.add("count");
        this.columnNames.add("UE");
        this.columnNames.add("MH");
        this.columnNames.add("Microfossil Group");
        this.columnNames.add("Optional");
        this.columnNames.add("Optional");
        this.clear();
    }

    public void setUE(int id, boolean tf) {
        for (DicRow row : this.data) {
            if (row.getID() != id) continue;
            row.setUE(tf);
            break;
        }
    }

    public void setMH(int id, boolean tf) {
        for (DicRow row : this.data) {
            if (row.getID() != id) continue;
            row.setMH(tf);
            break;
        }
    }

    public void clear() {
        this.data.removeAllElements();
        for (int i = 0; i < 998; ++i) {
            DicRow row = new DicRow();
            row.setName("");
            row.setID(-1);
            this.data.add(row);
        }
    }

    @Override
    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return FossilID.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return Boolean.class;
            }
            case 6: {
                return MicroFossilGroup.class;
            }
            case 7: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 3;
    }

    public void set(int index, String name, int id) {
        DicRow row = (DicRow)this.getRow(index);
        row.setName(name);
        row.setID(id);
    }

    public void setRow(int index, DicRow row) {
        this.data.set(index, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicRow getRowByID(int id) {
        Vector vector = this.data;
        synchronized (vector) {
            for (DicRow row : this.data) {
                if (row.getID() != id) continue;
                return row;
            }
        }
        return null;
    }

    @Override
    public String addRows(int numRows, int startRow) {
        int rowsAdded = 0;
        for (int i = 0; i < numRows; ++i) {
            DicRow last = (DicRow)this.data.lastElement();
            if (last.isPracticallyEmpty()) {
                this.data.insertElementAt(new DicRow(), startRow);
                this.data.remove(this.data.size() - 1);
                ++rowsAdded;
                continue;
            }
            this.fireTableRowsInserted(startRow, startRow + rowsAdded);
            return "Cannot insert another row because the last row would be removed, but it is non empty. Clear the last row to insert. <br>Only 998 rows are allowed (RASC limit).";
        }
        this.fireTableRowsInserted(startRow, startRow + rowsAdded);
        return null;
    }

    @Override
    public String removeRows(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            this.data.removeElementAt(rows[i]);
            this.data.add(new DicRow());
            this.fireTableRowsDeleted(rows[i], rows[i]);
        }
        return null;
    }

    @Override
    public TableCellRenderer getTableCellRenderer(int row, int column) {
        DicRow r;
        if (column == 0 && (r = (DicRow)this.getRow(row)).getID() == -1) {
            return null;
        }
        return super.getTableCellRenderer(row, column);
    }

    public void setTableHeader(JTableHeader h) {
        if (this.header != null) {
            this.header.removeMouseListener(this.mouseListener);
        }
        this.header = h;
        if (this.header != null) {
            h.addMouseListener(this.mouseListener);
        }
    }

    public void sortColumn(int which) {
        Collections.sort(this.data, new ColumnSorter(which));
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0 && value != null) {
            try {
                value = new Integer(value.toString());
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        super.setValueAt(value, row, col);
    }

    private void dumpData() {
        for (DicRow row : this.data) {
            System.out.println("" + row.getID() + "   " + row.getName());
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1 && column >= 0 && column <= 3) {
                DictionaryData.this.sortColumn(column);
            }
        }
    }

    private class ColumnSorter
    implements Comparator {
        int col;

        public int compare(Object leftRow, Object rightRow) {
            String r;
            String l;
            Object left = ((SpreadSheetTableModel.Row)leftRow).getCol(this.col);
            Object right = ((SpreadSheetTableModel.Row)rightRow).getCol(this.col);
            if (left instanceof String && (l = left.toString()).trim().length() == 0) {
                left = null;
            }
            if (right instanceof String && (r = right.toString()).trim().length() == 0) {
                right = null;
            }
            if (left instanceof Integer && (Integer)left == -1) {
                left = null;
            }
            if (right instanceof Integer && (Integer)right == -1) {
                right = null;
            }
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            if (left instanceof String && right instanceof String) {
                return left.toString().compareToIgnoreCase(right.toString());
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo(right);
            }
            return 0;
        }

        ColumnSorter(int which) {
            this.col = which;
        }
    }

    public static class MicroFossilGroup {
        public static JComboBox getComboBox() {
            JComboBox<String> cb = new JComboBox<String>();
            cb.addItem("");
            cb.addItem("AC Acritarchs");
            cb.addItem("DC Dinoflagellate cysts");
            cb.addItem("ABF Agglutinated benthic foraminifers");
            cb.addItem("CBF Calcareous benthic foraminifers");
            cb.addItem("PF Planktonic foraminifers");
            cb.addItem("DI Diatoms");
            cb.addItem("NA Nannofossils");
            cb.addItem("CA Bolboforma and other calcareous algae");
            cb.addItem("OS Ostracods");
            cb.addItem("RA Radiolarians");
            cb.addItem("SP Spores, pollen");
            cb.addItem("MM Miscellaneous (everything else)");
            return cb;
        }
    }

    public static class FossilID {
    }

    public static class DicRow
    extends SpreadSheetTableModel.Row {
        int tempCount;

        public DicRow() {
            this.cells.setSize(9);
            this.setID(-1);
            this.cells.set(1, "");
            this.cells.set(2, "");
            this.cells.set(3, null);
            this.cells.set(4, new Boolean(false));
            this.cells.set(5, new Boolean(false));
            this.cells.set(6, "");
            this.cells.set(7, "");
            this.cells.set(8, "");
        }

        public DicRow(DicRow other) {
            this.cells = (Vector)other.cells.clone();
        }

        public boolean isPracticallyEmpty() {
            String name = this.getName();
            int id = this.getID();
            return (name == null || name.trim().length() == 0) && id == -1;
        }

        public void setName(String name) {
            this.cells.set(1, name);
        }

        public void setID(int id) {
            if (id == 999) {
                id = 998;
            }
            if (id < 0) {
                this.cells.set(0, null);
            } else {
                this.cells.set(0, new Integer(id));
            }
        }

        public String getName() {
            return this.getCol(1).toString();
        }

        public int getID() {
            Object o = this.getCol(0);
            if (o == null || !(o instanceof Integer)) {
                return -1;
            }
            return (Integer)this.getCol(0);
        }

        public void setNickname(String name) {
            this.cells.set(2, name);
        }

        public String getNickname() {
            return this.getCol(2).toString();
        }

        public void setCount(int c) {
            if (c == 0) {
                this.cells.set(3, null);
            } else {
                this.cells.set(3, new Integer(c));
            }
        }

        public int getCount() {
            Object o = this.cells.get(3);
            if (o == null) {
                return 0;
            }
            return (Integer)o;
        }

        public void setUE(boolean tf) {
            this.cells.set(4, new Boolean(tf));
        }

        public boolean getUE() {
            Object o = this.getCol(4);
            if (o == null || !(o instanceof Boolean)) {
                return false;
            }
            return (Boolean)o;
        }

        public void setMH(boolean tf) {
            this.cells.set(5, new Boolean(tf));
        }

        public boolean getMH() {
            Object o = this.getCol(5);
            if (o == null || !(o instanceof Boolean)) {
                return false;
            }
            return (Boolean)o;
        }

        public String getMFG() {
            Object o = this.cells.get(6);
            if (o == null) {
                return null;
            }
            return o.toString();
        }

        public void setMFG(String s) {
            this.cells.set(6, s);
        }

        public void setOpt1(String opt) {
            this.cells.set(7, opt);
        }

        public String getOpt1() {
            return this.cells.get(7).toString();
        }

        public void setOpt2(String opt) {
            this.cells.set(8, opt);
        }

        public String getOpt2() {
            return this.cells.get(8).toString();
        }
    }
}

