/*
 * Decompiled with CFR 0.152.
 */
package datastore.editor;

import datastore.Datapoint;
import datastore.editor.AbstractDatapointTableInterpreter;
import datastore.editor.DataSteward;
import gui.ErrorHandler;
import gui.editor.SpreadSheet;
import gui.editor.SpreadSheetTableModel;
import java.util.Vector;

public class DatapointTableModel
extends SpreadSheetTableModel {
    private static final long serialVersionUID = 1L;
    Vector datapoints = new Vector();
    DataSteward steward;
    AbstractDatapointTableInterpreter interpreter;

    public DatapointTableModel(DataSteward data) {
        this.steward = data;
        this.interpreter = data.getInterpreter();
        this.refreshDatapoints();
    }

    public void refreshDatapoints() {
        this.datapoints = this.steward.getVector();
        this.fireTableDataChanged();
    }

    public void registerEditorsAndRenderers(SpreadSheet spread) {
        this.interpreter.registerEditorsAndRenderers(spread);
    }

    @Override
    public Class getColumnClass(int which) {
        return this.interpreter.getColumnClass(which);
    }

    @Override
    public String getColumnName(int which) {
        return this.interpreter.getColumnName(which);
    }

    @Override
    public String getColumnToolTip(int which) {
        return this.interpreter.getColumnToolTip(which);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row < 0) {
            return false;
        }
        if (row >= this.datapoints.size()) {
            return this.interpreter.isCellEditable(col);
        }
        return this.interpreter.isCellEditable(this.getRowDP(row), col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row < 0) {
            return;
        }
        if (row >= this.datapoints.size()) {
            while (this.datapoints.size() < row + 1) {
                Datapoint dp = this.interpreter.createEmptyDatapoint();
                this.datapoints.add(dp);
                this.steward.add(dp);
                this.fireTableRowsInserted(this.datapoints.size() - 1, this.datapoints.size() - 1);
                if (this.datapoints.size() == this.steward.size()) continue;
                ErrorHandler.log("DATA CACHE SIZE MISMATCH IN EDITOR!", 3);
            }
        }
        this.interpreter.setValue(this.getRowDP(row), value, col);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public int getColumnCount() {
        return this.interpreter.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.datapoints.size() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.datapoints.size()) {
            return null;
        }
        return this.interpreter.getValue(this.getRowDP(row), col);
    }

    @Override
    public String addRows(int numRows, int startRow) {
        for (int i = 0; i < numRows; ++i) {
            Datapoint dp = this.interpreter.createEmptyDatapoint();
            this.datapoints.insertElementAt(dp, startRow);
            this.steward.add(dp);
            this.fireTableRowsInserted(startRow, startRow);
        }
        return null;
    }

    @Override
    public String removeRows(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            if (rows[i] < 0 || rows[i] >= this.datapoints.size()) continue;
            Datapoint o = (Datapoint)this.datapoints.elementAt(rows[i]);
            this.datapoints.remove(o);
            this.steward.remove(o);
            this.fireTableRowsDeleted(rows[i], rows[i]);
        }
        return null;
    }

    protected Datapoint getRowDP(int row) {
        return (Datapoint)this.datapoints.elementAt(row);
    }
}

