/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.RangeColumn;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class EvTree {
    private int bnCnt = 0;

    public ArrayList<TreeNode> createExampleTree1() {
        ArrayList<TreeNode> tree = null;
        tree = new ArrayList<TreeNode>();
        TreeNode t1 = new TreeNode("F", 1.0);
        t1.child = new ArrayList();
        tree.add(t1);
        TreeNode t11 = new TreeNode("A", 0.1);
        t1.child.add(t11);
        TreeNode t12 = new TreeNode("B", 0.2);
        t1.child.add(t12);
        TreeNode t13 = new TreeNode("E", 0.5);
        t1.child.add(t13);
        t13.child = new ArrayList();
        TreeNode t131 = new TreeNode("C", 0.3);
        t13.child.add(t131);
        TreeNode t132 = new TreeNode("D", 0.4);
        t13.child.add(t132);
        return tree;
    }

    public ArrayList<TreeNode> createExampleTree2() {
        ArrayList<TreeNode> tree = null;
        tree = new ArrayList<TreeNode>();
        TreeNode t1 = new TreeNode("Globanomalina compressa", 1.8233333333333);
        t1.child = new ArrayList();
        tree.add(t1);
        TreeNode t11 = new TreeNode("Globanomalina compressa", 0.368333333333297);
        t1.child.add(t11);
        TreeNode t12 = new TreeNode("Globanomalina ehrenbergi", 1.925);
        t1.child.add(t12);
        t12.child = new ArrayList();
        TreeNode t121 = new TreeNode("Globanomalina ehrenbergi", 0.209999999999994);
        t12.child.add(t121);
        TreeNode t122 = new TreeNode("Globanomalina chapmani", 6.8157142857143);
        t12.child.add(t122);
        t121.child = new ArrayList();
        TreeNode t1211 = new TreeNode("Globanomalina ehrenbergi", 0.209999999999994);
        t121.child.add(t1211);
        TreeNode t1212 = new TreeNode("Globanomalina pseudomenardii", 3.63);
        t121.child.add(t1212);
        t122.child = new ArrayList();
        TreeNode t1221 = new TreeNode("Globanomalina chapmani", 3.2457142857143);
        t122.child.add(t1221);
        TreeNode t1222 = new TreeNode("Globanomalina planoconica", 7.125);
        t122.child.add(t1222);
        t1222.child = new ArrayList();
        TreeNode t12221 = new TreeNode("Globanomalina planoconica", 0.234999999999999);
        t1222.child.add(t12221);
        TreeNode t12222 = new TreeNode("Planoglobanomalina pseudoalgeriana", 6.0748120300752);
        t1222.child.add(t12222);
        return tree;
    }

    public ArrayList<TreeNode> createExampleTree3() {
        ArrayList<TreeNode> tree = null;
        tree = new ArrayList<TreeNode>();
        TreeNode t1 = new TreeNode("Globanomalina compressa", 63.9, 62.076666666666696);
        t1.child = new ArrayList();
        tree.add(t1);
        TreeNode t11 = new TreeNode("Globanomalina compressa", 62.076666666666696, 61.7083333333334);
        t1.child.add(t11);
        TreeNode t12 = new TreeNode("Globanomalina ehrenbergi", 62.445, 60.52);
        t1.child.add(t12);
        t12.child = new ArrayList();
        TreeNode t121 = new TreeNode("Globanomalina ehrenbergi", 60.52, 60.31000000000001);
        t12.child.add(t121);
        TreeNode t122 = new TreeNode("Globanomalina chapmani", 61.13, 54.3142857142857);
        t12.child.add(t122);
        t121.child = new ArrayList();
        TreeNode t1211 = new TreeNode("Globanomalina ehrenbergi", 60.31000000000001, 60.100000000000016);
        t121.child.add(t1211);
        TreeNode t1212 = new TreeNode("Globanomalina pseudomenardii", 60.73, 57.099999999999994);
        t121.child.add(t1212);
        t122.child = new ArrayList();
        TreeNode t1221 = new TreeNode("Globanomalina chapmani", 54.3142857142857, 51.0685714285714);
        t122.child.add(t1221);
        TreeNode t1222 = new TreeNode("Globanomalina planoconica", 57.56, 50.435);
        t122.child.add(t1222);
        t1222.child = new ArrayList();
        TreeNode t12221 = new TreeNode("Globanomalina planoconica", 50.435, 50.2);
        t1222.child.add(t12221);
        TreeNode t12222 = new TreeNode("Planoglobanomalina pseudoalgeriana", 50.67, 44.5951879699248);
        t1222.child.add(t12222);
        return tree;
    }

    public ArrayList<TreeNode> createExampleTree4() {
        ArrayList<TreeNode> tree = null;
        tree = new ArrayList<TreeNode>();
        TreeNode t1 = new TreeNode("Globanomalina compressa", 63.9, 62.0766666666667, -1.0);
        t1.child = new ArrayList();
        tree.add(t1);
        TreeNode t11 = new TreeNode("Globanomalina ehrenbergi", 62.445, 60.52, -1.0);
        t1.child.add(t11);
        t11.child = new ArrayList();
        TreeNode t111 = new TreeNode("Globanomalina chapmani", 61.13, 54.3142857142857, -1.0);
        t11.child.add(t111);
        TreeNode t112 = new TreeNode("Globanomalina pseudomenardii", 60.73, 57.1, -1.0);
        t11.child.add(t112);
        t111.child = new ArrayList();
        TreeNode t1111 = new TreeNode("Globanomalina planoconica", 57.56, 50.435, -1.0);
        t111.child.add(t1111);
        t1111.child = new ArrayList();
        TreeNode t11111 = new TreeNode("Planoglobanomalina pseudoalgeriana", 50.67, 44.5951879699248, -1.0);
        t1111.child.add(t11111);
        return tree;
    }

    public TreeNode createTreeFromRanges(TreeNode tree, TreeNode parent, RangeColumn.Range r) {
        if (!r.alreadyInsideTree && !r.isPhenonRange && tree.parent == parent) {
            String rName = r.name.split(" <img")[0];
            double rFAD = r.base;
            double rLAD = r.top;
            tree = new TreeNode(rName, rFAD, rLAD);
            r.alreadyInsideTree = true;
            TreeSet<RangeColumn.Range> sortedChildren = new TreeSet<RangeColumn.Range>(new Comparator<RangeColumn.Range>(){

                @Override
                public int compare(RangeColumn.Range r1, RangeColumn.Range r2) {
                    if (r1.base == r2.base) {
                        return -1;
                    }
                    if (r2.base < r1.base) {
                        return -1;
                    }
                    return 1;
                }
            });
            sortedChildren.addAll(r.children);
            if (sortedChildren.size() != r.children.size()) {
                this.print("!!!Something is wrong.");
            }
            for (RangeColumn.Range cr : sortedChildren) {
                String cName = cr.name.split(" <img")[0];
                double cFAD = cr.base;
                double cLAD = cr.top;
                TreeNode childTree = new TreeNode(cName, cFAD, cLAD);
                childTree.parent = tree;
                childTree = this.createTreeFromRanges(childTree, tree, cr);
                if (tree.child == null) {
                    tree.child = new ArrayList();
                }
                tree.child.add(childTree);
                cr.alreadyInsideTree = true;
            }
        }
        return tree;
    }

    public String getPathToNode(TreeNode tree, String node, String path) {
        if (tree.name == node) {
            return tree.name;
        }
        if (tree.child == null) {
            return tree.name;
        }
        ArrayList<TreeNode> children = tree.child;
        TreeNode c = null;
        String prevPath = "";
        for (int ci = 0; ci < children.size(); ++ci) {
            prevPath = path;
            c = children.get(ci);
            String npath = this.getPathToNode(c, node, path = tree.name);
            if (!npath.equalsIgnoreCase("")) {
                path = path + "->" + npath;
            }
            if (path.contains(node)) {
                return path;
            }
            if (ci + 1 == children.size()) continue;
            path = prevPath;
        }
        return path;
    }

    public Path getPathToNode(TreeNode tree, String node, Path path) {
        if (tree.name.equalsIgnoreCase(node)) {
            Path p = null;
            String np = tree.name;
            double nd = path.d + tree.d;
            if (!path.path.equalsIgnoreCase("")) {
                np = path.path + "->" + tree.name;
            }
            p = new Path(np, nd);
            return p;
        }
        if (tree.child == null) {
            Path p = new Path(tree.name, tree.d);
            return p;
        }
        ArrayList<TreeNode> children = tree.child;
        TreeNode c = null;
        Path prevPath = null;
        for (int ci = 0; ci < children.size(); ++ci) {
            prevPath = new Path(path);
            c = children.get(ci);
            path.path = tree.name;
            path.d = tree.d;
            Path npath = new Path(this.getPathToNode(c, node, path));
            path.path = !prevPath.path.equalsIgnoreCase("") ? prevPath.path + "->" + npath.path : npath.path;
            path.d = prevPath.d + npath.d;
            if (path.path.contains(node)) {
                return path;
            }
            path = prevPath;
        }
        return path;
    }

    public String getPathToNode(TreeNode tree, String node) {
        Path p = new Path();
        Path path = this.getPathToNode(tree, node, p);
        return path.path;
    }

    public String getCommonAncestor(TreeNode tree, String node1, String node2) {
        String commonAncestorName = null;
        String path1 = this.getPathToNode(tree, node1);
        String path2 = this.getPathToNode(tree, node2);
        String[] paths1 = path1.split("->");
        String[] paths2 = path2.split("->");
        int mp = Math.min(paths1.length, paths2.length);
        int match = 0;
        int no_match = -1;
        for (int i = 0; i < mp; ++i) {
            if (paths1[i].equalsIgnoreCase(paths2[i])) {
                ++match;
                continue;
            }
            no_match = i - 1;
            break;
        }
        if (no_match != -1) {
            commonAncestorName = paths1[no_match];
        }
        return commonAncestorName;
    }

    public ArrayList<String> getPathArrayFromRootToCommonAncestor(TreeNode tree, String node1, String node2) {
        ArrayList<String> pathFromRootToCommonAncestor;
        block8: {
            int i;
            int match;
            String[] paths2;
            String[] paths1;
            String commonAncestorName;
            block7: {
                commonAncestorName = null;
                pathFromRootToCommonAncestor = null;
                String path1 = this.getPathToNode(tree, node1);
                String path2 = this.getPathToNode(tree, node2);
                paths1 = path1.split("->");
                paths2 = path2.split("->");
                int mp = Math.min(paths1.length, paths2.length);
                match = 0;
                int no_match = -1;
                for (i = 0; i < mp; ++i) {
                    if (paths1[i].equalsIgnoreCase(paths2[i])) {
                        ++match;
                        continue;
                    }
                    no_match = i - 1;
                    break;
                }
                if (no_match == -1) break block7;
                commonAncestorName = paths1[no_match];
                pathFromRootToCommonAncestor = new ArrayList<String>();
                for (i = 0; i < no_match + 1; ++i) {
                    pathFromRootToCommonAncestor.add(paths1[i]);
                }
                break block8;
            }
            if (match == 0) break block8;
            if (paths1.length >= paths2.length) {
                commonAncestorName = node2;
                pathFromRootToCommonAncestor = new ArrayList();
                for (i = 0; i < paths2.length; ++i) {
                    pathFromRootToCommonAncestor.add(paths2[i]);
                }
            } else {
                commonAncestorName = node1;
                pathFromRootToCommonAncestor = new ArrayList();
                for (i = 0; i < paths1.length; ++i) {
                    pathFromRootToCommonAncestor.add(paths1[i]);
                }
            }
        }
        return pathFromRootToCommonAncestor;
    }

    public String getPathFromRootToCommonAncestor(TreeNode tree, String node1, String node2) {
        String pathFromRootToCommonAncestorS = "";
        ArrayList<String> pathFromRootToCommonAncestor = this.getPathArrayFromRootToCommonAncestor(tree, node1, node2);
        for (int i = 0; i < pathFromRootToCommonAncestor.size(); ++i) {
            pathFromRootToCommonAncestorS = pathFromRootToCommonAncestorS + pathFromRootToCommonAncestor.get(i);
            if (i + 1 == pathFromRootToCommonAncestor.size()) continue;
            pathFromRootToCommonAncestorS = pathFromRootToCommonAncestorS + "->";
        }
        return pathFromRootToCommonAncestorS;
    }

    public ArrayList<String> convertToStringArrayList(String[] s) {
        ArrayList<String> r = new ArrayList<String>();
        for (int i = 0; i < s.length; ++i) {
            r.add(s[i]);
        }
        return r;
    }

    public int stringExistsInArrayList(ArrayList<String> sA, String s) {
        int loc = -1;
        for (int i = 0; i < sA.size(); ++i) {
            if (!sA.get(i).equals(s)) continue;
            loc = i;
            break;
        }
        return loc;
    }

    public ArrayList<String> getPathArrayFromNodeToNode(TreeNode tree, String node1, String node2) {
        ArrayList<String> pathFromNodeToNode = null;
        String path1 = this.getPathToNode(tree, node1);
        String path2 = this.getPathToNode(tree, node2);
        String[] paths1 = path1.split("->");
        String[] paths2 = path2.split("->");
        ArrayList<String> pathA1 = this.convertToStringArrayList(paths1);
        ArrayList<String> pathA2 = this.convertToStringArrayList(paths2);
        ArrayList<String> longerPath = null;
        if (pathA1.size() > pathA2.size()) {
            longerPath = pathA1;
            int loc = this.stringExistsInArrayList(longerPath, node2);
            if (loc == -1) {
                return null;
            }
            pathFromNodeToNode = new ArrayList<String>();
            pathFromNodeToNode.add(node2);
            for (int i = loc + 1; i < longerPath.size(); ++i) {
                pathFromNodeToNode.add(longerPath.get(i));
            }
        } else {
            longerPath = pathA2;
            int loc = this.stringExistsInArrayList(longerPath, node1);
            if (loc == -1) {
                return null;
            }
            pathFromNodeToNode = new ArrayList();
            pathFromNodeToNode.add(node1);
            for (int i = loc + 1; i < longerPath.size(); ++i) {
                pathFromNodeToNode.add(longerPath.get(i));
            }
        }
        return pathFromNodeToNode;
    }

    public String getPathFromNodeToNode(TreeNode tree, String node1, String node2) {
        String pathFromNodeToNodeS = "";
        ArrayList<String> pathFromNodeToNode = this.getPathArrayFromNodeToNode(tree, node1, node2);
        for (int i = 0; i < pathFromNodeToNode.size(); ++i) {
            pathFromNodeToNodeS = pathFromNodeToNodeS + pathFromNodeToNode.get(i);
            if (i + 1 == pathFromNodeToNode.size()) continue;
            pathFromNodeToNodeS = pathFromNodeToNodeS + "->";
        }
        return pathFromNodeToNodeS;
    }

    public double getDistanceToNode(TreeNode tree, String node) {
        Path p = new Path();
        Path path = this.getPathToNode(tree, node, p);
        return path.d;
    }

    public double getDistanceToNode2(TreeNode tree, String node, double distance) {
        if (tree.name.equalsIgnoreCase(node) && tree.child == null) {
            return tree.d;
        }
        if (tree.child == null) {
            return -1.0;
        }
        ArrayList<TreeNode> children = tree.child;
        TreeNode c = null;
        double totalDistance = 0.0;
        for (int ci = 0; ci < children.size(); ++ci) {
            double prevDistance = distance;
            c = children.get(ci);
            double ndistance = this.getDistanceToNode2(c, node, tree.d);
            if (ndistance == -1.0) continue;
            if ((distance += ndistance) > totalDistance) {
                totalDistance = distance;
            }
            if (ci + 1 == children.size()) continue;
            distance = prevDistance;
        }
        if (tree.parent == null) {
            totalDistance += 2.0 * tree.d;
        }
        return totalDistance;
    }

    public void getTreeNodes(TreeNode tree, HashSet<TreeNode> treeNodes) {
        if (tree.child == null) {
            return;
        }
        treeNodes.add(tree);
        ArrayList<TreeNode> children = tree.child;
        TreeNode c = null;
        for (int ci = 0; ci < children.size(); ++ci) {
            c = children.get(ci);
            treeNodes.add(c);
            this.getTreeNodes(c, treeNodes);
        }
    }

    public ArrayList<String> getTreeNodeNames(TreeNode tree) {
        HashSet<TreeNode> treeNodes = new HashSet<TreeNode>();
        this.getTreeNodes(tree, treeNodes);
        ArrayList<String> treeNodeNames = new ArrayList<String>();
        for (TreeNode t : treeNodes) {
            treeNodeNames.add(t.name);
        }
        return treeNodeNames;
    }

    public HashSet<String> getUniqueTreeNodeNames(TreeNode tree) {
        HashSet<TreeNode> treeNodes = new HashSet<TreeNode>();
        this.getTreeNodes(tree, treeNodes);
        HashSet<String> uniqueTreeNodeNames = new HashSet<String>();
        for (TreeNode t : treeNodes) {
            uniqueTreeNodeNames.add(t.name);
        }
        return uniqueTreeNodeNames;
    }

    public void getLeafNodes(TreeNode tree, ArrayList<TreeNode> leafNodes) {
        if (tree.child == null) {
            leafNodes.add(tree);
            return;
        }
        ArrayList<TreeNode> children = tree.child;
        TreeNode c = null;
        for (int ci = 0; ci < children.size(); ++ci) {
            c = children.get(ci);
            this.getLeafNodes(c, leafNodes);
        }
    }

    public double roundWithPrecision(double val, int place) {
        String mps = null;
        mps = place == 2 ? String.format("%.2f", val) : String.format("%.3f", val);
        double r = Double.parseDouble(mps);
        return r;
    }

    public void getLivingNodes(TreeNode tree, ArrayList<TreeNode> livingNodes) {
        ArrayList<TreeNode> leafNodes = new ArrayList<TreeNode>();
        this.getLeafNodes(tree, leafNodes);
        double maxPathLength = this.getLongestPathLength(tree, 0.0);
        double mp = this.roundWithPrecision(maxPathLength, 2);
        for (int i = 0; i < leafNodes.size(); ++i) {
            TreeNode t = leafNodes.get(i);
            double d = this.getDistanceToNode(tree, t.name);
            double dp = this.roundWithPrecision(d, 2);
            if (mp != d) continue;
            livingNodes.add(t);
        }
    }

    public HashSet<String> getLivingNodeNames(TreeNode tree) {
        ArrayList<TreeNode> livingNodes = new ArrayList<TreeNode>();
        this.getLivingNodes(tree, livingNodes);
        HashSet<String> livingNodeNames = new HashSet<String>();
        for (int i = 0; i < livingNodes.size(); ++i) {
            TreeNode t = livingNodes.get(i);
            livingNodeNames.add(t.name);
        }
        return livingNodeNames;
    }

    public int getTotalNumberOfNodes(TreeNode tree) {
        if (tree.child == null) {
            return 1;
        }
        ArrayList<TreeNode> children = tree.child;
        TreeNode c = null;
        int total = 1;
        for (int ci = 0; ci < children.size(); ++ci) {
            c = children.get(ci);
            total += this.getTotalNumberOfNodes(c);
        }
        return total;
    }

    public double getLongestPathLength(TreeNode tree, double length) {
        if (tree.child == null) {
            return tree.d;
        }
        ArrayList<TreeNode> children = tree.child;
        TreeNode c = null;
        double prevLength = length;
        double maxLength = -1.0;
        for (int ci = 0; ci < children.size(); ++ci) {
            prevLength = length;
            c = children.get(ci);
            double newLength = this.getLongestPathLength(c, c.d);
            if ((length = prevLength + newLength) > maxLength) {
                maxLength = length;
            }
            length = prevLength;
        }
        if (tree.parent == null) {
            maxLength += tree.d;
        }
        return maxLength;
    }

    public String convertToNexusFormat(TreeNode tree, TreeNode parent) {
        ArrayList<String> tNodes = this.getTreeNodeNames(tree);
        String taxLabels = "";
        for (int i = 0; i < tNodes.size(); ++i) {
            taxLabels = taxLabels + "\"" + tNodes.get(i) + "\"";
            if (i == tNodes.size() - 1) continue;
            taxLabels = taxLabels + " ";
        }
        String nex = "";
        nex = nex + "#NEXUS\n";
        nex = nex + "BEGIN trees;\n";
        String nwk = this.convertToNewickFormat(tree, parent);
        nex = nex + "\tTree tree = " + nwk + "\n";
        nex = nex + "END;\n";
        return nex;
    }

    public String convertNexusToNewickFormat(String nex) {
        String nwk = "";
        HashMap<Integer, String> taxMap = null;
        taxMap = this.processTaxLabelTranslation(nex);
        String[] lines = nex.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String s = lines[i];
            if (!s.contains(" = ") && !s.contains("Tree ") && !s.contains("tree = ") && !s.contains("tree")) continue;
            if (s.contains("[") || s.contains("]")) {
                nwk = this.processNewickString(s, taxMap);
                if (nwk.length() != 0 && nwk.length() > 3) break;
                if (s.contains(" = ")) {
                    nwk = s.split(" = ")[1];
                    break;
                }
                if (s.contains("=")) {
                    nwk = s.split("=")[1];
                    break;
                }
                String message = "Could not convert from nexus to newick";
                JOptionPane.showMessageDialog(null, message);
                break;
            }
            if (s.contains(" = ")) {
                nwk = s.split(" = ")[1];
                continue;
            }
            if (!s.contains("=")) continue;
            nwk = s.split("=")[1];
        }
        return nwk;
    }

    public HashMap<Integer, String> processTaxLabelTranslation(String nex) {
        String[] lines = nex.split("\n");
        HashMap<Integer, String> taxMap = new HashMap<Integer, String>();
        boolean st = false;
        for (int i = 0; i < lines.length; ++i) {
            String l = lines[i];
            if (l.contains("translate")) {
                st = true;
                continue;
            }
            if (!st) continue;
            l = l.replace("\t", " ");
            String[] s = l.split(" ");
            int taxID = -1;
            int t = -1;
            for (int k = 0; k < s.length; ++k) {
                if (s[k].equals("")) continue;
                try {
                    taxID = t = Integer.parseInt(s[k]);
                    continue;
                }
                catch (NumberFormatException e) {
                    String sname = s[k];
                    if (sname.contains("}")) {
                        sname = sname.split("}")[0];
                    }
                    if (sname.contains(",")) {
                        sname = sname.split(",")[0];
                    }
                    if (taxID == -1) continue;
                    taxMap.put(taxID, sname);
                }
            }
        }
        return taxMap;
    }

    public String loadTreeFromFile(String fpath) {
        String nex = "";
        StringBuffer sb = null;
        try {
            FileInputStream inputStream = new FileInputStream(fpath);
            InputStreamReader isReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(isReader);
            sb = new StringBuffer();
            try {
                String str;
                while ((str = reader.readLine()) != null) {
                    sb.append(str + "\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        nex = sb.toString();
        return nex;
    }

    public String processNewickString(String s, HashMap<Integer, String> taxMap) {
        String nwk = s;
        String newNwk = "";
        ArrayList nodes = new ArrayList();
        ArrayList distances = new ArrayList();
        ArrayList<String> nodeAttrs = new ArrayList<String>();
        boolean fNode = false;
        ArrayList<String> dAttrs = new ArrayList<String>();
        boolean dNode = false;
        boolean fLFB = false;
        int lLFB = -1;
        boolean fRFB = false;
        int lRFB = -1;
        boolean fLSB = false;
        int lLSB = -1;
        boolean fRSB = false;
        int lRSB = -1;
        boolean fLTB = false;
        int lLTB = -1;
        boolean fRTB = false;
        int lRTB = -1;
        boolean st = true;
        int branchNodeCount = 1;
        for (int i = 0; i < nwk.length(); ++i) {
            char c = nwk.charAt(i);
            if (c == '=' && st) {
                String etmp;
                if ((nwk = nwk.charAt(i + 1) == ' ' ? nwk.substring(i + 2, nwk.length()) : nwk.substring(i + 1, nwk.length())).substring(0, 4).equals("[&U]")) {
                    nwk = nwk.charAt(4) != ' ' ? nwk.substring(4, nwk.length()) : nwk.substring(5, nwk.length());
                }
                if (nwk.charAt(nwk.length() - 1) == '\n') {
                    nwk = nwk.substring(0, nwk.length() - 1);
                }
                if ((etmp = nwk.substring(nwk.length() - 4, nwk.length())).equalsIgnoreCase("end;")) {
                    nwk = nwk.substring(0, nwk.length() - 4);
                }
                i = 0;
                st = false;
            }
            if ((c = nwk.charAt(i)) == '(') {
                fLFB = true;
                lLFB = i;
            } else if (fLFB && c == '[') {
                fLSB = true;
                lLSB = i;
            } else if (fLFB && fLSB && c == ']') {
                fRSB = true;
                lRSB = i;
            } else if (c == ')') {
                // empty if block
            }
            if (fLSB && fRSB && lLSB < lRSB) {
                if (lLSB > nwk.length()) {
                    lLSB = nwk.length();
                }
                String beforeAttr = nwk.substring(0, lLSB);
                if (lRSB > nwk.length()) {
                    lRSB = nwk.length();
                }
                String attr = nwk.substring(lLSB + 2, lRSB);
                String afterAttr = nwk.substring(lRSB + 1, nwk.length());
                if (afterAttr.charAt(0) == ':') {
                    fNode = true;
                    String tmpNodeName = beforeAttr;
                    String firstChar = "";
                    boolean isBranchNode = false;
                    if (beforeAttr.equals(")")) {
                        isBranchNode = true;
                        firstChar = ")";
                        String b = "bn" + branchNodeCount;
                        ++branchNodeCount;
                        tmpNodeName = b;
                    } else if (beforeAttr.charAt(0) == ')') {
                        firstChar = ")";
                        tmpNodeName = beforeAttr.substring(1, beforeAttr.length());
                    } else if (beforeAttr.charAt(0) == '(') {
                        firstChar = "(";
                        tmpNodeName = beforeAttr.substring(1, beforeAttr.length());
                    } else if (beforeAttr.startsWith(",(")) {
                        int locst = 2;
                        for (int ij = 2; ij < beforeAttr.length(); ++ij) {
                            if (beforeAttr.charAt(ij) == '(') continue;
                            locst = ij;
                            break;
                        }
                        firstChar = beforeAttr.substring(0, locst);
                        tmpNodeName = beforeAttr.substring(locst, beforeAttr.length());
                    } else if (beforeAttr.charAt(0) == ',') {
                        firstChar = ",";
                        tmpNodeName = beforeAttr.substring(1, beforeAttr.length());
                    }
                    String nodeName = tmpNodeName;
                    try {
                        if (!isBranchNode) {
                            int taxID = Integer.parseInt(nodeName);
                            nodeName = taxMap != null ? firstChar + taxMap.get(taxID) : firstChar + taxID;
                        } else {
                            nodeName = firstChar + tmpNodeName;
                        }
                    }
                    catch (NumberFormatException e) {
                        nodeName = beforeAttr;
                    }
                    newNwk = newNwk + nodeName;
                    nwk = afterAttr.substring(1, afterAttr.length());
                    nodeAttrs.add(attr);
                    fLSB = false;
                    fRSB = false;
                    i = 0;
                } else if (fLSB && fRSB && fNode) {
                    dNode = true;
                    fNode = false;
                    newNwk = newNwk + ":" + Double.parseDouble(beforeAttr);
                    dAttrs.add(attr);
                    nwk = afterAttr;
                    fLSB = false;
                    fRSB = false;
                    dNode = false;
                    fNode = false;
                    i = 0;
                }
            }
            if (c != ';') continue;
            newNwk = "(" + newNwk + ")bn" + branchNodeCount + ":" + 1.0E-7 + ");";
            break;
        }
        return newNwk;
    }

    public String convertToNewickFormat(TreeNode tree, TreeNode parent) {
        if (tree.child == null) {
            double d = tree.LAD - parent.LAD;
            d = Math.abs(d);
            String tr = "'" + tree.name + "':" + d;
            return tr;
        }
        ArrayList<TreeNode> children = tree.child;
        TreeSet<Map.Entry<Double, Integer>> c_FAD = new TreeSet<Map.Entry<Double, Integer>>(new Comparator<Map.Entry<Double, Integer>>(){

            @Override
            public int compare(Map.Entry<Double, Integer> e1, Map.Entry<Double, Integer> e2) {
                return e1.getValue().compareTo(e2.getValue());
            }
        });
        TreeMap<Double, Integer> m_FAD = new TreeMap<Double, Integer>();
        for (int i = 0; i < children.size(); ++i) {
            TreeNode c = children.get(i);
            m_FAD.put(c.FAD, i);
        }
        c_FAD.addAll(m_FAD.entrySet());
        ArrayList<Integer> oi = new ArrayList<Integer>();
        Iterator it = c_FAD.iterator();
        double max_child_FAD = -2.147483648E9;
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            double tmpFAD = (Double)e.getKey();
            int tmpFADID = (Integer)e.getValue();
            oi.add(tmpFADID);
            max_child_FAD = Math.max(max_child_FAD, tmpFAD);
        }
        int max_child_id = (Integer)oi.get(0);
        String clist = "(";
        TreeNode new_parent = new TreeNode(tree);
        if (new_parent.LAD <= max_child_FAD) {
            TreeNode new_child = new TreeNode(new_parent);
            new_child.FAD = max_child_FAD;
            new_parent.LAD = max_child_FAD;
            if (new_child.name.equals(new_parent.name)) {
                new_child.name = new_child.name + " ext";
            }
            ArrayList<TreeNode> new_children = new ArrayList<TreeNode>();
            int cin1 = 0;
            int cin2 = 0;
            for (int j = 0; j < children.size(); ++j) {
                if (cin1 != max_child_id) {
                    new_children.add(children.get(cin1));
                    ++cin2;
                }
                ++cin1;
            }
            new_child.child = new_children.size() > 0 ? new_children : null;
            String cr1 = this.convertToNewickFormat(children.get(max_child_id), new_parent);
            clist = clist + cr1;
            if (tree.LAD != max_child_FAD) {
                String cr2 = this.convertToNewickFormat(new_child, new_parent);
                clist = clist + "," + cr2;
            } else {
                int cn = 0;
                ArrayList noi = new ArrayList(oi);
                if (max_child_id < noi.size()) {
                    noi.remove(max_child_id);
                }
                for (int ii = 0; ii < noi.size(); ++ii) {
                    int ci = (Integer)noi.get(ii);
                    TreeNode c = children.get(ci);
                    if (new_parent.LAD != c.FAD) continue;
                    String cr = this.convertToNewickFormat(c, new_parent);
                    clist = clist + "," + cr;
                    ++cn;
                }
            }
        }
        double d = parent == null ? max_child_FAD - tree.FAD : max_child_FAD - parent.LAD;
        d = Math.abs(d);
        String tname = "'" + tree.name + "'";
        clist = clist + ")" + tname + ":" + d;
        if (parent == null) {
            clist = "(" + clist + ");";
        }
        return clist;
    }

    public String convertNewickTreeToTSCUtilQueue(TreeNode tree, double FAD, String tsf) {
        LinkedList<TreeNode> Q = new LinkedList<TreeNode>();
        Q.add(tree);
        tree.FAD = FAD;
        tree.LAD = tree.FAD - tree.d;
        while (!Q.isEmpty()) {
            TreeNode c;
            int i;
            TreeNode t = (TreeNode)Q.poll();
            String otherInfo = "";
            tsf = tsf + "\t" + t.name + "\t" + t.LAD + "\tTOP\t" + otherInfo + "\n";
            ArrayList<TreeNode> children = t.child;
            for (i = 0; children != null && i < children.size(); ++i) {
                c = children.get(i);
                c.FAD = t.LAD;
                c.LAD = t.LAD - c.d;
                otherInfo = "";
                String pn = t.name;
                this.print(pn);
                this.print(t);
                if (t.name.contains(" ext")) {
                    pn = t.name.split(" ext")[0];
                }
                String cn = c.name;
                if (c.name.contains(" ")) {
                    cn = c.name.split(" ext")[0];
                }
                if (pn.equals(cn)) {
                    c.name = t.name + " ext";
                }
                tsf = tsf + "\t" + t.name + "\t" + c.FAD + "\tbranch\t" + c.name + "\t" + otherInfo + "\n";
            }
            tsf = tsf + "\t" + t.name + "\t" + t.FAD + "\tfrequent\t" + otherInfo + "\n";
            for (i = 0; children != null && i < children.size(); ++i) {
                c = children.get(i);
                Q.add(c);
            }
        }
        return tsf;
    }

    public String convertNewickTreeToTSCUtilStack(TreeNode tree, double FAD, String tsf) {
        TreeNode c;
        int i;
        tree.FAD = FAD;
        tree.LAD = tree.FAD - tree.d;
        TreeNode t = tree;
        String otherInfo = "";
        tsf = tsf + "\t" + t.name + "\t" + t.LAD + "\tTOP\t" + otherInfo + "\n";
        ArrayList<TreeNode> children = t.child;
        for (i = 0; children != null && i < children.size(); ++i) {
            String cn;
            c = children.get(i);
            c.FAD = t.LAD;
            c.LAD = t.LAD - c.d;
            otherInfo = "";
            String pn = t.name.split(" ext")[0];
            if (pn.equals(cn = c.name.split(" ext")[0])) {
                c.name = t.name + " ext";
            }
            tsf = tsf + "\t" + t.name + "\t" + c.FAD + "\tbranch\t" + c.name + "\t" + otherInfo + "\n";
        }
        tsf = tsf + "\t" + t.name + "\t" + t.FAD + "\tfrequent\t" + otherInfo + "\n";
        for (i = 0; children != null && i < children.size(); ++i) {
            c = children.get(i);
            tsf = this.convertNewickTreeToTSCUtilStack(c, t.LAD, tsf);
        }
        return tsf;
    }

    public String convertNewickTreeToTSC(TreeNode tree, String nwkS) {
        String tsf = "";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(System.currentTimeMillis());
        String today = formatter.format(date);
        this.print(today);
        tsf = tsf + "format version:\t1.3\n";
        tsf = tsf + "date: \t" + today + "\n\n";
        String treeColumnName = "Tree";
        tsf = tsf + treeColumnName + "\trange\t100\t255/255/255\n";
        double FAD = this.getLongestPathLength(tree, 0.0);
        tsf = this.convertNewickTreeToTSCUtilQueue(tree, FAD, tsf);
        return tsf;
    }

    public String convertNewickToTSC(String nwkS) {
        String tsf = "";
        TreeNode tree = this.convertNewickToTree(nwkS);
        tsf = this.convertNewickTreeToTSC(tree, nwkS);
        return tsf;
    }

    public void print(Object line) {
        System.out.println(line);
    }

    public TreeNode convertNewickToTree(String nwkS) {
        int colonID;
        int semicolonID;
        int countBracket = 0;
        char[] s = nwkS.toCharArray();
        int i = 0;
        int bracketStartID = -1;
        int bracketEndID = -1;
        if (s.length > 0 && s[0] == '(') {
            while (s.length >= 2) {
                if (s[i] == '(') {
                    if (++countBracket == 1) {
                        bracketStartID = i;
                    }
                } else if (s[i] == ')') {
                    --countBracket;
                }
                if (countBracket == 0) {
                    bracketEndID = i;
                    break;
                }
                ++i;
            }
        }
        for (i = semicolonID = nwkS.length() - 1; i >= 0 && i <= nwkS.length(); --i) {
            if (s[i] != ';') continue;
            semicolonID = i;
            break;
        }
        int cID = colonID = i;
        int cIDS = colonID;
        int prevBracketID = -1;
        int cnt = 0;
        for (i = semicolonID; i >= 0 && i <= nwkS.length(); --i) {
            if (s[i] == ':') {
                colonID = i;
                continue;
            }
            if (s[i] != ')') continue;
            prevBracketID = i;
            if (++cnt == 2) break;
        }
        int sID = prevBracketID;
        if (bracketEndID == prevBracketID) {
            if (nwkS.charAt(1) == '\'') {
                sID = 2;
                cID = colonID - 1;
            } else {
                sID = 1;
                cID = colonID;
            }
            cIDS = colonID + 1;
        } else {
            if (nwkS.charAt(prevBracketID + 1) == '\'') {
                sID = prevBracketID + 2;
                cID = colonID - 1;
            } else {
                sID = prevBracketID + 1;
                cID = colonID;
            }
            cIDS = colonID + 1;
        }
        String treeName = "";
        String treeDs = "";
        if (nwkS.split("\n")[0].endsWith(");") && cID != -1) {
            treeName = nwkS.substring(sID, cID);
            this.print(treeName);
            treeDs = nwkS.substring(cIDS, semicolonID - 1);
            this.print(treeDs);
        } else if (cID == -1 || cID < bracketEndID) {
            treeName = nwkS.substring(bracketEndID + 1, semicolonID);
            treeDs = "0";
        } else {
            treeDs = nwkS.substring(bracketEndID + 1, cID);
            treeDs = nwkS.substring(cIDS, semicolonID);
        }
        double treeD = -1.0;
        try {
            treeD = Double.parseDouble(treeDs);
        }
        catch (NumberFormatException e) {
            treeD = 0.0;
        }
        treeName = treeName.split("\n")[0];
        this.print(treeName);
        if (treeName.contains(":") || treeName.length() == 0) {
            String[] tt = treeName.split(":");
            treeName = "bn_" + Integer.toString(this.bnCnt++) + tt[0];
            treeD = tt.length >= 2 ? Double.parseDouble(tt[1]) : 0.0;
        }
        TreeNode tree = new TreeNode(treeName, treeD);
        int startID = bracketStartID;
        int endID = prevBracketID;
        if (nwkS.split("\n")[0].endsWith(");")) {
            startID = bracketStartID + 1;
            endID = prevBracketID + 1;
        } else {
            startID = bracketStartID + 1;
            endID = bracketEndID;
        }
        if (bracketEndID == prevBracketID) {
            return tree;
        }
        String sss = nwkS.substring(startID, endID);
        if (sss.charAt(0) == '(' && sss.charAt(sss.length() - 1) == ')') {
            sss = sss.substring(1, sss.length() - 1);
        }
        ArrayList<String> children = sss.length() > 0 ? new ArrayList<String>() : null;
        countBracket = 0;
        int childStartID = 0;
        int childEndID = -1;
        for (int j = 0; j < sss.length(); ++j) {
            String child;
            if (sss.charAt(j) == '(') {
                ++countBracket;
            } else if (sss.charAt(j) == ')') {
                --countBracket;
            }
            if (sss.charAt(j) != ',' && j != sss.length() - 1 || countBracket != 0) continue;
            childEndID = j;
            if (j == sss.length() - 1) {
                childEndID = j + 1;
            }
            child = (child = sss.substring(childStartID, childEndID)).startsWith("(") && child.endsWith(")") ? child + ";" : "(" + child + ");";
            children.add(child);
            if (j + 1 >= sss.length()) continue;
            childStartID = j + 1;
        }
        if (children.size() > 0) {
            tree.child = new ArrayList();
        }
        for (int ci = 0; ci < children.size(); ++ci) {
            String childNwkS = (String)children.get(ci);
            TreeNode childTree = this.convertNewickToTree(childNwkS);
            childTree.parent = tree;
            tree.child.add(childTree);
        }
        return tree;
    }

    public static void main(String[] args) {
        EvTree T = new EvTree();
        String nwkComplex = "   tree con_50_majrule = [&U] (14[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.233411e-01[&length_mean=2.238061418277574e-01,length_median=2.233411000000000e-01,length_95%HPD={1.973215000000000e-01,2.522058000000000e-01}],(102[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.161846e-02[&length_mean=2.176788279929360e-02,length_median=2.161846000000000e-02,length_95%HPD={1.617482000000000e-02,2.762582000000000e-02}],((106[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.357874e-03[&length_mean=2.450586743144265e-03,length_median=2.357874000000000e-03,length_95%HPD={1.018898000000000e-03,4.051418000000000e-03}],107[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.341765e-03[&length_mean=1.436839376349155e-03,length_median=1.341765000000000e-03,length_95%HPD={4.040900000000000e-04,2.687991000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.895275e-03[&length_mean=5.015779614984656e-03,length_median=4.895275000000000e-03,length_95%HPD={2.594622000000000e-03,7.713333000000000e-03}],109[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.070787e-03[&length_mean=4.175231281362470e-03,length_median=4.070787000000000e-03,length_95%HPD={2.011886000000000e-03,6.716031000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.455818e-02[&length_mean=2.468343903846154e-02,length_median=2.455818000000000e-02,length_95%HPD={1.883503000000000e-02,3.093022000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.259232e-02[&length_mean=3.271713160511946e-02,length_median=3.259232000000000e-02,length_95%HPD={2.449788000000000e-02,4.118775000000000e-02}],(((((1[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.750640e-04[&length_mean=4.910334907714302e-04,length_median=3.750640000000000e-04,length_95%HPD={3.163094000000000e-08,1.352026000000000e-03}],2[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.621893e-03[&length_mean=3.681494424943335e-03,length_median=3.621893000000000e-03,length_95%HPD={1.872249000000000e-03,5.708362000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.462238e-02[&length_mean=1.484632114834687e-02,length_median=1.462238000000000e-02,length_95%HPD={9.065201000000000e-03,2.104826000000000e-02}],103[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:9.964884e-02[&length_mean=9.994532104319423e-02,length_median=9.964884000000000e-02,length_95%HPD={8.550344999999999e-02,1.138283000000000e-01}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.409916e-02[&length_mean=3.429612109118787e-02,length_median=3.409916000000000e-02,length_95%HPD={2.622402000000000e-02,4.259795000000000e-02}],(60[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.152947e-01[&length_mean=1.156511144547399e-01,length_median=1.152947000000000e-01,length_95%HPD={9.980272000000000e-02,1.321986000000000e-01}],105[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.251665e-02[&length_mean=4.263861293660858e-02,length_median=4.251665000000000e-02,length_95%HPD={3.405307000000000e-02,5.195993000000000e-02}])[&prob=9.888681509132117e-01,prob_stddev=2.765561548682660e-03,prob_range={9.849353419544061e-01,9.908012265031330e-01},prob(percent)=\"99\",prob+-sd=\"99+-0\"]:6.507297e-03[&length_mean=6.775622987788469e-03,length_median=6.507297000000000e-03,length_95%HPD={2.004524000000000e-03,1.220449000000000e-02}])[&prob=9.381749100119984e-01,prob_stddev=4.630197303509461e-03,prob_range={9.326756432475670e-01,9.440074656712438e-01},prob(percent)=\"94\",prob+-sd=\"94+-0\"]:4.915209e-03[&length_mean=5.057213955721305e-03,length_median=4.915209000000000e-03,length_95%HPD={1.422209000000000e-03,8.879801000000000e-03}],(((15[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.834194e-02[&length_mean=1.858147994810696e-02,length_median=1.834194000000000e-02,length_95%HPD={1.389868000000000e-02,2.352769000000000e-02}],((46[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.472418e-04[&length_mean=7.351652144314100e-04,length_median=6.472418000000000e-04,length_95%HPD={9.182609000000000e-05,1.563291000000000e-03}],47[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.629643e-03[&length_mean=1.708605093904158e-03,length_median=1.629643000000000e-03,length_95%HPD={5.782702000000000e-04,3.023099000000000e-03}],(48[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:7.630060e-04[&length_mean=8.474998098366899e-04,length_median=7.630060000000000e-04,length_95%HPD={1.211887000000000e-04,1.768705000000000e-03}],49[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.462061e-04[&length_mean=7.276176951886416e-04,length_median=6.462061000000000e-04,length_95%HPD={7.269770999999999e-05,1.557569000000000e-03}])[&prob=9.953006265831222e-01,prob_stddev=2.872478526385178e-03,prob_range={9.918677509665378e-01,9.978669510731902e-01},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:7.572418e-04[&length_mean=8.400011363263214e-04,length_median=7.572418000000000e-04,length_95%HPD={8.461087000000000e-05,1.760837000000000e-03}],76[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.626930e-04[&length_mean=2.328068987564645e-04,length_median=1.626930000000000e-04,length_95%HPD={1.635109000000000e-08,6.848211000000000e-04}])[&prob=9.912678309558726e-01,prob_stddev=4.636750113589830e-03,prob_range={9.861351819757366e-01,9.960005332622317e-01},prob(percent)=\"99\",prob+-sd=\"99+-0\"]:8.685082e-04[&length_mean=9.487583223640005e-04,length_median=8.685082000000000e-04,length_95%HPD={2.041038000000000e-04,1.944720000000000e-03}],67[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.754631e-04[&length_mean=2.568709726021934e-04,length_median=1.754631000000000e-04,length_95%HPD={2.883300000000000e-08,7.729917000000000e-04}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.213178e-02[&length_mean=1.223325941047860e-02,length_median=1.213178000000000e-02,length_95%HPD={8.378793000000001e-03,1.666275000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.028644e-02[&length_mean=1.040634670770567e-02,length_median=1.028644000000000e-02,length_95%HPD={6.414797000000000e-03,1.461724000000000e-02}],((((((16[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.181288e-04[&length_mean=6.926145337599964e-04,length_median=6.181288000000000e-04,length_95%HPD={2.966878000000000e-05,1.512021000000000e-03}],(17[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:9.048274e-04[&length_mean=9.954978907319009e-04,length_median=9.048274000000000e-04,length_95%HPD={1.252843000000000e-04,2.020867000000000e-03}],18[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.123088e-03[&length_mean=1.198017604754361e-03,length_median=1.123088000000000e-03,length_95%HPD={2.439444000000000e-04,2.259020000000000e-03}])[&prob=9.913344887348354e-01,prob_stddev=2.798568456442958e-03,prob_range={9.880015997866951e-01,9.946673776829756e-01},prob(percent)=\"99\",prob+-sd=\"99+-0\"]:6.518557e-04[&length_mean=7.343345797152346e-04,length_median=6.518557000000000e-04,length_95%HPD={5.812181000000000e-05,1.549925000000000e-03}],94[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.110813e-03[&length_mean=1.186466109782025e-03,length_median=1.110813000000000e-03,length_95%HPD={2.895662000000000e-04,2.282919000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.777031e-03[&length_mean=1.866471523340219e-03,length_median=1.777031000000000e-03,length_95%HPD={6.822767000000000e-04,3.282397000000000e-03}],(40[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:7.190920e-04[&length_mean=8.023115387987567e-04,length_median=7.190920000000000e-04,length_95%HPD={9.040385000000000e-05,1.679272000000000e-03}],(57[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.097704e-04[&length_mean=4.904697130877222e-04,length_median=4.097704000000000e-04,length_95%HPD={1.617388000000000e-05,1.180993000000000e-03}],59[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.393245e-03[&length_mean=1.474673692954272e-03,length_median=1.393245000000000e-03,length_95%HPD={3.939698000000000e-04,2.638801000000000e-03}])[&prob=6.177176376483136e-01,prob_stddev=2.996655790852456e-02,prob_range={5.912544994000800e-01,6.481802426343154e-01},prob(percent)=\"62\",prob+-sd=\"62+-3\"]:3.419379e-04[&length_mean=4.193690577841039e-04,length_median=3.419379000000000e-04,length_95%HPD={2.074705000000000e-07,1.079828000000000e-03}],58[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.172459e-04[&length_mean=6.885095056759692e-04,length_median=6.172459000000000e-04,length_95%HPD={5.911502000000000e-05,1.453429000000000e-03}],(62[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.730292e-04[&length_mean=9.389734561255109e-04,length_median=8.730292000000000e-04,length_95%HPD={1.537132000000000e-04,1.879108000000000e-03}],100[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.124837e-04[&length_mean=5.943927439141725e-04,length_median=5.124837000000000e-04,length_95%HPD={1.315034000000000e-05,1.390729000000000e-03}])[&prob=5.876883082255699e-01,prob_stddev=6.156911946441777e-02,prob_range={5.135315291294494e-01,6.508465537928276e-01},prob(percent)=\"59\",prob+-sd=\"59+-6\"]:4.014143e-04[&length_mean=4.829068620362933e-04,length_median=4.014143000000000e-04,length_95%HPD={1.433710000000000e-05,1.164524000000000e-03}],95[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.120629e-04[&length_mean=3.971923638137097e-04,length_median=3.120629000000000e-04,length_95%HPD={1.075782000000000e-07,1.056596000000000e-03}],(97[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.915079e-04[&length_mean=2.729060741699591e-04,length_median=1.915079000000000e-04,length_95%HPD={5.083996000000000e-08,8.221754000000000e-04}],99[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.201295e-04[&length_mean=4.071390453006973e-04,length_median=3.201295000000000e-04,length_95%HPD={1.455409000000000e-08,1.062255000000000e-03}])[&prob=5.614584722037061e-01,prob_stddev=1.581630518291518e-02,prob_range={5.428609518730836e-01,5.763231569124116e-01},prob(percent)=\"56\",prob+-sd=\"56+-2\"]:4.779612e-04[&length_mean=5.610900965885290e-04,length_median=4.779612000000000e-04,length_95%HPD={1.258026000000000e-07,1.326554000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.713449e-03[&length_mean=1.782796652639651e-03,length_median=1.713449000000000e-03,length_95%HPD={5.710458000000000e-04,3.083893000000000e-03}])[&prob=9.998666844420745e-01,prob_stddev=1.885366700937832e-04,prob_range={9.996000533262231e-01,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.328852e-03[&length_mean=1.420488502392006e-03,length_median=1.328852000000000e-03,length_95%HPD={3.948738000000000e-04,2.708857000000000e-03}],108[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.662262e-03[&length_mean=4.761315109752084e-03,length_median=4.662262000000000e-03,length_95%HPD={2.676643000000000e-03,6.854150000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.488780e-03[&length_mean=4.593286456972412e-03,length_median=4.488780000000000e-03,length_95%HPD={2.489458000000000e-03,6.894177000000000e-03}],((43[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.945782e-04[&length_mean=4.696530474488390e-04,length_median=3.945782000000000e-04,length_95%HPD={4.182725000000000e-08,1.105131000000000e-03}],(44[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.670817e-04[&length_mean=9.416958486468493e-04,length_median=8.670817000000000e-04,length_95%HPD={1.590827000000000e-04,1.888217000000000e-03}],45[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.613440e-03[&length_mean=1.697247984888676e-03,length_median=1.613440000000000e-03,length_95%HPD={5.466006000000000e-04,2.991210000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.452473e-04[&length_mean=7.237798265072611e-04,length_median=6.452473000000000e-04,length_95%HPD={6.562767999999999e-05,1.563543000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.391371e-03[&length_mean=2.502901559962011e-03,length_median=2.391371000000000e-03,length_95%HPD={1.043327000000000e-03,4.140170000000000e-03}],((50[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.721794e-04[&length_mean=6.626320342112689e-04,length_median=5.721794000000001e-04,length_95%HPD={7.371237000000000e-06,1.516278000000000e-03}],54[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.997677e-04[&length_mean=9.748161113594864e-04,length_median=8.997677000000000e-04,length_95%HPD={1.581493000000000e-04,1.903498000000000e-03}])[&prob=9.998666844420744e-01,prob_stddev=2.666311158512254e-04,prob_range={9.994667377682975e-01,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:9.061969e-04[&length_mean=9.948348401173420e-04,length_median=9.061969000000000e-04,length_95%HPD={1.280386000000000e-04,2.028978000000000e-03}],(51[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:7.207409e-04[&length_mean=8.056126369737323e-04,length_median=7.207409000000000e-04,length_95%HPD={8.175804000000000e-05,1.732133000000000e-03}],53[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.456618e-04[&length_mean=7.223296765338249e-04,length_median=6.456618000000000e-04,length_95%HPD={8.731681000000000e-05,1.562772000000000e-03}],55[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.664389e-04[&length_mean=2.398741760562026e-04,length_median=1.664389000000000e-04,length_95%HPD={1.012020000000000e-07,7.297068000000001e-04}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.497624e-03[&length_mean=1.573440050286632e-03,length_median=1.497624000000000e-03,length_95%HPD={5.124688000000000e-04,2.814589000000000e-03}],52[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.721993e-04[&length_mean=9.516002897560274e-04,length_median=8.721993000000000e-04,length_95%HPD={1.588068000000000e-04,1.879702000000000e-03}])[&prob=9.164778029596053e-01,prob_stddev=1.199272061380361e-02,prob_range={9.016131182508998e-01,9.280095987201706e-01},prob(percent)=\"92\",prob+-sd=\"92+-1\"]:5.733327e-04[&length_mean=6.576477953465348e-04,length_median=5.733327000000000e-04,length_95%HPD={2.723564000000000e-06,1.465611000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.581764e-03[&length_mean=4.688205884582064e-03,length_median=4.581764000000000e-03,length_95%HPD={2.516001000000000e-03,6.913074000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.316349e-03[&length_mean=6.389703951139860e-03,length_median=6.316349000000000e-03,length_95%HPD={3.669989000000000e-03,8.976221000000000e-03}],(((((19[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.047128e-04[&length_mean=4.823705893317249e-04,length_median=4.047128000000000e-04,length_95%HPD={1.478893000000000e-05,1.141801000000000e-03}],23[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.115042e-04[&length_mean=4.895509665280307e-04,length_median=4.115042000000000e-04,length_95%HPD={1.460541000000000e-05,1.174576000000000e-03}],25[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.660006e-04[&length_mean=2.437418393668879e-04,length_median=1.660006000000000e-04,length_95%HPD={3.459126000000000e-08,7.548563000000000e-04}],(28[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.964830e-04[&length_mean=9.707447304699349e-04,length_median=8.964830000000000e-04,length_95%HPD={1.617496000000000e-04,1.901272000000000e-03}],33[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.632424e-04[&length_mean=2.355357347986928e-04,length_median=1.632424000000000e-04,length_95%HPD={3.201089000000000e-08,7.069152000000000e-04}],96[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.020721e-04[&length_mean=4.763263750100251e-04,length_median=4.020721000000000e-04,length_95%HPD={8.470578000000000e-06,1.117899000000000e-03}])[&prob=9.757032395680576e-01,prob_stddev=4.052990298242956e-03,prob_range={9.704039461405146e-01,9.802692974270097e-01},prob(percent)=\"98\",prob+-sd=\"98+-0\"]:4.002816e-04[&length_mean=4.808068709746122e-04,length_median=4.002816000000000e-04,length_95%HPD={1.266044000000000e-05,1.157662000000000e-03}])[&prob=9.794694040794560e-01,prob_stddev=3.699356599256568e-03,prob_range={9.770697240367950e-01,9.849353419544061e-01},prob(percent)=\"98\",prob+-sd=\"98+-0\"]:4.044784e-04[&length_mean=4.797105587174003e-04,length_median=4.044784000000000e-04,length_95%HPD={1.594002000000000e-05,1.142800000000000e-03}],(20[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.545127e-04[&length_mean=7.414056590574556e-04,length_median=6.545127000000000e-04,length_95%HPD={6.598113000000000e-05,1.610588000000000e-03}],35[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.554123e-04[&length_mean=7.357612339489018e-04,length_median=6.554123000000000e-04,length_95%HPD={6.987166000000000e-05,1.568309000000000e-03}])[&prob=9.213438208238902e-01,prob_stddev=9.145486141123836e-03,prob_range={9.093454206105852e-01,9.310758565524597e-01},prob(percent)=\"92\",prob+-sd=\"92+-1\"]:3.955568e-04[&length_mean=4.783294137852877e-04,length_median=3.955568000000000e-04,length_95%HPD={5.059896000000000e-06,1.152345000000000e-03}],24[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.052359e-04[&length_mean=4.823227247180385e-04,length_median=4.052359000000000e-04,length_95%HPD={6.526217000000000e-06,1.130480000000000e-03}],26[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.300166e-04[&length_mean=7.085551158455564e-04,length_median=6.300166000000000e-04,length_95%HPD={7.828044000000001e-05,1.501999000000000e-03}],27[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.722889e-04[&length_mean=2.488637336980471e-04,length_median=1.722889000000000e-04,length_95%HPD={3.794649000000000e-08,7.308953000000000e-04}],36[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.115742e-04[&length_mean=4.913393002596972e-04,length_median=4.115742000000000e-04,length_95%HPD={2.236099000000000e-05,1.158868000000000e-03}],37[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.374064e-04[&length_mean=7.083848018750847e-04,length_median=6.374064000000000e-04,length_95%HPD={5.145686000000000e-05,1.488262000000000e-03}],(39[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.725162e-04[&length_mean=2.441536222372232e-04,length_median=1.725162000000000e-04,length_95%HPD={2.527904000000000e-08,7.311384000000000e-04}],(64[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.945505e-04[&length_mean=4.658783162542667e-04,length_median=3.945505000000000e-04,length_95%HPD={8.749956000000001e-06,1.107212000000000e-03}],65[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.892931e-04[&length_mean=4.712233998761512e-04,length_median=3.892931000000000e-04,length_95%HPD={1.151709000000000e-05,1.144888000000000e-03}],66[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.756290e-04[&length_mean=2.457327251721422e-04,length_median=1.756290000000000e-04,length_95%HPD={9.387912000000000e-08,7.315110000000000e-04}])[&prob=9.954339421410479e-01,prob_stddev=2.523622781762759e-04,prob_range={9.950673243567524e-01,9.956005865884549e-01},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.059876e-04[&length_mean=4.785986786054168e-04,length_median=4.059876000000000e-04,length_95%HPD={9.566920000000000e-06,1.135952000000000e-03}],101[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.645868e-04[&length_mean=2.394560513886307e-04,length_median=1.645868000000000e-04,length_95%HPD={4.524528000000000e-08,7.155334000000000e-04}])[&prob=9.998000266631115e-01,prob_stddev=3.999466737768582e-04,prob_range={9.992001066524463e-01,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:9.058396e-04[&length_mean=9.753194673864928e-04,length_median=9.058396000000000e-04,length_95%HPD={2.037320000000000e-04,1.903124000000000e-03}],61[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.039909e-04[&length_mean=4.884675870383264e-04,length_median=4.039909000000000e-04,length_95%HPD={1.633269000000000e-06,1.169809000000000e-03}],63[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.683932e-04[&length_mean=2.435697312942522e-04,length_median=1.683932000000000e-04,length_95%HPD={3.928855000000000e-08,7.237705000000001e-04}])[&prob=9.918344220770563e-01,prob_stddev=5.681573746796439e-03,prob_range={9.842687641647780e-01,9.974670043994134e-01},prob(percent)=\"99\",prob+-sd=\"99+-1\"]:7.592030e-04[&length_mean=8.489978316781486e-04,length_median=7.592030000000000e-04,length_95%HPD={9.425047000000001e-05,1.799829000000000e-03}],31[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.789697e-04[&length_mean=3.664355685077312e-04,length_median=2.789697000000000e-04,length_95%HPD={9.684879000000000e-08,1.038503000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.409228e-03[&length_mean=4.486560560625240e-03,length_median=4.409228000000000e-03,length_95%HPD={2.444843000000000e-03,6.600494000000000e-03}],(((((29[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.110392e-03[&length_mean=1.195659682823954e-03,length_median=1.110392000000000e-03,length_95%HPD={3.197782000000000e-04,2.306243000000000e-03}],32[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.111013e-04[&length_mean=4.934283586891096e-04,length_median=4.111013000000000e-04,length_95%HPD={3.887744000000000e-06,1.156994000000000e-03}],34[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.028845e-04[&length_mean=4.736503860578380e-04,length_median=4.028845000000000e-04,length_95%HPD={1.304829000000000e-05,1.120313000000000e-03}],87[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.701912e-04[&length_mean=2.416209459012097e-04,length_median=1.701912000000000e-04,length_95%HPD={1.681466000000000e-08,7.087409000000000e-04}])[&prob=5.246967071057191e-01,prob_stddev=1.982009024944946e-02,prob_range={5.031329156112518e-01,5.420610585255299e-01},prob(percent)=\"52\",prob+-sd=\"52+-2\"]:3.691845e-04[&length_mean=4.495529154161344e-04,length_median=3.691845000000000e-04,length_95%HPD={1.333753000000000e-06,1.114341000000000e-03}],77[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.081114e-04[&length_mean=4.815088361721117e-04,length_median=4.081114000000000e-04,length_95%HPD={1.609098000000000e-05,1.111318000000000e-03}])[&prob=5.542594320757233e-01,prob_stddev=1.822266493589935e-02,prob_range={5.403279562724970e-01,5.805892547660312e-01},prob(percent)=\"55\",prob+-sd=\"55+-2\"]:3.740879e-04[&length_mean=4.546090835104388e-04,length_median=3.740879000000000e-04,length_95%HPD={2.108335000000000e-07,1.135927000000000e-03}],30[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.723206e-04[&length_mean=2.407346960881420e-04,length_median=1.723206000000000e-04,length_95%HPD={1.771384000000000e-08,6.973470000000000e-04}],38[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.748814e-04[&length_mean=9.680527170363954e-04,length_median=8.748814000000000e-04,length_95%HPD={1.939045000000000e-04,2.003639000000000e-03}],91[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.606404e-04[&length_mean=2.368723437368288e-04,length_median=1.606404000000000e-04,length_95%HPD={1.076586000000000e-08,7.083408000000000e-04}])[&prob=9.999000133315558e-01,prob_stddev=1.999733368884291e-04,prob_range={9.996000533262231e-01,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.499663e-04[&length_mean=7.221307837459055e-04,length_median=6.499663000000000e-04,length_95%HPD={7.161996000000001e-05,1.509420000000000e-03}],41[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.007791e-04[&length_mean=4.798668730495898e-04,length_median=4.007791000000000e-04,length_95%HPD={1.326511000000000e-05,1.136275000000000e-03}],(42[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.023634e-04[&length_mean=5.932247707962326e-04,length_median=5.023633999999999e-04,length_95%HPD={2.472351000000000e-05,1.393438000000000e-03}],68[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:9.043790e-03[&length_mean=9.168859010698516e-03,length_median=9.043789999999999e-03,length_95%HPD={6.327014000000000e-03,1.214078000000000e-02}],72[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.658920e-04[&length_mean=3.476470972051608e-04,length_median=2.658920000000000e-04,length_95%HPD={2.812844000000000e-08,9.580240000000000e-04}],73[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.395000e-04[&length_mean=7.172706602859606e-04,length_median=6.395000000000000e-04,length_95%HPD={6.583280000000000e-05,1.538732000000000e-03}],74[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.051757e-04[&length_mean=4.835184153280528e-04,length_median=4.051757000000000e-04,length_95%HPD={1.449522000000000e-05,1.137791000000000e-03}],75[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.136666e-04[&length_mean=4.834418101840012e-04,length_median=4.136666000000000e-04,length_95%HPD={7.600423000000000e-06,1.126110000000000e-03}],98[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.805501e-04[&length_mean=9.502557297803647e-04,length_median=8.805501000000001e-04,length_95%HPD={1.779595000000000e-04,1.906823000000000e-03}])[&prob=7.886615117984268e-01,prob_stddev=1.943006606898778e-02,prob_range={7.702972936941741e-01,8.128249566724437e-01},prob(percent)=\"79\",prob+-sd=\"79+-2\"]:3.853694e-04[&length_mean=4.618941051455552e-04,length_median=3.853694000000000e-04,length_95%HPD={1.479460000000000e-07,1.103156000000000e-03}])[&prob=9.742034395413945e-01,prob_stddev=7.059852891950508e-03,prob_range={9.642714304759366e-01,9.809358752166378e-01},prob(percent)=\"97\",prob+-sd=\"97+-1\"]:4.038421e-04[&length_mean=4.798706911982897e-04,length_median=4.038421000000000e-04,length_95%HPD={1.740685000000000e-05,1.156042000000000e-03}],69[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.483086e-04[&length_mean=7.225084149727666e-04,length_median=6.483086000000000e-04,length_95%HPD={9.173806000000000e-05,1.536828000000000e-03}],70[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.467148e-04[&length_mean=7.187240408168894e-04,length_median=6.467148000000000e-04,length_95%HPD={6.500689000000000e-05,1.507006000000000e-03}],71[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.322775e-04[&length_mean=7.070351550963233e-04,length_median=6.322775000000001e-04,length_95%HPD={8.891761000000000e-05,1.499914000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.948662e-03[&length_mean=6.046323846687103e-03,length_median=5.948662000000000e-03,length_95%HPD={3.713046000000000e-03,8.724361999999999e-03}])[&prob=9.999000133315558e-01,prob_stddev=1.276399290436512e-04,prob_range={9.997333688841488e-01,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.519317e-03[&length_mean=1.616776716351113e-03,length_median=1.519317000000000e-03,length_95%HPD={4.175973000000000e-04,3.122133000000000e-03}],(21[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.689005e-03[&length_mean=1.774160692167709e-03,length_median=1.689005000000000e-03,length_95%HPD={6.219815000000000e-04,3.155175000000000e-03}],(22[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.758932e-04[&length_mean=9.359915006075838e-04,length_median=8.758932000000001e-04,length_95%HPD={1.609538000000000e-04,1.857120000000000e-03}],56[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.110298e-04[&length_mean=4.867551236855965e-04,length_median=4.110298000000000e-04,length_95%HPD={6.093614000000000e-06,1.161413000000000e-03}])[&prob=7.528996133848820e-01,prob_stddev=1.297688463800279e-02,prob_range={7.360351953072923e-01,7.644314091454473e-01},prob(percent)=\"75\",prob+-sd=\"75+-1\"]:3.786072e-04[&length_mean=4.546856808615468e-04,length_median=3.786072000000000e-04,length_95%HPD={9.620158000000000e-07,1.091422000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.974762e-03[&length_mean=5.054589494134122e-03,length_median=4.974762000000000e-03,length_95%HPD={2.941968000000000e-03,7.339403000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.787678e-03[&length_mean=4.851770360318654e-03,length_median=4.787678000000000e-03,length_95%HPD={2.495343000000000e-03,7.294482000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.773022e-03[&length_mean=5.857002869983994e-03,length_median=5.773022000000000e-03,length_95%HPD={3.116102000000000e-03,8.686048000000000e-03}],(((78[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.677418e-04[&length_mean=2.444771491727322e-04,length_median=1.677418000000000e-04,length_95%HPD={3.544103000000000e-08,7.277246000000000e-04}],(82[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.956773e-04[&length_mean=4.796176214796681e-04,length_median=3.956773000000000e-04,length_95%HPD={1.308715000000000e-05,1.158955000000000e-03}],85[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.682508e-04[&length_mean=2.437625237189042e-04,length_median=1.682508000000000e-04,length_95%HPD={3.030997000000000e-08,7.349962000000000e-04}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.467646e-04[&length_mean=7.296503401786404e-04,length_median=6.467646000000000e-04,length_95%HPD={7.301457000000000e-05,1.568198000000000e-03}])[&prob=9.639714704706039e-01,prob_stddev=5.836902665864670e-03,prob_range={9.589388081589122e-01,9.724036795093988e-01},prob(percent)=\"96\",prob+-sd=\"96+-1\"]:4.144170e-04[&length_mean=4.935054531372611e-04,length_median=4.144170000000000e-04,length_95%HPD={8.468325999999999e-06,1.163266000000000e-03}],((83[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.938615e-04[&length_mean=4.748793623288206e-04,length_median=3.938615000000000e-04,length_95%HPD={9.531803000000001e-06,1.130163000000000e-03}],86[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.101799e-04[&length_mean=4.861958636535438e-04,length_median=4.101799000000000e-04,length_95%HPD={1.000996000000000e-05,1.180262000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.737473e-04[&length_mean=9.472269446303794e-04,length_median=8.737473000000000e-04,length_95%HPD={1.759574000000000e-04,1.875899000000000e-03}],84[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.576574e-04[&length_mean=9.463889830615864e-04,length_median=8.576574000000000e-04,length_95%HPD={1.577971000000000e-04,1.901916000000000e-03}],(88[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.681422e-04[&length_mean=2.408792396746413e-04,length_median=1.681422000000000e-04,length_95%HPD={1.050247000000000e-08,7.315366000000000e-04}],89[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.734492e-04[&length_mean=2.459166596653934e-04,length_median=1.734492000000000e-04,length_95%HPD={1.552492000000000e-08,7.286516000000000e-04}],92[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.589898e-04[&length_mean=2.362497601566338e-04,length_median=1.589898000000000e-04,length_95%HPD={7.372769000000000e-08,7.099537000000000e-04}])[&prob=9.840354619384082e-01,prob_stddev=4.391157606741586e-03,prob_range={9.790694574056792e-01,9.892014398080256e-01},prob(percent)=\"98\",prob+-sd=\"98+-0\"]:3.963884e-04[&length_mean=4.756233988658016e-04,length_median=3.963884000000000e-04,length_95%HPD={5.010572000000000e-06,1.142350000000000e-03}],93[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.142675e-03[&length_mean=1.214464703716168e-03,length_median=1.142675000000000e-03,length_95%HPD={3.106121000000000e-04,2.285243000000000e-03}])[&prob=9.568390881215838e-01,prob_stddev=2.025855544711956e-03,prob_range={9.541394480735902e-01,9.589388081589122e-01},prob(percent)=\"96\",prob+-sd=\"96+-0\"]:3.944639e-04[&length_mean=4.796610162469966e-04,length_median=3.944639000000000e-04,length_95%HPD={4.669523000000000e-06,1.135909000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.613926e-03[&length_mean=2.691023812518337e-03,length_median=2.613926000000000e-03,length_95%HPD={1.137685000000000e-03,4.376386000000000e-03}],(79[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:8.836801e-04[&length_mean=9.709753774620095e-04,length_median=8.836801000000000e-04,length_95%HPD={1.862992000000000e-04,1.955559000000000e-03}],((80[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.422716e-04[&length_mean=7.211715554452702e-04,length_median=6.422716000000000e-04,length_95%HPD={7.440137999999999e-05,1.562380000000000e-03}],81[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.646258e-04[&length_mean=7.466862152373038e-04,length_median=6.646258000000000e-04,length_95%HPD={7.928462000000000e-05,1.592689000000000e-03}])[&prob=9.964004799360084e-01,prob_stddev=2.475030052107603e-03,prob_range={9.932009065457938e-01,9.986668444207439e-01},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.318315e-04[&length_mean=6.190280436143280e-04,length_median=5.318315000000000e-04,length_95%HPD={2.341030000000000e-05,1.412319000000000e-03}],90[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.375762e-03[&length_mean=1.450464103102919e-03,length_median=1.375762000000000e-03,length_95%HPD={4.066308000000000e-04,2.626253000000000e-03}])[&prob=9.840354619384082e-01,prob_stddev=1.486034982642856e-03,prob_range={9.826689774696707e-01,9.861351819757366e-01},prob(percent)=\"98\",prob+-sd=\"98+-0\"]:5.143125e-04[&length_mean=5.983789437787951e-04,length_median=5.143125000000000e-04,length_95%HPD={1.151804000000000e-05,1.354124000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.125448e-03[&length_mean=3.203830031805733e-03,length_median=3.125448000000000e-03,length_95%HPD={1.482303000000000e-03,5.049017000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.699802e-03[&length_mean=5.810016320390573e-03,length_median=5.699802000000000e-03,length_95%HPD={3.312144000000000e-03,8.706360999999999e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.319823e-02[&length_mean=1.330024495427286e-02,length_median=1.319823000000000e-02,length_95%HPD={8.715664999999999e-03,1.782668000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.857504e-02[&length_mean=1.867899597860293e-02,length_median=1.857504000000000e-02,length_95%HPD={1.275419000000000e-02,2.447803000000000e-02}],104[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.439121e-02[&length_mean=6.449995901479676e-02,length_median=6.439121000000000e-02,length_95%HPD={5.475674000000000e-02,7.472280000000001e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.196169e-02[&length_mean=1.214097522940265e-02,length_median=1.196169000000000e-02,length_95%HPD={7.044229000000000e-03,1.750589000000000e-02}])[&prob=7.140381282495667e-01,prob_stddev=7.760599292917216e-03,prob_range={7.076389814691374e-01,7.239034795360618e-01},prob(percent)=\"71\",prob+-sd=\"71+-1\"]:4.034893e-03[&length_mean=4.245973118681845e-03,length_median=4.034893000000000e-03,length_95%HPD={7.216214000000000e-04,8.155646000000001e-03}],((((((3[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.767551e-03[&length_mean=4.880657167011049e-03,length_median=4.767551000000000e-03,length_95%HPD={2.771551000000000e-03,7.173621000000000e-03}],4[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:3.495889e-04[&length_mean=4.557593776520010e-04,length_median=3.495889000000000e-04,length_95%HPD={2.605841000000000e-07,1.216950000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.108122e-02[&length_mean=1.116947736968411e-02,length_median=1.108122000000000e-02,length_95%HPD={7.605603000000000e-03,1.481174000000000e-02}],(12[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.993911e-02[&length_mean=2.002721223136900e-02,length_median=1.993911000000000e-02,length_95%HPD={1.545131000000000e-02,2.490270000000000e-02}],13[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.509195e-02[&length_mean=1.518778432652309e-02,length_median=1.509195000000000e-02,length_95%HPD={1.089002000000000e-02,1.937566000000000e-02}])[&prob=9.997333688841488e-01,prob_stddev=1.088516972307388e-04,prob_range={9.996000533262231e-01,9.998666844420744e-01},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.474750e-03[&length_mean=2.591456993829153e-03,length_median=2.474750000000000e-03,length_95%HPD={6.397801000000000e-04,4.554593000000000e-03}])[&prob=9.586721770430610e-01,prob_stddev=3.996503071753466e-03,prob_range={9.530729236101854e-01,9.621383815491268e-01},prob(percent)=\"96\",prob+-sd=\"96+-0\"]:2.405978e-03[&length_mean=2.563098639077335e-03,length_median=2.405978000000000e-03,length_95%HPD={3.828833000000000e-04,4.696069000000000e-03}],(8[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:2.627936e-03[&length_mean=2.761247603079587e-03,length_median=2.627936000000000e-03,length_95%HPD={1.088326000000000e-03,4.708048000000000e-03}],11[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.578457e-03[&length_mean=5.672043116851089e-03,length_median=5.578457000000000e-03,length_95%HPD={3.321915000000000e-03,8.272396000000000e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.623198e-02[&length_mean=1.633286353369564e-02,length_median=1.623198000000000e-02,length_95%HPD={1.210358000000000e-02,2.091678000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.254921e-03[&length_mean=6.375803925463276e-03,length_median=6.254921000000000e-03,length_95%HPD={2.873486000000000e-03,1.031156000000000e-02}],(6[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.145205e-02[&length_mean=1.160531602196375e-02,length_median=1.145205000000000e-02,length_95%HPD={8.053004000000001e-03,1.545023000000000e-02}],10[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.653762e-02[&length_mean=1.662879457082388e-02,length_median=1.653762000000000e-02,length_95%HPD={1.236350000000000e-02,2.147759000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.199724e-02[&length_mean=1.210016685441945e-02,length_median=1.199724000000000e-02,length_95%HPD={7.599532000000000e-03,1.663637000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:6.230100e-02[&length_mean=6.248493786728445e-02,length_median=6.230100000000000e-02,length_95%HPD={5.158393000000000e-02,7.379197000000000e-02}],(5[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:4.943148e-03[&length_mean=5.039288559375459e-03,length_median=4.943148000000000e-03,length_95%HPD={2.150515000000000e-03,7.886641999999999e-03}],7[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.767556e-03[&length_mean=5.836397278096195e-03,length_median=5.767556000000000e-03,length_95%HPD={2.904217000000000e-03,8.948062999999999e-03}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:5.000414e-02[&length_mean=5.008516978702834e-02,length_median=5.000414000000000e-02,length_95%HPD={3.971990000000000e-02,6.005726000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:1.759561e-02[&length_mean=1.788367992541012e-02,length_median=1.759561000000000e-02,length_95%HPD={1.032215000000000e-02,2.564159000000000e-02}],9[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:7.463525e-02[&length_mean=7.478535756032610e-02,length_median=7.463525000000000e-02,length_95%HPD={6.203630000000000e-02,8.767021000000000e-02}])[&prob=1.000000000000000e+00,prob_stddev=0.000000000000000e+00,prob_range={1.000000000000000e+00,1.000000000000000e+00},prob(percent)=\"100\",prob+-sd=\"100+-0\"]:7.923954e-02[&length_mean=7.935199156045922e-02,length_median=7.923954000000000e-02,length_95%HPD={6.549944000000001e-02,9.239187000000000e-02}])[&prob=5.562924943340888e-01,prob_stddev=1.380288237169630e-02,prob_range={5.428609518730836e-01,5.699240101319824e-01},prob(percent)=\"56\",prob+-sd=\"56+-1\"]:3.264752e-03[&length_mean=3.589768101536441e-03,length_median=3.264752000000000e-03,length_95%HPD={2.364439000000000e-05,7.760774000000000e-03}]);end;\n";
        String nexFilePath = "/Users/andy/Documents/TSCreator/EvolutionaryTree/Fordham and Zehady shared/180724/mmc2/mb_A1_SFig02_nmt.nex.con.nwk";
        String nexNN = T.loadTreeFromFile(nexFilePath);
        String newNwk = T.convertNexusToNewickFormat(nexNN);
        T.print(newNwk);
        T.print("----------------------------");
        String tsfN = T.convertNewickToTSC(newNwk);
        T.print(tsfN);
        T.print("--------------------------");
        try {
            String fpathN = "/Users/andy/Desktop/treeRealTSC.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fpathN));
            writer.write(tsfN);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class Path {
        public String path;
        public double d;

        public Path() {
            this.path = "";
            this.d = 0.0;
        }

        public Path(String path, double d) {
            this.path = path;
            this.d = d;
        }

        public Path(Path p) {
            this.path = p.path;
            this.d = p.d;
        }
    }

    public class TreeNode {
        public String name;
        public double d;
        public double FAD;
        public double LAD;
        public ArrayList<TreeNode> child;
        public TreeNode parent;
        public HashMap<String, Double> attributes;

        public TreeNode() {
        }

        public TreeNode(String name, double d) {
            this.name = name;
            this.LAD = -1.0;
            this.FAD = -1.0;
            this.d = d;
            this.parent = null;
            this.child = null;
            this.attributes = null;
        }

        public TreeNode(String name, double FAD, double LAD) {
            this.name = name;
            this.LAD = LAD;
            this.FAD = FAD;
            this.d = -1.0;
            this.parent = null;
            this.child = null;
            this.attributes = null;
        }

        public TreeNode(String name, double FAD, double LAD, double d) {
            this.name = name;
            this.LAD = LAD;
            this.FAD = FAD;
            this.d = d;
            this.parent = null;
            this.child = null;
            this.attributes = null;
        }

        public TreeNode(TreeNode tn) {
            this.name = tn.name;
            this.LAD = tn.LAD;
            this.FAD = tn.FAD;
            this.d = tn.d;
            this.parent = tn.parent;
            this.child = tn.child;
            this.attributes = tn.attributes;
        }
    }
}

