/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import gui.crossplot.Crossplot;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccumulationRateColumn {
    public int min = 0;
    public int max = 0;
    public AccumulationRatePair[] accuPair = null;

    public AccumulationRateColumn setAccuRateCol(Crossplot crossplot) {
        AccumulationRateColumn accCol = new AccumulationRateColumn();
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(1);
        accCol.accuPair = new AccumulationRatePair[crossplot.age_depth_models.size() - 1];
        ArrayList<Double> rateList = new ArrayList<Double>(accCol.accuPair.length);
        for (int i = 1; i < crossplot.age_depth_models.size(); ++i) {
            double depth = (crossplot.age_depth_models.get((int)i).depth + crossplot.age_depth_models.get((int)(i - 1)).depth) / 2.0;
            double depth_diff = Math.abs(crossplot.age_depth_models.get((int)i).depth - crossplot.age_depth_models.get((int)(i - 1)).depth);
            if (depth_diff == 0.0) {
                depth_diff = 0.1;
            }
            double age_diff = Math.abs(crossplot.age_depth_models.get((int)i).age - crossplot.age_depth_models.get((int)(i - 1)).age);
            double rate = Double.parseDouble(df.format(depth_diff / age_diff).replaceAll(",", ""));
            accCol.accuPair[i - 1] = new AccumulationRatePair(depth, rate);
            rateList.add(rate);
        }
        Collections.sort(rateList);
        this.limitRate(rateList, accCol);
        accCol.min = 0;
        accCol.max = (int)((Double)rateList.get(accCol.accuPair.length - 1) + 1.0);
        return accCol;
    }

    private void limitRate(List rateList, AccumulationRateColumn accCol) {
        double median = (Double)rateList.get(accCol.accuPair.length / 2);
        double median_ten = median * 10.0;
        for (int i = 0; i < accCol.accuPair.length; ++i) {
            if (!(accCol.accuPair[i].rate > median_ten)) continue;
            accCol.accuPair[i].rate = median * 10.0;
        }
    }

    public class AccumulationRatePair {
        public double depth;
        public double rate;

        public AccumulationRatePair(double depth, double rate) {
            this.depth = depth;
            this.rate = rate;
        }
    }
}

