/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Comparator;
import util.Point;
import util.Vector2D;

public class Geom {
    public static Vector2D getVectorPerpToLine(Point a, Point b) {
        return new Vector2D(-(b.x - a.x), b.y - a.y);
    }

    public static double getPointLineDistance(Point p, Point a, Point b) {
        Vector2D v = Geom.getVectorPerpToLine(a, b);
        Vector2D r = new Vector2D(a.x - p.x, a.y - p.y);
        return Math.abs(r.compThisInA(v));
    }

    public static boolean isPointInsideQuad(Point p, Point p1, Point p2, Point p3, Point p4) {
        Point[] ps = new Point[]{p1, p2, p3, p4};
        for (int i = 0; i < ps.length; ++i) {
            int me = i;
            int next = (i + 1) % ps.length;
            int test = (i + 2) % ps.length;
            if (Geom.isSameSide(ps[me], ps[next], ps[test], p)) continue;
            return false;
        }
        return true;
    }

    public static Point getLineSegmentIntersection(Point p1, Point p2, Point p3, Point p4) {
        double uaNum = (p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x);
        double ubNum = (p2.x - p1.x) * (p1.y - p3.y) - (p2.y - p1.y) * (p1.x - p3.x);
        double den = (p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y);
        if (den == 0.0) {
            return null;
        }
        double ua = uaNum / den;
        double ub = ubNum / den;
        if (ua < -1.0E-6 || ua > 1.000001 || ub < -1.0E-6 || ub > 1.000001) {
            return null;
        }
        if (ua < 0.0) {
            ua = 0.0;
        }
        if (ua > 1.0) {
            ua = 1.0;
        }
        double x = p1.x + ua * (p2.x - p1.x);
        double y = p1.y + ua * (p2.y - p1.y);
        return new Point(x, y);
    }

    public static Point getLineIntersection(Point p1, Point p2, Point p3, Point p4) {
        double uaNum = (p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x);
        double ubNum = (p2.x - p1.x) * (p1.y - p3.y) - (p2.y - p1.y) * (p1.x - p3.x);
        double den = (p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y);
        if (den == 0.0) {
            return null;
        }
        double ua = uaNum / den;
        double x = p1.x + ua * (p2.x - p1.x);
        double y = p1.y + ua * (p2.y - p1.y);
        return new Point(x, y);
    }

    protected static int ccw(Point p0, Point p1, Point p2) {
        int n = 3;
        Point[] v = new Point[]{p0, p1, p2};
        double area = v[n - 1].getX() * v[0].getY() - v[0].getX() * v[n - 1].getY();
        for (int i = 0; i < n - 1; ++i) {
            area += v[i].getX() * v[i + 1].getY() - v[i + 1].getX() * v[i].getY();
        }
        if (area < 1.0E-5 && area > -1.0E-5) {
            return 0;
        }
        if (area >= 0.0) {
            return -1;
        }
        return 1;
    }

    protected static boolean isSameSide(Point a, Point b, Point main, Point test) {
        int ccw1 = Geom.ccw(a, b, main);
        int ccw2 = Geom.ccw(a, b, test);
        if (ccw1 == 0 || ccw2 == 0) {
            return true;
        }
        return ccw1 == ccw2;
    }

    protected static class CWComparator
    implements Comparator {
        public Point center;

        public CWComparator(Point center) {
            this.center = center;
        }

        public int compare(Object arg0, Object arg1) {
            Point p1 = (Point)arg0;
            Point p2 = (Point)arg1;
            return Geom.ccw(this.center, p1, p2);
        }
    }
}

