/*
 * Decompiled with CFR 0.152.
 */
package model;

import model.Datapack;
import model.ModelIdentifier;
import model.storage.ColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public abstract class Column {
    private ModelIdentifier identifier = null;
    private ModelIdentifier datapackIdentifier = null;
    private int overlayId = 0;
    private Column overlay = null;
    private int overlayPos = 0;
    private String title = "";
    private double width = 0.0;
    private String color = "";
    private boolean showTitle = false;
    private boolean onOff = false;
    private String popupText = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public Column(String database) {
        this.setColumnIdentifier(new ModelIdentifier(0, database, 1));
    }

    public Column(SourceResult result) {
        this.setColumnIdentifier(new ModelIdentifier(result.getInt("columns_id"), result.getString("database"), 1));
        this.setDatapackIdentifier(new ModelIdentifier(result.getInt("datapacks_id"), result.getString("database"), 27));
        this.setOverlayId(result.getInt("overlay_id"));
        this.setOverlayPos(result.getInt("overlay_pos"));
        this.setTitle(result.getString("title"));
        this.setWidth(result.getDouble("width"));
        this.setColor(result.getString("color"));
        this.setShowTitle(result.getBool("default_show_title"));
        this.setOnOff(result.getBool("on_off"));
        this.setPopupText(result.getString("popup_text"));
        this.setColumnDeleted(result.getBool("deleted"));
        this.setColumnCreationDate(result.getString("creationDate"));
        this.setColumnLastModified(result.getString("lastModified"));
    }

    public void save() {
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            ColumnStorage.insert(this);
            this.getColumnIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            ColumnStorage.update(this);
        }
    }

    public abstract ModelIdentifier getIdentifier();

    public abstract void setIdentifier(ModelIdentifier var1);

    public final ModelIdentifier getColumnIdentifier() {
        return this.identifier;
    }

    public final void setColumnIdentifier(ModelIdentifier id) {
        this.identifier = id;
    }

    public final Datapack getDatapack() {
        return Datapack.Factory.getByIdentifier(this.datapackIdentifier);
    }

    public ModelIdentifier getDatapackIdentifier() {
        return this.datapackIdentifier;
    }

    public final void setDatapack(Datapack dp) {
        this.datapackIdentifier = dp.getIdentifier();
    }

    public final void setDatapackIdentifier(ModelIdentifier datapackId) {
        this.datapackIdentifier = datapackId;
    }

    public String getColor() {
        return this.color;
    }

    public final void setColor(String color) {
        this.color = color;
    }

    public final boolean isOnOff() {
        return this.onOff;
    }

    public final void setOnOff(boolean onOff) {
        this.onOff = onOff;
    }

    public final String getPopupText() {
        return this.popupText;
    }

    public final void setPopupText(String popupText) {
        this.popupText = popupText;
    }

    public final boolean isShowTitle() {
        return this.showTitle;
    }

    public final void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public final double getWidth() {
        return this.width;
    }

    public final void setWidth(double width) {
        this.width = width;
    }

    public final int getOverlayId() {
        return this.overlayId;
    }

    public final void setOverlayId(int overlayId) {
        this.overlayId = overlayId;
    }

    public final int getOverlayPos() {
        return this.overlayPos;
    }

    public final void setOverlayPos(int overlayPos) {
        this.overlayPos = overlayPos;
    }

    public boolean isColumnDeleted() {
        return this.deleted;
    }

    public final void setColumnDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getColumnLastModified() {
        return this.lastModified;
    }

    private void setColumnLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getColumnCreationDate() {
        return this.creationDate;
    }

    private void setColumnCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String toString() {
        return "COLUMN: [ Identifier( " + this.identifier.toString() + ") overlayId = " + this.overlayId + " overlayPos = " + this.overlayPos + " title = " + this.title + " width = " + this.width + " color = " + this.color + " showTitle = " + this.showTitle + " onOff = " + this.onOff + " popupText = " + this.popupText + "]";
    }
}

