/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import datastore.BlockSeriesMetaColumn;
import datastore.DataColumn;
import datastore.EventColumn;
import datastore.FreehandColumn;
import datastore.MetaColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.RulerColumn;
import datastore.SequenceColumn;
import datastore.ZoneColumn;
import gui.ModifyTextField;
import gui.editor.DataEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import path.ResPath;
import util.FileUtils;

public class MetaColumnEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSplitPane splitPane = null;
    private JPanel jPanel = null;
    private JScrollPane popupSP = null;
    private JEditorPane popupEP = null;
    private JToolBar rightToolbar = null;
    private JToolBar bottomToolbar = null;
    private JButton moveUp = null;
    private JButton createB = null;
    private JComboBox colTypeCB = null;
    private JButton moveDown = null;
    private JButton deleteB = null;
    private JPanel titlePanel = null;
    private JTextField titleTF = null;
    private JLabel titleLabel = null;
    private JCheckBox showTitleCB = null;
    private JButton moveB = null;
    private JScrollPane colListSP = null;
    private JList colList = null;
    private JPanel listCardPanel = null;
    private JPanel movingPanel = null;
    private JLabel movingLabel = null;
    private JButton cancelMove = null;
    protected MetaColumn col;
    protected DefaultTreeModel zoneTreeModel;
    protected boolean movingMode = false;
    protected static final String[] newColStrings = new String[]{"Age", "Blank", "Block", "Chron", "Event", "Facies", "Freehand", "Grouping", "Point (graph)", "Range", "Sequence", "Trend"};

    public MetaColumnEditor(MetaColumn col, DefaultTreeModel zoneTreeModel) {
        this.col = col;
        this.zoneTreeModel = zoneTreeModel;
        this.initialize();
        this.titleTF.setText(col.getName());
        this.showTitleCB.setSelected(col.drawTitle);
        this.setMovingMode(false);
    }

    public void nodeChanged(DataColumn dc) {
    }

    public void nodeStructureChanged(DataColumn dc) {
    }

    public final void setMovingMode(boolean mm) {
        this.movingMode = mm;
        CardLayout cl = (CardLayout)this.listCardPanel.getLayout();
        if (this.movingMode) {
            cl.show(this.listCardPanel, this.movingPanel.getName());
        } else {
            cl.show(this.listCardPanel, this.colListSP.getName());
        }
        this.doEnablings();
    }

    public boolean isInMovingMode() {
        return this.movingMode;
    }

    public void setMoveToColumn(DataColumn c) {
        if (c instanceof MetaColumn) {
            MetaColumn mc = (MetaColumn)c;
            int[] sel = this.colList.getSelectedIndices();
            for (int i = 0; i < sel.length; ++i) {
                DataColumn movee = this.col.removeColumn(sel[i]);
                mc.addColumn(movee);
            }
            this.nodeStructureChanged(this.col);
            this.nodeStructureChanged(mc);
        }
        this.setMovingMode(false);
    }

    public void doEnablings() {
        if (this.isInMovingMode()) {
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
            this.deleteB.setEnabled(false);
            this.moveB.setEnabled(false);
        } else {
            int[] sel = this.colList.getSelectedIndices();
            if (sel.length == 0) {
                this.moveUp.setEnabled(false);
                this.moveDown.setEnabled(false);
                this.deleteB.setEnabled(false);
                this.moveB.setEnabled(false);
            } else {
                this.moveUp.setEnabled(sel[0] != 0);
                this.moveDown.setEnabled(sel[sel.length - 1] != this.col.getSubColumnCount() - 1);
                this.deleteB.setEnabled(true);
                this.moveB.setEnabled(true);
            }
        }
    }

    private void initialize() {
        this.setSize(397, 336);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSplitPane(), "Center");
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setOrientation(0);
            this.splitPane.setContinuousLayout(false);
            this.splitPane.setResizeWeight(0.9);
            this.splitPane.setTopComponent(this.getJPanel());
            this.splitPane.setBottomComponent(this.getPopupSP());
            this.splitPane.setDividerLocation(200);
        }
        return this.splitPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jPanel.add((Component)this.getRightToolbar(), "East");
            this.jPanel.add((Component)this.getBottomToolbar(), "South");
            this.jPanel.add((Component)this.getTitlePanel(), "North");
            this.jPanel.add((Component)this.getListCardPanel(), "Center");
        }
        return this.jPanel;
    }

    private JScrollPane getPopupSP() {
        if (this.popupSP == null) {
            this.popupSP = new JScrollPane();
            this.popupSP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Information and References", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)), BorderFactory.createLineBorder(Color.black, 1)));
            this.popupSP.setToolTipText("Put references here. The next in this box appears in the Settings when the column is selected, as well as in the popup for the column's title.");
            this.popupSP.setViewportView(this.getPopupEP());
        }
        return this.popupSP;
    }

    private JEditorPane getPopupEP() {
        if (this.popupEP == null) {
            this.popupEP = new JEditorPane();
            this.popupEP.setToolTipText("Put references here. The next in this box appears in the Settings when the column is selected, as well as in the popup for the column's title.");
            this.popupEP.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    MetaColumnEditor.this.col.popup = DataEditor.convertRichTextFromEditing((String)MetaColumnEditor.this.popupEP.getText());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            if (this.col.popup != null) {
                this.popupEP.setText(DataEditor.convertRichTextForEditing((String)this.col.popup));
            }
        }
        return this.popupEP;
    }

    private JToolBar getRightToolbar() {
        if (this.rightToolbar == null) {
            this.rightToolbar = new JToolBar();
            this.rightToolbar.setOrientation(1);
            this.rightToolbar.setFloatable(false);
            this.rightToolbar.add(this.getMoveUp());
            this.rightToolbar.add(this.getMoveDown());
            this.rightToolbar.addSeparator();
            this.rightToolbar.add(this.getDeleteB());
            this.rightToolbar.addSeparator();
            this.rightToolbar.add(this.getMoveB());
        }
        return this.rightToolbar;
    }

    private JToolBar getBottomToolbar() {
        if (this.bottomToolbar == null) {
            this.bottomToolbar = new JToolBar();
            this.bottomToolbar.setFloatable(false);
            this.bottomToolbar.setBorder(null);
            this.bottomToolbar.add(this.getColTypeCB());
            this.bottomToolbar.add(Box.createHorizontalStrut(5));
            this.bottomToolbar.add(this.getCreateB());
        }
        return this.bottomToolbar;
    }

    private JButton getMoveUp() {
        if (this.moveUp == null) {
            this.moveUp = new JButton();
            this.moveUp.setIcon(FileUtils.getImageIcon(ResPath.getPath("gui.arrow_up")));
            this.moveUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] sel = MetaColumnEditor.this.colList.getSelectedIndices();
                    if (sel.length == 0 || sel[0] == 0) {
                        return;
                    }
                    for (int i = 0; i < sel.length; ++i) {
                        MetaColumnEditor.this.col.moveColumn(MetaColumnEditor.this.col.getColumnByIndex(sel[i]), -1);
                    }
                    MetaColumnEditor.this.nodeStructureChanged(MetaColumnEditor.this.col);
                }
            });
        }
        return this.moveUp;
    }

    private JButton getCreateB() {
        if (this.createB == null) {
            this.createB = new JButton();
            this.createB.setText("Create");
            this.createB.setToolTipText("Create a new column of the selected type and add it to this group.");
            this.createB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String sel = MetaColumnEditor.this.colTypeCB.getSelectedItem().toString();
                    if (sel.compareToIgnoreCase("Age") == 0) {
                        MetaColumnEditor.this.col.addColumn(new RulerColumn(" ", true));
                    } else if (sel.compareToIgnoreCase("Blank") == 0) {
                        MetaColumnEditor.this.col.addColumn(new DataColumn(MetaColumnEditor.this.col.getNewColumnName("Blank")));
                    } else if (sel.compareToIgnoreCase("Block") == 0) {
                        MetaColumnEditor.this.col.addColumn(new ZoneColumn(MetaColumnEditor.this.col.getNewColumnName("Block")));
                    } else if (sel.compareToIgnoreCase("Chron") == 0) {
                        BlockSeriesMetaColumn newCol = new BlockSeriesMetaColumn(MetaColumnEditor.this.col.getNewColumnName("Chron"), 1, 2);
                        newCol.createChronAndZoneColumns();
                        MetaColumnEditor.this.col.addColumn(newCol);
                    } else if (sel.compareToIgnoreCase("Event") == 0) {
                        MetaColumnEditor.this.col.addColumn(new EventColumn(MetaColumnEditor.this.col.getNewColumnName("Event")));
                    } else if (sel.compareToIgnoreCase("Facies") == 0) {
                        BlockSeriesMetaColumn newCol = new BlockSeriesMetaColumn(MetaColumnEditor.this.col.getNewColumnName("Facies"), 2, 2);
                        newCol.createChronAndZoneColumns();
                        MetaColumnEditor.this.col.addColumn(newCol);
                    } else if (sel.compareToIgnoreCase("Freehand") == 0) {
                        MetaColumnEditor.this.col.addColumn(new FreehandColumn(MetaColumnEditor.this.col.getNewColumnName("Freehand")));
                    } else if (sel.compareToIgnoreCase("Meta (grouping)") == 0) {
                        MetaColumnEditor.this.col.addColumn(new MetaColumn(MetaColumnEditor.this.col.getNewColumnName("group")));
                    } else if (sel.compareToIgnoreCase("Point (graph)") == 0) {
                        MetaColumnEditor.this.col.addColumn(new PointColumn(MetaColumnEditor.this.col.getNewColumnName("Point")));
                    } else if (sel.compareToIgnoreCase("Range") == 0) {
                        MetaColumnEditor.this.col.addColumn(new RangeColumn(MetaColumnEditor.this.col.getNewColumnName("Range")));
                    } else if (sel.compareToIgnoreCase("Sequence") == 0) {
                        MetaColumnEditor.this.col.addColumn(new SequenceColumn(MetaColumnEditor.this.col.getNewColumnName("Sequence"), 1));
                    } else if (sel.compareToIgnoreCase("Trend") == 0) {
                        MetaColumnEditor.this.col.addColumn(new SequenceColumn(MetaColumnEditor.this.col.getNewColumnName("Trend"), 2));
                    }
                    MetaColumnEditor.this.nodeStructureChanged(MetaColumnEditor.this.col);
                    MetaColumnEditor.this.colList.ensureIndexIsVisible(MetaColumnEditor.this.col.getSubColumnCount() - 1);
                }
            });
        }
        return this.createB;
    }

    private JComboBox getColTypeCB() {
        if (this.colTypeCB == null) {
            this.colTypeCB = new JComboBox();
            this.colTypeCB.setToolTipText("A list of all available column types.");
            this.colTypeCB.setMaximumRowCount(newColStrings.length);
            for (int i = 0; i < newColStrings.length; ++i) {
                this.colTypeCB.addItem(newColStrings[i]);
            }
        }
        return this.colTypeCB;
    }

    private JButton getMoveDown() {
        if (this.moveDown == null) {
            this.moveDown = new JButton();
            this.moveDown.setIcon(FileUtils.getImageIcon(ResPath.getPath("gui.arrow_down")));
            this.moveDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] sel = MetaColumnEditor.this.colList.getSelectedIndices();
                    if (sel.length == 0 || sel[sel.length - 1] == MetaColumnEditor.this.col.getSubColumnCount() - 1) {
                        return;
                    }
                    for (int i = sel.length - 1; i >= 0; --i) {
                        MetaColumnEditor.this.col.moveColumn(MetaColumnEditor.this.col.getColumnByIndex(sel[i]), 1);
                    }
                    MetaColumnEditor.this.nodeStructureChanged(MetaColumnEditor.this.col);
                }
            });
        }
        return this.moveDown;
    }

    private JButton getDeleteB() {
        if (this.deleteB == null) {
            this.deleteB = new JButton();
            this.deleteB.setText("Delete");
            this.deleteB.setToolTipText("Delete the selected column.");
            this.deleteB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] sel = MetaColumnEditor.this.colList.getSelectedIndices();
                    Object[] options = new String[]{"Delete", "Cancel"};
                    int chosen = JOptionPane.showOptionDialog(MetaColumnEditor.this, "Are you sure you want to delete " + (sel.length == 1 ? "this column?" : "these " + sel.length + " columns?"), "Confirm Column Delete", 0, 3, null, options, options[0]);
                    if (chosen == 0) {
                        for (int i = sel.length - 1; i >= 0; --i) {
                            MetaColumnEditor.this.col.removeColumn(sel[i]);
                        }
                        MetaColumnEditor.this.nodeStructureChanged(MetaColumnEditor.this.col);
                    }
                }
            });
        }
        return this.deleteB;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setText("Title: ");
            this.titlePanel = new JPanel();
            this.titlePanel.setLayout(new BoxLayout(this.getTitlePanel(), 0));
            this.titlePanel.add((Component)this.titleLabel, null);
            this.titlePanel.add((Component)this.getTitleTF(), null);
            this.titlePanel.add((Component)this.getShowTitleCB(), null);
        }
        return this.titlePanel;
    }

    private JTextField getTitleTF() {
        if (this.titleTF == null) {
            this.titleTF = new ModifyTextField(true, true);
            this.titleTF.setToolTipText("Title of this group column.");
            this.titleTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaColumnEditor.this.col.setName(MetaColumnEditor.this.titleTF.getText());
                    MetaColumnEditor.this.nodeChanged(MetaColumnEditor.this.col);
                }
            });
        }
        return this.titleTF;
    }

    private JCheckBox getShowTitleCB() {
        if (this.showTitleCB == null) {
            this.showTitleCB = new JCheckBox();
            this.showTitleCB.setText("Show Title");
            this.showTitleCB.setToolTipText("Determines whether the group column's title should be drawn on the chart. It is always visible in the Settings as well as the editor.");
            this.showTitleCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MetaColumnEditor.this.col.drawTitle = MetaColumnEditor.this.showTitleCB.isSelected();
                }
            });
        }
        return this.showTitleCB;
    }

    private JButton getMoveB() {
        if (this.moveB == null) {
            this.moveB = new JButton();
            this.moveB.setText("Move");
            this.moveB.setToolTipText("Move the selected column to another group.");
            this.moveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaColumnEditor.this.setMovingMode(true);
                }
            });
        }
        return this.moveB;
    }

    private JScrollPane getColListSP() {
        if (this.colListSP == null) {
            this.colListSP = new JScrollPane();
            this.colListSP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.black, 1)));
            this.colListSP.setName("colListSP");
            this.colListSP.setViewportView(this.getColList());
        }
        return this.colListSP;
    }

    private JList getColList() {
        if (this.colList == null) {
            this.colList = new JList(this.col.getSubColumnListModel());
            this.colList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    MetaColumnEditor.this.doEnablings();
                }
            });
        }
        return this.colList;
    }

    private JPanel getListCardPanel() {
        if (this.listCardPanel == null) {
            this.listCardPanel = new JPanel();
            this.listCardPanel.setLayout(new CardLayout());
            this.listCardPanel.add((Component)this.getMovingPanel(), this.getMovingPanel().getName());
            this.listCardPanel.add((Component)this.getColListSP(), this.getColListSP().getName());
        }
        return this.listCardPanel;
    }

    private JPanel getMovingPanel() {
        if (this.movingPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.ipady = 0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            this.movingLabel = new JLabel();
            this.movingLabel.setText("Select column to move to in the tree to the left.");
            this.movingPanel = new JPanel();
            this.movingPanel.setLayout(new GridBagLayout());
            this.movingPanel.setName("movingPanel");
            this.movingPanel.setName("movingPanel");
            this.movingPanel.add((Component)this.movingLabel, gridBagConstraints);
            this.movingPanel.add((Component)this.getCancelMove(), gridBagConstraints1);
        }
        return this.movingPanel;
    }

    private JButton getCancelMove() {
        if (this.cancelMove == null) {
            this.cancelMove = new JButton();
            this.cancelMove.setText("Cancel Move");
            this.cancelMove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaColumnEditor.this.setMovingMode(false);
                }
            });
        }
        return this.cancelMove;
    }
}

