/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.text.NumberFormat;

public class NumberUtils {
    public static final double EQUAL_MARGIN = 1.0E-6;

    public static boolean isEqual(double left, double right) {
        double result = left - right;
        return result == 0.0 || result > 0.0 && result < 1.0E-6 || result < 0.0 && result > -1.0E-6;
    }

    public static boolean doRangesOverlapErrYes(double a1, double a2, double b1, double b2, boolean negate) {
        double temp;
        if (negate) {
            a1 = -a1;
            a2 = -a2;
        }
        if (a2 < a1) {
            temp = a2;
            a2 = a1;
            a1 = temp;
        }
        if (b2 < b1) {
            temp = b2;
            b2 = b1;
            b1 = temp;
        }
        return a2 + 1.0E-6 > b1 && b2 + 1.0E-6 > a1;
    }

    public static boolean doRangesOverlapErrNo(double min, double max, double top, double base, boolean negate) {
        double temp;
        if (max < min) {
            temp = max;
            max = min;
            min = temp;
        }
        if (base < top) {
            temp = base;
            base = top;
            top = temp;
        }
        return max - 1.0E-6 > top && base - 1.0E-6 > min;
    }

    public static boolean isMultiple(double num, double factor) {
        double quotient = num / factor;
        double i = Math.round(quotient);
        return NumberUtils.isEqual(quotient, i);
    }

    public static String formatDouble(double d) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(0);
        return nf.format(d);
    }
}

