/*
 * Decompiled with CFR 0.152.
 */
package util;

import datastore.DataColumn;
import gui.TSCreator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import path.DatapackPath;
import util.Debug;
import util.JavaVMOptions;
import util.ProgramInfo;

public class FileUtils {
    public static String getExtension(URL url) {
        return FileUtils.getExtension(url.toString());
    }

    public static String getName(URL url) {
        return FileUtils.getExtension(url.toString());
    }

    public static String getExtension(String filename) {
        File f = new File(filename);
        int dot = (filename = f.getName()).lastIndexOf(46);
        if (dot < 0) {
            return null;
        }
        return filename.substring(dot + 1);
    }

    public static String getName(String filename) {
        File f = new File(filename);
        filename = f.getName();
        return filename;
    }

    public static String appendExtension(String path, String ext) {
        if (path.regionMatches(true, path.length() - ext.length() - 1, "." + ext, 0, ext.length())) {
            return path;
        }
        return path + "." + ext;
    }

    public static String getDirname(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        return f.getParent();
    }

    public static ImageIcon getImageIcon(String filename) {
        if (filename == null) {
            return null;
        }
        return new ImageIcon(FileUtils.getURL(filename));
    }

    protected static String getAbsoluteImageFilename_File(String filename, DataColumn.FileInfo fileInfo) {
        if (fileInfo == null || fileInfo.workingDir == null) {
            return null;
        }
        String workingDir = fileInfo.workingDir;
        File fn = new File(workingDir + filename);
        if (fn.isFile()) {
            return fn.getAbsolutePath();
        }
        fn = new File(workingDir + System.getProperty("file.separator") + filename);
        if (fn.isFile()) {
            return fn.getAbsolutePath();
        }
        return null;
    }

    protected static URL getAbsoluteImageURL_Builtin(String filename) {
        String path;
        if (filename.startsWith("$TSC/")) {
            filename = filename.substring(5);
        }
        if (FileUtils.getExtension(path = DatapackPath.resolveImageSetFilepath(filename)) == null) {
            StringTokenizer exts = new StringTokenizer("svg,png,jpg", ",");
            while (exts.hasMoreTokens()) {
                String ext = exts.nextToken();
                String tryPath = FileUtils.appendExtension(path, ext);
                try {
                    URL url = FileUtils.getURL(tryPath);
                    if (url == null) continue;
                    InputStream is = url.openStream();
                    is.close();
                    return url;
                }
                catch (Exception exception) {
                }
            }
        } else {
            try {
                URL url = FileUtils.getURL(path);
                if (url != null) {
                    InputStream is = url.openStream();
                    is.close();
                    return url;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static URL getAbsoluteImageURL(String filename, DataColumn.FileInfo fileInfo) {
        String path = null;
        try {
            URL url = new URL(filename);
            return url;
        }
        catch (MalformedURLException url) {
            URL url2;
            if (fileInfo.baseURL != null) {
                path = fileInfo.baseURL.toString() + filename;
                try {
                    URL url3 = new URL(path);
                    InputStream is = url3.openStream();
                    is.close();
                    return url3;
                }
                catch (Exception url3) {
                    // empty catch block
                }
            }
            if ((url2 = FileUtils.getAbsoluteImageURL_Builtin(filename)) != null) {
                return url2;
            }
            Debug.critical("Unable to find image URL '" + filename + "' from the datapack. baseURL=" + fileInfo.baseURL);
            return null;
        }
    }

    public static URL getURL(String filename) {
        if (JavaVMOptions.isJar()) {
            URL url = FileUtils.class.getResource("/" + filename);
            if (url == null) {
                return FileUtils.getURLExternOnly(filename);
            }
            return url;
        }
        return FileUtils.getURLExternOnly(filename);
    }

    public static boolean isURL(String s) {
        try {
            URL url = new URL(s);
            return true;
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public static URL getURLExternOnly(String filename) {
        try {
            URL url = new URL(filename);
            return url;
        }
        catch (MalformedURLException url) {
            try {
                return new URL("file:" + filename);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static InputStream getInputStream(String filename) {
        InputStream in = null;
        if (JavaVMOptions.isJar() && (in = TSCreator.class.getResourceAsStream("/" + filename)) != null) {
            return in;
        }
        try {
            in = new FileInputStream(filename);
        }
        catch (FileNotFoundException fnfe) {
            try {
                URL url = new URL(filename);
                return url.openStream();
            }
            catch (Exception e) {
                return null;
            }
        }
        return in;
    }

    public static InputStream getInputStream(String filename, boolean resource) throws Exception {
        InputStream in;
        if (resource) {
            in = FileUtils.getInputStream(filename);
            if (in == null) {
                throw new Exception("failed to open resource!");
            }
        } else {
            try {
                in = new FileInputStream(filename);
            }
            catch (Exception e) {
                try {
                    URL url = new URL(filename);
                    return url.openStream();
                }
                catch (Exception e2) {
                    throw new Exception("open file failed:\n" + e.toString());
                }
            }
        }
        return in;
    }

    public static File lookForFileInDirectory(File dir, String filename) {
        if (!dir.isDirectory()) {
            return null;
        }
        LFFIDFileFilter fileFilter = new LFFIDFileFilter(filename);
        File[] files = dir.listFiles(fileFilter);
        if (files != null && files.length >= 1) {
            return files[0];
        }
        files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File ret;
            if (!files[i].isDirectory() || (ret = FileUtils.lookForFileInDirectory(files[i], filename)) == null) continue;
            return ret;
        }
        return null;
    }

    public static boolean containsFile(ZipFile zip, String filename) {
        Enumeration<? extends ZipEntry> enum1 = zip.entries();
        while (enum1.hasMoreElements()) {
            ZipEntry entry = enum1.nextElement();
            String name = entry.getName();
            if (!name.equals(filename) && !name.endsWith(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesFileExist(String filename) {
        try {
            InputStream is = FileUtils.getInputStream(filename, true);
            is.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String readWholeTextFile(InputStream in) {
        String s = "";
        try {
            InputStreamReader r = new InputStreamReader(in);
            int size = in.available();
            if (size < 1000) {
                size = 1000;
            }
            char[] chars = new char[size];
            int numRead = 0;
            while (numRead != -1 && (numRead = ((Reader)r).read(chars, 0, size)) != -1) {
                String part = String.copyValueOf(chars, 0, numRead);
                s = s + part;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    public static File createTempDir() {
        File temp;
        try {
            temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        }
        catch (IOException e) {
            return null;
        }
        if (!temp.delete()) {
            return null;
        }
        if (!temp.mkdir()) {
            return null;
        }
        temp.deleteOnExit();
        return temp;
    }

    public String ExportResource(String resourceName, String path) throws Exception {
        String jarFolder;
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            String jarResourceName = ProgramInfo.get("TSC_BASE_SQLITE_DATABASE");
            stream = this.getClass().getResourceAsStream("/" + jarResourceName);
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + jarResourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            jarFolder = new File(FileUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath().replace('\\', '/');
            String outFilePath = null;
            outFilePath = path != null ? path : jarFolder + resourceName;
            resStreamOut = new FileOutputStream(outFilePath);
            while ((readBytes = stream.read(buffer)) > 0) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (resStreamOut != null) {
                resStreamOut.close();
            }
        }
        return jarFolder + resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    private static class LFFIDFileFilter
    implements FileFilter {
        public String filename;

        public LFFIDFileFilter(String f) {
            this.filename = f;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().compareToIgnoreCase(this.filename) == 0;
        }
    }
}

