/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.FocusManager;
import org.apache.batik.bridge.svg12.DefaultXBLManager;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.DOMUIEvent;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.svg12.XBLEventSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class SVG12FocusManager
extends FocusManager {
    public SVG12FocusManager(Document document) {
        super(document);
    }

    protected void addEventListeners(Document document) {
        AbstractNode abstractNode = (AbstractNode)((Object)document);
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractNode.initializeEventSupport();
        this.mouseclickListener = new MouseClickTracker();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.mouseclickListener, true);
        this.mouseoverListener = new MouseOverTracker();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, true);
        this.mouseoutListener = new MouseOutTracker();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, true);
        this.domFocusInListener = new DOMFocusInTracker();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.domFocusInListener, true);
        this.domFocusOutListener = new FocusManager.DOMFocusOutTracker(this);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.domFocusOutListener, true);
    }

    protected void removeEventListeners(Document document) {
        AbstractNode abstractNode = (AbstractNode)((Object)document);
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractNode.getEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.mouseclickListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.domFocusInListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.domFocusOutListener, true);
    }

    protected void fireDOMFocusInEvent(EventTarget eventTarget, EventTarget eventTarget2) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        DOMUIEvent dOMUIEvent = (DOMUIEvent)documentEvent.createEvent("UIEvents");
        dOMUIEvent.initUIEventNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", true, false, null, 0);
        int n = DefaultXBLManager.computeBubbleLimit((Node)((Object)eventTarget2), (Node)((Object)eventTarget));
        dOMUIEvent.setBubbleLimit(n);
        eventTarget.dispatchEvent(dOMUIEvent);
    }

    protected void fireDOMFocusOutEvent(EventTarget eventTarget, EventTarget eventTarget2) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        DOMUIEvent dOMUIEvent = (DOMUIEvent)documentEvent.createEvent("UIEvents");
        dOMUIEvent.initUIEventNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", true, false, null, 0);
        int n = DefaultXBLManager.computeBubbleLimit((Node)((Object)eventTarget), (Node)((Object)eventTarget2));
        dOMUIEvent.setBubbleLimit(n);
        eventTarget.dispatchEvent(dOMUIEvent);
    }

    protected class MouseOutTracker
    extends FocusManager.MouseOutTracker {
        protected MouseOutTracker() {
            super(SVG12FocusManager.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }

    protected class MouseOverTracker
    extends FocusManager.MouseOverTracker {
        protected MouseOverTracker() {
            super(SVG12FocusManager.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }

    protected class DOMFocusInTracker
    extends FocusManager.DOMFocusInTracker {
        protected DOMFocusInTracker() {
            super(SVG12FocusManager.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }

    protected class MouseClickTracker
    extends FocusManager.MouseClickTracker {
        protected MouseClickTracker() {
            super(SVG12FocusManager.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }
}

