/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.TransectTextData;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class TransectTextDataStorage
extends DataStorage {
    public static void insert(TransectTextData data) {
        Query query = new Query("INSERT INTO #.transect_texts       (id, transect_columns_id, title, width_pos,        age_pos, width, spread, style, deleted)       VALUES (NULL, :transect_column_id, :title,         :width_pos, :age_pos, :width, :spread, :style, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("transect_column_id", data.getColumn().getIdentifier().getId());
        query.setString("title", data.getTitle());
        query.setDouble("width_pos", data.getWidthPos());
        query.setDouble("age_pos", data.getAgePos());
        query.setDouble("width", data.getWidth());
        query.setDouble("spread", data.getSpread());
        query.setString("style", data.getStyle());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(TransectTextData data) {
        Query query = new Query("UPDATE #.transect_texts       SET transect_columns_id = :transect_columns_id,         title = :title, width_pos = :width_pos,        age_pos = :age_pos, width = :width,         spread = :spread, style = :style       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("transect_column_id", data.getColumn().getIdentifier().getId());
        query.setString("title", data.getTitle());
        query.setDouble("width_pos", data.getWidthPos());
        query.setDouble("age_pos", data.getAgePos());
        query.setDouble("width", data.getWidth());
        query.setDouble("spread", data.getSpread());
        query.setString("style", data.getStyle());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT id, transect_columns_id, title,         width_pos, age_pos, width, spread, style,         deleted, last_modified, creation_date       FROM #.transect_texts       WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(TransectTextData col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.transect_texts as transecttext ON ( data.id = transecttext.data_id )       WHERE transecttext.transect_columns_id = :transect_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted         AND NOT transecttext.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("transect_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

