/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.storage.DatapackStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class Datapack {
    private ModelIdentifier identifier = null;
    private ModelIdentifier parentIdentifier = null;
    private Datapack parent = null;
    private String name = "";
    private double formatVersion = 0.0;
    private String date = "";
    private String ageUnits = "";
    private String defaultChronostrat = "";
    private String chartTitle = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public Datapack(String database) {
        this.setIdentifier(new ModelIdentifier(0, database, 27));
        this.setDeleted(false);
    }

    public Datapack(ModelIdentifier id, SourceResult result) {
        this.setIdentifier(id);
        this.setParentIdentifier(new ModelIdentifier(result.getInt("parent_id"), result.getString("database"), 27));
        this.setName(result.getString("name"));
        this.setFormatVersion(result.getDouble("format_version"));
        this.setDate(result.getString("date"));
        this.setAgeUnits(result.getString("age_units"));
        this.setDefaultChronostrat(result.getString("default_chronostrat"));
        this.setChartTitle(result.getString("chart_title"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creation_date"));
        this.setLastModified(result.getString("last_modified"));
    }

    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public void save() {
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            DatapackStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            DatapackStorage.update(this);
        }
    }

    public boolean hasParent() {
        return this.parent != null || this.parentIdentifier != null;
    }

    public Datapack getParent() {
        if (this.hasParent()) {
            this.parent = Factory.getByIdentifier(this.parentIdentifier);
        }
        return this.parent;
    }

    public void setParent(Datapack parent) {
        this.parentIdentifier = parent.getIdentifier();
        this.parent = parent;
    }

    private void setParentIdentifier(ModelIdentifier parentIdentifier) {
        this.parentIdentifier = parentIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public final void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String getAgeUnits() {
        return this.ageUnits;
    }

    public final void setAgeUnits(String ageUnits) {
        this.ageUnits = ageUnits;
    }

    public String getDate() {
        return this.date;
    }

    public final void setDate(String date) {
        this.date = date;
    }

    public String getDefaultChronostrat() {
        return this.defaultChronostrat;
    }

    public final void setDefaultChronostrat(String defaultChronostrat) {
        this.defaultChronostrat = defaultChronostrat;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public final void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public static class Factory {
        public static List<Datapack> getByName(String title) {
            List<SourceResult> results = DatapackStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 27);
            return Factory.getByIdentifiers(ids);
        }

        public static Datapack getByIdentifier(ModelIdentifier id) {
            List<Object> datapacks = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            datapacks = Factory.getByIdentifiers(ids);
            if (datapacks.isEmpty()) {
                return null;
            }
            return (Datapack)datapacks.get(0);
        }

        public static List<Datapack> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<Datapack> datapacks = new ArrayList<Datapack>();
            List<SourceResult> results = DatapackStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                datapacks.add(new Datapack(ids.get(i), results.get(i)));
            }
            return datapacks;
        }
    }
}

