/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import datastore.DataColumn;
import gui.tree.DataColumnTreeNode;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import util.HTMLPreprocessor;
import util.Util;

public class DataColumnTreePanel
extends JPanel
implements ActionListener {
    public JCheckBox checkbox;
    JLabel label;
    Color foregroundColor;
    DataColumnTreeNode tree_node;
    DataColumn col;
    private boolean ignoreCheck = false;

    public DataColumnTreePanel() {
        this.setLayout(new FlowLayout());
        this.checkbox = new JCheckBox();
        this.checkbox.addActionListener(this);
        this.add(this.checkbox);
        this.label = new JLabel("title");
        this.add(this.label);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.checkbox.setBorder(BorderFactory.createEmptyBorder());
        this.label.setBorder(BorderFactory.createEmptyBorder());
        this.doLayout();
    }

    protected String getColNameFixedHTML() {
        String name = this.col.name;
        if (this.col.fileInfo != null) {
            name = HTMLPreprocessor.findAndFixDatapackLinks(name, this.col.fileInfo);
        }
        return name;
    }

    @Override
    public void setForeground(Color foreground) {
        this.foregroundColor = foreground;
        if (this.col != null) {
            String text = "<html>";
            text = this.col.grayedOut ? text + "<font size=\"-6\" color=\"red\">(NO DATA IN TIME INTERVAL)</font> <i><font color=\"#" + Util.colorToHex(this.foregroundColor) + "\">" + this.getColNameFixedHTML() + "</font></i>" : text + "<font color=\"#" + Util.colorToHex(this.foregroundColor) + "\">" + this.getColNameFixedHTML() + "</font>";
            text = text + "</html>";
            this.label.setText(text);
            this.doLayout();
        }
    }

    public void setChecked(boolean c) {
        this.ignoreCheck = true;
        this.checkbox.setSelected(c);
        this.ignoreCheck = false;
    }

    public void setToColumn(DataColumn col) {
        this.col = col;
        this.checkbox.setSelected(col.isSelected());
        if (col.grayedOut) {
            this.label.setText("<html><font size=\"-6\" color=\"red\">(NO DATA IN TIME INTERVAL)</font> <i><font color=\"#" + Util.colorToHex(this.foregroundColor) + "\">" + this.getColNameFixedHTML() + "</font></i></html>");
        } else {
            this.label.setText("<html><font color=\"#" + Util.colorToHex(this.foregroundColor) + "\">" + this.getColNameFixedHTML() + "</font></html>");
        }
        this.doLayout();
    }

    public boolean willThisCheck(Point p) {
        Rectangle bounds = this.checkbox.getBounds();
        return bounds.contains(p);
    }

    public void checkboxClick() {
        this.checkbox.doClick();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.checkbox) {
            if (this.ignoreCheck) {
                return;
            }
            this.col.setSelected(this.checkbox.isSelected());
            if (this.checkbox.isSelected()) {
                TreeNode node = this.tree_node;
                while ((node = node.getParent()) != null) {
                    if (!(node instanceof DataColumnTreeNode)) continue;
                    TreeNode casted_node = node;
                    if (casted_node.panel.checkbox.isSelected()) continue;
                    casted_node.panel.checkbox.doClick();
                }
            }
        }
    }

    public void setNode(DataColumnTreeNode node) {
        this.tree_node = node;
    }
}

