/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import gui.TSCAction;
import gui.editor.SpreadSheetBar;
import gui.editor.SpreadSheetTableModel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SpreadSheet
extends JTable
implements MouseListener {
    private static final long serialVersionUID = 1L;
    SpreadSheetTableModel dm;
    SpreadSheetBar bar = null;
    boolean contextMenuInsertRemove = false;
    TSCAction[] extraMenuActions = null;
    public ActionListener rowInsertRemoveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            SpreadSheet table = SpreadSheet.this;
            if (ae.getActionCommand().startsWith("Insert")) {
                String error = SpreadSheet.this.dm.addRows(table.getSelectedRowCount(), table.getSelectedRows()[0]);
                if (error != null) {
                    JOptionPane.showMessageDialog(table, "<html>" + error + "</html>", "Error inserting rows", 0);
                }
            } else if (ae.getActionCommand().startsWith("Remove") && table.getSelectedRowCount() > 0) {
                int[] selRows = table.getSelectedRows();
                String error = SpreadSheet.this.dm.removeRows(selRows);
                if (error != null) {
                    JOptionPane.showMessageDialog(table, "<html>" + error + "</html>", "Error removing rows", 0);
                }
                if (SpreadSheet.this.bar != null) {
                    SpreadSheet.this.bar.setValue(SpreadSheet.this, SpreadSheet.this.dm, SpreadSheet.this.getWorkingCellRow(), SpreadSheet.this.getWorkingCellColumn());
                }
            }
        }
    };

    public SpreadSheet(SpreadSheetTableModel dataModel) {
        if (dataModel == null) {
            dataModel = new SpreadSheetTableModel();
        }
        this.dm = dataModel;
        this.setModel(this.dm);
        this.setCellSelectionEnabled(true);
        this.autoResizeMode = 0;
        this.addMouseListener(this);
        this.configureEnclosingScrollPane();
        this.getSelectionModel().setSelectionInterval(0, 0);
        this.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
    }

    public void setDataModel(SpreadSheetTableModel dataModel) {
        this.dm = dataModel;
        this.setModel(this.dm);
    }

    public void setSpreadSheetBar(SpreadSheetBar bar) {
        this.bar = bar;
        bar.setValue(this, this.dm, this.getWorkingCellRow(), this.getWorkingCellColumn());
    }

    @Override
    public void changeSelection(int row, int col, boolean toggle, boolean extend) {
        if (!extend) {
            this.setBarCell(row, col);
        }
        super.changeSelection(row, col, false, extend);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer rend = null;
        if (rend == null) {
            return super.getCellRenderer(row, column);
        }
        return rend;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return SpreadSheet.this.dm.getColumnToolTip(realIndex);
            }
        };
    }

    public void setBarCell(int row, int col) {
        if (this.bar == null) {
            return;
        }
        this.bar.setValue(this, this.dm, row, col);
    }

    public int getWorkingCellRow() {
        int[] selRows = this.getSelectedRows();
        if (selRows != null && selRows.length != 0) {
            return selRows[0];
        }
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getWorkingCellColumn() {
        int[] selCols = this.getSelectedColumns();
        if (selCols != null && selCols.length != 0) {
            return selCols[0];
        }
        return this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
    }

    public void enableRowInsertRemove() {
        this.contextMenuInsertRemove = true;
    }

    public void setExtraMenuActions(TSCAction[] actions2) {
        this.extraMenuActions = actions2;
    }

    public void toClipboard(boolean copyOnly) {
        int[] selRows = this.getSelectedRows();
        int[] selCols = this.getSelectedColumns();
        String copyString = "";
        String newline = "\n";
        for (int rowCount = 0; rowCount < selRows.length; ++rowCount) {
            if (rowCount != 0) {
                copyString = copyString + newline;
            }
            for (int colCount = 0; colCount < selCols.length; ++colCount) {
                Object value;
                if (colCount != 0) {
                    copyString = copyString + '\t';
                }
                if ((value = this.dm.getValueAt(selRows[rowCount], selCols[colCount])) != null) {
                    copyString = copyString + value.toString();
                }
                if (copyOnly) continue;
                this.dm.setValueAt(null, selRows[rowCount], selCols[colCount]);
            }
        }
        StringSelection ss = new StringSelection(copyString);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public void setCells(Object[][] values, int startRow, int startCol) {
        if (values == null || startRow < 0 || startCol < 0) {
            return;
        }
        for (int row = 0; row < values.length; ++row) {
            Object[] column = values[row];
            for (int col = 0; col < column.length; ++col) {
                this.dm.setValueAt(values[row][col], startRow + row, startCol + col);
            }
        }
    }

    public static Object[][] stringToCells(String s) {
        if (s == null) {
            return null;
        }
        Object[][] values = null;
        int maxCols = 0;
        Vector<String[]> rows = new Vector<String[]>();
        s = s.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        StringTokenizer rowTokenizer = new StringTokenizer(s, "\n");
        while (rowTokenizer.hasMoreTokens()) {
            String row = rowTokenizer.nextToken();
            if (row.length() == 0) continue;
            StringTokenizer columnTokenizer = new StringTokenizer(row, "\t", true);
            int lastUsedIndex = -1;
            String[] scratch = new String[columnTokenizer.countTokens()];
            int i = 0;
            while (columnTokenizer.hasMoreTokens()) {
                String token = columnTokenizer.nextToken();
                if (token.compareTo("\t") == 0) {
                    ++i;
                    continue;
                }
                scratch[i] = token;
                lastUsedIndex = i;
            }
            int colNum = lastUsedIndex + 1;
            if (maxCols < colNum) {
                maxCols = colNum;
            }
            String[] rowValues = new String[colNum];
            for (i = 0; i <= lastUsedIndex; ++i) {
                rowValues[i] = scratch[i];
            }
            rows.add(rowValues);
        }
        values = new Object[rows.size()][maxCols];
        for (int i = 0; i < rows.size(); ++i) {
            String[] rowValues = (String[])rows.get(i);
            for (int j = 0; j < maxCols; ++j) {
                values[i][j] = j >= rowValues.length ? null : rowValues[j];
            }
        }
        return values;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        int col;
        int row = this.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (!this.isCellSelected(row, col = this.columnAtPoint(new Point(evt.getX(), evt.getY())))) {
            this.clearSelection();
            this.changeSelection(row, col, false, false);
        }
        if (evt.isPopupTrigger()) {
            JPopupMenu menu = new JPopupMenu();
            if (this.contextMenuInsertRemove) {
                int selRowCount = this.getSelectedRowCount();
                JMenuItem item = new JMenuItem("Insert " + selRowCount + (selRowCount == 1 ? " row" : " rows") + " here");
                item.addActionListener(this.rowInsertRemoveListener);
                menu.add(item);
                item = new JMenuItem("Remove selected " + (selRowCount == 1 ? "row" : "rows"));
                item.addActionListener(this.rowInsertRemoveListener);
                menu.add(item);
                if (this.extraMenuActions != null) {
                    menu.addSeparator();
                }
            }
            if (this.extraMenuActions != null) {
                for (int i = 0; i < this.extraMenuActions.length; ++i) {
                    if (this.extraMenuActions[i] == null) {
                        menu.addSeparator();
                        continue;
                    }
                    menu.add(this.extraMenuActions[i]);
                }
            }
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

