/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.editor.DataSeries;
import datastore.editor.DataSteward;
import datastore.loader.ParseException;
import gui.ImageGenerator;
import gui.Language;
import gui.LinkProcessor;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.datamining.RollApply;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import path.ResPath;
import util.FileUtils;
import util.NumberUtils;
import util.Util;

public class PointColumn
extends DataColumn {
    private static final long serialVersionUID = 1L;
    public final String frequencyColumnName = "Number of points per window";
    public final String minColumnName = "Minimum value per window";
    public final String maxColumnName = "Maximum value per window";
    public final String averageColumnName = "Average value per window";
    public final String rateOfChangeColumnName = "Rate of change";
    public final String overlayName = "Overlay";
    public final String regressionAnalysisName = "Regression Analysis";
    public boolean drawPoints = true;
    public int pointType = 1;
    public boolean drawLine = true;
    public Color lineColor = new Color(0, 0, 0);
    public boolean drawSmooth = true;
    public boolean drawFill = true;
    public boolean drawBgrndGradient = false;
    public boolean drawCurveGradient = false;
    public boolean enExtendedSettings = false;
    public boolean isFrameOpen;
    public Color fillColor = new Color(64, 233, 191);
    public int side = 2;
    public boolean doNotSetWindowAuto = false;
    public double minWindow = 0.0;
    public double maxWindow = 0.0;
    public double maxMag = Double.NEGATIVE_INFINITY;
    public double minMag = Double.POSITIVE_INFINITY;
    public boolean drawScale = true;
    public boolean drawRCScale = false;
    public boolean flipScale = false;
    public boolean checkInit = false;
    public double scaleStart = 0.0;
    public double initStep = 0.0;
    public double scaleStep = 1.0;
    public double windowSize = 2.0;
    public double stepSize = 1.0;
    private double prevMinMag;
    private double prevMaxMag;
    public static final double scaleTickLength = 5.0;
    public static final int RISE_LEFT = 1;
    public static final int RISE_RIGHT = 2;
    public static final double SCALE_DEFAULT_STEP_RATIO = 0.2;
    public static final String SCALE_TICK_STYLE = "stroke-width: 1; stroke: black; fill: none;";
    public static final double SCALE_TICK_LABEL_MARGIN = 1.0;
    public static final double SCALE_LABEL_TITLE_MARGIN = 2.0;
    public static final double SCALE_LABEL_TEXT_MARGIN = 2.0;
    public static final double MARGIN = 0.1;
    public static final String POINT_LINE_STYLE = "stroke-width: 1; fill: none;";
    public static final String DASHED_LINE_STYLE = "stroke-dasharray:7,4; opacity: 2; fill: none;";
    public static final String DOTTED_LINE_STYLE = "stroke-dasharray:2,2; opacity: 2; fill: none;";
    public String columnName;
    public Color backGradStart = new Color(0, 0, 0);
    public Color backGradEnd = new Color(255, 255, 255);
    public Color curveGradStart = new Color(0, 0, 0);
    public Color curveGradEnd = new Color(255, 255, 255);
    private boolean endRecursive = true;
    public double[] newX;
    public double[] newY;

    public PointColumn(String colName) {
        super(colName);
        this.iconPath = ResPath.getPath("icons.col_icon_point");
        this.setColor(new Coloring(Color.white));
    }

    public static double getMag(Datapoint p) {
        return (Double)p.value;
    }

    public void getPointColName() {
        this.columnName = super.getColName();
    }

    @Override
    public void addData(Datapoint dp) {
        super.addData(dp);
        if (dp != null) {
            double mag = PointColumn.getMag(dp);
            if (mag > this.maxMag) {
                this.maxMag = mag;
            }
            if (mag < this.minMag) {
                this.minMag = mag;
            }
            double margin = (this.maxMag - this.minMag) * 0.1;
            if (!this.doNotSetWindowAuto) {
                this.minWindow = this.minMag - margin / 2.0;
                this.maxWindow = this.maxMag + margin / 2.0;
            }
        }
    }

    @Override
    public void finalizeLoading() throws ParseException {
        if (this.overlayParent != null && this.overlayParent instanceof PointColumn) {
            PointColumn op = (PointColumn)this.overlayParent;
            op.maxWindow = Math.max(this.maxWindow, op.maxWindow);
            op.minWindow = Math.max(this.minWindow, op.minWindow);
            op.autoScale();
            return;
        }
        this.autoScale();
    }

    public Interval getMinMaxMag() {
        PointColumn col;
        double min = this.minMag;
        double max = this.maxMag;
        if (this.overlays != null) {
            for (Object o : this.overlays) {
                if (!(o instanceof PointColumn)) continue;
                col = (PointColumn)o;
                max = Math.max(max, col.maxMag);
                min = Math.min(min, col.minMag);
            }
        }
        if (this.underlays != null) {
            for (Object o : this.underlays) {
                if (!(o instanceof PointColumn)) continue;
                col = (PointColumn)o;
                max = Math.max(max, col.maxMag);
                min = Math.min(min, col.minMag);
            }
        }
        Interval ret = new Interval();
        ret.min = min;
        ret.max = max;
        return ret;
    }

    public void autoScale() {
        this.scaleStart = 0.0;
        this.autoScaleStep();
    }

    public void autoScaleStep() {
        this.scaleStep = (this.maxWindow - this.minWindow) * 0.2;
    }

    public double getXFromMag(double mag, double startx, double width) {
        double ret;
        double percent = (mag - this.minWindow) / (this.maxWindow - this.minWindow);
        if (this.side == 2) {
            percent = 1.0 - percent;
        }
        if ((ret = startx + width - width * percent) < startx) {
            return startx;
        }
        if (ret > startx + width) {
            return startx + width;
        }
        return ret;
    }

    public double getUnclippedXFromMag(double mag, double startx, double width) {
        double percent = (mag - this.minWindow) / (this.maxWindow - this.minWindow);
        if (this.side == 2) {
            percent = 1.0 - percent;
        }
        double ret = startx + width - width * percent;
        return ret;
    }

    public double getIntersectionMag(Datapoint top, Datapoint base, double cutAge) {
        double magBase;
        if (top == null || base == null) {
            return -1.0;
        }
        if (base.baseAge < top.baseAge) {
            Datapoint temp = top;
            top = base;
            base = temp;
        }
        if (top.baseAge > cutAge || base.baseAge < cutAge) {
            return -1.0;
        }
        double magTop = PointColumn.getMag(top);
        if (NumberUtils.isEqual(magTop, magBase = PointColumn.getMag(base))) {
            return magTop;
        }
        double slope = (magTop - magBase) / (top.baseAge - base.baseAge);
        double ret = magBase + (cutAge - base.baseAge) * slope;
        return ret;
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new PCOptionsPanel(this);
        }
        return this.optionsPanel;
    }

    public void readTextFieldsFromPanel() {
        PCOptionsPanel useOP;
        PCOptionsPanel op = (PCOptionsPanel)this.optionsPanel;
        PCOptionsPanel parentOP = null;
        if (this.overlayParent != null && this.overlayParent instanceof PointColumn) {
            parentOP = (PCOptionsPanel)this.overlayParent.optionsPanel;
        }
        PCOptionsPanel pCOptionsPanel = useOP = parentOP == null ? op : parentOP;
        if (useOP == null) {
            return;
        }
        String s = useOP.tfMinWin.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        try {
            this.minWindow = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.minWindow = this.minMag;
        }
        s = useOP.tfMaxWin.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        try {
            this.maxWindow = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.maxWindow = this.maxMag;
        }
        s = useOP.tfScaleStart.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        try {
            this.scaleStart = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.scaleStart = 0.0;
        }
        s = useOP.tfScaleStep.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        try {
            this.scaleStep = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.autoScaleStep();
        }
        s = useOP.windowSizeText.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        double prevWindowSize = this.windowSize;
        try {
            this.windowSize = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.windowSize = 2.0;
        }
        s = useOP.stepSizeText.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        double prevStepSize = this.stepSize;
        try {
            this.stepSize = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.stepSize = 2.0;
        }
        if (this.windowSize != prevWindowSize || this.stepSize != prevStepSize || this.extraColumnHeaderName != null && this.extraColumnHeaderName != this.prevExtraColumnHeaderName) {
            this.drawExtraColumn = true;
            this.prevExtraColumnHeaderName = this.extraColumnHeaderName;
        }
        useOP.readTextFieldsFromColumn();
    }

    @Override
    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        super.getHeaderHeight(settings, ig);
        if (this.drawScale) {
            StringWrappingInfo testLabelSWI = ig.getSWIOneLine("0123456789.", this.fonts.getFont(8), 1, this.fileInfo);
            double scaleTextHeight = testLabelSWI.getHeight();
            this.myOwnHeaderHeight += scaleTextHeight + 1.0 + 2.0 + 5.0;
        }
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    @Override
    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        this.readTextFieldsFromPanel();
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
        double scaleHeight = 0.0;
        if (this.drawScale) {
            StringWrappingInfo testLabelSWI = ig.getSWIOneLine("0123456789.", this.fonts.getFont(8), 1, this.fileInfo);
            double scaleTextHeight = testLabelSWI.getHeight();
            scaleHeight = scaleTextHeight + 1.0 + 2.0 + 5.0;
        }
        if (this.name.length() > 0 && this.drawTitle) {
            StringWrappingInfo myWrap = this.nameWrap;
            TSCFont myWrapHolder = this.fonts.getFont(0);
            double wrapSize = Math.floor(myWrapHolder.getSize());
            double myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
            double myThreshold = this.myWidth * 2.0;
            double wrapSize2 = wrapSize;
            String myString = this.name;
            String[] split = myString.split("(\\s)+");
            int myLength = 0;
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            Font font = new Font("Arial", 0, 14);
            int marker = 0;
            for (int x = 0; x < split.length; ++x) {
                int textwidth = (int)font.getStringBounds(split[x], frc).getWidth();
                if (textwidth <= myLength) continue;
                myLength = textwidth;
                marker = x;
            }
            if (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth()) {
                while (wrapSize > 6.0 && (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth())) {
                    myWrapHolder.setSize(wrapSize);
                    myWrap = ig.wrapString(this.name, this.myWidth, myWrapHolder, this.fileInfo);
                    myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
                    font = new Font("Arial", 0, (int)wrapSize);
                    myLength = (int)font.getStringBounds(split[marker], frc).getWidth();
                    wrapSize -= 1.0;
                }
            }
            ig.drawString(myWrap, startx, starty, width, height - scaleHeight - 5.0 * (double)(this.tickStack - 1), 3);
            wrapSize = wrapSize2;
            myWrapHolder.setSize(wrapSize);
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup, this.fileInfo);
            ig.drawRect(startx, starty, width, height - scaleHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
        if (this.checkInit) {
            this.scaleStep = this.initStep;
        }
        if (this.drawScale) {
            this.getPointColName();
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumFractionDigits(0);
            if (this.columnName != null && this.columnName.contains("Strontium")) {
                nf.setMaximumFractionDigits(4);
            }
            double lastLabelLeft = startx + width;
            double lastLabelRight = startx;
            double scaleX = 0.0;
            if (!this.flipScale) {
                for (scaleX = this.scaleStart > this.minWindow ? this.scaleStart - Math.floor((this.scaleStart - this.minWindow) / this.scaleStep) * this.scaleStep : this.scaleStart + Math.ceil((this.minWindow - this.scaleStart) / this.scaleStep) * this.scaleStep; scaleX < this.maxWindow; scaleX += this.scaleStep) {
                    double labelLeft;
                    if (this.tickStack == 1) {
                        ig.drawLine(this.getXFromMag(scaleX, startx, width), starty + height - 5.0 * (double)this.tickStack, this.getXFromMag(scaleX, startx, width), starty + height - 5.0 * (double)(this.tickStack - 1), SCALE_TICK_STYLE);
                    }
                    String label = nf.format(scaleX);
                    StringWrappingInfo labelSWI = ig.getSWIOneLine(label, this.fonts.getFont(8), 1, this.fileInfo);
                    double labelHeight = labelSWI.getHeight();
                    double labelWidth = labelSWI.getWidth();
                    if (this.side == 1) {
                        double labelRight;
                        if (lastLabelLeft < this.getXFromMag(scaleX, startx, width) || (labelRight = Math.min(lastLabelLeft - 2.0, this.getXFromMag(scaleX, startx, width) + labelWidth / 2.0)) - labelWidth < startx) continue;
                        ig.drawString(labelSWI, labelRight - labelWidth, starty + height - 5.0 * (double)this.tickStack - 1.0 - labelHeight, labelWidth, labelHeight, 2);
                        lastLabelLeft = labelRight - labelWidth;
                        continue;
                    }
                    if (lastLabelRight > this.getXFromMag(scaleX, startx, width) || (labelLeft = Math.max(lastLabelRight + 2.0, this.getXFromMag(scaleX, startx, width) - labelWidth / 2.0)) + labelWidth > startx + width) continue;
                    ig.drawString(labelSWI, labelLeft, starty + height - 5.0 * (double)this.tickStack - 1.0 - labelHeight, labelWidth, labelHeight, 2);
                    lastLabelRight = labelLeft + labelWidth;
                }
            } else {
                for (scaleX = this.scaleStart < this.minWindow ? this.scaleStart - Math.floor((this.scaleStart - this.minWindow) / this.scaleStep) * this.scaleStep : this.scaleStart + Math.ceil((this.minWindow - this.scaleStart) / this.scaleStep) * this.scaleStep; scaleX > this.maxWindow; scaleX -= this.scaleStep) {
                    double labelLeft;
                    ig.drawLine(this.getXFromMag(scaleX, startx, width), starty + height - 5.0 * (double)this.tickStack, this.getXFromMag(scaleX, startx, width), starty + height - 5.0 * (double)(this.tickStack - 1), SCALE_TICK_STYLE);
                    String label = nf.format(scaleX);
                    StringWrappingInfo labelSWI = ig.getSWIOneLine(label, this.fonts.getFont(8), 1, this.fileInfo);
                    double labelHeight = labelSWI.getHeight();
                    double labelWidth = labelSWI.getWidth();
                    if (this.side == 1) {
                        double labelRight;
                        if (lastLabelLeft < this.getXFromMag(scaleX, startx, width) || (labelRight = Math.min(lastLabelLeft - 2.0, this.getXFromMag(scaleX, startx, width) + labelWidth / 2.0)) - labelWidth < startx) continue;
                        ig.drawString(labelSWI, labelRight - labelWidth, starty + height - 5.0 * (double)this.tickStack - 1.0 - labelHeight, labelWidth, labelHeight, 2);
                        lastLabelLeft = labelRight - labelWidth;
                        continue;
                    }
                    if (lastLabelRight > this.getXFromMag(scaleX, startx, width) || (labelLeft = Math.max(lastLabelRight + 2.0, this.getXFromMag(scaleX, startx, width) - labelWidth / 2.0)) + labelWidth > startx + width) continue;
                    ig.drawString(labelSWI, labelLeft, starty + height - 5.0 * (double)this.tickStack - 1.0 - labelHeight, labelWidth, labelHeight, 2);
                    lastLabelRight = labelLeft + labelWidth;
                }
            }
        }
        if (this.drawMyOverlay) {
            this.drawHeaderOverlays(ig, startx, starty, width, height, settings);
        }
    }

    @Override
    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        super.grayOutIfEmpty(topAge, baseAge, en);
        SortedSet drawingData = this.getDrawingDataSet();
        Iterator iter = drawingData.iterator();
        Datapoint p = null;
        int count = 0;
        double myBase = 0.0;
        double curTop = topAge;
        double curBase = baseAge;
        if (this.isOutcrop) {
            if (curTop < curBase) {
                return this.grayedOut;
            }
            while (iter.hasNext()) {
                p = (Datapoint)iter.next();
                myBase = -p.baseAge;
                if (!(curBase <= myBase) || !(myBase <= curTop)) continue;
                ++count;
            }
        } else {
            while (iter.hasNext()) {
                p = (Datapoint)iter.next();
                myBase = p.baseAge;
                if (!(curTop <= myBase) || !(myBase <= curBase)) continue;
                ++count;
            }
        }
        if (count == 0) {
            this.NoDataInDataColumn = true;
            this.grayedOut = true;
        } else {
            this.NoDataInDataColumn = false;
            this.grayedOut = false;
        }
        return this.grayedOut;
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        boolean[] smoothNextB;
        double[] coordY;
        double[] coordX;
        super.drawData(ig, startx, starty, width, height, settings);
        this.readTextFieldsFromPanel();
        SortedSet drawingData = this.getDrawingDataSet();
        Iterator iter = drawingData.iterator();
        Datapoint p = null;
        Datapoint lastP = null;
        boolean setupTop = true;
        double prevY = 0.0;
        Vector<Double> x = new Vector<Double>();
        Vector<Double> y = new Vector<Double>();
        Vector<Boolean> lineTo = new Vector<Boolean>();
        Datapoint start = null;
        Datapoint oneAfterStart = null;
        Datapoint end = null;
        double minMag = Double.POSITIVE_INFINITY;
        while (iter.hasNext()) {
            p = (Datapoint)iter.next();
            if (settings.isAbove(p.baseAge)) {
                lastP = p;
                start = oneAfterStart;
                oneAfterStart = p;
                if (start == null) {
                    start = p;
                }
                minMag = Math.min(PointColumn.getMag(start), PointColumn.getMag(oneAfterStart));
                continue;
            }
            if (start == null) {
                start = p;
            }
            minMag = Math.min(minMag, PointColumn.getMag(p));
            if (settings.isBelow(p.baseAge)) break;
            lastP = p;
        }
        if (Double.isInfinite(minMag)) {
            minMag = this.minWindow;
        }
        if ((end = p) == null) {
            end = lastP;
        }
        if (iter.hasNext()) {
            end = (Datapoint)iter.next();
        }
        if (start == end) {
            return;
        }
        iter = drawingData.iterator();
        boolean reachedStart = false;
        while (iter.hasNext()) {
            p = (Datapoint)iter.next();
            if (!reachedStart && p != start) continue;
            reachedStart = true;
            if (setupTop) {
                if (this.side == 1) {
                    if (this.flipScale) {
                        x.add(new Double(Math.min(startx, this.getUnclippedXFromMag(minMag, startx, width))));
                    } else {
                        x.add(new Double(Math.max(startx + width, this.getUnclippedXFromMag(minMag, startx, width))));
                    }
                } else if (this.flipScale) {
                    x.add(new Double(Math.max(startx + width, this.getUnclippedXFromMag(minMag, startx, width))));
                } else {
                    x.add(new Double(Math.min(startx, this.getUnclippedXFromMag(minMag, startx, width))));
                }
                y.add(new Double(ImageGenerator.getYFromYear(p.baseAge, starty, settings)));
                lineTo.add(new Boolean(true));
                setupTop = false;
            }
            double mag = PointColumn.getMag(p);
            if (p.lineType == 5) {
                x.add(new Double(this.getUnclippedXFromMag(0.0, startx, width)));
                y.add(new Double(prevY));
            }
            lineTo.add(new Boolean(p == start));
            double curX = this.getUnclippedXFromMag(mag, startx, width);
            double curY = ImageGenerator.getYFromYear(p.baseAge, starty, settings);
            if (p.lineType == 5) {
                x.add(new Double(this.getUnclippedXFromMag(0.0, startx, width)));
                y.add(new Double(curY));
            }
            lineTo.add(new Boolean(p == start));
            x.add(new Double(curX));
            y.add(new Double(curY));
            prevY = curY;
            if (p == end) {
                lineTo.add(new Boolean(true));
                break;
            }
            if (p == start) {
                lineTo.add(new Boolean(true));
                continue;
            }
            lineTo.add(new Boolean(p == start));
        }
        if (this.side == 1) {
            if (this.flipScale) {
                x.add(new Double(Math.min(startx, this.getUnclippedXFromMag(minMag, startx, width))));
            } else {
                x.add(new Double(Math.max(startx + width, this.getUnclippedXFromMag(minMag, startx, width))));
            }
        } else if (this.flipScale) {
            x.add(new Double(Math.max(startx + width, this.getUnclippedXFromMag(minMag, startx, width))));
        } else {
            x.add(new Double(Math.min(startx, this.getUnclippedXFromMag(minMag, startx, width))));
        }
        y.add(new Double(ImageGenerator.getYFromYear(p.baseAge, starty, settings)));
        lineTo.add(new Boolean(true));
        if (this.drawBgrndGradient) {
            String bgf = ig.pushGradient();
            if (this.flipScale) {
                ig.setStop(0.0, "stop-color:" + Coloring.getStyleRGB(this.backGradEnd) + ";stop-opacity:1");
                ig.setStop(1.0, "stop-color:" + Coloring.getStyleRGB(this.backGradStart) + ";stop-opacity:1");
            } else {
                ig.setStop(0.0, "stop-color:" + Coloring.getStyleRGB(this.backGradStart) + ";stop-opacity:1");
                ig.setStop(1.0, "stop-color:" + Coloring.getStyleRGB(this.backGradEnd) + ";stop-opacity:1");
            }
            ig.popGradient();
            ig.drawRect(startx, starty, width, height, "stroke-width: 0; fill: url(#grad" + ImageGenerator.gradNum + ");");
        }
        if (this.drawCurveGradient) {
            String cgf = ig.pushGradient();
            if (this.flipScale) {
                ig.setStop(0.0, "stop-color:" + Coloring.getStyleRGB(this.curveGradEnd) + ";stop-opacity:1");
                ig.setStop(1.0, "stop-color:" + Coloring.getStyleRGB(this.curveGradStart) + ";stop-opacity:1");
            } else {
                ig.setStop(0.0, "stop-color:" + Coloring.getStyleRGB(this.curveGradStart) + ";stop-opacity:1");
                ig.setStop(1.0, "stop-color:" + Coloring.getStyleRGB(this.curveGradEnd) + ";stop-opacity:1");
            }
            ig.popGradient();
        }
        String cp = ig.pushClipPath();
        ig.drawRect(startx, starty, width, height, null);
        ig.popClipPath();
        ig.pushGrouping();
        ig.setClipPath(cp);
        if (this.fillColor == null) {
            this.fillColor = new Color(64, 233, 191);
        }
        if (this.drawFill) {
            coordX = Util.getDoubleArray(x);
            coordY = Util.getDoubleArray(y);
            smoothNextB = Util.getBooleanArray(lineTo);
            if (this.drawSmooth) {
                if (this.drawCurveGradient) {
                    ig.drawSmoothVerticalPolyline(coordX, coordY, smoothNextB, "stroke-width: 0; fill: url(#grad" + ImageGenerator.gradNum + ");");
                } else {
                    ig.drawSmoothVerticalPolyline(coordX, coordY, smoothNextB, "stroke-width: 0;" + Coloring.getFillStyle(this.fillColor));
                }
            } else if (this.drawCurveGradient) {
                ig.drawPolygon(coordX, coordY, "stroke-width: 0; fill: url(#grad" + ImageGenerator.gradNum + ");");
            } else {
                ig.drawPolygon(coordX, coordY, "stroke-width: 0;" + Coloring.getFillStyle(this.fillColor));
            }
        }
        if (this.drawPoints || this.drawLine) {
            coordX = Util.getDoubleArray(x, 1, x.size() - 1);
            coordY = Util.getDoubleArray(y, 1, y.size() - 1);
            smoothNextB = Util.getBooleanArray(lineTo, 1, lineTo.size() - 1);
            if (this.drawLine) {
                if (this.drawSmooth) {
                    ig.drawSmoothVerticalPolyline(coordX, coordY, smoothNextB, "stroke-width: 1; fill: none;stroke: " + Coloring.getStyleRGB(this.lineColor) + ";");
                } else {
                    ig.drawPolyline(coordX, coordY, "stroke-width: 1; fill: none;stroke: " + Coloring.getStyleRGB(this.lineColor) + ";");
                }
            }
            if (this.drawPoints) {
                ig.drawPoints(coordX, coordY, this.pointType, null, this.lineColor);
            }
        }
        ig.popGrouping();
        if (this.drawMyOverlay) {
            this.drawOverlays(ig, startx, starty, width, height, settings);
        }
        if (this.drawExtraColumn) {
            TreeSet newData = new TreeSet();
            Vector<Double> coordX2 = new Vector<Double>();
            Vector<Double> coordY2 = new Vector<Double>();
            Iterator itr = this.data.iterator();
            int i = 0;
            while (itr.hasNext()) {
                Datapoint dp = (Datapoint)itr.next();
                coordY2.add(dp.baseAge);
                coordX2.add((Double)dp.value);
                ++i;
            }
            double[] coordX22 = Util.getDoubleArray(coordX2, 1, coordX2.size() - 1);
            double[] coordY22 = Util.getDoubleArray(coordY2, 1, coordY2.size() - 1);
            PCOptionsPanel pc = (PCOptionsPanel)this.optionsPanel;
            double[][] result = RollApply.rollApply(coordY22, coordX22, this.windowSize, this.stepSize, this.dataMiningFunction);
            this.newX = result[0];
            this.newY = result[1];
            this.dataMiningColumnDrawing = true;
            this.drawExtraColumn = false;
        }
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null && name.compareToIgnoreCase("drawPoints") != 0) {
            if (name.compareToIgnoreCase("drawLine") == 0) {
                this.drawLine = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawSmooth") == 0) {
                this.drawSmooth = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawFill") == 0) {
                this.drawFill = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("fillColor") == 0) {
                this.fillColor = Coloring.getColorFromStyle(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawBgrndGradient") == 0) {
                this.drawBgrndGradient = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawCurveGradient") == 0) {
                this.drawCurveGradient = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("backGradStart") == 0) {
                this.backGradStart = Coloring.getColorFromStyle(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("backGradEnd") == 0) {
                this.backGradEnd = Coloring.getColorFromStyle(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("curveGradStart") == 0) {
                this.curveGradStart = Coloring.getColorFromStyle(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("curveGradEnd") == 0) {
                this.curveGradEnd = Coloring.getColorFromStyle(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("doNotSetWindowAuto") == 0) {
                this.doNotSetWindowAuto = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("minWindow") == 0) {
                this.minWindow = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("maxWindow") == 0) {
                this.maxWindow = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("scaleStart") == 0) {
                this.scaleStart = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("scaleStep") == 0) {
                this.scaleStep = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("pointType") == 0) {
                String pt = setting.getAttribute("pointType");
                this.pointType = pt.compareToIgnoreCase("round") == 0 ? 2 : (pt.compareToIgnoreCase("rect") == 0 ? 1 : 3);
            } else if (name.compareToIgnoreCase("flipScale") == 0) {
                this.flipScale = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawScale") == 0) {
                this.drawScale = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawRCScale") == 0) {
                this.drawRCScale = Boolean.valueOf(Settings.getNodeTextContent(setting));
            }
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        this.readTextFieldsFromPanel();
        element.appendChild(Settings.createSimpleSetting(doc, "drawPoints", "" + this.drawPoints));
        element.appendChild(Settings.createSimpleSetting(doc, "drawLine", "" + this.drawLine));
        element.appendChild(Settings.createSimpleSetting(doc, "lineColor", Coloring.getColorStyle(this.lineColor)));
        element.appendChild(Settings.createSimpleSetting(doc, "drawSmooth", "" + this.drawSmooth));
        element.appendChild(Settings.createSimpleSetting(doc, "drawFill", "" + this.drawFill));
        element.appendChild(Settings.createSimpleSetting(doc, "fillColor", Coloring.getColorStyle(this.fillColor)));
        element.appendChild(Settings.createSimpleSetting(doc, "doNotSetWindowAuto", "" + this.doNotSetWindowAuto));
        element.appendChild(Settings.createSimpleSetting(doc, "minWindow", "" + this.minWindow));
        element.appendChild(Settings.createSimpleSetting(doc, "maxWindow", "" + this.maxWindow));
        element.appendChild(Settings.createSimpleSetting(doc, "drawScale", "" + this.drawScale));
        element.appendChild(Settings.createSimpleSetting(doc, "drawBgrndGradient", "" + this.drawBgrndGradient));
        element.appendChild(Settings.createSimpleSetting(doc, "backGradStart", "" + Coloring.getColorStyle(this.backGradStart)));
        element.appendChild(Settings.createSimpleSetting(doc, "backGradEnd", "" + Coloring.getColorStyle(this.backGradEnd)));
        element.appendChild(Settings.createSimpleSetting(doc, "drawCurveGradient", "" + this.drawCurveGradient));
        element.appendChild(Settings.createSimpleSetting(doc, "curveGradStart", "" + Coloring.getColorStyle(this.curveGradStart)));
        element.appendChild(Settings.createSimpleSetting(doc, "curveGradEnd", "" + Coloring.getColorStyle(this.curveGradEnd)));
        element.appendChild(Settings.createSimpleSetting(doc, "flipScale", "" + this.flipScale));
        element.appendChild(Settings.createSimpleSetting(doc, "scaleStart", "" + this.scaleStart));
        element.appendChild(Settings.createSimpleSetting(doc, "scaleStep", "" + this.scaleStep));
        Element ptE = Settings.createSimpleSetting(doc, "pointType", "");
        switch (this.pointType) {
            case 1: {
                ptE.setAttribute("pointType", "rect");
                break;
            }
            case 2: {
                ptE.setAttribute("pointType", "round");
                break;
            }
            default: {
                ptE.setAttribute("pointType", "tick");
            }
        }
        element.appendChild(ptE);
    }

    public void writePointHeader(Writer w) throws IOException {
        if (this.drawPoints) {
            switch (this.pointType) {
                case 1: {
                    w.write("rect\t");
                    break;
                }
                case 2: {
                    w.write("circle\t");
                    break;
                }
                default: {
                    w.write("cross\t");
                    break;
                }
            }
        } else {
            w.write("nopoints\t");
        }
        if (!this.drawLine) {
            w.write("noline\t");
        } else if (this.lineColor == null || this.lineColor.getRGB() == 0) {
            w.write("line\t");
        } else {
            w.write("" + this.lineColor.getRed() + "/" + this.lineColor.getGreen() + "/" + this.lineColor.getBlue() + "\t");
        }
        if (this.drawFill && this.fillColor != null) {
            w.write("" + this.fillColor.getRed() + "/" + this.fillColor.getGreen() + "/" + this.fillColor.getBlue() + "\t");
        } else {
            w.write("nofill\t");
        }
        w.write(Double.toString(this.minWindow) + "\t" + Double.toString(this.maxWindow) + "\t");
        if (this.drawSmooth) {
            w.write("smoothed\t");
        } else {
            w.write("notsmoothed\t");
        }
        w.write("\r\n");
    }

    @Override
    public void write(Writer w) throws IOException {
        this.writeHeader(w, "point");
        this.writePointHeader(w);
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            Datapoint dp = (Datapoint)iter.next();
            w.write("\t" + Double.toString(dp.baseAge) + "\t" + ((Double)dp.value).toString() + "\t");
            if (dp.label != null) {
                w.write(dp.label + "\t");
            } else {
                w.write(9);
            }
            if (dp.popup != null) {
                PointColumn.writeRichText(w, dp.popup);
            }
            w.write("\r\n");
        }
        this.writeOverlaysAndUnderlays(w);
    }

    @Override
    public DataSeries getSeriesModel(int which) {
        if (which != 0) {
            return null;
        }
        DataSeries series = new DataSeries();
        series.setSingle(new DataSteward(this.data, new TableInterpreter()));
        return series;
    }

    public class TableInterpreter
    extends DataColumn.TableInterpreter {
        public String[] myNames = new String[]{"Age", "X"};
        public String[] myToolTips = new String[]{null, "The x coordinate of the point"};
        public Class[] myClasses = new Class[]{Double.class, Double.class};

        public TableInterpreter() {
            this.names = this.myNames;
            this.classes = this.myClasses;
            this.toolTips = this.myToolTips;
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return new Double(p.baseAge);
                }
                case 1: {
                    return p.value;
                }
                case 2: {
                    return p.label;
                }
                case 3: {
                    return p.popup;
                }
            }
            return null;
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    p.baseAge = !Double.isNaN(age) ? age : 0.0;
                    PointColumn.this.updateMinMaxAges();
                    break;
                }
                case 1: {
                    if (value == null) {
                        p.value = new Double(0.0);
                        break;
                    }
                    p.value = Double.valueOf(value.toString());
                    break;
                }
                case 2: {
                    p.label = value.toString();
                    break;
                }
                case 3: {
                    p.popup = value.toString();
                }
            }
        }

        @Override
        public Datapoint createEmptyDatapoint() {
            Datapoint p = new Datapoint();
            p.value = new Double(0.0);
            return p;
        }
    }

    public static class Interval {
        public double min;
        public double max;
    }

    public class PCOptionsPanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    Cloneable {
        private static final long serialVersionUID = 1L;
        PointColumn pc;
        private JPanel pointsPanel;
        private JPanel autoFlipPanel;
        private JCheckBox bTicks;
        private JRadioButton tickTick;
        private JCheckBox bSmooth;
        private JTextField tfMaxWin;
        private JButton colorPick;
        private JPanel lineColorPreview;
        private JButton lineColorChoose;
        private JPanel colorPreview;
        private JTextField tfScaleStep;
        private JTextField tfScaleStart;
        private JLabel scaleStepLabel;
        private JLabel scaleStartLabel;
        private JCheckBox bDrawScale;
        private JCheckBox bFlip;
        private JButton autoWin;
        private JButton flip;
        private JLabel toLabel;
        private JLabel frequencyStartLabel;
        private JTextField tfMinWin;
        private JLabel labelRange;
        private JPanel rangePanel;
        private JCheckBox bFill;
        private JCheckBox bBgrndGrad;
        private JCheckBox bCurveGrad;
        private JCheckBox bLine;
        public JCheckBox bRateOfChange;
        public JCheckBox bFrequency;
        public JCheckBox bAverage;
        public JCheckBox bMaximum;
        public JCheckBox bMinimum;
        public JCheckBox bOverlay;
        public JCheckBox bRegression;
        private JButton secondChoose;
        private JButton generateTest;
        private JButton generateCloseTest;
        private JButton generateCurveTest;
        private JButton generateCurveCloseTest;
        public JPanel bRangePanel;
        private JPanel dataPanel;
        private JPanel lineSettingsPanel;
        private JPanel smoothGradPanel;
        private JRadioButton tickRound;
        private JRadioButton tickRect;
        private JPanel scalePanel;
        private JTextField windowSizeText;
        private JTextField stepSizeText;
        private JTextField stepSizeMaxData;
        private JTextField windowSizeMaxData;
        private JTextField stepSizeAverageData;
        private JTextField windowSizeAverageData;
        private JLabel windowSizeLabelFrequency;
        private JLabel windowSizeLabelMax;
        private JLabel windowSizeLabelMin;
        private JLabel windowSizeLabelAverage;
        private JLabel stepSizeLabelFrequency;
        private JLabel stepSizeLabelMax;
        private JLabel stepSizeLabelMin;
        private JLabel stepSizeLabelAverage;
        private JButton backGradStartChoose;
        private JButton backGradEndChoose;
        private JButton curveGradStartChoose;
        private JButton curveGradEndChoose;
        private JPanel backGradStartPrev;
        private JPanel backGradEndPrev;
        private JPanel curveGradStartPrev;
        private JPanel curveGradEndPrev;
        private JPanel gradientPanel;
        private JLabel spacerLabel1;
        private JLabel spacerLabel2;
        private JLabel spacerLabel3;
        private JLabel spacerLabel4;
        private JLabel rangeFromLabel;
        private JTextField myBaseColumn;
        private JTextField myOverlayColumn;
        private JButton bExtendedSettingsWindow;
        private JButton bMiningSettingsWindow;
        private JButton bCurveExport;
        private JLabel mySpacer1;
        private JLabel mySpacer2;
        private JLabel dualColComp;
        private JPanel settingsButtonPanel;
        private JLabel extendedSettingsText;
        private JPanel extendedSettingsPanel;
        private JTabbedPane curveTabbedPane;
        private JFrame extendedSettingsFrame;
        private JPanel dataMiningSettingsPanel;
        private JTabbedPane extendedOptionsPane1;
        private JLabel displaySettingsTab;
        private JLabel dataSettingsTab;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void setTFMinWindow(String text) {
            this.tfMinWin.setText(text);
        }

        public void setTFMaxWindow(String text) {
            this.tfMaxWin.setText(text);
        }

        public PCOptionsPanel(PointColumn pc) {
            this.pc = pc;
            this.initGUI();
            ButtonGroup tickGroup = new ButtonGroup();
            tickGroup.add(this.tickRect);
            tickGroup.add(this.tickRound);
            tickGroup.add(this.tickTick);
            this.bTicks.addItemListener(this);
            this.tickRect.addItemListener(this);
            this.tickRound.addItemListener(this);
            this.tickTick.addItemListener(this);
            this.bLine.addItemListener(this);
            this.lineColorChoose.addActionListener(this);
            this.bFill.addItemListener(this);
            this.bFrequency.addItemListener(this);
            this.bMaximum.addItemListener(this);
            this.bMinimum.addItemListener(this);
            this.bAverage.addItemListener(this);
            this.bRateOfChange.addItemListener(this);
            this.bOverlay.addItemListener(this);
            this.colorPick.addActionListener(this);
            this.bSmooth.addItemListener(this);
            this.bBgrndGrad.addItemListener(this);
            this.backGradStartChoose.addActionListener(this);
            this.backGradEndChoose.addActionListener(this);
            this.bCurveGrad.addItemListener(this);
            this.curveGradStartChoose.addActionListener(this);
            this.curveGradEndChoose.addActionListener(this);
            this.bExtendedSettingsWindow.addItemListener(this);
            this.bMiningSettingsWindow.addItemListener(this);
            this.bCurveExport.addItemListener(this);
            this.autoWin.addActionListener(this);
            this.flip.addActionListener(this);
            this.bExtendedSettingsWindow.addActionListener(this);
            this.bMiningSettingsWindow.addActionListener(this);
            this.bCurveExport.addActionListener(this);
            this.secondChoose.addActionListener(this);
            this.generateTest.addActionListener(this);
            this.generateCloseTest.addActionListener(this);
            this.generateCurveTest.addActionListener(this);
            this.generateCurveCloseTest.addActionListener(this);
            this.bDrawScale.addItemListener(this);
            this.bRateOfChange.addItemListener(this);
            this.bFlip.addItemListener(this);
            this.tfScaleStep.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (Settings.mySelectDC instanceof PointColumn) {
                        PointColumn.this.scaleStep = Double.parseDouble(PCOptionsPanel.this.tfScaleStep.getText());
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            this.readDataFromPC();
        }

        public PCOptionsPanel() {
        }

        private Component cloneSwingComponent(Component c) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(c);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                return (Component)ois.readObject();
            }
            catch (IOException | ClassNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private void initGUI() {
            try {
                GridBagLayout thisLayout = new GridBagLayout();
                thisLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
                thisLayout.rowHeights = new int[]{4, 4, 4, 10, 10, 10, 10, 10};
                thisLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
                thisLayout.columnWidths = new int[]{45, 60, 30, 20, 17};
                this.setPreferredSize(new Dimension(30, 30));
                this.setLayout(thisLayout);
                GridBagConstraints constraints = new GridBagConstraints();
                JPanel panel = new JPanel();
                GridBagLayout layout = new GridBagLayout();
                layout.columnWidths = new int[]{0, 0};
                layout.rowHeights = new int[]{0, 0, 0, 0};
                layout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
                layout.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
                panel.setLayout(layout);
                this.pointsPanel = new JPanel();
                GridBagLayout pointsPanelLayout = new GridBagLayout();
                pointsPanelLayout.rowWeights = new double[]{0.01, 0.01};
                pointsPanelLayout.rowHeights = new int[]{9, 9};
                pointsPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                pointsPanelLayout.columnWidths = new int[]{45, 45, 200, 45};
                this.pointsPanel.setLayout(pointsPanelLayout);
                this.pointsPanel.setAlignmentX(0.0f);
                this.spacerLabel1 = new JLabel();
                this.pointsPanel.add((Component)this.spacerLabel1, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.spacerLabel1.setText(Language.translate("_______________", true));
                this.spacerLabel1.setLayout(null);
                this.spacerLabel2 = new JLabel();
                this.pointsPanel.add((Component)this.spacerLabel2, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.spacerLabel2.setText(Language.translate("____________", true));
                this.spacerLabel2.setLayout(null);
                this.spacerLabel3 = new JLabel();
                this.pointsPanel.add((Component)this.spacerLabel3, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.spacerLabel3.setText(Language.translate("____________", true));
                this.spacerLabel3.setLayout(null);
                this.spacerLabel4 = new JLabel();
                this.pointsPanel.add((Component)this.spacerLabel4, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.spacerLabel4.setText(Language.translate("_____________", true));
                this.spacerLabel4.setLayout(null);
                this.bTicks = new JCheckBox();
                this.bTicks.setText(Language.translate("Points:", true));
                this.bTicks.setLayout(null);
                this.pointsPanel.add((Component)this.bTicks, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.tickRect = new JRadioButton();
                this.tickRect.setText("<html><img src=\"" + FileUtils.getURL(ResPath.getPath("gui.rect")).toString() + "\"</html>");
                this.tickRect.setLayout(null);
                this.pointsPanel.add((Component)this.tickRect, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.tickRound = new JRadioButton();
                this.tickRound.setText("<html><img src=\"" + FileUtils.getURL(ResPath.getPath("gui.round")).toString() + "\"</html>");
                this.tickRound.setLayout(null);
                this.pointsPanel.add((Component)this.tickRound, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.tickTick = new JRadioButton();
                this.tickTick.setText("<html><img src=\"" + FileUtils.getURL(ResPath.getPath("gui.tick")).toString() + "\"</html>");
                this.tickTick.setLayout(null);
                this.pointsPanel.add((Component)this.tickTick, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.lineSettingsPanel = new JPanel();
                GridBagLayout lineSettingsLayout = new GridBagLayout();
                lineSettingsLayout.rowWeights = new double[]{0.01, 0.01};
                lineSettingsLayout.rowHeights = new int[]{10, 10};
                lineSettingsLayout.columnWeights = new double[]{0.01, 0.01, 0.0, 1.0};
                lineSettingsLayout.columnWidths = new int[]{45, 45, 200, 45};
                this.lineSettingsPanel.setLayout(lineSettingsLayout);
                this.lineSettingsPanel.setAlignmentX(0.0f);
                this.bLine = new JCheckBox();
                this.bLine.setText(Language.translate("Line:", true));
                this.bLine.setLayout(null);
                this.pointsPanel.add((Component)this.bLine, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.lineColorChoose = new JButton();
                this.lineColorChoose.setText(Language.translate("Choose", true));
                this.lineColorChoose.setLayout(null);
                this.pointsPanel.add((Component)this.lineColorChoose, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.lineColorPreview = new JPanel();
                this.pointsPanel.add((Component)this.lineColorPreview, new GridBagConstraints(2, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.lineColorPreview.setPreferredSize(new Dimension(23, 23));
                this.bFill = new JCheckBox();
                this.bFill.setText(Language.translate("Fill:", true));
                this.bFill.setLayout(null);
                this.pointsPanel.add((Component)this.bFill, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.colorPick = new JButton();
                this.colorPick.setText(Language.translate("Choose", true));
                this.colorPick.setLayout(null);
                this.pointsPanel.add((Component)this.colorPick, new GridBagConstraints(1, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.colorPreview = new JPanel();
                this.colorPreview.setPreferredSize(new Dimension(23, 23));
                this.pointsPanel.add((Component)this.colorPreview, new GridBagConstraints(2, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.smoothGradPanel = new JPanel();
                GridBagLayout smoothGradPanelLayout = new GridBagLayout();
                smoothGradPanelLayout.rowWeights = new double[]{0.01, 0.01};
                smoothGradPanelLayout.rowHeights = new int[]{10, 10};
                smoothGradPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                smoothGradPanelLayout.columnWidths = new int[]{45, 45, 200, 45};
                this.smoothGradPanel.setLayout(lineSettingsLayout);
                this.smoothGradPanel.setAlignmentX(0.0f);
                this.bSmooth = new JCheckBox();
                this.bSmooth.setText(Language.translate("Smoothed", true));
                this.bSmooth.setLayout(null);
                this.pointsPanel.add((Component)this.bSmooth, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 17, 10, new Insets(0, 0, 0, 0), 0, 0));
                this.bBgrndGrad = new JCheckBox();
                this.bBgrndGrad.setText(Language.translate("BgrndGrad:", true));
                this.bBgrndGrad.setLayout(null);
                this.pointsPanel.add((Component)this.bBgrndGrad, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 17, 10, new Insets(0, 0, 0, 0), 0, 0));
                this.backGradStartChoose = new JButton();
                this.pointsPanel.add((Component)this.backGradStartChoose, new GridBagConstraints(1, 16, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.backGradStartChoose.setText(Language.translate("Choose", true));
                this.backGradStartChoose.setLayout(null);
                this.backGradStartPrev = new JPanel();
                this.pointsPanel.add((Component)this.backGradStartPrev, new GridBagConstraints(2, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.backGradStartPrev.setPreferredSize(new Dimension(23, 23));
                this.backGradEndChoose = new JButton();
                this.pointsPanel.add((Component)this.backGradEndChoose, new GridBagConstraints(1, 17, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.backGradEndChoose.setText(Language.translate("Choose", true));
                this.backGradEndChoose.setLayout(null);
                this.backGradEndPrev = new JPanel();
                this.pointsPanel.add((Component)this.backGradEndPrev, new GridBagConstraints(2, 17, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.backGradEndPrev.setPreferredSize(new Dimension(23, 23));
                this.bCurveGrad = new JCheckBox();
                this.pointsPanel.add((Component)this.bCurveGrad, new GridBagConstraints(0, 18, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.bCurveGrad.setText(Language.translate("CurveGrad:", true));
                this.bCurveGrad.setLayout(null);
                this.curveGradStartChoose = new JButton();
                this.pointsPanel.add((Component)this.curveGradStartChoose, new GridBagConstraints(1, 18, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.curveGradStartChoose.setText(Language.translate("Choose", true));
                this.curveGradStartChoose.setLayout(null);
                this.curveGradStartPrev = new JPanel();
                this.pointsPanel.add((Component)this.curveGradStartPrev, new GridBagConstraints(2, 18, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.curveGradStartPrev.setPreferredSize(new Dimension(23, 23));
                this.curveGradEndChoose = new JButton();
                this.pointsPanel.add((Component)this.curveGradEndChoose, new GridBagConstraints(1, 19, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.curveGradEndChoose.setText(Language.translate("Choose", true));
                this.curveGradEndChoose.setLayout(null);
                this.curveGradEndPrev = new JPanel();
                this.pointsPanel.add((Component)this.curveGradEndPrev, new GridBagConstraints(2, 19, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.curveGradEndPrev.setPreferredSize(new Dimension(23, 23));
                this.generateCurveTest = new JButton();
                this.generateCurveTest.setText(Language.translate("Generate", true));
                this.pointsPanel.add((Component)this.generateCurveTest, new GridBagConstraints(1, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.generateCurveTest.setLayout(null);
                this.generateCurveCloseTest = new JButton();
                this.generateCurveCloseTest.setText(Language.translate("Generate and Close", true));
                this.pointsPanel.add((Component)this.generateCurveCloseTest, new GridBagConstraints(2, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.generateCurveCloseTest.setLayout(null);
                this.rangePanel = new JPanel();
                GridBagLayout rangePanelLayout = new GridBagLayout();
                rangePanelLayout.rowWeights = new double[]{0.01, 0.01};
                rangePanelLayout.rowHeights = new int[]{10, 10};
                rangePanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                rangePanelLayout.columnWidths = new int[]{45, 45, 200, 45};
                this.rangePanel.setLayout(rangePanelLayout);
                this.rangePanel.setAlignmentX(0.0f);
                this.labelRange = new JLabel();
                this.pointsPanel.add((Component)this.labelRange, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.labelRange.setText(Language.translate(" Range", true));
                this.labelRange.setLayout(null);
                this.rangeFromLabel = new JLabel();
                this.pointsPanel.add((Component)this.rangeFromLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.rangeFromLabel.setText(Language.translate("Start:", true));
                this.rangeFromLabel.setLayout(null);
                this.tfMinWin = new JTextField("0");
                this.pointsPanel.add((Component)this.tfMinWin, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.tfMinWin.setText("0");
                this.tfMinWin.setMaximumSize(new Dimension(10000, 200));
                this.toLabel = new JLabel();
                this.pointsPanel.add((Component)this.toLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.toLabel.setText(Language.translate("End:", true));
                this.toLabel.setLayout(null);
                this.tfMaxWin = new JTextField("1");
                this.pointsPanel.add((Component)this.tfMaxWin, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.tfMaxWin.setText("1");
                this.tfMaxWin.setMaximumSize(new Dimension(10000, 200));
                this.autoFlipPanel = new JPanel();
                GridBagLayout autoFlipPanelLayout = new GridBagLayout();
                autoFlipPanelLayout.rowWeights = new double[]{0.01, 0.01};
                autoFlipPanelLayout.rowHeights = new int[]{10, 10};
                autoFlipPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                autoFlipPanelLayout.columnWidths = new int[]{45, 45, 200, 45};
                this.autoFlipPanel.setLayout(autoFlipPanelLayout);
                this.autoFlipPanel.setAlignmentX(0.0f);
                this.autoWin = new JButton();
                this.pointsPanel.add((Component)this.autoWin, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.autoWin.setText(Language.translate("Auto", true));
                this.autoWin.setLayout(null);
                this.flip = new JButton();
                this.pointsPanel.add((Component)this.flip, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.flip.setText(Language.translate("Flip", true));
                this.flip.setLayout(null);
                this.scalePanel = new JPanel();
                constraints = new GridBagConstraints();
                constraints.fill = 1;
                constraints.gridx = 0;
                constraints.gridy = 6;
                PointColumn.this.panel.add((Component)this.scalePanel, constraints);
                this.bDrawScale = new JCheckBox();
                this.pointsPanel.add((Component)this.bDrawScale, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.bDrawScale.setText(Language.translate("Show Scale:", true));
                this.bDrawScale.setLayout(null);
                this.scaleStartLabel = new JLabel();
                this.pointsPanel.add((Component)this.scaleStartLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.scaleStartLabel.setText(Language.translate("Start:", true));
                this.scaleStartLabel.setLayout(null);
                this.tfScaleStart = new JTextField();
                this.pointsPanel.add((Component)this.tfScaleStart, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.tfScaleStart.setText("0");
                this.tfScaleStart.setMaximumSize(new Dimension(10000, 200));
                this.scaleStepLabel = new JLabel();
                this.pointsPanel.add((Component)this.scaleStepLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.scaleStepLabel.setText(Language.translate("Step:", true));
                this.scaleStepLabel.setLayout(null);
                this.tfScaleStep = new JTextField();
                this.pointsPanel.add((Component)this.tfScaleStep, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.tfScaleStep.setText("1");
                this.tfScaleStep.setMaximumSize(new Dimension(10000, 200));
                this.bFlip = new JCheckBox();
                this.pointsPanel.add((Component)this.bFlip, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.bFlip.setText(Language.translate("Flipped", true));
                this.bFlip.setLayout(null);
                this.dataPanel = new JPanel();
                GridBagLayout dataPanelLayout = new GridBagLayout();
                dataPanelLayout.rowWeights = new double[]{0.01, 0.01};
                dataPanelLayout.rowHeights = new int[]{9, 9};
                dataPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                dataPanelLayout.columnWidths = new int[]{45, 45, 200, 45};
                this.dataPanel.setLayout(dataPanelLayout);
                this.dataPanel.setAlignmentX(0.0f);
                this.windowSizeLabelFrequency = new JLabel();
                this.dataPanel.add((Component)this.windowSizeLabelFrequency, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.windowSizeLabelFrequency.setText(Language.translate(" Window Size :", true));
                this.windowSizeLabelFrequency.setLayout(null);
                this.windowSizeText = new JTextField();
                this.dataPanel.add((Component)this.windowSizeText, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.windowSizeText.setText("2");
                this.stepSizeLabelFrequency = new JLabel();
                this.dataPanel.add((Component)this.stepSizeLabelFrequency, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.stepSizeLabelFrequency.setText(Language.translate(" Step Size:", true));
                this.stepSizeLabelFrequency.setLayout(null);
                this.stepSizeText = new JTextField();
                this.dataPanel.add((Component)this.stepSizeText, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.stepSizeText.setText("1");
                this.mySpacer1 = new JLabel();
                this.dataPanel.add((Component)this.mySpacer1, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.mySpacer1.setText(Language.translate("---------------", true));
                this.mySpacer1.setLayout(null);
                this.bFrequency = new JCheckBox();
                this.dataPanel.add((Component)this.bFrequency, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bFrequency.setText(Language.translate("Frequency", true));
                this.bFrequency.setLayout(null);
                this.bMaximum = new JCheckBox();
                this.dataPanel.add((Component)this.bMaximum, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bMaximum.setText(Language.translate("Maximum Value", true));
                this.bMaximum.setLayout(null);
                this.bMinimum = new JCheckBox();
                this.dataPanel.add((Component)this.bMinimum, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bMinimum.setText(Language.translate("Minimum Value", true));
                this.bMinimum.setLayout(null);
                this.bAverage = new JCheckBox();
                this.dataPanel.add((Component)this.bAverage, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bAverage.setText(Language.translate("Average Value", true));
                this.bAverage.setLayout(null);
                this.bRateOfChange = new JCheckBox();
                this.dataPanel.add((Component)this.bRateOfChange, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bRateOfChange.setText(Language.translate("Rate of Change", true));
                this.bRateOfChange.setLayout(null);
                this.mySpacer2 = new JLabel();
                this.dataPanel.add((Component)this.mySpacer2, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.mySpacer2.setText(Language.translate("---------------", true));
                this.mySpacer2.setLayout(null);
                this.dualColComp = new JLabel();
                this.dataPanel.add((Component)this.dualColComp, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.dualColComp.setText(Language.translate("Dual-Column Comparisons:", true));
                this.dualColComp.setLayout(null);
                this.myBaseColumn = new JTextField();
                this.dataPanel.add((Component)this.myBaseColumn, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.myBaseColumn.setText(Settings.mySelectDC.name);
                this.myBaseColumn.setEditable(false);
                this.myOverlayColumn = new JTextField();
                this.dataPanel.add((Component)this.myOverlayColumn, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.myOverlayColumn.setText("Select column");
                this.myOverlayColumn.setEditable(false);
                this.secondChoose = new JButton();
                this.secondChoose.setText(Language.translate("Choose Second Column", true));
                this.dataPanel.add((Component)this.secondChoose, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.secondChoose.setLayout(null);
                this.bOverlay = new JCheckBox();
                this.dataPanel.add((Component)this.bOverlay, new GridBagConstraints(1, 14, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bOverlay.setText(Language.translate("Overlay", true));
                this.bOverlay.setLayout(null);
                this.bRegression = new JCheckBox();
                this.dataPanel.add((Component)this.bRegression, new GridBagConstraints(1, 15, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bRegression.setText(Language.translate("Regression Analysis", true));
                this.bRegression.setLayout(null);
                this.generateTest = new JButton();
                this.generateTest.setText(Language.translate("Generate", true));
                this.dataPanel.add((Component)this.generateTest, new GridBagConstraints(1, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.generateTest.setLayout(null);
                this.generateCloseTest = new JButton();
                this.generateCloseTest.setText(Language.translate("Generate and Close", true));
                this.dataPanel.add((Component)this.generateCloseTest, new GridBagConstraints(2, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.generateCloseTest.setLayout(null);
                this.settingsButtonPanel = new JPanel();
                GridBagLayout settingsButtonLayout = new GridBagLayout();
                settingsButtonLayout.rowWeights = new double[]{0.01, 0.01};
                settingsButtonLayout.rowHeights = new int[]{10, 10};
                settingsButtonLayout.columnWeights = new double[]{0.01, 0.01, 0.0, 1.0};
                settingsButtonLayout.columnWidths = new int[]{45, 45, 200, 45};
                this.settingsButtonPanel.setLayout(settingsButtonLayout);
                this.add(this.settingsButtonPanel);
                this.bExtendedSettingsWindow = new JButton("Curve drawing options");
                this.settingsButtonPanel.add((Component)this.bExtendedSettingsWindow, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 10, new Insets(0, 0, 0, 0), 0, 0));
                this.bExtendedSettingsWindow.setBackground(Color.red);
                this.bMiningSettingsWindow = new JButton("Data Mining Settings");
                this.settingsButtonPanel.add((Component)this.bMiningSettingsWindow, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 10, new Insets(0, 0, 0, 0), 0, 0));
                this.bMiningSettingsWindow.setBackground(Color.red);
                this.bCurveExport = new JButton("Export curve column");
                this.settingsButtonPanel.add((Component)this.bCurveExport, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 10, new Insets(0, 0, 0, 0), 0, 0));
                this.bCurveExport.setBackground(Color.green);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void readTextFieldsFromColumn() {
            PointColumn.this.getPointColName();
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setGroupingUsed(false);
            nf.setMinimumFractionDigits(0);
            if (PointColumn.this.columnName == null || !PointColumn.this.columnName.contains("Strontium")) {
                this.tfMinWin.setText(nf.format(this.pc.minWindow));
                this.tfMaxWin.setText(nf.format(this.pc.maxWindow));
                this.tfScaleStart.setText(nf.format(this.pc.scaleStart));
                this.tfScaleStep.setText(nf.format(this.pc.scaleStep));
            } else {
                nf.setMaximumFractionDigits(4);
                this.tfMinWin.setText(nf.format(this.pc.minWindow));
                this.tfMaxWin.setText(nf.format(this.pc.maxWindow));
                this.tfScaleStart.setText(nf.format(this.pc.scaleStart));
                this.tfScaleStep.setText(nf.format(this.pc.scaleStep));
            }
        }

        public void doGraying() {
            boolean enTicks = this.bTicks.isSelected();
            this.tickRect.setEnabled(enTicks);
            this.tickRound.setEnabled(enTicks);
            this.tickTick.setEnabled(enTicks);
            boolean enFill = this.bFill.isSelected();
            this.colorPick.setEnabled(enFill);
            this.colorPreview.setEnabled(enFill);
            boolean enLine = this.bLine.isSelected();
            this.lineColorChoose.setEnabled(enLine);
            this.lineColorPreview.setEnabled(enLine);
            boolean enScale = this.bDrawScale.isSelected();
            this.tfScaleStart.setEnabled(enScale);
            this.tfScaleStep.setEnabled(enScale);
            this.scaleStartLabel.setEnabled(enScale);
            this.scaleStepLabel.setEnabled(enScale);
            if (PointColumn.this.overlayParent != null && PointColumn.this.overlayParent instanceof PointColumn) {
                this.tfScaleStart.setEnabled(false);
                this.tfScaleStep.setEnabled(false);
                this.scaleStartLabel.setEnabled(false);
                this.scaleStepLabel.setEnabled(false);
            }
        }

        public void readDataFromPC() {
            this.bTicks.setSelected(this.pc.drawPoints);
            this.bLine.setSelected(this.pc.drawLine);
            this.bSmooth.setSelected(this.pc.drawSmooth);
            this.bFill.setSelected(this.pc.drawFill);
            this.bBgrndGrad.setSelected(this.pc.drawBgrndGradient);
            this.bCurveGrad.setSelected(this.pc.drawCurveGradient);
            switch (this.pc.pointType) {
                case 1: {
                    this.tickRect.setSelected(true);
                    break;
                }
                case 2: {
                    this.tickRound.setSelected(true);
                    break;
                }
                default: {
                    this.tickTick.setSelected(true);
                }
            }
            this.colorPreview.setBackground(this.pc.fillColor);
            this.lineColorPreview.setBackground(this.pc.lineColor);
            this.backGradStartPrev.setBackground(this.pc.backGradStart);
            this.backGradEndPrev.setBackground(this.pc.backGradEnd);
            this.curveGradStartPrev.setBackground(this.pc.curveGradStart);
            this.curveGradEndPrev.setBackground(this.pc.curveGradEnd);
            this.bDrawScale.setSelected(this.pc.drawScale);
            this.bFlip.setSelected(this.pc.flipScale);
            this.readTextFieldsFromColumn();
            this.doGraying();
        }

        public File openExportCurveFileDialog() {
            FileDialog fileChooser = new FileDialog(new Frame(), "Export curve column", 1);
            fileChooser.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String filename) {
                    return filename.endsWith(".txt");
                }
            });
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            Date date = new Date();
            String sdate = formatter.format(date);
            fileChooser.setFile("point_column_" + sdate + ".txt");
            fileChooser.setVisible(true);
            File selFile = null;
            if (fileChooser.getFile() != null && !fileChooser.getFile().isEmpty()) {
                selFile = new File(fileChooser.getDirectory() + fileChooser.getFile());
            }
            return selFile;
        }

        public String convertCurveColumnToTSC() {
            String tsf = "";
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date(System.currentTimeMillis());
            String today = formatter.format(date);
            tsf = tsf + "format version:\t1.3\n";
            tsf = tsf + "date: \t" + today + "\n";
            tsf = tsf + "default chronostat: \tUNESCO\n\n";
            String treeColumnName = this.pc.name;
            tsf = tsf + treeColumnName + "\tpoint\t100\t255/255/255\n";
            tsf = tsf + "no points\tline\t255/0/0\t\t\tnotsmoothed\n";
            for (Datapoint dp : this.pc.data) {
                tsf = tsf + "\t" + dp.baseAge + "\t" + dp.value + "\n";
            }
            tsf = tsf + "\n";
            return tsf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.autoWin) {
                Interval magInt = this.pc.getMinMaxMag();
                double margin = (magInt.max - magInt.min) * 0.1;
                this.pc.minWindow = magInt.min - margin / 2.0;
                this.pc.maxWindow = magInt.max + margin / 2.0;
                this.pc.autoScale();
                this.readTextFieldsFromColumn();
            } else if (source == this.flip) {
                this.bFlip.setSelected(!this.bFlip.isSelected());
            } else if (source == this.bCurveExport) {
                File selFile = this.openExportCurveFileDialog();
                if (selFile != null) {
                    String txt = this.convertCurveColumnToTSC();
                    String fpath = selFile.getAbsolutePath() + ".txt";
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(fpath));
                        writer = new BufferedWriter(new FileWriter(fpath));
                        writer.write(txt);
                        writer.close();
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            } else if (source == this.bExtendedSettingsWindow || source == this.bMiningSettingsWindow) {
                if (this.extendedSettingsFrame == null) {
                    this.extendedSettingsFrame = new JFrame("Extended Settings Window");
                    this.extendedSettingsFrame.setSize(500, 700);
                    this.extendedSettingsFrame.setVisible(true);
                    this.extendedSettingsPanel = new JPanel();
                    GridBagLayout extendedSettingsPanelLayout = new GridBagLayout();
                    extendedSettingsPanelLayout.rowWeights = new double[]{0.01, 0.01};
                    extendedSettingsPanelLayout.rowHeights = new int[]{10, 10};
                    extendedSettingsPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                    extendedSettingsPanelLayout.columnWidths = new int[]{45, 45, 100, 45};
                    this.extendedSettingsPanel.setLayout(extendedSettingsPanelLayout);
                    this.extendedSettingsPanel.setAlignmentX(0.0f);
                    this.dataMiningSettingsPanel = new JPanel();
                    this.dataMiningSettingsPanel.setLayout(extendedSettingsPanelLayout);
                    this.dataMiningSettingsPanel.setAlignmentX(0.0f);
                    this.extendedSettingsPanel.add((Component)this.pointsPanel, new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 10, new Insets(0, 0, 0, 0), 0, 0));
                    this.dataMiningSettingsPanel.add((Component)this.dataPanel, new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 10, new Insets(0, 0, 0, 0), 0, 0));
                    this.curveTabbedPane = new JTabbedPane();
                    this.curveTabbedPane.addTab("Curve Drawing Settings", null, this.extendedSettingsPanel, "Curve Drawing Settings");
                    this.curveTabbedPane.addTab("Data Mining Settings", null, this.dataMiningSettingsPanel, "Data Mining Settings");
                    if (source == this.bExtendedSettingsWindow) {
                        this.curveTabbedPane.setSelectedIndex(0);
                    } else {
                        this.curveTabbedPane.setSelectedIndex(1);
                    }
                    this.extendedSettingsFrame.add(this.curveTabbedPane);
                } else {
                    if (source == this.bExtendedSettingsWindow) {
                        this.curveTabbedPane.setSelectedIndex(0);
                    } else {
                        this.curveTabbedPane.setSelectedIndex(1);
                    }
                    this.extendedSettingsFrame.setVisible(true);
                }
            } else if (source == this.colorPick) {
                Color chosenColor = JColorChooser.showDialog(this, Language.translate("Choose Graph's Fill Color", true), this.pc.fillColor);
                if (chosenColor != null) {
                    this.pc.fillColor = chosenColor;
                    this.colorPreview.setBackground(chosenColor);
                }
            } else if (source == this.lineColorChoose) {
                Color chosenColor = JColorChooser.showDialog(this, Language.translate("Choose Graph's Line Color", true), this.pc.lineColor);
                if (chosenColor != null) {
                    this.pc.lineColor = chosenColor;
                    this.lineColorPreview.setBackground(PointColumn.this.lineColor);
                }
            } else if (source == this.backGradStartChoose) {
                Color chosenColor = JColorChooser.showDialog(this, Language.translate("Choose Starting Color of Background Gradient", true), this.pc.backGradStart);
                if (chosenColor != null) {
                    this.pc.backGradStart = chosenColor;
                    this.backGradStartPrev.setBackground(PointColumn.this.backGradStart);
                }
            } else if (source == this.backGradEndChoose) {
                Color chosenColor = JColorChooser.showDialog(this, Language.translate("Choose Starting Color of Background Gradient", true), this.pc.backGradEnd);
                if (chosenColor != null) {
                    this.pc.backGradEnd = chosenColor;
                    this.backGradEndPrev.setBackground(PointColumn.this.backGradEnd);
                }
            } else if (source == this.curveGradStartChoose) {
                Color chosenColor = JColorChooser.showDialog(this, Language.translate("Choose Starting Color of Background Gradient", true), this.pc.curveGradStart);
                if (chosenColor != null) {
                    this.pc.curveGradStart = chosenColor;
                    this.curveGradStartPrev.setBackground(PointColumn.this.curveGradStart);
                }
            } else if (source == this.curveGradEndChoose) {
                Color chosenColor = JColorChooser.showDialog(this, Language.translate("Choose Starting Color of Background Gradient", true), this.pc.backGradEnd);
                if (chosenColor != null) {
                    this.pc.curveGradEnd = chosenColor;
                    this.curveGradEndPrev.setBackground(PointColumn.this.curveGradEnd);
                }
            } else if (source != this.curveGradEndChoose) {
                if (source == this.secondChoose) {
                    if (Settings.mySelectDC instanceof PointColumn) {
                        PointColumn pc_old = (PointColumn)Settings.mySelectDC;
                        this.myOverlayColumn.setText(pc_old.name);
                        PointColumn pc_new = new PointColumn(pc_old.name + " copy");
                        pc_new.pointType = pc_old.pointType;
                        pc_new.drawPoints = pc_old.drawPoints;
                        pc_new.drawLine = pc_old.drawLine;
                        pc_new.lineColor = pc_old.lineColor;
                        pc_new.drawFill = pc_old.drawFill;
                        pc_new.drawSmooth = pc_old.drawSmooth;
                        pc_new.minWindow = pc_old.minWindow;
                        pc_new.maxWindow = pc_old.maxWindow;
                        pc_new.data = pc_old.data;
                        pc_new.initStep = pc_old.scaleStep;
                        pc_new.scaleStep = pc_old.scaleStep;
                        pc_new.fonts = pc_old.fonts;
                        TSCFont myChosenFont = new TSCFont(pc_new.fonts.getFont(8));
                        Color myColor = pc_old.lineColor;
                        myChosenFont.setColor(myColor);
                        pc_new.fonts.setFont(8, myChosenFont);
                        pc_new.drawScale = true;
                        pc_new.drawTitle = false;
                        pc_new.keepCol = false;
                        this.pc.addOverlay(pc_new);
                    }
                } else if (source == this.generateTest || source == this.generateCurveTest) {
                    if (Settings.generateAction != null) {
                        Settings.generateAction.actionPerformed(null);
                    }
                } else if (source == this.generateCloseTest || source == this.generateCurveCloseTest) {
                    this.extendedSettingsFrame.setVisible(false);
                    if (Settings.generateAction != null) {
                        Settings.generateAction.actionPerformed(null);
                    }
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            Object source = ie.getSource();
            if (source == this.bTicks) {
                this.pc.drawPoints = this.bTicks.isSelected();
                this.doGraying();
            } else if (source == this.bLine) {
                this.pc.drawLine = this.bLine.isSelected();
                this.doGraying();
            } else if (source == this.bBgrndGrad) {
                this.pc.drawBgrndGradient = this.bBgrndGrad.isSelected();
            } else if (source == this.bCurveGrad) {
                this.pc.drawCurveGradient = this.bCurveGrad.isSelected();
            } else if (source == this.bSmooth) {
                this.pc.drawSmooth = this.bSmooth.isSelected();
            } else if (source == this.bFill) {
                this.pc.drawFill = this.bFill.isSelected();
                this.doGraying();
            } else if (source == this.bFrequency) {
                if (this.bFrequency.isSelected()) {
                    this.pc.prevExtraColumnHeaderName = this.pc.extraColumnHeaderName;
                    this.pc.extraColumnHeaderName = "Number of points per window";
                    this.bMaximum.setSelected(false);
                    this.bMinimum.setSelected(false);
                    this.bAverage.setSelected(false);
                    this.bRateOfChange.setSelected(false);
                    this.bOverlay.setSelected(false);
                    if (PointColumn.this.prevDataMiningFunction != PointColumn.this.dataMiningFunction) {
                        PointColumn.this.prevDataMiningFunction = PointColumn.this.dataMiningFunction;
                        this.pc.drawExtraColumn = true;
                    }
                    PointColumn.this.dataMiningFunction = 0;
                }
            } else if (source == this.bMinimum) {
                if (this.bMinimum.isSelected()) {
                    this.pc.prevExtraColumnHeaderName = this.pc.extraColumnHeaderName;
                    this.pc.extraColumnHeaderName = "Minimum value per window";
                    this.bRateOfChange.setSelected(false);
                    this.bFrequency.setSelected(false);
                    this.bMaximum.setSelected(false);
                    this.bAverage.setSelected(false);
                    this.bOverlay.setSelected(false);
                    if (PointColumn.this.prevDataMiningFunction != PointColumn.this.dataMiningFunction) {
                        PointColumn.this.prevDataMiningFunction = PointColumn.this.dataMiningFunction;
                        this.pc.drawExtraColumn = true;
                    }
                    PointColumn.this.dataMiningFunction = 1;
                }
            } else if (source == this.bMaximum) {
                if (this.bMaximum.isSelected()) {
                    this.pc.prevExtraColumnHeaderName = this.pc.extraColumnHeaderName;
                    this.pc.extraColumnHeaderName = "Maximum value per window";
                    this.bRateOfChange.setSelected(false);
                    this.bFrequency.setSelected(false);
                    this.bMinimum.setSelected(false);
                    this.bAverage.setSelected(false);
                    this.bOverlay.setSelected(false);
                    if (PointColumn.this.prevDataMiningFunction != PointColumn.this.dataMiningFunction) {
                        PointColumn.this.prevDataMiningFunction = PointColumn.this.dataMiningFunction;
                        this.pc.drawExtraColumn = true;
                    }
                    PointColumn.this.dataMiningFunction = 2;
                }
            } else if (source == this.bAverage) {
                if (this.bAverage.isSelected()) {
                    this.pc.prevExtraColumnHeaderName = this.pc.extraColumnHeaderName;
                    this.pc.extraColumnHeaderName = "Average value per window";
                    this.bRateOfChange.setSelected(false);
                    this.bFrequency.setSelected(false);
                    this.bMaximum.setSelected(false);
                    this.bMinimum.setSelected(false);
                    this.bOverlay.setSelected(false);
                    if (PointColumn.this.prevDataMiningFunction != PointColumn.this.dataMiningFunction) {
                        PointColumn.this.prevDataMiningFunction = PointColumn.this.dataMiningFunction;
                        this.pc.drawExtraColumn = true;
                    }
                    PointColumn.this.dataMiningFunction = 3;
                }
            } else if (source == this.bRateOfChange) {
                if (this.bRateOfChange.isSelected()) {
                    this.pc.prevExtraColumnHeaderName = this.pc.extraColumnHeaderName;
                    this.pc.extraColumnHeaderName = "Rate of change";
                    this.bFrequency.setSelected(false);
                    this.bMaximum.setSelected(false);
                    this.bMinimum.setSelected(false);
                    this.bAverage.setSelected(false);
                    this.bOverlay.setSelected(false);
                    if (PointColumn.this.prevDataMiningFunction != PointColumn.this.dataMiningFunction) {
                        PointColumn.this.prevDataMiningFunction = PointColumn.this.dataMiningFunction;
                        this.pc.drawExtraColumn = true;
                    }
                    PointColumn.this.dataMiningFunction = 4;
                }
            } else if (source == this.bOverlay) {
                if (this.bOverlay.isSelected()) {
                    this.pc.prevExtraColumnHeaderName = this.pc.extraColumnHeaderName;
                    this.pc.extraColumnHeaderName = "Rate of change";
                    this.bRateOfChange.setSelected(false);
                    this.bFrequency.setSelected(false);
                    this.bMaximum.setSelected(false);
                    this.bMinimum.setSelected(false);
                    this.bAverage.setSelected(false);
                    PointColumn.this.drawMyOverlay = true;
                    if (PointColumn.this.prevDataMiningFunction != PointColumn.this.dataMiningFunction) {
                        PointColumn.this.prevDataMiningFunction = PointColumn.this.dataMiningFunction;
                        this.pc.drawExtraColumn = true;
                    }
                    PointColumn.this.dataMiningFunction = 5;
                } else {
                    PointColumn.this.drawMyOverlay = false;
                }
            } else if (source == this.tickRect) {
                this.pc.pointType = 1;
            } else if (source == this.tickRound) {
                this.pc.pointType = 2;
            } else if (source == this.tickTick) {
                this.pc.pointType = 3;
            } else if (source == this.bDrawScale) {
                this.pc.drawScale = this.bDrawScale.isSelected();
                this.doGraying();
            } else if (source == this.bFlip) {
                String maxRange;
                String minRange = this.tfMinWin.getText();
                if (minRange.contains(",")) {
                    minRange = minRange.replace(",", ".");
                }
                if ((maxRange = this.tfMaxWin.getText()).contains(",")) {
                    maxRange = maxRange.replace(",", ".");
                }
                this.tfMinWin.setText(maxRange);
                this.tfMaxWin.setText(minRange);
                this.pc.flipScale = this.bFlip.isSelected();
            }
        }
    }
}

