/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import gui.ErrorHandler;
import gui.ImageGenerator;
import gui.StringWrappingInfo;
import gui.TSCFont;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import path.ResPath;
import util.FileUtils;

public class PatternManager {
    public static final String patternsFilename = ResPath.getPath("svg.facies_patterns");
    public Map patterns = Collections.synchronizedMap(new HashMap());
    protected List patternUsageHolders = Collections.synchronizedList(new Vector());

    public void loadDefaultPatterns() {
        this.readPatternsFromSVG(patternsFilename, true);
    }

    public String[] getPatternNames() {
        Vector<String> names = new Vector<String>();
        for (String name : this.patterns.keySet()) {
            name = name.replace(" ", "").replace("_", "").toLowerCase();
            names.add(name);
        }
        Collections.sort(names);
        String[] ret = new String[names.size()];
        names.toArray(ret);
        return ret;
    }

    public String getPatternFill(String name) {
        Object p = this.patterns.get(name = name.replace(" ", "").replace("_", "").toLowerCase());
        if (p == null) {
            return "white";
        }
        this.updatePatternUsageHolders(name);
        return "url(#" + this.getSVGPatName(name) + ")";
    }

    public String getPatternStyle(String name) {
        Object p = this.patterns.get(name = name.replace(" ", "").replace("_", "").toLowerCase());
        if (p == null) {
            return "stroke-width: 0.5; stroke: black; fill: white;";
        }
        this.updatePatternUsageHolders(name);
        return "stroke-width: 0.5; stroke: black; fill: url(#" + this.getSVGPatName(name) + ");";
    }

    public void readPatterns(String filePath) {
        DOMParser parser = new DOMParser();
        try {
            parser.parse(filePath);
        }
        catch (SAXException se) {
            ErrorHandler.printException(se);
        }
        catch (IOException ioe) {
            ErrorHandler.printException(ioe);
        }
        Document document = parser.getDocument();
        Element root = document.getDocumentElement();
        NodeList nl = root.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nl.getLength(); ++nodeIndex) {
            String name;
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() != 1 || (name = node.getNodeName()).compareToIgnoreCase("lithologyPatterns") != 0) continue;
            NodeList pat_nl = node.getChildNodes();
            for (int patIndex = 0; patIndex < pat_nl.getLength(); ++patIndex) {
                String pat_name;
                Node pat_node = pat_nl.item(patIndex);
                if (pat_node.getNodeType() != 1 || (pat_name = pat_node.getNodeName()).compareToIgnoreCase("pattern") != 0) continue;
                this.readPattern((Element)pat_node);
            }
        }
    }

    public void readPatternsFromSVG(String filePath, boolean jar) {
        DOMParser parser = new DOMParser();
        try {
            parser.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            InputStream is = jar ? FileUtils.getInputStream(filePath) : new FileInputStream(filePath);
            parser.parse(new InputSource(is));
        }
        catch (SAXException se) {
            ErrorHandler.showError(se, null, "Error parsing SVG", 3);
            return;
        }
        catch (IOException ioe) {
            ErrorHandler.showError(ioe, null, "Error parsing SVG", 3);
            return;
        }
        catch (Exception e) {
            ErrorHandler.showError(e, null, "Error parsing SVG", 3);
            return;
        }
        Document document = parser.getDocument();
        Element root = document.getDocumentElement();
        this.scavangePatternsFromNode(root);
    }

    protected void scavangePatternsFromNode(Node rootNode) {
        NodeList nl = rootNode.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nl.getLength(); ++nodeIndex) {
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() != 1) continue;
            String tagName = node.getNodeName();
            if (tagName.compareToIgnoreCase("pattern") == 0) {
                this.readPattern((Element)node);
                continue;
            }
            this.scavangePatternsFromNode(node);
        }
    }

    public void readPattern(Element p) {
        String name = p.getAttribute("id");
        this.patterns.put(this.getHumanPatName(name), p);
    }

    public String getSVGPatName(String humanName) {
        String ret = humanName.replaceAll("\\)", "_x29_");
        ret = ret.replaceAll("\\(", "_x28_");
        ret = ret.replace(" ", "").replace("_", "").toLowerCase();
        return ret;
    }

    public String getHumanPatName(String svgName) {
        String name = svgName.replaceAll("_x28_", "(");
        name = name.replaceAll("_x29_", ")");
        name = name.replace(" ", "").replace("_", "").toLowerCase();
        return name;
    }

    public Set getPatternUsageHolder() {
        TreeSet ret = new TreeSet();
        this.patternUsageHolders.add(ret);
        return ret;
    }

    public void updatePatternUsageHolders(String patName) {
        Iterator iter = this.patternUsageHolders.iterator();
        while (iter.hasNext()) {
            ((Set)iter.next()).add(patName);
        }
    }

    public void writePatternsToIG(ImageGenerator ig) {
        for (Map.Entry entry : this.patterns.entrySet()) {
            Element pat = (Element)entry.getValue();
            String name = entry.getKey().toString();
            if (name == null || name.length() == 0) continue;
            pat.setAttribute("id", this.getSVGPatName(name));
            ig.addPattern(pat);
        }
    }

    public void writePatternsToIG(ImageGenerator ig, Set patternUsageHolder) {
        Iterator iter = patternUsageHolder.iterator();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            Element pat = (Element)this.patterns.get(name);
            if (pat == null) continue;
            pat.setAttribute("id", this.getSVGPatName(name));
            ig.addPattern(pat);
        }
        this.patternUsageHolders.remove(patternUsageHolder);
    }

    public SVGDocument generatePatternList() {
        int i;
        ImageGenerator ig = new ImageGenerator(null, null, this);
        this.writePatternsToIG(ig);
        int BOX_WIDTH = 200;
        int BOX_HEIGHT = 200;
        int MARGIN_Y = 5;
        int MARGIN_X = 5;
        int MARGIN_BOX_TEXT = 5;
        String[] patternNames = this.getPatternNames();
        StringWrappingInfo[] swi = new StringWrappingInfo[patternNames.length];
        TSCFont font = new TSCFont("Arial", 0, 12.0, Color.BLACK);
        double maxWidth = 0.0;
        for (i = 0; i < patternNames.length; ++i) {
            swi[i] = ig.getSWIOneLine(patternNames[i], font, 1, null);
            double width = swi[i].getWidth();
            if (!(width > maxWidth)) continue;
            maxWidth = width;
        }
        ig.setCanvasSize((double)(MARGIN_X + BOX_WIDTH + MARGIN_BOX_TEXT) + maxWidth + (double)MARGIN_X, swi.length * (BOX_HEIGHT + MARGIN_Y));
        for (i = 0; i < swi.length; ++i) {
            double y = i * (BOX_HEIGHT + MARGIN_Y);
            ig.drawRect(MARGIN_X, y, BOX_WIDTH, BOX_HEIGHT, this.getPatternStyle(patternNames[i]));
            ig.drawString(swi[i], MARGIN_X + BOX_WIDTH + MARGIN_BOX_TEXT, y, swi[i].getWidth(), BOX_HEIGHT, 2);
        }
        return ig.getDocument();
    }
}

