/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.SequenceColumn;
import model.SequenceData;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class SequenceDataStorage
extends DataStorage {
    public static void insert(SequenceData data) {
        Query query = new Query("INSERT INTO #.sequence_data       (id, data_id, sequence_columns_id, label, sequence_boundry,         severity, deleted)       VALUES (NULL, :data_id, :sequence_column_id, :label,         :sequence_boundry, :severity, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("sequence_column_id", data.getColumn().getIdentifier().getId());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setBoolean("sequence_boundry", data.isSequenceBoundry());
        query.setString("severity", data.getSeverity());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(SequenceData data) {
        Query query = new Query("UPDATE #.sequence_data       SET sequence_columns_id = :sequence_column_id,         label = :label, sequence_boundry = :sequence_boundry,         severity = :severity       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getDataIdentifier().getId());
        query.setInt("sequence_column_id", data.getColumn().getIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setBoolean("sequence_boundry", data.isSequenceBoundry());
        query.setString("severity", data.getSeverity());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT label, sequence_boundry, severity,                      deleted, last_modified, creation_date             FROM #.sequence_data             WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(SequenceColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.sequence_data as seqdata ON ( data.id = seqdata.data_id )       WHERE seqdata.sequence_columns_id = :sequence_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted        AND NOT seqdata.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("sequence_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

