/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.FaciesData;
import model.ModelIdentifier;
import model.storage.FaciesColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class FaciesColumn
extends Column {
    private ModelIdentifier identifier = null;
    private double seriesWidth = 0.0;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public FaciesColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 10));
    }

    public FaciesColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setSeriesWidth(result.getDouble("series_width"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            FaciesColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            FaciesColumnStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public final void setSeriesWidth(double seriesWidth) {
        this.seriesWidth = seriesWidth;
    }

    public List<FaciesData> getDataByAge(double top, double bottom) {
        return FaciesData.Factory.getByAge(this, top, bottom);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static List<FaciesColumn> getByTitle(String title) {
            List<SourceResult> results = FaciesColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 10);
            return Factory.getByIdentifiers(ids);
        }

        public static FaciesColumn getByIdentifier(ModelIdentifier id) {
            List<Object> faciesColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            faciesColumns = Factory.getByIdentifiers(ids);
            if (faciesColumns.isEmpty()) {
                return null;
            }
            return (FaciesColumn)faciesColumns.get(0);
        }

        public static List<FaciesColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<FaciesColumn> faciesColumns = new ArrayList<FaciesColumn>();
            List<SourceResult> results = FaciesColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                faciesColumns.add(new FaciesColumn(ids.get(i), results.get(i)));
            }
            return faciesColumns;
        }
    }
}

