/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.ModelIdentifier;
import model.storage.BlankColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class BlankColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public BlankColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 3));
    }

    public BlankColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            BlankColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            BlankColumnStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static List<BlankColumn> getByTitle(String title) {
            List<SourceResult> results = BlankColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 3);
            return Factory.getByIdentifiers(ids);
        }

        public static BlankColumn getByIdentifier(ModelIdentifier id) {
            List<Object> blockColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            blockColumns = Factory.getByIdentifiers(ids);
            if (blockColumns.isEmpty()) {
                return null;
            }
            return (BlankColumn)blockColumns.get(0);
        }

        public static List<BlankColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<BlankColumn> blockColumns = new ArrayList<BlankColumn>();
            List<SourceResult> results = BlankColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                blockColumns.add(new BlankColumn(ids.get(i), results.get(i)));
            }
            return blockColumns;
        }
    }
}

