/*
 * Decompiled with CFR 0.152.
 */
package gui.transect;

import datastore.PatternManager;
import datastore.TransectColumn;
import gui.ActionDialog;
import gui.ExtensionFileFilter;
import gui.ImageGenerator;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.TSCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.svg.SVGDocument;
import util.FileUtils;
import util.Point;
import util.Util;

public class TemplateGen
extends JDialog
implements ActionListener {
    private JPanel dims;
    private JButton bCancel;
    private JLabel jLabel2;
    private JLabel usage;
    private JTextField tBaseAge;
    private JLabel jLabel1;
    private JPanel buttons;
    private JTextField tTopAge;
    private JButton bSave;
    public static boolean forTemplateGen = false;

    public TemplateGen(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Transect Template Generator");
            this.dims = new JPanel();
            GridBagLayout dimsLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.dims, "Center");
            this.dims.setBorder(BorderFactory.createTitledBorder("Options"));
            dimsLayout.rowWeights = new double[]{0.1, 0.1, 1.0};
            dimsLayout.rowHeights = new int[]{7, 7, 7};
            dimsLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 1.0};
            dimsLayout.columnWidths = new int[]{7, 7, 65, 7};
            this.dims.setLayout(dimsLayout);
            this.tTopAge = new JTextField();
            this.dims.add((Component)this.tTopAge, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tTopAge.setText("0");
            this.jLabel1 = new JLabel();
            this.dims.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Top Age:");
            this.jLabel2 = new JLabel();
            this.dims.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Base Age:");
            this.tBaseAge = new JTextField();
            this.dims.add((Component)this.tBaseAge, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tBaseAge.setText("100");
            this.usage = new JLabel();
            this.dims.add((Component)this.usage, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.usage.setText("<html>Edit the generated SVG template file in any SVG editor to create a Transect Column.<br>Simply add polygons using patterns/swatches built into the template. The polygons should be entirely within the red clipping rectangle.<br><ul><li>You may edit the text (Top Age, etc) provided the \"Top Age:\", etc part remains</li><li>You may move/resize the red clipping rectangle</li><li>Do not overlap polygons unless one polygon is meant to be entirely within another.</li><li>Only add polygons, other shapes are ignored</li><li>Only the polygons' points and fill matters, any other attributes are ignored.</li><li>If two points are close to each other, TSCreator will merge them. This ensures there are no unwanted gaps or slight overlapping.</li></ul>You may also add text labels. The text size and positioning will be kept as faithfully as possible, but font face will be lost. Please avoid multi-line text boxes.</html>");
            this.buttons = new JPanel();
            this.getContentPane().add((Component)this.buttons, "South");
            GridBagLayout buttonsLayout = new GridBagLayout();
            buttonsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            buttonsLayout.rowHeights = new int[]{7, -1, 7, -1};
            buttonsLayout.columnWeights = new double[]{1.0, 0.1, 0.1};
            buttonsLayout.columnWidths = new int[]{7, 7, 7};
            this.buttons.setLayout(buttonsLayout);
            this.bCancel = new JButton();
            this.buttons.add((Component)this.bCancel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bCancel.setText("Cancel");
            this.bCancel.addActionListener(this);
            this.bSave = new JButton();
            this.buttons.add((Component)this.bSave, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bSave.setText("Save Template As...");
            this.bSave.addActionListener(this);
            this.setSize(607, 419);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.bCancel) {
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.bSave) {
            int returnVal;
            double base;
            double top = Util.parseDouble(this.tTopAge.getText(), 0.0);
            if (top > (base = Util.parseDouble(this.tBaseAge.getText(), 0.0))) {
                double temp = top;
                top = base;
                base = temp;
            }
            SVGDocument doc = this.generateTemplate(top, base);
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription("SVG file (*.svg)");
            eff.addExtension("svg", true);
            chooser.setFileFilter(eff);
            if (TSCreator.fileChooserPath != null) {
                chooser.setCurrentDirectory(TSCreator.fileChooserPath);
            }
            if ((returnVal = chooser.showSaveDialog(this)) == 0) {
                ActionDialog ad = new ActionDialog("Saving Transect Template SVG...");
                ad.setVisible(true);
                String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "svg");
                TSCreator.fileChooserPath = chooser.getCurrentDirectory();
                try {
                    OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath), "UTF-8");
                    ImageGenerator.write(doc, fw);
                    fw.close();
                    ad.setVisible(false);
                    this.setVisible(false);
                    this.dispose();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Error writing template SVG", 0);
                }
                catch (OutOfMemoryError oome) {
                    JOptionPane.showMessageDialog(this, "Out of memory!", "Error writing template SVG", 0);
                }
            }
        }
    }

    public SVGDocument generateTemplate(double topAge, double baseAge) {
        PatternManager patMan = TSCreator.db.patMan;
        ImageGenerator ig = new ImageGenerator(null, null, patMan);
        patMan.writePatternsToIG(ig);
        TransectColumn templateCol = new TransectColumn("");
        int BOX_WIDTH = 200;
        int SVG_PER_AGE = 2;
        int MARGIN = 10;
        int TEXT_MARGIN = 5;
        int LINE_SAMPLE_LENGTH = 30;
        double boxHeight = (baseAge - topAge) * (double)SVG_PER_AGE;
        TSCFont font = new TSCFont("Arial", 0, 12.0, Color.BLACK);
        double maxWidth = BOX_WIDTH;
        double y = MARGIN;
        StringWrappingInfo swi = ig.getSWIOneLine("Top Age: " + topAge, font, 1, null);
        ig.drawString(swi, MARGIN, y, swi.getWidth(), swi.getHeight(), 3);
        maxWidth = Math.max(swi.getWidth(), maxWidth);
        y += swi.getHeight() + (double)TEXT_MARGIN;
        swi = ig.getSWIOneLine("Base Age: " + baseAge, font, 1, null);
        ig.drawString(swi, MARGIN, y, swi.getWidth(), swi.getHeight(), 3);
        maxWidth = Math.max(swi.getWidth(), maxWidth);
        ig.drawRect(MARGIN, y += swi.getHeight() + (double)TEXT_MARGIN, BOX_WIDTH, boxHeight, "stroke: red; stroke-width: 1; fill: none;");
        swi = ig.getSWIOneLine("To show unconformities, cross copies of the following lines", font, 1, null);
        ig.drawString(swi, MARGIN, y += boxHeight + (double)TEXT_MARGIN, swi.getWidth(), swi.getHeight(), 3);
        maxWidth = Math.max(swi.getWidth(), maxWidth);
        y += swi.getHeight() + (double)TEXT_MARGIN;
        swi = ig.getSWIOneLine("with the unconformity. Rotate/scale ok.", font, 1, null);
        ig.drawString(swi, MARGIN, y, swi.getWidth(), swi.getHeight(), 3);
        maxWidth = Math.max(swi.getWidth(), maxWidth);
        y += swi.getHeight() + (double)(TEXT_MARGIN * 2);
        swi = ig.getSWIOneLine("Interfingering: ", font, 1, null);
        ig.drawString(swi, MARGIN, y, swi.getWidth(), swi.getHeight(), 3);
        maxWidth = Math.max(swi.getWidth(), maxWidth);
        double linesX = (double)MARGIN + swi.getWidth() + (double)TEXT_MARGIN;
        double interfingerY = y + swi.getHeight() / 2.0;
        y += swi.getHeight() + (double)TEXT_MARGIN;
        swi = ig.getSWIOneLine("Wavy: ", font, 1, null);
        ig.drawString(swi, MARGIN, y, swi.getWidth(), swi.getHeight(), 3);
        maxWidth = Math.max(swi.getWidth(), maxWidth);
        linesX = Math.max(linesX, (double)MARGIN + swi.getWidth() + (double)TEXT_MARGIN);
        double wavyY = y + swi.getHeight() / 2.0;
        y += swi.getHeight() + (double)TEXT_MARGIN;
        double width = (double)(2 * MARGIN) + maxWidth;
        double height = y += (double)MARGIN;
        ig.setCanvasSize(width, height);
        double xFactor = (double)(templateCol.xHigh - templateCol.xLow) / width;
        double xAdd = templateCol.xLow;
        TransectColumn transectColumn = templateCol;
        Objects.requireNonNull(transectColumn);
        TransectColumn.Line interfingerLine = transectColumn.new TransectColumn.Line(new Point(linesX * xFactor + xAdd, interfingerY), new Point((linesX + (double)LINE_SAMPLE_LENGTH) * xFactor + xAdd, interfingerY), "lapping");
        interfingerLine.amplitude /= 2.0;
        TransectColumn transectColumn2 = templateCol;
        Objects.requireNonNull(transectColumn2);
        TransectColumn.Line wavyLine = transectColumn2.new TransectColumn.Line(new Point(linesX * xFactor + xAdd, wavyY), new Point((linesX + (double)LINE_SAMPLE_LENGTH) * xFactor + xAdd, wavyY), "wavy");
        Settings settings = new Settings(null);
        settings.topAge = 0.0;
        settings.baseAge = height;
        settings.unitsPerMY = 1.0;
        forTemplateGen = true;
        TransectColumn.Line[] lines = new TransectColumn.Line[]{interfingerLine, wavyLine};
        for (int i = 0; i < lines.length; ++i) {
            lines[i].generatePoints(ig, 0.0, 0.0, width, height, settings);
            lines[i].draw(ig, 0.0, 0.0, width, height, settings, "fill: none; stroke: black; stroke-width: 1;");
        }
        forTemplateGen = false;
        return ig.getDocument();
    }
}

