/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import gui.ModifyTextField;
import gui.editor.SpreadSheet;
import gui.editor.SpreadSheetTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import path.ResPath;
import util.FileUtils;

public class SpreadSheetBar
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton bAccept;
    JButton bCancel;
    JButton bEqual;
    ModifyTextField tText;
    SpreadSheet sheet = null;
    SpreadSheetTableModel dm = null;
    int row;
    int col;
    Object originalValue = null;

    public SpreadSheetBar() {
        this.setLayout(new BorderLayout());
        this.tText = new ModifyTextField(true, true);
        this.add((Component)this.tText, "Center");
        this.tText.addActionListener(this);
        JToolBar buttons = new JToolBar(0);
        this.bAccept = new JButton(FileUtils.getImageIcon(ResPath.getPath("icons.checkmark")));
        this.bCancel = new JButton(FileUtils.getImageIcon("icons.x"));
        this.bEqual = new JButton(FileUtils.getImageIcon("icons.fx"));
        this.bAccept.setToolTipText("Accept new text");
        this.bCancel.setToolTipText("Cancel any changes to text");
        this.bEqual.setToolTipText("Make cell dependent on another cell");
        this.bAccept.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bEqual.addActionListener(this);
        buttons.add(this.bAccept);
        buttons.add(this.bCancel);
        buttons.setFloatable(false);
        buttons.setBorder(null);
        this.tText.setDefaultButton(this.bAccept);
        this.add((Component)buttons, "West");
        this.clear();
    }

    public final void clear() {
        this.bAccept.setEnabled(false);
        this.bCancel.setEnabled(false);
        this.bEqual.setEnabled(false);
        this.tText.setText(null);
        this.tText.setEnabled(false);
        this.sheet = null;
        this.dm = null;
    }

    public void setValue(SpreadSheet sheet, SpreadSheetTableModel dm, int row, int col) {
        if (row < 0 || col < 0) {
            this.clear();
            return;
        }
        this.sheet = sheet;
        this.dm = dm;
        this.row = row;
        this.col = col;
        this.bAccept.setEnabled(true);
        this.bCancel.setEnabled(true);
        this.bEqual.setEnabled(false);
        this.tText.setEnabled(true);
        Object value = dm.getValueAt(row, col);
        String text = null;
        if (value != null) {
            text = value.toString();
        }
        this.originalValue = value;
        this.tText.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.tText) {
            String text = this.tText.getText();
            if (this.dm != null) {
                this.dm.setValueAt(text, this.row, this.col);
            }
        } else if (source == this.bAccept) {
            if (this.sheet != null) {
                this.sheet.requestFocus();
            }
        } else if (source == this.bCancel) {
            String text = null;
            if (this.originalValue != null) {
                text = this.originalValue.toString();
            }
            this.tText.setText(text);
            if (this.dm != null) {
                this.dm.setValueAt(this.originalValue, this.row, this.col);
            }
            if (this.sheet != null) {
                this.sheet.requestFocus();
            }
        } else if (source == this.bEqual) {
            // empty if block
        }
    }
}

