/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Objects;
import javax.swing.JScrollBar;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.w3c.dom.svg.SVGDocument;

public class TSCSVGScrollPane
extends JSVGScrollPane
implements MouseListener,
MouseMotionListener,
AdjustmentListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private static final Color LINE_COLOR = new Color(255, 0, 0, 100);
    private static final Stroke STROKE = new BasicStroke(3.0f);
    private int mouseX;
    private int mouseY;
    private boolean fixLine;
    private int verticalScrollBarAdjustmentValue;
    private boolean retainZoom = false;
    private int previousVerticalPosition = 0;
    private int previousHorizontalPosition = 0;
    private Dimension2D previousSize;

    public TSCSVGScrollPane(JSVGCanvas c) {
        super(c);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                TSCSVGScrollPane.this.recenter();
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.canvas.addMouseWheelListener(this);
        this.vertical.addMouseWheelListener(this);
        this.horizontal.addMouseWheelListener(this);
        this.vertical.addAdjustmentListener(this);
        this.verticalScrollBarAdjustmentValue = 0;
    }

    public void zoomBy(double factor) {
        JSVGCanvas jSVGCanvas = this.canvas;
        Objects.requireNonNull(jSVGCanvas);
        JSVGCanvas.ZoomAction a = new JSVGCanvas.ZoomAction(jSVGCanvas, factor);
        a.actionPerformed(null);
        if (factor < 1.0) {
            this.recenter();
        }
        this.fixLine = false;
        this.repaint();
    }

    public void resetTransform() {
        AffineTransform at = this.canvas.getViewingTransform();
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
        }
        catch (NullPointerException npe) {
            at = new AffineTransform();
        }
        this.canvas.setRenderingTransform(at);
    }

    public void retainZoom(boolean retainZoom) {
        this.previousVerticalPosition = this.vertical.getValue();
        this.previousHorizontalPosition = this.horizontal.getValue();
        this.previousSize = this.getImageBounds().getSize();
        this.retainZoom = retainZoom;
    }

    public void zoomToPreviousZoom() {
        Dimension canvasDim = this.getSize();
        double sx = this.previousSize.getWidth() / (double)canvasDim.width;
        double sy = this.previousSize.getHeight() / (double)canvasDim.height;
        double scale = Math.max(sx, sy);
        this.zoomBy(scale);
        this.horizontal.setValue(this.previousHorizontalPosition);
        this.vertical.setValue(this.previousVerticalPosition);
    }

    public void zoomToFit() {
        SVGDocument doc;
        this.resetTransform();
        Dimension canvasDim = this.getSize();
        Dimension docSize = this.getImageBounds().getSize();
        double sx = (double)canvasDim.width / ((Dimension2D)docSize).getWidth();
        double sy = (double)canvasDim.height / ((Dimension2D)docSize).getHeight();
        double scale = Math.min(sx, sy);
        this.zoomBy(scale);
        if (scale >= 1.0) {
            this.recenter();
        }
        if ((doc = this.canvas.getSVGDocument()) != null) {
            doc.getDocumentElement().setAttribute("doc-scale", Double.toString(scale));
        }
    }

    public Rectangle getImageBounds() {
        this.checkAndSetViewBoxRect();
        if (this.viewBox == null) {
            return this.getBounds();
        }
        AffineTransform crt = this.canvas.getRenderingTransform();
        AffineTransform vbt = this.canvas.getViewBoxTransform();
        if (crt == null) {
            crt = new AffineTransform();
        }
        if (vbt == null) {
            vbt = new AffineTransform();
        }
        return vbt.createTransformedShape(this.viewBox).getBounds();
    }

    public void recenter() {
        int shouldBe;
        Rectangle img = this.getImageBounds();
        Dimension canvasDim = this.canvas.getSize();
        double translateX = 0.0;
        double translateY = 0.0;
        if (img.width < canvasDim.width) {
            shouldBe = (canvasDim.width - img.width) / 2;
            translateX = shouldBe - img.x;
        } else if (img.x > 0) {
            translateX = -img.x;
        } else if (img.x + img.width < canvasDim.width) {
            translateX = canvasDim.width - img.x - img.width;
        }
        if (img.height < canvasDim.height) {
            shouldBe = (canvasDim.height - img.height) / 2;
            translateY = shouldBe - img.y;
        } else if (img.y > 0) {
            translateY = -img.y;
        } else if (img.y + img.height < canvasDim.height) {
            translateY = canvasDim.height - img.y - img.height;
        }
        AffineTransform at = this.canvas.getRenderingTransform();
        at.preConcatenate(AffineTransform.getTranslateInstance(translateX, translateY));
        this.canvas.setRenderingTransform(at);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            // empty if block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar sb;
        JScrollBar jScrollBar = sb = (e.getSource() == this.vertical || e.getSource() == this.canvas) && this.vertical.isVisible() ? this.vertical : this.horizontal;
        if (e.getScrollType() == 0) {
            int amt = e.getUnitsToScroll() * sb.getUnitIncrement();
            sb.setValue(sb.getValue() + amt);
        } else if (e.getScrollType() == 1) {
            int amt = e.getWheelRotation() * sb.getBlockIncrement();
            sb.setValue(sb.getValue() + amt);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        this.verticalScrollBarAdjustmentValue -= ae.getValue();
        this.mouseY += this.verticalScrollBarAdjustmentValue;
        this.verticalScrollBarAdjustmentValue = ae.getValue();
        this.repaint();
    }
}

