/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ImageSizeDialog;
import gui.ModifyTextField;
import gui.TSCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.svg.SVGDocument;
import util.Util;

public class RasterSave
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton cancel;
    private JButton ok;
    private JPanel buttons;
    private JLabel resL;
    private ModifyTextField dpiTF;
    private JRadioButton specifyDPI;
    private JLabel dpiInfo;
    private ModifyTextField zoomTF;
    private JRadioButton p100;
    private JRadioButton specifyZoom;
    private JPanel radioPanel;
    private ButtonGroup radioGroup;
    protected double currentZoom;
    protected RasterSaveOptions rso = new RasterSaveOptions();
    TSCreator saver;
    protected ImageSizeDialog.ImageInfo imageInfo;

    public RasterSave(JFrame parent, SVGDocument doc, double currentZoom, TSCreator saver) {
        super(parent);
        this.saver = saver;
        this.currentZoom = currentZoom;
        this.imageInfo = new ImageSizeDialog.ImageInfo(doc);
        this.setTitle("Bitmap options");
        this.radioGroup = new ButtonGroup();
        this.setResizable(false);
        BorderLayout thisLayout = new BorderLayout();
        this.getContentPane().setLayout(thisLayout);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.radioPanel = new JPanel();
        GridBagLayout dpiLayout = new GridBagLayout();
        dpiLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
        dpiLayout.rowHeights = new int[]{7, 7, 7, 20, 20, 7};
        dpiLayout.columnWeights = new double[]{0.1, 1.0};
        dpiLayout.columnWidths = new int[]{7, 7};
        this.getContentPane().add((Component)this.radioPanel, "Center");
        this.radioPanel.setBorder(BorderFactory.createTitledBorder(null, "Resolution of bitmap image", 4, 2));
        this.radioPanel.setLayout(dpiLayout);
        this.specifyZoom = new JRadioButton();
        this.radioPanel.add((Component)this.specifyZoom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.specifyZoom.setText("Specify Scale Factor %:");
        this.radioGroup.add(this.specifyZoom);
        this.specifyZoom.addActionListener(this);
        this.p100 = new JRadioButton();
        this.radioPanel.add((Component)this.p100, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.p100.setText("Full Size (100%)");
        this.p100.setSelected(true);
        this.radioGroup.add(this.p100);
        this.p100.addActionListener(this);
        this.specifyDPI = new JRadioButton();
        this.radioPanel.add((Component)this.specifyDPI, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.specifyDPI.setText("Specify DPI: ");
        this.radioGroup.add(this.specifyDPI);
        this.specifyDPI.addActionListener(this);
        this.dpiTF = new ModifyTextField();
        this.radioPanel.add((Component)this.dpiTF, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.dpiTF.setColumns(5);
        this.dpiTF.setText("300");
        this.dpiTF.setEnabled(false);
        this.dpiTF.addActionListener(this);
        this.resL = new JLabel();
        this.radioPanel.add((Component)this.resL, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.resL.setText("bitmap size: 0 x 0");
        this.zoomTF = new ModifyTextField();
        this.radioPanel.add((Component)this.zoomTF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.zoomTF.setText("200");
        this.zoomTF.setEnabled(false);
        this.zoomTF.addActionListener(this);
        this.dpiInfo = new JLabel();
        this.radioPanel.add((Component)this.dpiInfo, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dpiInfo.setText("<html>DPI uses physical dimensions<br>which you can view/change<br>using the Image->Image Size<br>menu item.</html>");
        this.buttons = new JPanel();
        GridBagLayout buttonsLayout = new GridBagLayout();
        buttonsLayout.rowWeights = new double[]{0.1};
        buttonsLayout.rowHeights = new int[]{7};
        buttonsLayout.columnWeights = new double[]{1.0, 0.1, 0.1};
        buttonsLayout.columnWidths = new int[]{7, 7, 7};
        this.getContentPane().add((Component)this.buttons, "South");
        this.buttons.setLayout(buttonsLayout);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ok = new JButton();
        this.buttons.add((Component)this.ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.ok.setText("Save");
        this.ok.addActionListener(this);
        this.cancel = new JButton();
        this.buttons.add((Component)this.cancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(this);
        this.updateImageSize();
        this.pack();
        this.setSize(298, 299);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.specifyZoom) {
            this.zoomTF.setEnabled(this.specifyZoom.isSelected());
            this.dpiTF.setEnabled(this.specifyDPI.isSelected());
            this.updateImageSize();
        } else if (evt.getSource() == this.p100) {
            this.zoomTF.setEnabled(this.specifyZoom.isSelected());
            this.dpiTF.setEnabled(this.specifyDPI.isSelected());
            this.updateImageSize();
        } else if (evt.getSource() == this.specifyDPI) {
            this.zoomTF.setEnabled(this.specifyZoom.isSelected());
            this.dpiTF.setEnabled(this.specifyDPI.isSelected());
            this.updateImageSize();
        } else if (evt.getSource() == this.ok) {
            this.dispose();
            this.saver.save("RASTER", this.rso);
        } else if (evt.getSource() == this.cancel) {
            this.dispose();
        } else {
            this.updateImageSize();
        }
    }

    public final void updateImageSize() {
        if (this.specifyZoom.isSelected()) {
            double zoom = Util.parseDoubleLax(this.zoomTF.getText(), 200.0);
            this.rso.width = (int)Math.ceil(this.imageInfo.svgWidth * zoom / 100.0);
            this.rso.height = (int)Math.ceil(this.imageInfo.svgHeight * zoom / 100.0);
        } else if (this.p100.isSelected()) {
            this.rso.width = (int)Math.ceil(this.imageInfo.svgWidth);
            this.rso.height = (int)Math.ceil(this.imageInfo.svgHeight);
        } else if (this.specifyDPI.isSelected()) {
            this.imageInfo.convertTo(2);
            double dpi = Util.parseDoubleLax(this.dpiTF.getText(), 300.0);
            this.rso.width = (int)Math.ceil(this.imageInfo.unitWidth * dpi);
            this.rso.height = (int)Math.ceil(this.imageInfo.unitHeight * dpi);
        }
        this.resL.setText("Bitmap size: " + this.rso.width + " x " + this.rso.height);
    }

    public static class RasterSaveOptions {
        public int width;
        public int height;
    }
}

