/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.ages.AgeConverter;
import datastore.loader.ParseException;
import gui.ImageGenerator;
import gui.RichText;
import gui.SVGStyleParser;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.transect.TemplateGen;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.Geom;
import util.NumberUtils;
import util.Point;
import util.Util;
import util.Vector2D;

public class TransectColumn
extends DataColumn {
    public static final int LINESPACING = 10;
    public static final int CLIPPINGMARGIN = 10;
    public static final int CLIPPINGMARGIN_STRAIGHT = 2;
    public static final Color LINE_INTERSECT_ERROR_COLOR = new Color(255, 0, 0);
    public static final Color THREE_SIDED_LINE_ERROR_COLOR = new Color(255, 180, 0);
    public static final Color ONE_SIDED_LINE_ERROR_COLOR = new Color(0, 230, 0);
    public static final int KEEP_ORIGINAL_FONT = 1;
    public static final int KEEP_FONT_PROPORTIONS = 2;
    public int textSize = 2;
    public Vector points = new Vector();
    public Vector lines = new Vector();
    public Vector polygons = new Vector();
    public Vector textLabels = new Vector();
    public int xLow = 0;
    public int xHigh = 100;
    protected boolean drawErrors = false;
    public boolean drawPopupIDs = false;
    protected int lastPolygonID = 1;
    protected int errorStringOffset;

    public TransectColumn(String colName) {
        super(colName);
        this.setColor(new Coloring(Color.white));
        this.setWidth(300.0);
    }

    public void setParsedGrid(Vector grid, Vector xtraPolys, int lineOfXRow) throws ParseException {
        this.points.clear();
        this.polygons.clear();
        this.errorStringOffset = lineOfXRow;
        Object[][] polyGrid = this.normalizeGrid(grid);
        HashMap<String, GridPoint> pointIds = new HashMap<String, GridPoint>();
        double[] xLine = this.getXLine(grid);
        Vector ageCol = this.getAges(grid);
        Vector<GridPoint> foundPolyLabels = new Vector<GridPoint>();
        for (int row = 1; row < grid.size(); ++row) {
            Vector line = (Vector)grid.get(row);
            double curAge = (Double)ageCol.get(row);
            for (int col = 2; col < line.size(); ++col) {
                GridPoint p;
                Object o = line.get(col);
                if (o == null) {
                    o = "";
                }
                String cell = o.toString().trim();
                String cellType = "";
                if (cell.length() > 0) {
                    cellType = "" + cell.toUpperCase().charAt(0);
                    if (cell.length() > 1 && Character.isLetter(cell.charAt(1))) {
                        cellType = cell;
                    }
                }
                if (cellType.equals("X")) {
                    String id;
                    p = new GridPoint(0, 0, row, col);
                    p.y = curAge;
                    p.x = xLine[col];
                    if (cell.length() > 1 && (id = cell.substring(1).trim()).length() > 0) {
                        pointIds.put(id, p);
                    }
                    this.points.add(p);
                    polyGrid[row][col] = p;
                    continue;
                }
                if (cellType.equals("L")) {
                    GridLine l = new GridLine(cell);
                    l.loc = new GridPoint(0, 0, row, col);
                    polyGrid[row][col] = l;
                    continue;
                }
                if (cell.length() <= 0) continue;
                p = new GridPoint(0, 0, row, col);
                foundPolyLabels.add(p);
            }
        }
        for (GridPoint labelLoc : foundPolyLabels) {
            Polygon poly;
            if (polyGrid[labelLoc.row][labelLoc.col] != null || (poly = this.expandPolygon(grid, polyGrid, labelLoc.row, labelLoc.col)) == null) continue;
            this.polygons.add(poly);
        }
        if (xtraPolys != null) {
            this.readExtraPolygons(xtraPolys, pointIds);
        }
    }

    protected String getCellColString(int col) {
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String alphaCol = "";
        int col2 = col;
        while (col2 > 0) {
            int remainder = col2 % 26;
            alphaCol = alphabet.charAt(remainder) + alphaCol;
            col2 = (col2 - remainder) / 26;
        }
        return "column " + (col + 1) + " (" + alphaCol + ")";
    }

    protected String getCellRowString(int row) {
        return "line " + (this.errorStringOffset + row);
    }

    protected String getCellString(int row, int col) {
        return "line " + (this.errorStringOffset + row) + " " + this.getCellColString(col);
    }

    protected Object[][] normalizeGrid(Vector grid) {
        Vector line;
        int i;
        int maxLineSize = 0;
        for (i = 0; i < grid.size(); ++i) {
            line = (Vector)grid.get(i);
            if (line.size() <= maxLineSize) continue;
            maxLineSize = line.size();
        }
        for (i = 0; i < grid.size(); ++i) {
            line = (Vector)grid.get(i);
            line.setSize(maxLineSize);
        }
        return new Object[grid.size()][maxLineSize];
    }

    protected Polygon expandPolygon(Vector grid, Object[][] polyGrid, int startRow, int startCol) throws ParseException {
        Polygon poly = new Polygon();
        String style = TransectColumn.getStringAt(grid, startRow, startCol);
        if (style == null) {
            throw new ParseException("This error shouldn't happen: Empty style at " + this.getCellString(startRow, startCol));
        }
        poly.setStyle(style);
        int rows = polyGrid.length;
        int cols = polyGrid[0].length;
        Object[][] border = new Object[rows][cols];
        GridPoint startingPoint = null;
        int[] rowdfull = new int[]{0, 0, 1, -1, 1, 1, -1, -1};
        int[] coldfull = new int[]{1, -1, 0, 0, 1, -1, 1, -1};
        int firstNonCross = 4;
        Vector<GridPoint> worklist = new Vector<GridPoint>();
        GridPoint p = new GridPoint(0, 0, startRow, startCol);
        worklist.add(p);
        while (worklist.size() > 0) {
            p = (GridPoint)worklist.remove(0);
            Object o = polyGrid[p.row][p.col];
            if (o == null) {
                polyGrid[p.row][p.col] = poly;
                for (int i = 0; i < rowdfull.length; ++i) {
                    int tRow = p.row + rowdfull[i];
                    int tCol = p.col + coldfull[i];
                    if (tRow < 1 || tRow >= rows || tCol < 2 || tCol >= cols || rowdfull[i] != 0 && coldfull[i] != 0 && (polyGrid[tRow][tCol] == null || !(polyGrid[tRow][tCol] instanceof GridPoint))) continue;
                    GridPoint newp = new GridPoint(0, 0, tRow, tCol);
                    worklist.add(newp);
                }
                continue;
            }
            if (o instanceof GridPoint) {
                if (startingPoint == null) {
                    startingPoint = (GridPoint)o;
                }
                border[p.row][p.col] = o;
                continue;
            }
            if (o instanceof GridLine) {
                border[p.row][p.col] = o;
                continue;
            }
            if (!(o instanceof Polygon) || o == poly) continue;
            Polygon otherPoly = (Polygon)o;
            throw new ParseException("clashing polygon styles. \"" + poly.originalStyle + "\" at " + this.getCellString(startRow, startCol) + " conflicts with \"" + otherPoly.originalStyle + "\" at " + this.getCellString(p.row, p.col));
        }
        if (startingPoint == null) {
            return null;
        }
        Vector<Object> borderWorklist = new Vector<Object>();
        borderWorklist.add(startingPoint);
        poly.genStart(startingPoint);
        String lineStyle = null;
        while (borderWorklist.size() > 0) {
            Object o = borderWorklist.remove(0);
            if (o == null) {
                throw new ParseException("This error shouldn't happen: border worklist item null");
            }
            if (o instanceof GridPoint || o instanceof GridLine) {
                if (o instanceof GridPoint) {
                    p = (GridPoint)o;
                    poly.genLineTo(p, lineStyle);
                    lineStyle = null;
                } else {
                    GridLine l = (GridLine)o;
                    p = l.loc;
                    if (lineStyle == null && l.style != null) {
                        lineStyle = l.style;
                    }
                }
                border[p.row][p.col] = null;
                int nextRow = -1;
                int nextCol = -1;
                int numFound = 0;
                for (int i = 0; i < rowdfull.length && (i != firstNonCross - 1 || nextRow == -1); ++i) {
                    int tRow = p.row + rowdfull[i];
                    int tCol = p.col + coldfull[i];
                    if (tRow < 1 || tRow >= rows || tCol < 2 || tCol >= cols || border[tRow][tCol] == null) continue;
                    if (i < firstNonCross) {
                        if (numFound > 1 && o != startingPoint || numFound > 2 && o == startingPoint) {
                            throw new ParseException("Transect grid formatting error in \"" + this.getName() + "\": at polygon \"" + poly.originalStyle + "\" border cell (" + this.getCellString(p.row, p.col) + ") has a choice conflict between (" + this.getCellString(nextRow, nextCol) + ") and (" + this.getCellString(tRow, tCol) + ")");
                        }
                        if (border[tRow][tCol] instanceof GridPoint || border[tRow][tCol] instanceof GridLine) {
                            nextRow = tRow;
                            nextCol = tCol;
                            ++numFound;
                        }
                    } else {
                        if (numFound > 1 && o != startingPoint || numFound > 2 && o == startingPoint) {
                            throw new ParseException("Transect grid formatting error in \"" + this.getName() + "\": at polygon \"" + poly.originalStyle + "\" border cell (" + this.getCellString(p.row, p.col) + ") has a choice conflict between (" + this.getCellString(nextRow, nextCol) + ") and (" + this.getCellString(tRow, tCol) + ")");
                        }
                        if (border[tRow][tCol] instanceof GridPoint || border[tRow][tCol] instanceof GridLine) {
                            nextRow = tRow;
                            nextCol = tCol;
                            ++numFound;
                        }
                    }
                    if (i == firstNonCross - 1 && nextRow != -1) break;
                }
                if (nextRow == -1) continue;
                borderWorklist.add(border[nextRow][nextCol]);
                continue;
            }
            throw new ParseException("This error shouldn't happen: border worklist item not a point or line: " + o.getClass());
        }
        poly.genClose(lineStyle);
        return poly;
    }

    protected void readExtraPolygons(Vector xtraPolys, Map pointIds) {
        for (GridPolygon gpoly : xtraPolys) {
            Polygon poly = new Polygon();
            poly.setStyle(gpoly.style);
            poly.popup = gpoly.popup;
            boolean started = false;
            Iterator lineIter = gpoly.lines.iterator();
            while (lineIter.hasNext()) {
                GridPolygon.GPLine l = (GridPolygon.GPLine)lineIter.next();
                GridPoint p1 = (GridPoint)pointIds.get(l.id1);
                GridPoint p2 = (GridPoint)pointIds.get(l.id2);
                if (p1 == null || p2 == null) {
                    if (p1 == null) {
                        System.out.println("p1 is null. p2=" + l.id2 + " style=" + l.style);
                    }
                    if (p2 != null) continue;
                    System.out.println("p2 is null. p1=" + l.id1 + " style=" + l.style);
                    continue;
                }
                if (!started) {
                    poly.genStart(p1);
                    started = true;
                }
                if (lineIter.hasNext()) {
                    poly.genLineTo(p2, l.style);
                    continue;
                }
                poly.genClose(l.style);
            }
            this.polygons.add(poly);
        }
    }

    public static String arrayToString(Object[][] a) {
        String ret = "";
        int rows = a.length;
        int cols = a[0].length;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Object o = a[i][j];
                ret = o == null ? ret + "\t" : (o instanceof Point ? ret + "X\t" : (o instanceof Line ? ret + "L\t" : (o instanceof Polygon ? ret + ((Polygon)o).originalStyle + "\t" : ret + o.toString() + "\t")));
            }
            ret = ret + "\n";
        }
        return ret;
    }

    protected double[] getXLine(Vector grid) throws ParseException {
        Vector xLineS = (Vector)grid.get(0);
        Vector<Double> xLine = new Vector<Double>();
        double lastVal = this.xLow;
        int numEmpties = 0;
        for (int i = 0; i < xLineS.size(); ++i) {
            Object o = xLineS.get(i);
            if (o == null) {
                ++numEmpties;
                continue;
            }
            try {
                double d = Double.parseDouble(o.toString());
                if (numEmpties > 0) {
                    double step = (d - lastVal) / (double)(numEmpties + 1);
                    for (int ei = 1; ei <= numEmpties; ++ei) {
                        xLine.add(new Double(lastVal + step * (double)ei));
                    }
                }
                xLine.add(new Double(d));
                lastVal = d;
                numEmpties = 0;
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Transect grid formatting error:\nIn \"" + this.getName() + "\" there is an invalid x-value at " + this.getCellString(-1, i) + ": " + o.toString());
            }
        }
        if (numEmpties > 0) {
            double step = ((double)this.xHigh - lastVal) / (double)(numEmpties + 1);
            if (step <= 1.0E-7) {
                step = 1.0E-5;
            }
            for (int ei = 1; ei <= numEmpties; ++ei) {
                xLine.add(new Double(lastVal + step * (double)ei));
            }
        }
        return Util.getDoubleArray(xLine);
    }

    protected Vector getAges(Vector grid) throws ParseException {
        Vector<Double> ages = new Vector<Double>();
        ages.add(null);
        double lastVal = Double.NaN;
        int numEmpties = 0;
        for (int i = 1; i < grid.size(); ++i) {
            Vector line = (Vector)grid.get(i);
            if (line.size() < 2) {
                ++numEmpties;
                continue;
            }
            Object o = line.get(1);
            if (o == null || o.toString().length() == 0) {
                ++numEmpties;
                continue;
            }
            try {
                double d = Double.parseDouble(o.toString());
                if (numEmpties > 0) {
                    if (Double.isNaN(lastVal)) {
                        throw new ParseException("Transect grid formatting error:\nIn \"" + this.getName() + "\" there is are blank ages before " + this.getCellRowString(i) + ": " + o.toString());
                    }
                    double step = (d - lastVal) / (double)(numEmpties + 1);
                    for (int ei = 1; ei <= numEmpties; ++ei) {
                        ages.add(new Double(lastVal + step * (double)ei));
                    }
                }
                ages.add(new Double(d));
                lastVal = d;
                numEmpties = 0;
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Transect grid formatting error:\nIn \"" + this.getName() + "\" there is an invalid age around " + this.getCellRowString(i) + ": " + o.toString());
            }
        }
        if (numEmpties > 0) {
            throw new ParseException("Transect grid formatting error:\nIn \"" + this.getName() + "\" there is are " + numEmpties + " missing ages at the bottom of the column.");
        }
        return ages;
    }

    protected static String getStringAt(Vector grid, int row, int col) {
        if (row < 1 || col < 0) {
            return null;
        }
        if (row >= grid.size()) {
            return null;
        }
        Vector line = (Vector)grid.get(row);
        if (col >= line.size()) {
            return null;
        }
        Object o = line.get(col);
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    protected Line getLine(Point p1, Point p2, String lineStyle) {
        Line l2;
        for (Line l2 : this.lines) {
            if ((l2.a != p1 || l2.b != p2) && (l2.b != p1 || l2.a != p2)) continue;
            return l2;
        }
        l2 = new Line(p1, p2, lineStyle);
        if (!l2.isValid()) {
            return null;
        }
        this.lines.add(l2);
        return l2;
    }

    public boolean isValid() {
        boolean ret = true;
        HashMap<Line, Integer> uses = new HashMap<Line, Integer>();
        for (Polygon poly : this.polygons) {
            for (Line l : poly.lines) {
                Integer useNum = (Integer)uses.get(l);
                if (useNum == null) {
                    uses.put(l, new Integer(1));
                    continue;
                }
                useNum = new Integer(useNum + 1);
                uses.put(l, useNum);
            }
        }
        for (Line l : uses.keySet()) {
            int useNum = (Integer)uses.get(l);
            if (useNum == 1) {
                l.setErrorColor(ONE_SIDED_LINE_ERROR_COLOR);
                continue;
            }
            if (useNum < 3) continue;
            l.setErrorColor(THREE_SIDED_LINE_ERROR_COLOR);
            ret = false;
        }
        for (Line l : this.lines) {
            for (Line l2 : this.lines) {
                if (l == l2 || !l.intersects(l2)) continue;
                l.setErrorColor(LINE_INTERSECT_ERROR_COLOR);
                l2.setErrorColor(LINE_INTERSECT_ERROR_COLOR);
                ret = false;
            }
        }
        return ret;
    }

    public void setDrawErrors(boolean drawErrors) {
        this.drawErrors = drawErrors;
    }

    public Point normalizePoint(Point p, ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        double ax = (p.x - (double)this.xLow) * width / (double)(this.xHigh - this.xLow) + startx;
        double useY = p.y;
        if (this.unit != null && this.unit.isNegated()) {
            useY = -useY;
        }
        double ay = ImageGenerator.getYFromYear(useY, starty, settings);
        return new Point(ax, ay);
    }

    public Polygon getPolygonForPoint(Point p) {
        if (p == null) {
            return null;
        }
        for (Polygon poly : this.polygons) {
            if (!poly.pointHitTest(p)) continue;
            return poly;
        }
        return null;
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        for (Line l : this.lines) {
            l.generatePoints(ig, startx, starty, width, height, settings);
        }
        for (Line l : this.lines) {
            for (Line l2 : this.lines) {
                if (l == l2) continue;
                l.preventIntersections(l2);
            }
        }
        String cp = ig.pushClipPath();
        ig.drawRect(startx, starty, width, height, null);
        ig.popClipPath();
        ig.pushGrouping();
        ig.setClipPath(cp);
        double ageMargin = 10.0 / settings.unitsPerMY;
        for (Polygon poly : this.polygons) {
            if (!poly.hasPointWithinAges(settings.topAge - ageMargin, settings.baseAge + ageMargin)) continue;
            poly.draw(ig, startx, starty, width, height, settings);
        }
        for (TextLabel text : this.textLabels) {
            if (!settings.isInRange(text.point.getY())) continue;
            text.draw(ig, startx, starty, width, height, settings);
        }
        for (Polygon poly : this.polygons) {
            if (!poly.hasPointWithinAges(settings.topAge - ageMargin, settings.baseAge + ageMargin)) continue;
            poly.addPopup(ig, settings);
        }
        if (this.drawErrors) {
            for (Line l : this.lines) {
                if (l.errorColor == null) continue;
                ig.drawLine(l.an.x, l.an.y, l.bn.x, l.bn.y, "stroke-width: 2; stroke: rgb(" + l.errorColor.getRed() + "," + l.errorColor.getGreen() + "," + l.errorColor.getBlue() + ");");
            }
        }
        ig.popGrouping();
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
        }
        return this.optionsPanel;
    }

    @Override
    public SortedSet negateAges() {
        return super.negateAges();
    }

    @Override
    public void convertAges(AgeConverter translator) {
        for (Point p : this.points) {
            p.y = translator.convertAge(p.y, -1);
        }
        for (TextLabel text : this.textLabels) {
            text.point.y = translator.convertAge(text.point.y, -1);
        }
        this.updateMinMaxAges();
    }

    @Override
    public double getDataDensity() {
        this.updateMinMaxAges();
        double density = (double)(this.points.size() + this.textLabels.size()) / (this.maxAge - this.minAge);
        return density;
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
    }

    @Override
    public void readSettings(Element element, Settings settings) {
        super.readSettings(element, settings);
    }

    @Override
    public void updateMinMaxAges() {
        this.minAge = Double.POSITIVE_INFINITY;
        this.maxAge = Double.NEGATIVE_INFINITY;
        for (Point p : this.points) {
            this.maxAge = Math.max(p.y, this.maxAge);
            this.minAge = Math.min(p.y, this.minAge);
        }
        for (TextLabel text : this.textLabels) {
            this.maxAge = Math.max(text.point.y, this.maxAge);
            this.minAge = Math.min(text.point.y, this.minAge);
        }
    }

    @Override
    public void write(Writer w) throws IOException {
        Double key;
        this.writeHeader(w, "transect");
        HashMap<Point, String> ids = new HashMap<Point, String>();
        int curId = 1;
        TreeMap<Double, Integer> xs = new TreeMap<Double, Integer>();
        TreeMap<Double, Integer> ages = new TreeMap<Double, Integer>();
        for (Point p : this.points) {
            Double x = new Double(p.x);
            Double age = new Double(p.y);
            if (!xs.containsKey(x)) {
                xs.put(x, new Integer(-1));
            }
            if (!ages.containsKey(age)) {
                ages.put(age, new Integer(-1));
            }
            ids.put(p, "" + curId);
            ++curId;
        }
        w.write("\t");
        Iterator keyIter = xs.keySet().iterator();
        int i = 0;
        while (keyIter.hasNext()) {
            key = (Double)keyIter.next();
            xs.put(key, new Integer(i));
            w.write("\t" + NumberUtils.formatDouble(key));
            ++i;
        }
        w.write("\r\n");
        double[] ageArray = new double[ages.size()];
        keyIter = ages.keySet().iterator();
        i = 0;
        while (keyIter.hasNext()) {
            key = (Double)keyIter.next();
            ages.put(key, new Integer(i));
            ageArray[i] = key;
            ++i;
        }
        String[][] grid = new String[ages.size()][xs.size()];
        for (Point p : this.points) {
            int col = (Integer)xs.get(new Double(p.x));
            int row = (Integer)ages.get(new Double(p.y));
            Object id = ids.get(p);
            if (id == null) {
                System.out.println("Writing a point without an ID! skipping : " + p.toString());
                continue;
            }
            grid[row][col] = "X" + id.toString();
        }
        for (int row = 0; row < grid.length; ++row) {
            String[] line = grid[row];
            w.write("\t" + NumberUtils.formatDouble(ageArray[row]));
            for (int col = 0; col < line.length; ++col) {
                w.write("\t");
                if (grid[row][col] == null) continue;
                w.write(grid[row][col]);
            }
            w.write("\r\n");
        }
        for (Polygon poly : this.polygons) {
            w.write("POLYGON\t" + poly.getDatafileStyle());
            if (poly.popup != null && poly.popup.trim().length() > 0) {
                w.write("\t" + poly.popup.trim());
            }
            w.write("\r\n");
            Point curPoint = poly.startPoint;
            int numPointsWritten = 0;
            Iterator lineIter = poly.lines.iterator();
            while (lineIter.hasNext() && curPoint != null) {
                Line l = (Line)lineIter.next();
                String id = (String)ids.get(curPoint);
                if (id == null) {
                    System.out.println("ID IS NULL WHEN WRITING");
                    continue;
                }
                w.write("\t" + id + "\r\n");
                ++numPointsWritten;
                String lineStyle = l.getDatafileStyle();
                if (lineStyle != null && lineStyle.length() > 0) {
                    w.write("\t\t" + lineStyle + "\r\n");
                }
                if ((curPoint = l.getOtherPoint(curPoint)) != poly.startPoint) continue;
                curPoint = null;
            }
            if (numPointsWritten == poly.lines.size()) continue;
            System.out.println("Number of points written for " + this.name + " polygon " + poly.getDatafileStyle() + " is wrong. Expected: " + poly.lines.size() + " but only found " + numPointsWritten + " points.");
        }
        for (TextLabel text : this.textLabels) {
            w.write("TEXT\t");
            w.write(NumberUtils.formatDouble(text.point.y) + "\t" + NumberUtils.formatDouble(text.point.x) + "\t");
            w.write(text.text.getOriginalString() + "\t");
            w.write(text.font.getSVGStyleNoColor() + "\t");
            if (text.ageSpread > 0.0) {
                w.write(NumberUtils.formatDouble(text.ageSpread));
            }
            w.write("\t");
            if (text.widthFrac > 0.0) {
                w.write(NumberUtils.formatDouble(text.widthFrac * 100.0));
            }
            w.write("\r\n");
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
    }

    public static class GridPolygon {
        public Vector lines = new Vector();
        public String style = null;
        public String popup = null;

        public static class GPLine {
            public String id1;
            public String id2;
            public String style;
        }
    }

    public class Polygon {
        public Vector lines = new Vector();
        public String popup = null;
        public int id = 0;
        public String originalStyle;
        public Map style;
        public double strokeWidth = 1.0;
        public String stroke = "black";
        public String fill = "none";
        public String patternFill = null;
        protected Point startPoint = null;
        protected Point curPoint = null;
        protected double[] cache_x = null;
        protected double[] cache_y = null;
        protected boolean[] cache_sharp = null;

        public Polygon() {
            this.id = TransectColumn.this.lastPolygonID++;
        }

        public Polygon(Polygon copyFrom) {
            this.id = copyFrom.id;
            if (copyFrom.lines != null && copyFrom.lines.size() > 0) {
                this.lines.addAll(copyFrom.lines);
            }
            this.popup = copyFrom.popup;
            this.originalStyle = copyFrom.originalStyle;
            if (copyFrom.style != null) {
                if (this.style == null) {
                    this.style = new HashMap();
                }
                this.style.putAll(copyFrom.style);
            }
            this.strokeWidth = copyFrom.strokeWidth;
            this.stroke = copyFrom.stroke;
            this.fill = copyFrom.fill;
            this.patternFill = copyFrom.patternFill;
            this.startPoint = copyFrom.startPoint;
            this.curPoint = copyFrom.curPoint;
        }

        public void genStart(Point start) {
            this.lines.clear();
            this.startPoint = start;
            this.curPoint = start;
        }

        public void genLineTo(Point p, String lineStyle) {
            if (this.curPoint == p) {
                return;
            }
            Line l = TransectColumn.this.getLine(this.curPoint, p, lineStyle);
            if (l == null) {
                System.out.println("Invalid line (polygon lineto): " + this.curPoint + " => " + p);
                return;
            }
            this.lines.add(l);
            this.curPoint = p;
        }

        public void genClose(String lineStyle) {
            if (this.curPoint == this.startPoint) {
                this.curPoint = null;
                return;
            }
            Line l = TransectColumn.this.getLine(this.curPoint, this.startPoint, lineStyle);
            if (l == null) {
                System.out.println("Invalid line when closing polygon: " + this.curPoint + " => " + this.startPoint);
                return;
            }
            this.lines.add(l);
            this.curPoint = null;
        }

        public void setStyle(String SVGStyle) {
            this.originalStyle = SVGStyle;
            if (SVGStyle.indexOf(58) < 0) {
                this.patternFill = SVGStyle;
                return;
            }
            this.style = SVGStyleParser.parseSVGStyle(SVGStyle);
            this.strokeWidth = SVGStyleParser.getDouble(this.style, "stroke-width", this.strokeWidth);
            this.stroke = SVGStyleParser.getString(this.style, "stroke", this.stroke);
            this.fill = SVGStyleParser.getString(this.style, "fill", this.fill);
            this.patternFill = SVGStyleParser.getString(this.style, "pattern", this.patternFill);
            this.style.remove("pattern");
            this.style.remove("stroke-width");
            this.style.remove("stroke");
            this.style.remove("fill");
        }

        public String getStyleString(ImageGenerator ig) {
            String ret = SVGStyleParser.getStyleString(this.style);
            ret = ret + SVGStyleParser.getStyleString("stroke-width", "" + this.strokeWidth);
            ret = ret + SVGStyleParser.getStyleString("stroke", this.stroke);
            if (this.patternFill != null) {
                this.fill = ig.patMan.getPatternFill(this.patternFill);
            }
            ret = ret + SVGStyleParser.getStyleString("fill", this.fill);
            return ret;
        }

        public String getDatafileStyle() {
            String ret = "";
            if (this.patternFill != null) {
                ret = ret + "pattern: " + this.patternFill + ";";
            }
            return ret;
        }

        public boolean hasPointWithinAges(double top, double base) {
            if (TransectColumn.this.unit.isNegated()) {
                double top_save = top;
                top = -base;
                base = -top_save;
            }
            for (Line l : this.lines) {
                if (l.a.y > top && l.a.y < base) {
                    return true;
                }
                if (!(l.b.y > top) || !(l.b.y < base)) continue;
                return true;
            }
            return false;
        }

        public boolean pointHitTest(Point p) {
            Line hitRay = new Line(p, new Point(p.x, -10.0));
            int intersectCount = 0;
            for (Line l : this.lines) {
                if (!l.intersects(hitRay)) continue;
                ++intersectCount;
            }
            return intersectCount % 2 != 0;
        }

        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            if (this.lines.size() < 2) {
                return;
            }
            Vector<Double> X = new Vector<Double>();
            Vector<Double> Y = new Vector<Double>();
            Vector<Boolean> sharpV = new Vector<Boolean>();
            boolean negated = false;
            if (TransectColumn.this.unit != null && TransectColumn.this.unit.isNegated()) {
                negated = true;
            }
            Point startSVG = TransectColumn.this.normalizePoint(this.startPoint, ig, startx, starty, width, height, settings);
            X.add(new Double(startSVG.x));
            Y.add(new Double(startSVG.y));
            sharpV.add(new Boolean(true));
            Point curP = this.startPoint;
            for (int i = 0; i < this.lines.size(); ++i) {
                Line l = (Line)this.lines.get(negated ? this.lines.size() - i - 1 : i);
                curP = l.addToDraw(curP, X, Y, sharpV, ig, startx, starty, width, height, settings);
            }
            this.cache_x = Util.getDoubleArray(X);
            this.cache_y = Util.getDoubleArray(Y);
            this.cache_sharp = Util.getBooleanArray(sharpV);
            ig.drawSmoothPolyline(this.cache_x, this.cache_y, this.cache_sharp, this.getStyleString(ig), true);
        }

        protected void addPopup(ImageGenerator ig, Settings settings) {
            if (this.cache_x == null) {
                return;
            }
            if (this.popup != null && settings.doPopups || TransectColumn.this.drawPopupIDs) {
                ig.pushGrouping();
                if (!TransectColumn.this.drawPopupIDs) {
                    ig.doPopupThings(this.popup, TransectColumn.this.fileInfo);
                } else {
                    ig.doPopupThings("" + this.id, TransectColumn.this.fileInfo);
                }
                ig.drawSmoothPolyline(this.cache_x, this.cache_y, this.cache_sharp, "stroke-width: 0; opacity: 0.5; fill: red;", true);
                ig.popGrouping();
            }
            this.cache_y = null;
            this.cache_x = null;
            this.cache_sharp = null;
        }

        public String toString() {
            String ret = "polygon fill: " + this.patternFill + "\n" + this.lines.size() + " lines:\n";
            Iterator iter = this.lines.iterator();
            while (iter.hasNext()) {
                ret = ret + iter.next().toString() + "\n";
            }
            return ret;
        }

        public void write(Writer w) throws IOException {
        }
    }

    public class TextLabel {
        public RichText text;
        public TSCFont font;
        public Point point;
        public double widthFrac = -1.0;
        public double ageSpread = -1.0;

        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            double scaleToFitFactor;
            double y = ImageGenerator.getYFromYear(this.point.y, starty, settings);
            double x = startx + this.point.x / 100.0 * width;
            StringWrappingInfo swi = new StringWrappingInfo(ig.g, this.text, this.font, 1);
            swi.useOriginalLineBreaks();
            switch (TransectColumn.this.textSize) {
                case 2: {
                    if (this.widthFrac > 0.0 && this.ageSpread > 0.0) {
                        double scaleX = this.widthFrac * width / swi.getWidth();
                        double ageFrac = this.ageSpread / (settings.baseAge - settings.topAge);
                        double scaleY = ageFrac * height / swi.getHeight();
                        swi.scale(Math.min(scaleX, scaleY));
                        break;
                    }
                    if (!(this.ageSpread > 0.0)) break;
                    double ageFrac = this.ageSpread / (settings.baseAge - settings.topAge);
                    double scaleY = ageFrac * height / swi.getHeight();
                    swi.scale(scaleY);
                    break;
                }
            }
            if (y + swi.getHeight() > starty + height) {
                scaleToFitFactor = 1.0 - (y + swi.getHeight() - (starty + height)) / swi.getHeight();
                swi.scale(scaleToFitFactor);
            }
            if (x + swi.getWidth() > startx + width) {
                scaleToFitFactor = 1.0 - (x + swi.getWidth() - (startx + width)) / swi.getWidth();
                swi.scale(scaleToFitFactor);
            }
            if ((y -= swi.lineHeights[0] - swi.descents[0]) < starty) {
                scaleToFitFactor = 1.0 - (starty - y) / swi.getHeight();
                swi.scale(scaleToFitFactor);
                y = starty;
            }
            ig.drawString(swi, x, y, swi.getWidth(), swi.getHeight(), 9, y, 12, TransectColumn.this.color.getColor(y, y));
        }
    }

    public class GridLine {
        GridPoint loc = null;
        String style = null;

        public GridLine() {
        }

        public GridLine(String s) {
            if (s.compareToIgnoreCase("L") == 0) {
                return;
            }
            int colon = s.indexOf(58);
            if (colon < 0 || colon == s.length() - 1) {
                return;
            }
            this.style = s.substring(colon + 1).trim();
        }
    }

    public class Line {
        public Point a;
        public Point b;
        protected Point an;
        protected Point bn;
        protected Vector pX;
        protected Vector pY;
        protected Vector perpsV;
        protected int type = 1;
        public double amplitude = 4.0;
        protected double amplitudePlusMin = 0.0;
        protected double halfperiod = 6.0;
        protected double periodPlusMin = 0.0;
        protected boolean interfinger = false;
        protected double interfingerHeight = 0.0;
        protected double clipDist = 2.0;
        protected Color errorColor = null;
        public static final int STRAIGHT = 1;
        public static final int JAGGED = 2;
        public static final int WAVY = 3;

        public Line(Point a, Point b) {
            this(a, b, null);
        }

        public Line(Point a, Point b, String style) {
            this.a = a;
            this.b = b;
            this.setStyle(style);
            if (a == b) {
                System.out.println("Line created with identical endpoints : " + a.toString());
            } else if (a.distance(b) < 1.0E-5) {
                System.out.println("Line created with very close endpoints : " + a.toString() + " => \t" + b.toString());
            }
        }

        public boolean isValid() {
            if (this.a == this.b) {
                return false;
            }
            return !(this.a.distance(this.b) < 1.0E-5);
        }

        public void setErrorColor(Color ec) {
            this.errorColor = ec;
        }

        public Point getOtherPoint(Point p) {
            if (this.a == p) {
                return this.b;
            }
            return this.a;
        }

        public void setStyle(Line copyFrom) {
            this.type = copyFrom.type;
            this.amplitude = copyFrom.amplitude;
            this.amplitudePlusMin = copyFrom.amplitudePlusMin;
            this.halfperiod = copyFrom.halfperiod;
            this.periodPlusMin = copyFrom.periodPlusMin;
            this.interfinger = copyFrom.interfinger;
            this.interfingerHeight = copyFrom.interfingerHeight;
        }

        public void setStyle(String style) {
            if (style == null || style.length() == 0) {
                this.type = 1;
                return;
            }
            if ((style = style.toLowerCase()).startsWith("jagged")) {
                this.type = 2;
            } else if (style.startsWith("lapping")) {
                this.type = 2;
                this.interfinger = true;
                this.interfingerHeight = 0.0;
                this.amplitude = 9.0;
                this.halfperiod = 6.0;
            } else if (style.startsWith("wavy")) {
                this.amplitude = 3.0;
                this.halfperiod = 6.0;
                this.type = 3;
            } else if (style.startsWith("wavylapping")) {
                this.type = 3;
                this.interfinger = true;
                this.interfingerHeight = 0.0;
                this.amplitude = 9.0;
                this.halfperiod = 6.0;
            }
            this.clipDist = 10.0;
        }

        public String getDatafileStyle() {
            String ret = "";
            if (this.type != 1) {
                if (this.type == 2) {
                    ret = this.interfinger ? ret + "lapping" : ret + "jagged";
                } else if (this.type == 3) {
                    ret = this.interfinger ? ret + "wavylapping" : ret + "wavy";
                }
            }
            return ret;
        }

        public boolean intersects(Line o) {
            if (this.a == o.a || this.a == o.b || this.b == o.a || this.b == o.b) {
                return false;
            }
            Point intersect = Geom.getLineSegmentIntersection(this.a, this.b, o.a, o.b);
            return intersect != null;
        }

        public void generatePoints(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            this.an = TransectColumn.this.normalizePoint(this.a, ig, startx, starty, width, height, settings);
            this.bn = TransectColumn.this.normalizePoint(this.b, ig, startx, starty, width, height, settings);
            if (this.amplitude < 0.25) {
                this.amplitude = 0.25;
            }
            if (this.type == 2 && !TemplateGen.forTemplateGen) {
                Point main_line_top;
                Point main_line_bottom;
                this.pX = new Vector();
                this.pY = new Vector();
                this.perpsV = new Vector();
                double ystep_million_years = settings.unitsPerMY < 30.0 ? 0.4 * (1.0 / (settings.unitsPerMY / 30.0)) : 0.4;
                double min_slope_degrees = 10.0;
                double min_slope = Math.tan(Math.toRadians(min_slope_degrees));
                double min_interfinger_delta_x = width * 0.05 / 2.0;
                double max_interfinger_delta_x = 2.0 * min_interfinger_delta_x;
                double full_interfinger_delta_x = 15.0;
                double min_allowable_delta_y = ystep_million_years * 1.5;
                double column_border_horizontal_margin = width / 100.0;
                double ystep_document = ystep_million_years * settings.unitsPerMY;
                double min_allowable_delta_y_document = min_allowable_delta_y * settings.unitsPerMY;
                double line_slope = (this.bn.y - this.an.y + 0.01) / (this.bn.x - this.an.x + 0.01);
                double line_yintercept = this.bn.y - line_slope * this.bn.x;
                double vertical_degrees = 90.0;
                double m = (max_interfinger_delta_x - min_interfinger_delta_x) / (min_slope_degrees - vertical_degrees);
                double b = max_interfinger_delta_x - m * min_slope_degrees;
                double line_slope_degrees = Math.abs(Math.toDegrees(Math.atan(line_slope)));
                double interfinger_width_delta_x = m * line_slope_degrees + b;
                boolean reverse_points_when_done = false;
                if (this.an.y < this.bn.y) {
                    main_line_bottom = this.an;
                    main_line_top = this.bn;
                    reverse_points_when_done = false;
                } else {
                    main_line_bottom = this.bn;
                    main_line_top = this.an;
                    reverse_points_when_done = true;
                }
                Vector2D main_line = new Vector2D(this.an, this.bn);
                Point last_vertex = main_line_bottom;
                int num_steps = (int)Math.ceil(Math.abs((main_line_top.y - min_allowable_delta_y - main_line_bottom.y) / ystep_document));
                double vertical_threshold = 45.0;
                double amount_overlap = 0.005 * TransectColumn.this.myWidth;
                for (int cur_step = 1; cur_step < num_steps; ++cur_step) {
                    Point second_vertex_to_add;
                    Point first_vertex_to_add;
                    double x1;
                    double x0;
                    double cur_y = main_line_bottom.y + (double)cur_step * ystep_document;
                    double next_y = cur_y + ystep_document;
                    double curx_on_mainline = (cur_y - line_yintercept) / line_slope;
                    double nextx_on_mainline = (next_y - line_yintercept) / line_slope;
                    Point central_point_on_mainline = new Point(curx_on_mainline, cur_y);
                    Point next_point_on_mainline = new Point(nextx_on_mainline, next_y);
                    if (width < 300.0) {
                        x0 = central_point_on_mainline.x - max_interfinger_delta_x;
                        x1 = central_point_on_mainline.x + max_interfinger_delta_x;
                    } else {
                        x0 = central_point_on_mainline.x - full_interfinger_delta_x;
                        x1 = central_point_on_mainline.x + full_interfinger_delta_x;
                    }
                    double x0_distance = last_vertex.distance(x0, cur_y);
                    double x1_distance = last_vertex.distance(x1, cur_y);
                    if (x0_distance < x1_distance) {
                        first_vertex_to_add = new Point(x1, cur_y);
                        second_vertex_to_add = new Point(x0, cur_y);
                    } else {
                        first_vertex_to_add = new Point(x0, cur_y);
                        second_vertex_to_add = new Point(x1, cur_y);
                    }
                    Vector2D vector_from_mainline_to_first_vertex = main_line.perpVectorFromLineToPoint(main_line_bottom, first_vertex_to_add);
                    Vector2D vector_from_mainline_to_second_vertex = main_line.perpVectorFromLineToPoint(main_line_bottom, second_vertex_to_add);
                    if (vector_from_mainline_to_first_vertex.length() > this.clipDist) {
                        this.clipDist = vector_from_mainline_to_first_vertex.length();
                    }
                    if (vector_from_mainline_to_second_vertex.length() > this.clipDist) {
                        this.clipDist = vector_from_mainline_to_second_vertex.length();
                    }
                    this.pX.add(first_vertex_to_add.x);
                    this.pY.add(first_vertex_to_add.y);
                    this.perpsV.add(vector_from_mainline_to_first_vertex);
                    this.pX.add(second_vertex_to_add.x);
                    this.pY.add(second_vertex_to_add.y);
                    this.perpsV.add(vector_from_mainline_to_second_vertex);
                    last_vertex = second_vertex_to_add;
                }
                if (reverse_points_when_done) {
                    Collections.reverse(this.pX);
                    Collections.reverse(this.pY);
                    Collections.reverse(this.perpsV);
                }
            } else if (this.type == 3 || TemplateGen.forTemplateGen) {
                Vector2D perp2;
                Vector2D perp1;
                double frac;
                this.pX = new Vector();
                this.pY = new Vector();
                this.perpsV = new Vector();
                double ax = this.an.x;
                double ay = this.an.y;
                double bx = this.bn.x;
                double by = this.bn.y;
                Vector2D mainLine = new Vector2D(bx - ax, by - ay);
                double mainLength = mainLine.length();
                Vector2D mainLinePerp = new Vector2D(mainLine);
                mainLinePerp.perpSlope();
                double stepLength = this.halfperiod;
                double numSteps = mainLength / this.halfperiod;
                if (numSteps < 2.0) {
                    numSteps = 2.0;
                }
                numSteps = (frac = numSteps - Math.floor(numSteps)) < 0.5 ? Math.floor(numSteps) : Math.floor(numSteps) + 1.0;
                stepLength = mainLength / numSteps;
                Vector2D step1 = new Vector2D(mainLine);
                step1.setLength(stepLength);
                Vector2D step2 = step1;
                Vector2D halfStep = new Vector2D(step1);
                halfStep.mul(0.5);
                Vector2D interfingerVect = null;
                double slope = 1.0;
                if (this.interfinger) {
                    slope = mainLine.y / mainLine.x;
                    if (Math.abs(slope) < 0.05) {
                        interfingerVect = new Vector2D(0.0, this.halfperiod);
                    } else {
                        interfingerVect = new Vector2D(this.halfperiod, 0.0);
                        slope = mainLine.x / mainLine.y;
                    }
                }
                if (this.interfinger) {
                    if (slope > 0.0) {
                        perp1 = interfingerVect.setLengthR(this.amplitude);
                        perp2 = interfingerVect.setLengthR(-this.amplitude);
                    } else {
                        perp1 = interfingerVect.setLengthR(-this.amplitude);
                        perp2 = interfingerVect.setLengthR(this.amplitude);
                    }
                    Vector2D interfingerPerp = new Vector2D(interfingerVect);
                    interfingerPerp.perpSlope();
                    double newStepLength = Math.abs(mainLine.compThisInA(interfingerPerp));
                    newStepLength = Math.min(stepLength * 2.0, newStepLength);
                    if (Math.abs(slope) < 0.01 || Math.abs(slope) > 10.0 || Double.isNaN(slope)) {
                        newStepLength = stepLength;
                    }
                    stepLength = newStepLength;
                    step1 = new Vector2D(mainLine);
                    step1.setLength(stepLength * 2.0 - this.interfingerHeight);
                    step2 = new Vector2D(mainLine);
                    step2.setLength(this.interfingerHeight);
                } else {
                    perp1 = new Vector2D(mainLine);
                    perp1.perpSlope();
                    perp1.setLength(this.amplitude);
                    perp2 = new Vector2D(perp1);
                    perp2.mul(-1.0);
                }
                boolean using1 = false;
                Vector2D cur = new Vector2D(halfStep);
                double maxPerp = 0.0;
                while (cur.length() < mainLength - stepLength / 4.0) {
                    Vector2D perp = new Vector2D(using1 ? perp1 : perp2);
                    Vector2D step = new Vector2D(using1 ? step1 : step2);
                    if (this.amplitudePlusMin > 0.0) {
                        perp.setLength(perp.length() + (Math.random() * this.amplitudePlusMin - this.amplitudePlusMin / 2.0));
                    }
                    Vector2D p = cur.addR(perp);
                    this.pX.add(new Double(p.x + ax));
                    this.pY.add(new Double(p.y + ay));
                    this.perpsV.add(perp);
                    if (this.periodPlusMin > 0.0) {
                        Vector2D stepRand = new Vector2D(step);
                        double stepLengthR = Math.max(0.0, stepLength / 2.0 + (Math.random() * this.periodPlusMin - stepLength / 2.0 / 2.0));
                        stepRand.setLength(stepLengthR);
                        cur = cur.addR(stepRand);
                    } else {
                        cur = cur.addR(step);
                    }
                    boolean bl = using1 = !using1;
                    double compOnPerp = perp.compThisInA(mainLinePerp);
                    if (!(compOnPerp > maxPerp)) continue;
                    maxPerp = compOnPerp;
                }
                this.clipDist = maxPerp;
            }
        }

        public double getClippingDistance() {
            switch (this.type) {
                case 1: {
                    return 2.0;
                }
                case 2: 
                case 3: {
                    return 10.0;
                }
            }
            return 0.0;
        }

        public void drawPoint(Point start, ImageGenerator ig) {
            ig.drawCircle(start.x, start.y, 1.0, "fill: blue;");
        }

        public void drawVector(Vector2D v, Point start, ImageGenerator ig) {
            ig.drawLine(start.x, start.y, start.x + v.x, start.y + v.y, "stroke: green; stroke-width: 0.5;");
            ig.drawCircle(start.x + v.x, start.y + v.y, 1.0, "fill: green;");
        }

        public void preventIntersections(Line other) {
            if (this.type == 2) {
                return;
            }
            if (this == other) {
                return;
            }
            if (this.pX == null || this.pY == null || other.an == null || other.bn == null) {
                return;
            }
            double clipDist = other.getClippingDistance();
            Vector2D mainLine = new Vector2D(this.an, this.bn);
            Vector2D mainLineOther = new Vector2D(other.an, other.bn);
            if (mainLineOther.length() < 1.0E-5) {
                System.out.println("BAD MAINLINEOTHER LENGTH! : " + mainLineOther.length() + " line: " + other.toString());
                return;
            }
            Vector2D otherPerp = new Vector2D(mainLineOther);
            otherPerp.perpSlope();
            otherPerp.setLength(clipDist);
            Point clipA1 = other.an.addRp(otherPerp);
            Point clipB1 = other.bn.addRp(otherPerp);
            otherPerp.mul(-1.0);
            Point clipA2 = other.an.addRp(otherPerp);
            Point clipB2 = other.bn.addRp(otherPerp);
            Vector2D mainPerp = new Vector2D(mainLine);
            mainPerp.perpSlope();
            for (int i = 0; i < this.pX.size(); ++i) {
                double l;
                double x = (Double)this.pX.get(i);
                double y = (Double)this.pY.get(i);
                Point p = new Point(x, y);
                Vector2D pPerp = (Vector2D)this.perpsV.get(i);
                Point mainP = p.subRp(pPerp);
                boolean perpLengthChanged = false;
                double newPerpLength = pPerp.length();
                if (Geom.isPointInsideQuad(mainP, clipA1, clipB1, clipB2, clipA2)) {
                    newPerpLength = 0.0;
                    perpLengthChanged = true;
                } else {
                    Vector2D d;
                    Point intersect = Geom.getLineSegmentIntersection(mainP, p, clipA1, clipB1);
                    if (intersect != null) {
                        d = new Vector2D(p, intersect);
                        newPerpLength = Math.min(pPerp.length() - d.length(), newPerpLength);
                        perpLengthChanged = true;
                    }
                    if ((intersect = Geom.getLineSegmentIntersection(mainP, p, clipA2, clipB2)) != null) {
                        d = new Vector2D(p, intersect);
                        newPerpLength = Math.min(pPerp.length() - d.length(), newPerpLength);
                        perpLengthChanged = true;
                    }
                }
                double dist = p.distance(other.an);
                if (dist < clipDist) {
                    l = dist - clipDist;
                    newPerpLength = Math.min(newPerpLength, l);
                    perpLengthChanged = true;
                }
                if ((dist = p.distance(other.bn)) < clipDist) {
                    l = dist - clipDist;
                    newPerpLength = Math.min(newPerpLength, l);
                    perpLengthChanged = true;
                }
                if (!perpLengthChanged) continue;
                if (newPerpLength < 0.5) {
                    newPerpLength = 0.5;
                }
                pPerp.setLength(newPerpLength);
                p = mainP.addRp(pPerp);
                this.pX.set(i, new Double(p.x));
                this.pY.set(i, new Double(p.y));
            }
        }

        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, String style) {
            switch (this.type) {
                case 1: {
                    double ax = (this.a.x - (double)TransectColumn.this.xLow) * width / (double)(TransectColumn.this.xHigh - TransectColumn.this.xLow) + startx;
                    double useY = this.a.y;
                    if (TransectColumn.this.unit != null && TransectColumn.this.unit.isNegated()) {
                        useY = -useY;
                    }
                    double ay = ImageGenerator.getYFromYear(useY, starty, settings);
                    double bx = (this.b.x - (double)TransectColumn.this.xLow) * width / (double)(TransectColumn.this.xHigh - TransectColumn.this.xLow) + startx;
                    useY = this.b.y;
                    if (TransectColumn.this.unit != null && TransectColumn.this.unit.isNegated()) {
                        useY = -useY;
                    }
                    double by = ImageGenerator.getYFromYear(useY, starty, settings);
                    ig.drawLine(ax, ay, bx, by, style);
                    break;
                }
                case 2: 
                case 3: {
                    Vector<Double> X = new Vector<Double>();
                    Vector<Double> Y = new Vector<Double>();
                    Vector<Boolean> sharpV = new Vector<Boolean>();
                    X.add(new Double(this.an.x));
                    Y.add(new Double(this.an.y));
                    sharpV.add(new Boolean(true));
                    this.addToDraw(this.a, X, Y, sharpV, ig, startx, starty, width, height, settings);
                    double[] xs = Util.getDoubleArray(X);
                    double[] ys = Util.getDoubleArray(Y);
                    boolean[] sharps = Util.getBooleanArray(sharpV);
                    if (this.type == 3) {
                        ig.drawSmoothPolyline(xs, ys, sharps, style, false);
                        break;
                    }
                    ig.drawPolyline(xs, ys, style);
                }
            }
        }

        public Point addToDraw(Point startP, Vector x, Vector y, Vector sharp, ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            boolean reverse;
            Point endP;
            if (this.a == startP) {
                endP = this.b;
                reverse = false;
            } else if (this.b == startP) {
                endP = this.a;
                reverse = true;
            } else {
                return null;
            }
            switch (this.type) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    int xSize = this.pX.size();
                    Boolean sh = new Boolean(this.type == 2);
                    for (int i = 0; i < this.pX.size(); ++i) {
                        if (reverse) {
                            x.add(this.pX.get(xSize - i - 1));
                            y.add(this.pY.get(xSize - i - 1));
                        } else {
                            x.add(this.pX.get(i));
                            y.add(this.pY.get(i));
                        }
                        sharp.add(sh);
                    }
                    break;
                }
            }
            double xd = (endP.x - (double)TransectColumn.this.xLow) * width / (double)(TransectColumn.this.xHigh - TransectColumn.this.xLow) + startx;
            double useY = endP.y;
            if (TransectColumn.this.unit != null && TransectColumn.this.unit.isNegated()) {
                useY = -endP.y;
            }
            double yd = ImageGenerator.getYFromYear(useY, starty, settings);
            x.add(new Double(xd));
            y.add(new Double(yd));
            sharp.add(new Boolean(true));
            return endP;
        }

        public String toString() {
            return this.a.toString() + " => " + this.b.toString() + "\t (" + super.toString() + ")";
        }
    }

    public class GridPoint
    extends Point {
        public int row;
        public int col;

        public GridPoint(int x, int y, int row, int col) {
            super(x, y);
            this.row = row;
            this.col = col;
        }

        @Override
        public String toString() {
            return "\tx=" + this.x + " y=" + this.y + " row=" + this.row + " col=" + this.col;
        }
    }
}

