/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.ChronColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.ages.AgeConverter;
import gui.ImageGenerator;
import gui.Settings;
import java.awt.Color;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JPanel;
import path.ResPath;
import util.NumberUtils;
import util.Util;

public class FaciesColumn
extends DataColumn {
    private static final long serialVersionUID = 1L;
    public static final Color defaultBackground = new Color(255, 255, 255);

    public FaciesColumn(String colName) {
        super(colName);
        this.iconPath = ResPath.getPath("icons.col_icon_chron");
        this.setWidth(60.0);
        this.color = new Coloring(defaultBackground);
    }

    protected FaciesColumn(String colName, boolean imAChron) {
        super(colName);
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
        }
        return this.optionsPanel;
    }

    @Override
    public SortedSet negateAges() {
        return this.negateAgesBreakerBased();
    }

    @Override
    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        Datapoint p;
        super.grayOutIfEmpty(topAge, baseAge, en);
        Iterator iter = this.getDrawingData();
        Iterator iter1 = this.getDrawingData();
        double curTop = topAge;
        double curBase = baseAge;
        Datapoint p1 = null;
        int dis1 = 0;
        int dis2 = 0;
        int dis3 = 0;
        int count = 0;
        boolean count_final = false;
        boolean lastGO = this.grayedOut;
        if (this.isOutcrop) {
            double outBase = 0.0;
            double outPrev = 0.0;
            if (curTop < curBase) {
                return this.grayedOut;
            }
            while (iter1.hasNext() && !(curTop + 1.0E-6 <= curBase)) {
                p = (Datapoint)iter1.next();
                outBase = -p.baseAge;
                if (outBase <= curTop && outBase >= curBase) {
                    ++count;
                }
                if (p1 != null) {
                    dis1 = Math.abs((int)(outBase - curBase));
                    dis2 = Math.abs((int)(outBase - curTop));
                    dis3 = Math.abs((int)(outBase - outPrev));
                    if (dis3 >= dis2 && curBase >= outBase && p.value.toString().equals("TOP")) {
                        count = 0;
                    }
                    if (dis3 >= dis2 && curBase >= outBase && !p.value.toString().equals("TOP")) {
                        count = 1;
                    }
                }
                p1 = p;
                outBase = outPrev;
                if (count == 0) continue;
                count_final = true;
            }
        } else {
            while (iter1.hasNext() && !(curTop + 1.0E-6 >= curBase)) {
                p = (Datapoint)iter1.next();
                if (p.baseAge <= curBase && p.baseAge >= curTop) {
                    ++count;
                }
                if (p1 != null) {
                    dis1 = Math.abs((int)(p.baseAge - curBase));
                    dis2 = Math.abs((int)(p.baseAge - curTop));
                    dis3 = Math.abs((int)(p.baseAge - p1.baseAge));
                    if (dis3 >= dis2 && curBase <= p.baseAge && p.value.toString().equals("TOP")) {
                        count = 0;
                    }
                    if (dis3 >= dis2 && curBase <= p.baseAge && !p.value.toString().equals("TOP")) {
                        count = 1;
                    }
                }
                p1 = p;
                if (count == 0) continue;
                count_final = true;
            }
        }
        if (count == 0) {
            this.NoDataInDataColumn = true;
            this.grayedOut = true;
            DataColumn d = (DataColumn)this.parent;
            for (int i = 0; i < d.getChildCount(); ++i) {
                DataColumn c = (DataColumn)d.getChildAt(i);
                c.grayedOut = true;
                c.NoDataInDataColumn = true;
                c.grayedOutAlreadyComputed = true;
            }
            d.NoDataInDataColumn = true;
            d.grayedOut = true;
            if (lastGO != this.grayedOut) {
                this.setName(d.name);
            }
            this.fireChange(3);
        } else {
            this.NoDataInDataColumn = false;
            this.grayedOut = false;
            DataColumn d = (DataColumn)this.parent;
            for (int i = 0; i < d.getChildCount(); ++i) {
                DataColumn c = (DataColumn)d.getChildAt(i);
                c.grayedOut = false;
                c.NoDataInDataColumn = false;
                c.grayedOutAlreadyComputed = true;
            }
            d.NoDataInDataColumn = false;
            d.grayedOut = false;
            if (lastGO != this.grayedOut) {
                this.setName(d.name);
            }
            this.fireChange(3);
        }
        return this.grayedOut;
    }

    @Override
    public void convertAges(AgeConverter translator) {
        List<AgeConverter.Gap> gaps = translator.getGaps();
        if (gaps != null) {
            Vector<Datapoint> addBreakers = new Vector<Datapoint>();
            Iterator<AgeConverter.Gap> gapIter = gaps.iterator();
            AgeConverter.Gap gap = gapIter.next();
            Datapoint lastP = null;
            Iterator iter = this.getData();
            while (iter.hasNext()) {
                DataColumn d;
                Datapoint p = (Datapoint)iter.next();
                if (gap == null) {
                    p.baseAge = translator.convertAge(p.baseAge, 1);
                    continue;
                }
                if (NumberUtils.isEqual(p.baseAge, gap.gapKey)) {
                    d = (DataColumn)this.parent;
                    if (!p.breaker && iter.hasNext()) {
                        Datapoint newBreaker = new Datapoint();
                        newBreaker.value = "Gap";
                        newBreaker.baseAge = gap.gapValueBase;
                        addBreakers.add(newBreaker);
                        p.baseAge = gap.gapValueTop;
                        gap = gapIter.hasNext() ? gapIter.next() : null;
                    }
                } else if (lastP != null) {
                    d = (DataColumn)this.parent;
                    if (d.isOutcrop && p.baseAge < gap.gapKey) {
                        double b = -1.0 * p.baseAge;
                        double a = -1.0 * gap.gapKey;
                        if (b > a) {
                            Datapoint topHalf = new Datapoint(p);
                            topHalf.value = p.value;
                            topHalf.baseAge = gap.gapValueTop;
                            addBreakers.add(topHalf);
                            Datapoint newGap = new Datapoint();
                            newGap.baseAge = gap.gapValueBase;
                            newGap.value = "Gap";
                            addBreakers.add(newGap);
                            p.baseAge = translator.convertAge(p.baseAge, -1);
                            gap = gapIter.hasNext() ? gapIter.next() : null;
                        } else {
                            p.baseAge = translator.convertAge(p.baseAge, 1);
                        }
                    } else if (p.baseAge < gap.gapKey) {
                        p.baseAge = translator.convertAge(p.baseAge, 1);
                    } else if (p.baseAge > gap.gapKey) {
                        Datapoint topHalf = new Datapoint(p);
                        topHalf.value = p.value;
                        topHalf.baseAge = gap.gapValueTop;
                        addBreakers.add(topHalf);
                        Datapoint newGap = new Datapoint();
                        newGap.baseAge = gap.gapValueBase;
                        newGap.value = "Gap";
                        addBreakers.add(newGap);
                        p.baseAge = translator.convertAge(p.baseAge, -1);
                        gap = gapIter.hasNext() ? gapIter.next() : null;
                    } else {
                        p.baseAge = translator.convertAge(p.baseAge, 1);
                        gap = gapIter.hasNext() ? gapIter.next() : null;
                    }
                } else {
                    p.baseAge = translator.convertAge(p.baseAge, 1);
                }
                lastP = p;
            }
            this.data.addAll(addBreakers);
            this.updateMinMaxAges();
        } else {
            super.convertAges(translator);
        }
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        Iterator iter = this.getDrawingData();
        double curTop = settings.topAge;
        double curBase = settings.baseAge;
        double amplitude = 3.0;
        boolean ceiling = false;
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        while (iter.hasNext() && !settings.isBelow(curTop)) {
            Datapoint p = (Datapoint)iter.next();
            if (settings.isAbove(p.baseAge)) continue;
            if (p.breaker) {
                curTop = p.baseAge;
                continue;
            }
            curBase = p.baseAge;
            if (settings.isBelow(curBase)) {
                curBase = settings.baseAge;
            }
            String pattern = p.value.toString();
            double patternWidthPercent = settings.noIndentPattern ? 1.0 : this.ds.patWidthMan.getWidth(pattern) / 100.0;
            double parker = 0.0;
            Vector<Double> X = new Vector<Double>();
            Vector<Double> Y = new Vector<Double>();
            Vector<Boolean> sharpV = new Vector<Boolean>();
            double y = (curBase - settings.topAge) * settings.unitsPerMY + starty;
            X.add(new Double(startx));
            Y.add(new Double((curBase - settings.topAge) * settings.unitsPerMY + starty));
            sharpV.add(new Boolean(true));
            for (double i = 0.0; i < width * patternWidthPercent; i += 0.5235987755982988) {
                if (p.lineType == 4) {
                    X.add(new Double(startx + i));
                    Y.add(new Double(y + amplitude * Math.sin(i)));
                    sharpV.add(new Boolean(true));
                }
                parker = i;
            }
            X.add(new Double(startx + width * patternWidthPercent));
            Y.add(new Double((curBase - settings.topAge) * settings.unitsPerMY + starty));
            sharpV.add(new Boolean(true));
            X.add(new Double(startx + width * patternWidthPercent));
            Y.add(new Double((curTop - settings.topAge) * settings.unitsPerMY + starty));
            sharpV.add(new Boolean(true));
            if (ceiling) {
                while (parker > 0.0) {
                    X.add(new Double(startx + parker));
                    Y.add(new Double((curTop - settings.topAge) * settings.unitsPerMY + starty + amplitude * Math.sin(parker)));
                    sharpV.add(new Boolean(true));
                    parker -= 0.5235987755982988;
                }
            }
            X.add(new Double(startx));
            Y.add(new Double((curTop - settings.topAge) * settings.unitsPerMY + starty));
            sharpV.add(new Boolean(true));
            ceiling = p.lineType == 4;
            double[] xs = Util.getDoubleArray(X);
            double[] ys = Util.getDoubleArray(Y);
            boolean[] sharps = Util.getBooleanArray(sharpV);
            if (pattern.compareToIgnoreCase("Gap") == 0) {
                ig.drawPolygon(xs, ys, "stroke: black; stroke-width: 1; fill: white;");
                ig.drawLineYear(startx, curTop, startx + width * patternWidthPercent, curBase, "stroke: black; stroke-width: 1;", starty);
                ig.drawLineYear(startx + width * patternWidthPercent, curTop, startx, curBase, "stroke: black; stroke-width: 1;", starty);
            } else {
                String styleToUse = ig.patMan.getPatternStyle(pattern);
                ig.drawPolygon(xs, ys, styleToUse);
            }
            if (this.drawAgeLabel) {
                ig.drawString(ig.getSWIOneLine(this.getAgeLabel(p.baseAge), this.fonts.getFont(1), 1, this.fileInfo), startx + 10.0, (curBase - settings.topAge) * settings.unitsPerMY + starty - ageLabelHeight, 20.0, ageLabelHeight, 3, 0.0, 12, this.color.getColor(p.baseAge, p.baseAge));
            }
            if (p.popup != null && settings.doPopups) {
                ig.pushGrouping();
                ig.doPopupThings(p.popup, this.fileInfo);
                ig.drawRectYear(startx, curTop, width, curBase - curTop, "stroke-width: 0; opacity: 0.5; fill: red;", starty);
                ig.popGrouping();
            }
            curTop = curBase;
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    @Override
    public void write(Writer w) throws IOException {
        if (this instanceof ChronColumn) {
            this.writeHeader(w, "chron-only");
        } else {
            this.writeHeader(w, "facies-only");
        }
        Iterator chronIter = this.getData();
        while (chronIter.hasNext()) {
            Datapoint p = (Datapoint)chronIter.next();
            w.write("\t" + p.value.toString() + "\t");
            if (p.label != null) {
                w.write(p.label);
            }
            w.write("\t" + Double.toString(p.baseAge));
            if (p.popup != null) {
                w.write("\t");
                FaciesColumn.writeRichText(w, p.popup);
            }
            w.write("\r\n");
        }
        this.writeOverlaysAndUnderlays(w);
    }
}

