/*
 * Decompiled with CFR 0.152.
 */
package util;

import gui.TSCreator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import util.Debug;

public class JavaVMOptions {
    private static boolean is_jar = true;
    private static boolean is_exe = false;
    private static String jar_file = "";
    private static boolean is_jar_is_valid = false;

    public static void start(String max_memory, String[] args, Boolean alreadySpawned) throws IOException {
        StreamPipe err;
        StreamPipe out;
        Process p;
        Debug.print("Classpath is " + System.getProperty("java.class.path"));
        if (System.getProperty("java.vm.version").startsWith("1.5")) {
            Debug.print("Detected Java 1.5, applying -Dapple.awt.graphics.UseQuartz=false workaround for Batik bug 47917");
            System.setProperty("apple.awt.graphics.UseQuartz", "false");
        }
        Debug.print("Beginning procedure to restart Java VM with " + max_memory + " maximum memory size.");
        boolean first_start = true;
        boolean enough_mem_already = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-JavaVMOptions.realstart")) continue;
            Debug.print("Found -JavaVMOptions.realstart argument: this is the second time starting");
            first_start = false;
        }
        if ((double)Runtime.getRuntime().totalMemory() > 1.0E9 && (double)Runtime.getRuntime().freeMemory() > 1.0E9 || alreadySpawned.booleanValue()) {
            first_start = false;
            enough_mem_already = true;
        } else {
            System.out.println("Spawning JVM with max memory second time.");
            Debug.print("Heap size is now " + Runtime.getRuntime().maxMemory() + ".Therefore we will spawn a new process with enough heap memory.");
            ArrayList<String> command = new ArrayList<String>();
            command.add("java");
            command.add("-Xmx" + max_memory);
            if (!is_jar) {
                File f = new File(TSCreator.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                String Classpath = "$(CLASSPATH):" + f.getAbsolutePath() + "/../../build/classes:" + f.getAbsolutePath() + "/../../extlib/batik-1.7/*:" + f.getAbsolutePath() + "/../../extlib/batik-1.7/extensions/*:" + f.getAbsolutePath() + "/../../extlib/batik-1.7/lib/*:" + f.getAbsolutePath() + "/../../src:" + f.getAbsolutePath() + "/../../extlib/vecmath/vecmath-1.3.1.jar:" + f.getAbsolutePath() + "/../../extlib/google-gson-2.2.1/gson-2.2.1.jar";
                command.add("-cp");
                command.add(Classpath);
                command.add("gui.TSCreator");
                command.add("-alreadySpawned");
            } else {
                command.add("-Djava.protocol.handler.pkgs=util.protocols");
                command.add("-jar");
                command.add(jar_file);
                command.add("-JavaVMOptions.realstart");
                command.add("-alreadySpawned");
            }
            for (int i = 0; i < args.length; ++i) {
                command.add(args[i]);
            }
            String[] command_array = new String[command.size()];
            command.toArray(command_array);
            System.out.println("Running command array: " + command.toString());
            Debug.print("Running command array: " + command.toString());
            p = Runtime.getRuntime().exec(command_array);
            out = new StreamPipe(p.getInputStream(), System.out);
            err = new StreamPipe(p.getErrorStream(), System.err);
            out.run();
            err.run();
            try {
                System.exit(p.waitFor());
            }
            catch (InterruptedException e) {
                System.exit(1);
            }
        }
        if (first_start) {
            System.setProperty("java.awt.headless", "true");
        }
        if (first_start) {
            Debug.print("First time starting, heap size is " + Runtime.getRuntime().maxMemory());
            Debug.print("jarFile is: " + jar_file);
            if (!is_jar || is_exe) {
                Debug.print("The jarFile string does not end with '.jar', returning from start.");
                return;
            }
            is_jar = true;
            Debug.print("The program is running from a jar, commencing restart of Java VM.");
            ArrayList<String> command = new ArrayList<String>();
            command.add("java");
            command.add("-Xmx" + max_memory);
            command.add("-Djava.protocol.handler.pkgs=util.protocols");
            command.add("-jar");
            command.add(jar_file);
            command.add("-JavaVMOptions.realstart");
            for (int i = 0; i < args.length; ++i) {
                command.add(args[i]);
            }
            String[] command_array = new String[command.size()];
            command.toArray(command_array);
            Debug.print("Running command array: " + command.toString());
            p = Runtime.getRuntime().exec(command_array);
            out = new StreamPipe(p.getInputStream(), System.out);
            err = new StreamPipe(p.getErrorStream(), System.err);
            out.run();
            err.run();
            try {
                System.exit(p.waitFor());
            }
            catch (InterruptedException e) {
                System.exit(1);
            }
        } else {
            if (enough_mem_already) {
                Debug.print("Heap size is " + Runtime.getRuntime().maxMemory());
                System.out.println("Heap size is " + Runtime.getRuntime().maxMemory());
            } else {
                Debug.print("Second time starting, heap size is now " + Runtime.getRuntime().maxMemory());
            }
            return;
        }
    }

    public static void addOpenGLSupport() {
        String currentDir = System.getProperty("user.dir");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String classpath = System.getProperty("java.class.path");
        String libPath = System.getProperty("java.library.path");
        String partialJOGLLibraryPath = "extlib/jogl1.1.1/jogl-1.1.1-";
        if (osName.toLowerCase().contains("windows")) {
            partialJOGLLibraryPath = partialJOGLLibraryPath + "windows-";
        } else if (osName.toLowerCase().contains("linux")) {
            partialJOGLLibraryPath = partialJOGLLibraryPath + "linux-";
        } else if (osName.toLowerCase().contains("solaris")) {
            partialJOGLLibraryPath = partialJOGLLibraryPath + "solaris-";
        }
        partialJOGLLibraryPath = osArch.toLowerCase().contains("amd64") ? partialJOGLLibraryPath + "amd64" : partialJOGLLibraryPath + "i586";
        if (osName.toLowerCase().contains("mac")) {
            partialJOGLLibraryPath = "extlib/jogl1.1.1/jogl-1.1.1-";
            partialJOGLLibraryPath = partialJOGLLibraryPath + "macosx-universal";
        }
        partialJOGLLibraryPath = partialJOGLLibraryPath + "/lib";
        File joglFile = new File(partialJOGLLibraryPath);
        classpath = classpath + classpath + System.getProperty("path.separator") + partialJOGLLibraryPath;
        libPath = libPath + libPath + System.getProperty("path.separator") + partialJOGLLibraryPath;
        String[] classPathList = classpath.split(System.getProperty("path.separator"));
        String[] libPathList = libPath.split(System.getProperty("path.separator"));
        System.setProperty("java.class.path", classpath);
        System.setProperty("java.library.path", libPath);
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (Exception ex) {
            Debug.printStackTrace();
        }
    }

    public static void addLWJGLSupport() {
        String[] libPathList;
        String currentDir = System.getProperty("user.dir");
        String osName = System.getProperty("os.name");
        String classpath = System.getProperty("java.class.path");
        String libPath = System.getProperty("java.library.path");
        String fileSeparator = System.getProperty("file.separator");
        String partialLWJGLLibraryPath = "extlib" + fileSeparator + "lwjgl-2.7.1" + fileSeparator;
        String partialLWJGLJarPath = partialLWJGLLibraryPath + "jars";
        partialLWJGLLibraryPath = partialLWJGLLibraryPath + "native" + fileSeparator;
        if (osName.toLowerCase().contains("windows")) {
            partialLWJGLLibraryPath = partialLWJGLLibraryPath + "windows";
        } else if (osName.toLowerCase().contains("linux")) {
            partialLWJGLLibraryPath = partialLWJGLLibraryPath + "linux";
        } else if (osName.toLowerCase().contains("solaris")) {
            partialLWJGLLibraryPath = partialLWJGLLibraryPath + "solaris";
        } else if (osName.toLowerCase().contains("mac")) {
            partialLWJGLLibraryPath = partialLWJGLLibraryPath + "macosx";
        }
        classpath = classpath + classpath + System.getProperty("path.separator") + partialLWJGLJarPath;
        libPath = libPath + libPath + System.getProperty("path.separator") + partialLWJGLLibraryPath;
        String[] classPathList = classpath.split(System.getProperty("path.separator"));
        for (String classPath : libPathList = libPath.split(System.getProperty("path.separator"))) {
            System.err.println(classPath);
        }
        System.setProperty("java.class.path", classpath);
        System.setProperty("java.library.path", libPath);
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (Exception ex) {
            Debug.printStackTrace();
        }
    }

    public static boolean isJar() {
        if (!is_jar_is_valid) {
            Debug.print("WARNING: isJar() is being called before is_jar is valid!!");
        }
        return is_jar;
    }

    public static String getJarfile() {
        return jar_file;
    }

    static {
        Debug.turnOffDebugMessages();
        try {
            jar_file = new File(JavaVMOptions.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (jar_file.endsWith(".exe")) {
            is_jar = true;
            is_exe = true;
        } else if (!jar_file.endsWith(".jar")) {
            is_jar = false;
        }
        is_jar_is_valid = true;
        if (System.getProperty("java.protocol.handler.pkgs") != "util.protocols") {
            System.setProperty("java.protocol.handler.pkgs", "util.protocols");
        }
        JavaVMOptions.addOpenGLSupport();
        JavaVMOptions.addLWJGLSupport();
    }

    public static class StreamPipe
    extends Thread {
        InputStream in;
        OutputStream out;

        public StreamPipe(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            int BYTES_READ_AT_A_TIME = 10;
            byte[] b = new byte[BYTES_READ_AT_A_TIME];
            int num_bytes_read = 1;
            try {
                while ((num_bytes_read = this.in.read(b)) > 0) {
                    this.out.write(b, 0, num_bytes_read);
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

