/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.FreehandPoint;
import model.FreehandPolygonData;
import model.ModelIdentifier;
import model.storage.Query;
import model.util.SourceResult;

public class FreehandPointStorage {
    public static void insert(FreehandPoint point) {
        Query query = new Query("INSERT INTO #.freehand_points       (id, freehand_polygons_id, width_pos, age_pos, deleted)       VALUES (NULL, :freehand_polygons_id, :width_pos, :age_pos,              :deleted)");
        query.useDatabase(point.getIdentifier().getDatabase());
        query.setInt("freehand_polygons_id", point.getPolygon().getIdentifier().getId() + 1);
        query.setDouble("width_pos", point.getWidthPos());
        query.setDouble("age_pos", point.getAgePos());
        query.setBoolean("deleted", point.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(FreehandPoint point) {
        Query query = new Query("UPDATE #.freehand_points       SET freehand_polygons_id = :freehand_polygons_id,         width_pos = :width_pos, age_pos = :age_pos       WHERE id = :id");
        query.useDatabase(point.getIdentifier().getDatabase());
        query.setInt("id", point.getIdentifier().getId());
        query.setInt("freehand_polygons_id", point.getPolygon().getIdentifier().getId());
        query.setDouble("width_pos", point.getWidthPos());
        query.setDouble("age_pos", point.getAgePos());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        Query query = new Query("SELECT width_pos, age_pos, deleted, last_modified, creation_date             FROM #.freehand_points             WHERE id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            results.addAll(query.executeQuery());
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByPolygon(FreehandPolygonData polygon) {
        Query query = new Query("SELECT '#' AS database, id             FROM #.freehand_points             WHERE freehand_polygons_id = :freehand_polygons_id               AND NOT deleted");
        query.useDatabase(polygon.getIdentifier().getDatabase());
        query.setInt("freehand_polygons_id", polygon.getIdentifier().getId());
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

