/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.ModelIdentifier;
import model.TransectColumn;
import model.storage.Storage;
import model.storage.TransectTextDataStorage;
import model.util.SourceResult;

public class TransectTextData
extends Data {
    private ModelIdentifier identifier = null;
    private String title = "";
    private double width_pos = 0.0;
    private double age_pos = 0.0;
    private double width = 0.0;
    private double spread = 0.0;
    private String style = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public TransectTextData(TransectColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 25));
    }

    public TransectTextData(TransectColumn col, ModelIdentifier identifier, SourceResult result) {
        super((Column)col, result);
        this.setIdentifier(identifier);
        this.setTitle(result.getString("title"));
        this.setWidthPos(result.getDouble("width_pos"));
        this.setAgePos(result.getDouble("age_pos"));
        this.setWidth(result.getDouble("width"));
        this.setSpread(result.getDouble("spread"));
        this.setStyle(result.getString("style"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            TransectTextDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            TransectTextDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getStyle() {
        return this.style;
    }

    public final void setStyle(String style) {
        this.style = style;
    }

    public String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public double getWidthPos() {
        return this.width_pos;
    }

    public final void setWidthPos(double width_pos) {
        this.width_pos = width_pos;
    }

    public double getAgePos() {
        return this.age_pos;
    }

    public final void setAgePos(double age_pos) {
        this.age_pos = age_pos;
    }

    public double getSpread() {
        return this.spread;
    }

    public final void setSpread(double spread) {
        this.spread = spread;
    }

    public double getWidth() {
        return this.width;
    }

    public final void setWidth(double width) {
        this.width = width;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static TransectTextData getByIdentifier(TransectColumn c, ModelIdentifier id) {
            List<Object> transectText = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            transectText = Factory.getByIdentifiers(c, ids);
            if (transectText.isEmpty()) {
                return null;
            }
            return (TransectTextData)transectText.get(0);
        }

        public static List<TransectTextData> getByIdentifiers(TransectColumn c, List<ModelIdentifier> ids) {
            ArrayList<TransectTextData> transectText = new ArrayList<TransectTextData>();
            List<SourceResult> results = TransectTextDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                transectText.add(new TransectTextData(c, ids.get(i), results.get(i)));
            }
            return transectText;
        }

        public static List<TransectTextData> getByAge(TransectColumn col, double top, double bottom) {
            List<SourceResult> results = TransectTextDataStorage.findByAge(col, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 5);
            return Factory.getByIdentifiers(col, ids);
        }
    }
}

