/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.ModelIdentifier;
import model.SequenceData;
import model.storage.SequenceColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class SequenceColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean trend = false;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public SequenceColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 20));
    }

    public SequenceColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setTrend(result.getBool("trend"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            SequenceColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            SequenceColumnStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isTrend() {
        return this.trend;
    }

    public final void setTrend(boolean trend) {
        this.trend = trend;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public List<SequenceData> getDataByAge(double top, double bottom) {
        return SequenceData.Factory.getByAge(this, top, bottom);
    }

    @Override
    public String toString() {
        return super.toString() + "SEQUENCE_COLUMN [ Identifier( " + this.identifier.toString() + ") Trend = " + this.isTrend() + " Deleted = " + this.isDeleted() + "]";
    }

    public static class Factory {
        public static List<SequenceColumn> getByTitle(String title) {
            List<SourceResult> results = SequenceColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 20);
            return Factory.getByIdentifiers(ids);
        }

        public static SequenceColumn getByIdentifier(ModelIdentifier id) {
            List<Object> sequenceColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            sequenceColumns = Factory.getByIdentifiers(ids);
            if (sequenceColumns.isEmpty()) {
                return null;
            }
            return (SequenceColumn)sequenceColumns.get(0);
        }

        public static List<SequenceColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<SequenceColumn> sequenceColumns = new ArrayList<SequenceColumn>();
            List<SourceResult> results = SequenceColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                sequenceColumns.add(new SequenceColumn(ids.get(i), results.get(i)));
            }
            return sequenceColumns;
        }
    }
}

