/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.FreehandPolygonData;
import model.ModelIdentifier;
import model.storage.FreehandPointStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class FreehandPoint {
    private ModelIdentifier identifier = null;
    private FreehandPolygonData polygon = null;
    private double width_pos = 0.0;
    private double age_pos = 0.0;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public FreehandPoint(FreehandPolygonData poly, String database) {
        this.setPolygon(poly);
        this.setIdentifier(new ModelIdentifier(0, database, 15));
    }

    public FreehandPoint(FreehandPolygonData polygon, ModelIdentifier identifier, SourceResult result) {
        this.setIdentifier(identifier);
        this.setPolygon(polygon);
        this.setWidthPos(result.getDouble("x_pos"));
        this.setAgePos(result.getDouble("y_pos"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    public void save() {
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            FreehandPointStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            FreehandPointStorage.update(this);
        }
    }

    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public FreehandPolygonData getPolygon() {
        return this.polygon;
    }

    public final void setPolygon(FreehandPolygonData polygon) {
        this.polygon = polygon;
    }

    public double getWidthPos() {
        return this.width_pos;
    }

    public final void setWidthPos(double width_pos) {
        this.width_pos = width_pos;
    }

    public double getAgePos() {
        return this.age_pos;
    }

    public final void setAgePos(double age_pos) {
        this.age_pos = age_pos;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static List<FreehandPoint> getById(FreehandPolygonData polygon, List<ModelIdentifier> ids) {
            ArrayList<FreehandPoint> freehandPointData = new ArrayList<FreehandPoint>();
            List<SourceResult> results = FreehandPointStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                freehandPointData.add(new FreehandPoint(polygon, ids.get(i), results.get(i)));
            }
            return freehandPointData;
        }

        public static List<FreehandPoint> getByPolygon(FreehandPolygonData polygon) {
            List<SourceResult> results = FreehandPointStorage.findByPolygon(polygon);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 15);
            return Factory.getById(polygon, ids);
        }
    }
}

