/*
 * Decompiled with CFR 0.152.
 */
package map;

import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import gui.TSCAction;
import gui.TSCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreeNode;
import map.MapCircle;
import map.MapFrame;
import map.MapInformation;
import map.MapLocation;
import map.MapPolarCoordinates;
import map.MapRectangle;
import map.MapRectangularCoordinates;
import map.MapSub;
import map.MapTransect;
import util.Debug;
import util.FileUtils;

public class MapPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
ActionListener {
    MapFrame mfd;
    TSCAction generateAction = null;
    Image mapImage;
    Point center = new Point();
    Point mousePos = new Point();
    Point oldCenter = new Point();
    MapInformation currentMap;
    Datastore ds;
    Dimension initialSize;
    BufferedImage myPat = null;
    TexturePaint tp;
    int count = 0;
    public double scale;
    public ArrayList<String> meLocations;
    public ArrayList<Boolean> meSelected;
    public boolean adjustStuff;
    public double myBase = 0.0;
    public int myDotSize = 0;
    public double minAge = 0.0;
    public double maxAge = 0.0;
    JWindow tooltip;
    JLabel ttLabel;

    public void setDs(Datastore ds) {
        this.ds = ds;
    }

    public MapPanel(int width, int height, Datastore ds, boolean interactive) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.initialSize = new Dimension(width, height);
        this.center.x = width / 2;
        this.center.y = height / 2;
        this.setPreferredSize(new Dimension(width, height));
        this.scale = 1.0;
        this.adjustStuff = interactive;
        this.initTooltip();
        this.ds = ds;
    }

    public void loadMap(String mapName) {
        this.currentMap = this.ds.getMap(mapName);
        try {
            this.mapImage = ImageIO.read(new File(this.currentMap.imageName));
        }
        catch (IOException e) {
            System.out.println("FATAL ERROR: could not load map image \"" + this.currentMap.imageName + "\" in map \"" + this.currentMap.imageName + "\".");
            System.out.println("Exception was: " + e.toString());
            File f = new File(".");
            System.out.println("Current Directory is: " + f.getAbsolutePath());
            e.printStackTrace();
            System.exit(1);
        }
        this.addChildren();
        this.setCenters();
        this.repaint();
    }

    private void addChildren() {
        Iterator it = this.ds.getMapIterator();
        while (it.hasNext()) {
            MapInformation mi = (MapInformation)it.next();
            if (mi.parentName == null || !mi.parentName.equalsIgnoreCase(this.currentMap.mapName) || !(mi.parentCoordinates instanceof MapRectangularCoordinates)) continue;
            MapRectangularCoordinates parentCoords = (MapRectangularCoordinates)mi.parentCoordinates;
            double width = parentCoords.lowerRight.x - parentCoords.upperLeft.x;
            double height = parentCoords.lowerRight.y - parentCoords.upperLeft.y;
            Point2D.Double centerCoordinate = new Point2D.Double();
            centerCoordinate.x = parentCoords.lowerRight.x - width / 2.0;
            centerCoordinate.y = parentCoords.lowerRight.y - height / 2.0;
            Point upLeft = this.convertCoordinates(parentCoords.upperLeft.x, parentCoords.upperLeft.y);
            Point lowRight = this.convertCoordinates(parentCoords.lowerRight.x, parentCoords.lowerRight.y);
            int pixelWidth = lowRight.x - upLeft.x;
            int pixelHeight = lowRight.y - upLeft.y;
            MapRectangle ml = new MapRectangle(centerCoordinate.x, centerCoordinate.y, pixelWidth, pixelHeight, mi.mapName);
            this.currentMap.locations.add(ml);
        }
    }

    private void setCenters() {
        for (MapLocation loc : this.currentMap.locations) {
            Point newCenter = this.convertCoordinates(loc.longitude, loc.latitude);
            if (this.ds.getColumnByName(loc.locationName) != null) {
                loc.setSelected(this.ds.getColumnByName(loc.locationName).isSelected());
            }
            boolean x = false;
            if (loc instanceof MapRectangle) {
                MapRectangle r = (MapRectangle)loc;
                MapInformation mi = this.ds.getMap(r.locationName);
                MapRectangularCoordinates parentCoords = (MapRectangularCoordinates)mi.parentCoordinates;
                double width = parentCoords.lowerRight.x - parentCoords.upperLeft.x;
                double height = parentCoords.lowerRight.y - parentCoords.upperLeft.y;
                Point2D.Double centerCoordinate = new Point2D.Double();
                centerCoordinate.x = parentCoords.lowerRight.x - width / 2.0;
                centerCoordinate.y = parentCoords.lowerRight.y - height / 2.0;
                Point upLeft = this.convertCoordinates(parentCoords.upperLeft.x, parentCoords.upperLeft.y);
                Point lowRight = this.convertCoordinates(parentCoords.lowerRight.x, parentCoords.lowerRight.y);
                int pixelWidth = lowRight.x - upLeft.x;
                int pixelHeight = lowRight.y - upLeft.y;
                r.longitude = centerCoordinate.x;
                r.latitude = centerCoordinate.y;
                r.width = pixelWidth;
                r.height = pixelHeight;
            }
            loc.setCenter(newCenter);
        }
    }

    public void resetSelected() {
        for (MapLocation loc : this.currentMap.locations) {
            if (this.ds.getColumnByName(loc.locationName) == null) continue;
            loc.setSelected(this.ds.getColumnByName(loc.locationName).isSelected());
        }
    }

    private Point convertCoordinates(double longitude, double latitude) {
        Object[] params;
        if (this.currentMap.coordinates instanceof MapRectangularCoordinates) {
            params = new Object[]{new Double(longitude), new Double(latitude), new Integer(this.getWidth()), new Integer(this.getHeight())};
        } else if (this.currentMap.coordinates instanceof MapPolarCoordinates) {
            params = new Object[]{new Double(longitude), new Double(latitude), new Integer(this.getWidth()), new Integer(this.getHeight())};
        } else {
            System.out.println("A coordinate system is being used which does not have an implementation.");
            return new Point(0, 0);
        }
        return (Point)this.currentMap.coordinates.convertCoordinates(params);
    }

    public void zoom(boolean zoom) {
        if (zoom) {
            this.scales(this.scale + 1.0);
        } else if (this.scale > 1.0) {
            this.scales(this.scale - 1.0);
        }
    }

    public void resetZoom() {
        this.scale = 1.0;
        this.center.x = this.initialSize.width / 2;
        this.center.y = this.initialSize.height / 2;
        this.setPreferredSize(this.initialSize);
        this.repaint();
    }

    public boolean checkReader(String myCard) {
        boolean gate = true;
        try {
            ImageIO.read(new File(myCard));
        }
        catch (IOException e1) {
            gate = false;
        }
        return gate;
    }

    public boolean checkJarReader(String myCard) {
        boolean gate = true;
        InputStream in = this.getClass().getResourceAsStream("/resources/Patterns/" + myCard + ".PNG");
        if (in == null) {
            gate = false;
        }
        return gate;
    }

    @Override
    public void paintComponent(Graphics screen) {
        MapLocation location;
        int x;
        Graphics2D screen2d = (Graphics2D)screen;
        this.center = this.validateCenter(this.center);
        screen2d.setColor(Color.black);
        screen2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        screen2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        screen.drawImage(this.mapImage, -(this.center.x - this.getWidth() / 2), -(this.center.y - this.getHeight() / 2), (int)((double)this.getWidth() * this.scale), (int)((double)this.getHeight() * this.scale), null);
        if (this.scale == 1.0) {
            this.setCenters();
        }
        for (x = 0; x < this.currentMap.locations.size(); ++x) {
            location = this.currentMap.locations.get(x);
            if (!(location instanceof MapTransect)) continue;
            MapTransect mt = (MapTransect)location;
            mt.scaleTransect(this.center, this.getWidth(), this.getHeight());
            screen2d.setColor(this.getLocationColor(location));
            screen2d.fillPolygon(mt.getTransect());
            screen2d.setColor(Color.black);
            screen2d.drawPolygon(mt.getTransect());
        }
        for (x = 0; x < this.currentMap.locations.size(); ++x) {
            int checkCou;
            location = this.currentMap.locations.get(x);
            DataColumn d = this.ds.getColumnByName(location.locationName);
            double meLat = location.latitude;
            double meLong = location.longitude;
            ArrayList<String> locCheck = new ArrayList<String>();
            ArrayList<Boolean> selCheck = new ArrayList<Boolean>();
            if (location instanceof MapCircle) {
                for (int y = 0; y < this.currentMap.locations.size(); ++y) {
                    MapLocation meLoc = this.currentMap.locations.get(y);
                    if (meLoc.longitude != meLong || meLoc.latitude != meLat || !(meLoc instanceof MapCircle)) continue;
                    locCheck.add(meLoc.locationName);
                    selCheck.add(meLoc.isSelected());
                }
            }
            if (!this.adjustStuff) {
                if (location instanceof MapCircle) {
                    if (this.getLocationColor(location) != MapLocation.COLOR_INFORMATIONAL) {
                        DataColumn d1 = null;
                        Enumeration<TreeNode> e = d.children();
                        while (e.hasMoreElements()) {
                            boolean myThingy2;
                            boolean myThingy;
                            String pat_Path;
                            d1 = (DataColumn)e.nextElement();
                            Iterator iter = d1.getData();
                            double topAge_selected = 0.0;
                            double baseAge_selected = this.myBase;
                            double baseAge = 0.0;
                            Datapoint p = null;
                            Datapoint tmp = null;
                            String pattern_name = null;
                            boolean reachedBase = false;
                            while (iter.hasNext()) {
                                p = (Datapoint)iter.next();
                                if (p.baseAge > topAge_selected && p.baseAge < baseAge_selected) continue;
                                if (p.value != null && p.value.toString().toLowerCase() != "top") {
                                    pattern_name = p.value.toString();
                                }
                                if (p.baseAge >= baseAge_selected && pattern_name != null && !pattern_name.toLowerCase().equals("lad") && !pattern_name.toLowerCase().equals("fad")) {
                                    reachedBase = true;
                                    break;
                                }
                                baseAge = p.baseAge;
                                tmp = p;
                            }
                            if (reachedBase) {
                                block40: {
                                    if (p != null) {
                                        try {
                                            if (!(pattern_name == null || pattern_name.toLowerCase().equals("top") || pattern_name.toLowerCase().equals("lad") || pattern_name.toLowerCase().equals("fad"))) {
                                                pattern_name = pattern_name.replaceAll("/", ":");
                                                pat_Path = "resources/Patterns/" + pattern_name + ".png";
                                                myThingy = this.checkReader("resources/Patterns/No Data.png");
                                                myThingy2 = this.checkJarReader(pattern_name);
                                                this.myPat = myThingy ? ImageIO.read(new File(pat_Path)) : (myThingy2 ? ImageIO.read(MapPanel.class.getResourceAsStream("/resources/Patterns/" + pattern_name + ".PNG")) : ImageIO.read(MapPanel.class.getResourceAsStream("/resources/Patterns/No Pattern.PNG")));
                                                this.tp = new TexturePaint(this.myPat, new Rectangle(0, 0, 50, 50));
                                                screen2d.setPaint(this.tp);
                                                break block40;
                                            }
                                            screen2d.setColor(this.getLocationColor(location));
                                        }
                                        catch (IOException e1) {
                                            System.out.println("shit happends " + pattern_name);
                                        }
                                    } else {
                                        System.out.println("What is this? " + x + " " + location.locationName);
                                    }
                                }
                                if (pattern_name.toLowerCase().equals("lad") || pattern_name.toLowerCase().equals("fad")) continue;
                                break;
                            }
                            try {
                                if (!(pattern_name == null || pattern_name.toLowerCase().equals("top") || pattern_name.toLowerCase().equals("lad") || pattern_name.toLowerCase().equals("fad"))) {
                                    pattern_name = pattern_name.replaceAll("/", ":");
                                    pat_Path = "resources/Patterns/" + pattern_name + ".png";
                                    myThingy = this.checkReader("resources/Patterns/No Data.png");
                                    myThingy2 = this.checkJarReader(pattern_name);
                                    this.myPat = myThingy ? ImageIO.read(new File(pat_Path)) : (myThingy2 ? ImageIO.read(MapPanel.class.getResourceAsStream("/resources/Patterns/" + pattern_name + ".PNG")) : ImageIO.read(MapPanel.class.getResourceAsStream("/resources/Patterns/No Pattern.PNG")));
                                    this.tp = new TexturePaint(this.myPat, new Rectangle(0, 0, 50, 50));
                                    screen2d.setPaint(this.tp);
                                    continue;
                                }
                                screen2d.setColor(this.getLocationColor(location));
                            }
                            catch (IOException e1) {
                                System.out.println("D'OH! " + pattern_name);
                            }
                        }
                    } else {
                        screen2d.setColor(this.getLocationColor(location));
                    }
                } else if (selCheck == null || selCheck.size() == 1) {
                    screen2d.setColor(this.getLocationColor(location));
                } else {
                    checkCou = 0;
                    for (int alpha = 0; alpha < selCheck.size(); ++alpha) {
                        if (!((Boolean)selCheck.get(alpha)).booleanValue()) continue;
                        ++checkCou;
                    }
                    if (checkCou == 0) {
                        screen2d.setColor(this.getLocationColor(location));
                    } else {
                        try {
                            String pat_Path = "resources/Patterns/Partially Full.png";
                            boolean myThingy = this.checkReader(pat_Path);
                            this.myPat = myThingy ? ImageIO.read(new File(pat_Path)) : ImageIO.read(MapPanel.class.getResourceAsStream("/resources/Patterns/Partially Full.PNG"));
                            this.tp = new TexturePaint(this.myPat, new Rectangle(0, 0, 50, 50));
                            screen2d.setPaint(this.tp);
                        }
                        catch (IOException e1) {
                            System.out.println("shit happends");
                        }
                    }
                }
            } else {
                try {
                    checkCou = 0;
                    for (int alpha = 0; alpha < selCheck.size(); ++alpha) {
                        if (!((Boolean)selCheck.get(alpha)).booleanValue()) continue;
                        ++checkCou;
                    }
                    if (checkCou == selCheck.size() || checkCou == 0) {
                        screen2d.setColor(this.getLocationColor(location));
                    }
                    String pat_Path = "resources/Patterns/Partially Full.png";
                    boolean myThingy = this.checkReader(pat_Path);
                    this.myPat = myThingy ? ImageIO.read(new File(pat_Path)) : ImageIO.read(MapPanel.class.getResourceAsStream("/resources/Patterns/Partially Full.PNG"));
                    this.tp = new TexturePaint(this.myPat, new Rectangle(0, 0, 50, 50));
                    screen2d.setPaint(this.tp);
                }
                catch (IOException e2) {
                    System.out.println("D'OH!");
                }
            }
            if (location instanceof MapCircle) {
                if (!this.adjustStuff) {
                    double myDots = (1.0 + (double)this.myDotSize / 4.0) * (double)MapCircle.SIZE;
                    int fDots = (int)myDots;
                    MapCircle circle = (MapCircle)location;
                    screen2d.fillOval(circle.getCenter().x - (this.center.x - this.getWidth() / 2 + 2 * this.myDotSize) - MapCircle.OFFSET, circle.getCenter().y - (this.center.y - this.getHeight() / 2 + 2 * this.myDotSize) - MapCircle.OFFSET, fDots, fDots);
                    screen2d.setColor(Color.black);
                    screen2d.drawOval(circle.getCenter().x - (this.center.x - this.getWidth() / 2 + 2 * this.myDotSize) - MapCircle.OFFSET, circle.getCenter().y - (this.center.y - this.getHeight() / 2 + 2 * this.myDotSize) - MapCircle.OFFSET, fDots, fDots);
                } else {
                    MapCircle circle = (MapCircle)location;
                    screen2d.fillOval(circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapCircle.OFFSET, circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapCircle.OFFSET, MapCircle.SIZE, MapCircle.SIZE);
                    screen2d.setColor(Color.black);
                    screen2d.drawOval(circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapCircle.OFFSET, circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapCircle.OFFSET, MapCircle.SIZE, MapCircle.SIZE);
                    if (selCheck.size() > 1) {
                        screen2d.setColor(Color.red);
                        screen2d.fillOval(circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapCircle.OFFSET, circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapCircle.OFFSET, MapCircle.SIZE / 2, MapCircle.SIZE / 2);
                    }
                }
            }
            if (location instanceof MapSub) {
                MapSub circle = (MapSub)location;
                screen2d.fillOval(circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapSub.OFFSET, circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapSub.OFFSET, MapSub.SIZE, MapSub.SIZE);
                screen2d.setColor(Color.black);
                screen2d.drawOval(circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapSub.OFFSET, circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapSub.OFFSET, MapSub.SIZE, MapSub.SIZE);
            }
            if (!(location instanceof MapRectangle)) continue;
            MapRectangle rectangle = (MapRectangle)location;
            screen2d.setColor(Color.yellow);
            int a = rectangle.getCenter().x - (this.center.x - this.getWidth() / 2);
            int b = rectangle.getCenter().y - (this.center.y - this.getHeight() / 2);
            a = (int)((double)a - (double)(rectangle.getWidth() / 2) * this.scale);
            b = (int)((double)b - (double)(rectangle.getHeight() / 2) * this.scale);
            screen2d.drawRect(a, b, (int)((double)rectangle.getWidth() * this.scale), (int)((double)rectangle.getHeight() * this.scale));
        }
    }

    public URL getPatPath(URL gif_url) {
        InputStream svg_stream;
        String gif_string = gif_url.toString();
        URL svg_url = null;
        try {
            svg_url = new URL(gif_string.substring(0, gif_string.length() - 3) + "svg");
            svg_stream = FileUtils.getInputStream(svg_url.toString());
        }
        catch (Exception e) {
            svg_stream = null;
        }
        if (svg_stream != null) {
            return svg_url;
        }
        URL png_url = null;
        InputStream png_stream = null;
        try {
            png_url = new URL(gif_string.substring(0, gif_string.length() - 3) + "png");
            png_stream = FileUtils.getInputStream(png_url.toString());
        }
        catch (Exception e) {
            png_stream = null;
        }
        if (png_stream != null) {
            return png_url;
        }
        InputStream gif_stream = null;
        File png_converted_file = null;
        URL png_converted_url = null;
        try {
            gif_stream = FileUtils.getInputStream(gif_url.toString());
        }
        catch (Exception e) {
            gif_stream = null;
        }
        if (gif_stream != null) {
            try {
                png_converted_file = File.createTempFile("converted_gif", ".png");
                File temp_gif_file = File.createTempFile("copy_of_gif", ".gif");
                FileOutputStream outstream = new FileOutputStream(temp_gif_file);
                byte[] buf = new byte[1024];
                int num_bytes_read = 0;
                while ((num_bytes_read = gif_stream.read(buf)) > 0) {
                    outstream.write(buf, 0, num_bytes_read);
                }
                outstream.close();
                BufferedImage image = ImageIO.read(temp_gif_file);
                ImageIO.write((RenderedImage)image, "png", png_converted_file);
                png_converted_url = png_converted_file.toURI().toURL();
            }
            catch (Exception ex) {
                Debug.print("Unable to convert gif file to png.  Exception was: " + ex.toString());
                return null;
            }
            Debug.print("Converted gif " + gif_url.toString() + " to png " + png_converted_url.toString());
            return png_converted_url;
        }
        Debug.print("gif_image_path " + gif_url.toString() + " does not exist!");
        return null;
    }

    private Color getLocationColor(MapLocation location) {
        DataColumn column;
        boolean isInformational;
        boolean bl = isInformational = this.ds.getColumnByName(location.locationName) == null;
        if (isInformational) {
            return MapLocation.COLOR_INFORMATIONAL;
        }
        if (column.grayedOut) {
            return MapLocation.COLOR_NO_INTERVAL_DATA;
        }
        if (column.isSelected()) {
            boolean allFlagsSelected = true;
            for (column = this.ds.getColumnByName(location.locationName); column != null; column = column.getColParent()) {
                if (column.isSelected()) continue;
                allFlagsSelected = false;
            }
            if (allFlagsSelected) {
                return MapLocation.COLOR_SELECTED;
            }
            return MapLocation.COLOR_AVAILABLE;
        }
        return MapLocation.COLOR_AVAILABLE;
    }

    public Point validateCenter(Point newCenter) {
        if (newCenter.x < this.getWidth() / 2) {
            newCenter.x = this.getWidth() / 2;
        }
        if ((double)newCenter.x > (double)this.getWidth() * this.scale - (double)(this.getWidth() / 2)) {
            newCenter.x = (int)((double)this.getWidth() * this.scale - (double)(this.getWidth() / 2));
        }
        if (newCenter.y < this.getHeight() / 2) {
            newCenter.y = this.getHeight() / 2;
        }
        if ((double)newCenter.y > (double)this.getHeight() * this.scale - (double)(this.getHeight() / 2)) {
            newCenter.y = (int)((double)this.getHeight() * this.scale - (double)(this.getHeight() / 2));
        }
        return newCenter;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.oldCenter = this.center;
        Point offset = new Point();
        offset.x = (int)(this.mousePos.getX() - (double)e.getX());
        offset.y = (int)(this.mousePos.getY() - (double)e.getY());
        this.mousePos = e.getPoint();
        Point newCenter = new Point(this.center.x + offset.x, this.center.y + offset.y);
        this.center = this.validateCenter(newCenter);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.mousePos = e.getPoint();
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.mousePos = e.getPoint();
        }
    }

    public void scales(double newScale) {
        this.oldCenter = this.center;
        this.resetPointsScale(newScale);
        double xproportion = (double)this.oldCenter.x / ((double)this.getWidth() * this.scale);
        double yproportion = (double)this.oldCenter.y / ((double)this.getHeight() * this.scale);
        this.scale = newScale;
        Point newCenter = new Point((int)((double)this.getWidth() * newScale * xproportion), (int)((double)this.getHeight() * newScale * yproportion));
        this.center = this.validateCenter(newCenter);
        this.repaint();
    }

    public void resetPointsScale(double newScale) {
        for (int x = 0; x < this.currentMap.locations.size(); ++x) {
            double xproportion = (double)this.currentMap.locations.get((int)x).getCenter().x / ((double)this.getWidth() * this.scale);
            double yproportion = (double)this.currentMap.locations.get((int)x).getCenter().y / ((double)this.getHeight() * this.scale);
            Point newLocation = new Point((int)((double)this.getWidth() * newScale * xproportion), (int)((double)this.getHeight() * newScale * yproportion));
            this.currentMap.locations.get(x).setCenter(newLocation);
        }
    }

    public Point scalePoint(Point p, double newScale, double oldScale) {
        double xproportion = (double)p.x / ((double)this.getWidth() * oldScale);
        double yproportion = (double)p.y / ((double)this.getHeight() * oldScale);
        Point newLocation = new Point((int)((double)this.getWidth() * newScale * xproportion), (int)((double)this.getHeight() * newScale * yproportion));
        return newLocation;
    }

    public String getPattern(MapLocation billy) {
        DataColumn d = this.ds.getColumnByName(billy.locationName);
        String pattern_name = null;
        DataColumn d1 = null;
        boolean reachTop = false;
        Enumeration<TreeNode> e = d.children();
        while (e.hasMoreElements()) {
            d1 = (DataColumn)e.nextElement();
            Iterator iter = d1.getData();
            double topAge_selected = TSCreator.settings1.topAge;
            double baseAge_selected = TSCreator.settings1.baseAge;
            double baseAge = 0.0;
            Datapoint p = null;
            boolean reachedBase = false;
            while (iter.hasNext()) {
                p = (Datapoint)iter.next();
                if (p.baseAge > topAge_selected && p.baseAge < baseAge_selected) continue;
                if (p.value != null && p.value.toString().toLowerCase() != "top") {
                    pattern_name = p.value.toString();
                }
                if (p.baseAge >= baseAge_selected) {
                    reachedBase = true;
                    break;
                }
                baseAge = p.baseAge;
            }
            if (!reachedBase) continue;
            break;
        }
        if (pattern_name == null || pattern_name.toLowerCase().equals("top")) {
            pattern_name = "No Data";
        }
        return pattern_name;
    }

    public void newFaciesWindow(String myMap) {
        MapInformation newMap = this.ds.getMap(myMap);
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(newMap.imageName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.minAge = 0.0;
        this.maxAge = 0.0;
        for (int x = 0; x < newMap.locations.size(); ++x) {
            MapLocation location = newMap.locations.get(x);
            DataColumn d = this.ds.getColumnByName(location.locationName);
            DataColumn d1 = null;
            if (d == null) continue;
            Enumeration<TreeNode> e = d.children();
            while (e.hasMoreElements()) {
                d1 = (DataColumn)e.nextElement();
                Iterator iter = d1.getData();
                Datapoint p = null;
                while (iter.hasNext()) {
                    p = (Datapoint)iter.next();
                    if (this.maxAge == 0.0 && this.minAge == 0.0) {
                        this.maxAge = p.baseAge;
                        this.minAge = p.baseAge;
                        continue;
                    }
                    if (p.baseAge > this.maxAge) {
                        this.maxAge = p.baseAge;
                        continue;
                    }
                    if (!(p.baseAge < this.minAge)) continue;
                    this.minAge = p.baseAge;
                }
            }
        }
        this.mfd = new MapFrame(image.getWidth(), image.getHeight(), this.ds, newMap.mapName, this.minAge, this.maxAge);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point myCenter = new Point(screenSize.width / 3, 0);
        this.mfd.setLocation(myCenter);
        this.mfd.setVisible(true);
        this.mfd.setMapGenerateAction(this.generateAction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MapLocation location;
        Point clickPoint = e.getPoint();
        ArrayList<String> lcLocations = new ArrayList<String>();
        ArrayList<Boolean> lSelected = new ArrayList<Boolean>();
        ArrayList<MapLocation> mePicList = new ArrayList<MapLocation>();
        Point topLeft = new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
        boolean circleEnc = false;
        for (int x = 0; x < this.currentMap.locations.size(); ++x) {
            MapTransect transect;
            MapLocation circle;
            boolean isInformational;
            location = this.currentMap.locations.get(x);
            boolean bl = isInformational = this.ds.getColumnByName(location.locationName) == null;
            if (location instanceof MapRectangle) {
                MapRectangle rectangle = (MapRectangle)location;
                if (!((double)clickPoint.x <= (double)(rectangle.getCenter().x - (this.center.x - this.getWidth() / 2)) - (double)(rectangle.getWidth() / 2) * this.scale + (double)rectangle.getWidth() * this.scale) || !((double)clickPoint.x >= (double)(rectangle.getCenter().x - (this.center.x - this.getWidth() / 2)) - (double)(rectangle.getWidth() / 2) * this.scale) || !((double)clickPoint.y <= (double)(rectangle.getCenter().y - (this.center.y - this.getHeight() / 2)) - (double)(rectangle.getHeight() / 2) * this.scale + (double)rectangle.getHeight() * this.scale) || !((double)clickPoint.y >= (double)(rectangle.getCenter().y - (this.center.y - this.getHeight() / 2)) - (double)(rectangle.getHeight() / 2) * this.scale)) continue;
                if (e.getID() == 503) {
                    this.displayTooltip(location, e.getPoint());
                    return;
                }
                if (e.getModifiers() == 16) {
                    MapInformation newMap = this.ds.getMap(this.currentMap.locations.get((int)x).locationName);
                    BufferedImage image = null;
                    try {
                        image = ImageIO.read(new File(newMap.imageName));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mfd = new MapFrame(image.getWidth(), image.getHeight(), this.ds, newMap.mapName);
                    this.mfd.setLocationRelativeTo(null);
                    this.mfd.setVisible(true);
                    this.mfd.setMapGenerateAction(this.generateAction);
                    break;
                }
                if (e.getModifiers() != 4) continue;
                this.currentMap.locations.get(x).changeSelected();
                this.ds.getColumnByName(this.currentMap.locations.get((int)x).locationName).checkboxClick();
                continue;
            }
            if (isInformational && e.getID() == 500) continue;
            if (location instanceof MapCircle) {
                circle = (MapCircle)location;
                if (clickPoint.x > circle.getCenter().x - (this.center.x - this.getWidth() / 2) + MapCircle.OFFSET || clickPoint.x < circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapCircle.OFFSET || clickPoint.y > circle.getCenter().y - (this.center.y - this.getHeight() / 2) + MapCircle.OFFSET || clickPoint.y < circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapCircle.OFFSET) continue;
                if (e.getID() == 503) {
                    this.displayTooltip(location, e.getPoint());
                    return;
                }
                if (this.ds.getColumnByName(((MapCircle)circle).locationName) == null) continue;
                lcLocations.add(((MapCircle)circle).locationName);
                lSelected.add(circle.isSelected());
                mePicList.add(location);
                circleEnc = true;
                continue;
            }
            if (location instanceof MapSub) {
                circle = (MapSub)location;
                if (clickPoint.x > circle.getCenter().x - (this.center.x - this.getWidth() / 2) + MapSub.OFFSET || clickPoint.x < circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapSub.OFFSET || clickPoint.y > circle.getCenter().y - (this.center.y - this.getHeight() / 2) + MapSub.OFFSET || clickPoint.y < circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapSub.OFFSET) continue;
                if (e.getID() == 503) {
                    this.displayTooltip(location, e.getPoint());
                    return;
                }
                if (this.ds.getColumnByName(((MapSub)circle).locationName) == null) continue;
                circle.changeSelected();
                this.ds.getColumnByName(((MapSub)circle).locationName).checkboxClick();
                break;
            }
            if (!(location instanceof MapTransect) || !(transect = (MapTransect)location).getTransect().contains(clickPoint)) continue;
            if (e.getID() == 503) {
                this.displayTooltip(location, e.getPoint());
                return;
            }
            if (this.ds.getColumnByName(transect.locationName) == null || circleEnc) continue;
            transect.changeSelected();
            this.ds.getColumnByName(transect.locationName).checkboxClick();
        }
        for (int y = 0; y < this.currentMap.locations.size(); ++y) {
            location = this.currentMap.locations.get(y);
            if (!(location instanceof MapCircle) || !this.adjustStuff) continue;
            final MapCircle circle = (MapCircle)location;
            if (clickPoint.x > circle.getCenter().x - (this.center.x - this.getWidth() / 2) + MapCircle.OFFSET || clickPoint.x < circle.getCenter().x - (this.center.x - this.getWidth() / 2) - MapCircle.OFFSET || clickPoint.y > circle.getCenter().y - (this.center.y - this.getHeight() / 2) + MapCircle.OFFSET || clickPoint.y < circle.getCenter().y - (this.center.y - this.getHeight() / 2) - MapCircle.OFFSET) continue;
            JPopupMenu n = new JPopupMenu();
            ActionListener menuListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String firstWord = event.getActionCommand();
                    String[] split = firstWord.split(", ");
                    String secondWord = split[1];
                    circle.changeSelected();
                    MapPanel.this.ds.getColumnByName(secondWord).checkboxClick();
                    if (MapPanel.this.meLocations.size() > 1) {
                        for (int z = 0; z < MapPanel.this.meLocations.size(); ++z) {
                            if (!secondWord.equals(MapPanel.this.meLocations.get(z))) continue;
                            if (!MapPanel.this.meSelected.get(z).booleanValue()) {
                                MapPanel.this.meSelected.set(z, true);
                                continue;
                            }
                            MapPanel.this.meSelected.set(z, false);
                        }
                    }
                }
            };
            if (lSelected.size() == 1) {
                circle.changeSelected();
                this.ds.getColumnByName((String)lcLocations.get(0)).checkboxClick();
                break;
            }
            for (int i = 0; i < lSelected.size(); ++i) {
                JMenuItem item;
                boolean myThingy2;
                boolean myThingy;
                String goodies = (String)lcLocations.get(i);
                String myPats = this.getPattern((MapLocation)mePicList.get(i));
                myPats = myPats.replaceAll("/", ":");
                if (!((Boolean)lSelected.get(i)).booleanValue()) {
                    myThingy = this.checkReader("resources/Patterns/No Data.PNG");
                    myThingy2 = this.checkJarReader(this.getPattern((MapLocation)mePicList.get(i)));
                    item = myThingy ? new JMenuItem("OFF, " + goodies + ", " + this.getPattern((MapLocation)mePicList.get(i)), new ImageIcon("resources/Patterns/" + myPats + ".PNG")) : (myThingy2 ? new JMenuItem("OFF, " + goodies + ", " + this.getPattern((MapLocation)mePicList.get(i)), new ImageIcon(this.getClass().getResource("/resources/Patterns/" + myPats + ".PNG"))) : new JMenuItem("OFF, " + goodies + ", " + this.getPattern((MapLocation)mePicList.get(i)), new ImageIcon("resources/Patterns/No Pattern.PNG")));
                    n.add(item);
                } else {
                    myThingy = this.checkReader("resources/Patterns/No Data.PNG");
                    myThingy2 = this.checkJarReader(this.getPattern((MapLocation)mePicList.get(i)));
                    item = myThingy ? new JMenuItem("ON, " + goodies + ", " + this.getPattern((MapLocation)mePicList.get(i)), new ImageIcon("resources/Patterns/" + myPats + ".PNG")) : (myThingy2 ? new JMenuItem("ON, " + goodies + ", " + this.getPattern((MapLocation)mePicList.get(i)), new ImageIcon(this.getClass().getResource("/resources/Patterns/" + myPats + ".PNG"))) : new JMenuItem("ON, " + goodies + ", " + this.getPattern((MapLocation)mePicList.get(i)), new ImageIcon("resources/Patterns/No Pattern.PNG")));
                    item.setForeground(new Color(0, 150, 50));
                    n.add(item);
                }
                item.setMnemonic(66);
                item.addActionListener(menuListener);
            }
            n.show(this, clickPoint.x, clickPoint.y);
        }
        this.meLocations = lcLocations;
        this.meSelected = lSelected;
        this.tooltip.setVisible(false);
        this.repaint();
    }

    private void doPop(MouseEvent e) {
    }

    private void Popup(Component component, int x, int y) {
    }

    private void maybeShowPopup(MouseEvent e) {
    }

    public void setMapGenerateAction(TSCAction a) {
        this.generateAction = a;
    }

    private void initTooltip() {
        this.ttLabel = new JLabel(" ");
        this.ttLabel.setOpaque(true);
        this.ttLabel.setBackground(UIManager.getColor("ToolTip.background"));
        this.tooltip = new JWindow(new JFrame());
        this.tooltip.getContentPane().add(this.ttLabel);
    }

    public void closeTooltip() {
        this.tooltip.dispose();
    }

    private void displayTooltip(MapLocation loc, Point p) {
        String text = "";
        int numberOfWordsPerLine = 5;
        String name = this.separateString(loc.getLocationName(), numberOfWordsPerLine);
        text = "<html><b>Name</b>: " + name;
        if (!(loc instanceof MapTransect)) {
            text = text + "<br /><b>Lon/Lat</b>: " + loc.longitude + "/" + loc.latitude;
        }
        if (!loc.getNote().equalsIgnoreCase("")) {
            String note = this.separateString(loc.getNote(), numberOfWordsPerLine);
            text = text + "<br /><b>Note</b>: " + note;
        }
        text = text + "</html>";
        this.ttLabel.setText(text);
        this.tooltip.pack();
        if (!this.tooltip.isVisible()) {
            this.tooltip.setVisible(true);
        }
        SwingUtilities.convertPointToScreen(p, this);
        this.tooltip.setLocation(p.x + 5, p.y - this.tooltip.getHeight() - 5);
        if (this.tooltip.isVisible()) {
            // empty if block
        }
    }

    private String separateString(String line, int numberOfWords) {
        String[] words = line.split(" ");
        String result = "";
        for (int i = 0; i < words.length; ++i) {
            result = result + words[i];
            if (i == words.length - 1) continue;
            if (i != 0 && i % numberOfWords == 0) {
                result = result + "<br />";
                result = result + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                continue;
            }
            result = result + " ";
        }
        return result;
    }

    public void setCenter(Point newCenter) {
        this.center = newCenter;
    }

    public double getMapScale() {
        return this.scale;
    }

    public void setMapScale(double mapScale) {
        this.scale = mapScale;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPop(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

