/*
 * Decompiled with CFR 0.152.
 */
package map;

import gui.ErrorHandler;
import gui.TSCreator;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import map.MapCircle;
import map.MapCoordinates;
import map.MapLocation;
import map.MapPolarCoordinates;
import map.MapRectangularCoordinates;
import map.MapSub;
import map.MapTransect;
import util.CSVReader;

public class MapInformation {
    String imageName;
    Vector<MapLocation> locations;
    Point2D.Double upperLeft;
    Point2D.Double lowerRight;
    String mapName;
    String description;
    MapCoordinates coordinates;
    MapCoordinates parentCoordinates;
    String parentName;

    public Point2D.Double getUpperLeft() {
        return this.upperLeft;
    }

    public Point2D.Double getLowerRight() {
        return this.lowerRight;
    }

    public MapCoordinates getParentCoordinates() {
        return this.parentCoordinates;
    }

    public MapInformation(String name, Point2D.Double upperLeft, Point2D.Double lowerRight) {
        this.imageName = name;
        this.locations = new Vector();
        this.upperLeft = upperLeft;
        this.lowerRight = lowerRight;
    }

    public MapInformation(String name, double upperLeftLatitude, double upperLeftLongitude, double lowerRightLatitude, double lowerRightLongitude) {
        this(name, new Point2D.Double(upperLeftLatitude, upperLeftLongitude), new Point2D.Double(lowerRightLatitude, lowerRightLongitude));
    }

    private MapInformation() {
        this.locations = new Vector();
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public Iterator<MapLocation> getLocationList() {
        return this.locations.iterator();
    }

    public void resetPointsSelected() {
        for (int x = 0; x < this.locations.size(); ++x) {
            if (!this.locations.get(x).isSelected()) continue;
            this.locations.get(x).changeSelected();
        }
    }

    public MapCoordinates getCoordinates() {
        return this.coordinates;
    }

    public static MapInformation MapParseFromFile(String fileName) throws Exception {
        String mapFile;
        File file;
        String[] values;
        MapInformation newMap = new MapInformation();
        String version = "";
        String errorReport = "";
        int lineNum = 0;
        int lastIndex = fileName.lastIndexOf("\\");
        if (lastIndex < 1) {
            lastIndex = fileName.lastIndexOf("/");
        }
        String fileNameNoPath = fileName.substring(lastIndex + 1);
        TSCreator.logAndShow("Trying to load map pack located at: " + fileName, 1);
        CSVReader reader = new CSVReader(new FileReader(fileName), '\t');
        HashMap<String, Integer> currentHeader = new HashMap<String, Integer>();
        while ((values = reader.readNext()) != null) {
            String rowType = values[0];
            ++lineNum;
            if (rowType.equalsIgnoreCase("COMMENT")) continue;
            if (rowType.startsWith("MAP-VERSION")) {
                version = values[1];
                TSCreator.logAndShow("Loading map with version " + version, 1);
                continue;
            }
            if (version.equalsIgnoreCase("1.0") || version.equalsIgnoreCase("1")) {
                String message;
                MapLocation ml;
                if (rowType.startsWith("HEADER")) {
                    currentHeader = new HashMap();
                    for (int i = 0; i < values.length; ++i) {
                        currentHeader.put(values[i].toUpperCase(), i);
                    }
                    continue;
                }
                if (rowType.equalsIgnoreCase("MAP INFO")) {
                    String imagesFolder = "MapImages";
                    try {
                        newMap.imageName = new File(fileName).getParent() + "/" + imagesFolder + "/" + values[currentHeader.get("IMAGE")];
                    }
                    catch (Exception e) {
                        throw new Exception("\nMissing 'IMAGE' field on line : " + (lineNum - 1) + "\n In file: " + fileNameNoPath + "\n");
                    }
                    try {
                        newMap.mapName = values[currentHeader.get("MAP NAME")];
                    }
                    catch (Exception e) {
                        throw new Exception("\nMissing 'MAP NAME' field on line : " + (lineNum - 1) + "\n In file: " + fileNameNoPath + "\n");
                    }
                    try {
                        if (currentHeader.get("NOTE") != null) {
                            newMap.description = values[currentHeader.get("NOTE")];
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("\nMissing 'Note' field on line : " + (lineNum - 1) + "\n In file: " + fileNameNoPath + "\n");
                    }
                    TSCreator.logAndShow("Loading map information + " + newMap.mapName, 1);
                    continue;
                }
                if (rowType.equalsIgnoreCase("PARENT MAP")) {
                    try {
                        newMap.parentName = values[(Integer)currentHeader.get("PARENT NAME")];
                    }
                    catch (Exception e) {
                        throw new Exception("\nMissing 'PARENT NAME' field On line : " + (lineNum - 1) + "\n In file: " + fileNameNoPath + "\n");
                    }
                    newMap.parentCoordinates = MapInformation.getCoordinates(currentHeader, values, lineNum - 1, fileNameNoPath);
                    continue;
                }
                if (rowType.startsWith("COORD")) {
                    newMap.coordinates = MapInformation.getCoordinates(currentHeader, values, lineNum - 1, fileNameNoPath);
                    continue;
                }
                if (rowType.startsWith("TRANSECT")) {
                    try {
                        String name = values[currentHeader.get("NAME")];
                        String startLoc = values[currentHeader.get("STARTLOC")];
                        String endLoc = values[currentHeader.get("ENDLOC")];
                        String note = "";
                        if (currentHeader.get("NOTE") != null && values.length > currentHeader.get("NOTE")) {
                            note = values[currentHeader.get("NOTE")];
                        }
                        MapLocation startCircle = MapInformation.findElement(newMap.locations, startLoc);
                        MapLocation endCircle = MapInformation.findElement(newMap.locations, endLoc);
                        if (startCircle == null || endCircle == null) {
                            String error = "Transect '" + name + "' is missing endpoints ('" + startLoc + "' and '" + endLoc + "')";
                            error = error + "\nPlease verify that the mappack has these endpoints as datacolumns or information points.\n";
                            throw new Exception(error);
                        }
                        ml = new MapTransect(startCircle, endCircle, name, note);
                        newMap.locations.add(ml);
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("\nMissing NAME/STARTLOC/ENDLOC field(s) on line : " + (lineNum - 1) + "\n In file: " + fileNameNoPath + "\n");
                    }
                }
                if (rowType.startsWith("DATACOL") || rowType.startsWith("INFOPT")) {
                    try {
                        double lon = 0.0;
                        lon = currentHeader.get("LONG") != null ? Double.parseDouble(values[currentHeader.get("LONG")]) : Double.parseDouble(values[currentHeader.get("LON")]);
                        double lat = Double.parseDouble(values[currentHeader.get("LAT")]);
                        String name = values[currentHeader.get("NAME")];
                        String note = "";
                        if (currentHeader.get("NOTE") != null && values.length > currentHeader.get("NOTE")) {
                            note = values[currentHeader.get("NOTE")];
                        }
                        ml = new MapCircle(lon, lat, name, note);
                        message = "map point " + name + " done!";
                        newMap.locations.add(ml);
                        TSCreator.logAndShow(message, 1);
                    }
                    catch (Exception e) {
                        ErrorHandler.showError(e, "\nMissing NAME/LAT/LON field(s) on line : " + (lineNum - 1) + "\n In file: " + fileNameNoPath + "\n", "Invalid Header", 3);
                    }
                    continue;
                }
                if (!rowType.startsWith("SUBDIR")) continue;
                try {
                    double lonSub = 0.0;
                    lonSub = currentHeader.get("LONG") != null ? Double.parseDouble(values[currentHeader.get("LONG")]) : Double.parseDouble(values[currentHeader.get("LON")]);
                    double latSub = Double.parseDouble(values[currentHeader.get("LAT")]);
                    String nameSub = values[currentHeader.get("NAME")];
                    String noteSub = "";
                    if (currentHeader.get("NOTE") != null && values.length > currentHeader.get("NOTE")) {
                        noteSub = values[currentHeader.get("NOTE")];
                    }
                    ml = new MapSub(lonSub, latSub, nameSub, noteSub);
                    message = "map point " + nameSub + " done!";
                    newMap.locations.add(ml);
                    TSCreator.logAndShow(message, 1);
                }
                catch (Exception e) {
                    ErrorHandler.showError(e, "\nMissing NAME/LAT/LON field(s) on line : " + (lineNum - 1) + "\n In file: " + fileNameNoPath + "\n", "Invalid Header", 3);
                }
                continue;
            }
            throw new Exception("A map pack version number received which is not supported " + version + "\n");
        }
        ParseResult result = MapInformation.isValidMap(newMap);
        if (result == ParseResult.Success) {
            TSCreator.logAndShow("Map information " + newMap.mapName + " parsed successfully.", 1);
            return newMap;
        }
        if (result == ParseResult.InvalidMapImage) {
            file = new File(fileName);
            File image = new File(newMap.imageName);
            String mapFile2 = file.getName();
            String imageFile = image.getName();
            throw new Exception("Invalid map image \"" + imageFile + "\" for MapPack \"" + mapFile2 + "\".");
        }
        if (result == ParseResult.InvalidMapName) {
            file = new File(fileName);
            mapFile = file.getName();
            throw new Exception("Invalid map name for MapPack \"" + mapFile + "\".");
        }
        file = new File(fileName);
        mapFile = file.getName();
        String err = "Invalid MapPack detected \"" + mapFile + "\".";
        throw new Exception(err);
    }

    private static MapLocation findElement(Vector<MapLocation> locations, String locationName) {
        for (MapLocation loc : locations) {
            if (!loc.locationName.equalsIgnoreCase(locationName)) continue;
            return loc;
        }
        return null;
    }

    private static MapCoordinates getCoordinates(HashMap<String, Integer> header, String[] values, int lineNumber, String fileName) {
        MapCoordinates result = null;
        String type = values[header.get("COORDINATE TYPE")];
        if (type.equalsIgnoreCase(MapRectangularCoordinates.getMapByName())) {
            result = new MapRectangularCoordinates();
        } else if (type.equalsIgnoreCase(MapPolarCoordinates.getMapByName())) {
            result = new MapPolarCoordinates();
        }
        ((MapCoordinates)result).parseCoordinates(header, values, lineNumber, fileName);
        return result;
    }

    private static ParseResult isValidMap(MapInformation map) {
        if (map.mapName == null) {
            return ParseResult.InvalidMapName;
        }
        if (!new File(map.imageName).exists()) {
            return ParseResult.InvalidMapImage;
        }
        return ParseResult.Success;
    }

    public static boolean isMapFile(File file) {
        boolean result = false;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            if (line.startsWith("MAP-VERSION")) {
                result = true;
            }
            br.close();
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void addLocation(MapLocation location) {
        this.locations.add(location);
    }

    static enum ParseResult {
        Success,
        InvalidMapName,
        InvalidMapImage;

    }
}

