/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ColumnPanel;
import gui.HeaderPanel;
import gui.LASConverter;
import gui.TSCreator;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class LASConverterGUI
extends JFrame {
    JPanel combo;
    JFrame f;
    List<ColumnPanel> panelList;
    String inputFile;
    HeaderPanel hp;
    File tempOut = null;
    String tempOutLoc;
    JButton OKButtonTop;
    JButton OKButtonBottom;
    LASConverter lscv = new LASConverter();
    List<String> contentList = new ArrayList<String>();
    List<List<String>> fileList = new ArrayList<List<String>>();
    List<String> units = new ArrayList<String>();
    String ageUnit;
    List<Integer> maxPoints = new ArrayList<Integer>();
    List<String> header = new ArrayList<String>();
    String top;
    String base;
    String scale;
    TSCreator tsGUI = null;
    int col;

    public LASConverterGUI(String inputFilePath, TSCreator ts) {
        int i;
        this.contentList = this.lscv.readfile(inputFilePath);
        this.header = this.lscv.getHeader(this.contentList);
        this.fileList = this.lscv.fileProcessing(this.contentList, this.header);
        this.maxPoints = this.lscv.getMaxPoint(this.fileList);
        this.units = this.lscv.getUnits(this.contentList);
        this.col = this.lscv.getColumnCount(this.units);
        this.top = Double.toString(this.lscv.getTop(this.header));
        this.base = Double.toString(this.lscv.getBase(this.header));
        this.scale = Double.toString(this.lscv.getScale(Double.parseDouble(this.top), Double.parseDouble(this.base)));
        this.ageUnit = this.lscv.getAgeUnit(this.units.get(0));
        this.units.remove(0);
        this.combo = new JPanel();
        this.combo.setLayout(new BoxLayout(this.combo, 3));
        this.f = new JFrame("Log ASCII Converter");
        JSeparator js = new JSeparator();
        this.panelList = new ArrayList<ColumnPanel>();
        this.hp = new HeaderPanel();
        this.inputFile = inputFilePath;
        File f = new File(inputFilePath);
        for (i = 0; i < this.col; ++i) {
            this.panelList.add(new ColumnPanel());
        }
        this.hp.fileNameLabel.setText(f.getName());
        this.hp.ageUnitText.setText(this.ageUnit);
        this.hp.baseText.setText(this.base);
        this.hp.topText.setText(this.top);
        this.hp.scaleText.setText(this.scale);
        this.hp.titleText.setText(f.getName());
        this.OKButtonTop = new JButton("OK");
        this.combo.add(this.OKButtonTop);
        this.combo.add(js);
        this.combo.add(this.hp);
        for (i = 0; i < this.col; ++i) {
            this.panelList.get((int)i).columnLabel.setText(this.units.get(i));
            this.combo.add(this.panelList.get(i));
            this.panelList.get((int)i).titleText.setText(this.units.get(i));
            this.panelList.get((int)i).widthText.setText("400");
            this.panelList.get((int)i).lowText.setText("0");
            this.panelList.get((int)i).highText.setText(String.valueOf(this.maxPoints.get(i)));
            this.panelList.get((int)i).fillColorText.setText("0/0/255");
            this.panelList.get((int)i).colorText.setText("255/255/255");
        }
        this.OKButtonBottom = new JButton("OK");
        this.combo.add(this.OKButtonBottom);
        this.f.add(this.combo);
        this.f.pack();
    }

    public void OKButtonActionPerformed(ActionEvent evt) {
        LASConverter lscv = new LASConverter();
        ArrayList<String> contentList = new ArrayList();
        ArrayList<List<String>> fileList = new ArrayList();
        ArrayList<String> units = new ArrayList();
        List<Object> maxPoints = new ArrayList();
        ArrayList<String> titleList = new ArrayList();
        ArrayList<String> widthList = new ArrayList();
        ArrayList<String> colorList = new ArrayList();
        ArrayList<String> pointList = new ArrayList();
        ArrayList<String> lineList = new ArrayList();
        ArrayList<String> fillList = new ArrayList();
        ArrayList<String> lowList = new ArrayList();
        ArrayList<String> highList = new ArrayList();
        ArrayList<String> smoothedList = new ArrayList();
        titleList = this.getTitleList();
        widthList = this.getWidthList();
        colorList = this.getColorList();
        pointList = this.getPointList();
        lineList = this.getLineList();
        fillList = this.getFillList();
        lowList = this.getLowList();
        highList = this.getHighList();
        smoothedList = this.getSmoothedList();
        try {
            this.tempOut = File.createTempFile("ConvertedLAS", ".txt");
            this.tempOutLoc = this.tempOut.getAbsolutePath();
            contentList = lscv.readfile(this.inputFile);
            List<String> header = lscv.getHeader(contentList);
            fileList = lscv.fileProcessing(contentList, header);
            units = lscv.getUnits(contentList);
            maxPoints = lscv.getMaxPoint(fileList);
            String ageUnit = this.hp.ageUnitText.getText();
            double top = Double.parseDouble(this.hp.topText.getText());
            double base = Double.parseDouble(this.hp.baseText.getText());
            double scale = Double.parseDouble(this.hp.scaleText.getText());
            String title = this.hp.titleText.getText();
            lscv.writeFile(fileList, this.tempOutLoc, units, ageUnit, titleList, widthList, colorList, pointList, lineList, fillList, lowList, highList, smoothedList, top, base, scale, title);
            JOptionPane.showMessageDialog(null, "File was saved successfully!");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Temporary file creation failed!");
            e.printStackTrace();
        }
    }

    public List<String> getTitleList() {
        ArrayList<String> titleList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            titleList.add(this.panelList.get((int)i).titleText.getText());
        }
        return titleList;
    }

    public List<String> getWidthList() {
        ArrayList<String> widthList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            widthList.add(this.panelList.get((int)i).widthText.getText());
        }
        return widthList;
    }

    public List<String> getColorList() {
        ArrayList<String> colorList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            colorList.add(this.panelList.get((int)i).colorText.getText());
        }
        return colorList;
    }

    public List<String> getPointList() {
        ArrayList<String> pointList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            pointList.add(this.panelList.get((int)i).pointCombo.getSelectedItem().toString());
        }
        return pointList;
    }

    public List<String> getLineList() {
        ArrayList<String> lineList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            lineList.add(this.panelList.get((int)i).lineCombo.getSelectedItem().toString());
        }
        return lineList;
    }

    public List<String> getFillList() {
        ArrayList<String> fillList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            fillList.add(this.panelList.get((int)i).fillColorText.getText());
        }
        return fillList;
    }

    public List<String> getLowList() {
        ArrayList<String> lowList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            lowList.add(this.panelList.get((int)i).lowText.getText());
        }
        return lowList;
    }

    public List<String> getHighList() {
        ArrayList<String> highList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            highList.add(this.panelList.get((int)i).highText.getText());
        }
        return highList;
    }

    public List<String> getSmoothedList() {
        ArrayList<String> smoothedList = new ArrayList<String>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            smoothedList.add(this.panelList.get((int)i).smoothedCombo.getSelectedItem().toString());
        }
        return smoothedList;
    }
}

