/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.DataColumn;
import datastore.MetaColumn;
import datastore.PatternManager;
import datastore.RootColumn;
import gui.ImageGenerator;
import gui.Settings;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.svg.SVGDocument;

public class ColumnImageGenerator
extends ImageGenerator {
    ColumnImageGenerator(RootColumn rootColumn, Settings settings, PatternManager patMan) {
        super(rootColumn, settings, patMan);
    }

    public SVGDocument drawColumnImage(DataColumn column) throws ImageGenerator.NoColumnsToDrawException {
        this.reset();
        double borderWidth = Settings.BORDER_WIDTH;
        double halfBorderWidth = borderWidth / 2.0;
        double canvas_Width = 0.0;
        double canvas_Height = 0.0;
        String nameOfFirstRoot = null;
        boolean noRootsSelected = true;
        Set patternUsageHolder = null;
        if (this.patMan != null) {
            patternUsageHolder = this.patMan.getPatternUsageHolder();
        }
        Settings settingsBackup = this.settings;
        Iterator<DataColumn> subRootIter = this.rootCol.getSubColumns();
        while (subRootIter.hasNext()) {
            Settings subSettings;
            DataColumn dc = subRootIter.next();
            if (!(dc instanceof MetaColumn)) continue;
            MetaColumn subRoot = (MetaColumn)dc;
            if (!subRoot.isSelected()) {
                if (nameOfFirstRoot != null) continue;
                nameOfFirstRoot = subRoot.getName();
                continue;
            }
            noRootsSelected = false;
            this.settings = subSettings = settingsBackup.getReadOnlySettings(subRoot.unit);
            DataColumn col = subRoot.getColumnByName(column.getName());
            Object content = null;
            if (!(col instanceof MetaColumn)) {
                throw new ImageGenerator.NoColumnsToDrawException(nameOfFirstRoot, noRootsSelected);
            }
            subRoot = (MetaColumn)col;
            double dataHeight = Math.abs(subSettings.topAge - subSettings.baseAge) * subSettings.unitsPerMY;
            double xOffset = canvas_Width;
            double colWidth = subRoot.getWidth(subSettings, this, dataHeight);
            double colHeaderHeight = subRoot.getHeaderHeight(subSettings, this);
            subRoot.setVariableColoring(subSettings);
            subRoot.drawHeader(this, xOffset + borderWidth, borderWidth, colWidth, colHeaderHeight, subSettings);
            subRoot.drawData(this, xOffset + borderWidth, borderWidth + colHeaderHeight + borderWidth, colWidth, dataHeight, subSettings);
            this.drawRect(xOffset + halfBorderWidth, halfBorderWidth, borderWidth + colWidth + halfBorderWidth - 1.0, borderWidth + colHeaderHeight + borderWidth + dataHeight + halfBorderWidth - 1.0, BORDER_STYLE);
            this.drawLine(xOffset, borderWidth + colHeaderHeight + halfBorderWidth, xOffset + borderWidth + colWidth + borderWidth, borderWidth + colHeaderHeight + halfBorderWidth, BORDER_STYLE);
            double subWidth = colWidth + 2.0 * borderWidth + 1.0;
            double subHeight = colHeaderHeight + dataHeight + 3.0 * borderWidth + 1.0;
            canvas_Width += subWidth;
            if (subRootIter.hasNext()) {
                canvas_Width += Settings.SUB_IMAGE_SPACING;
            }
            canvas_Height = Math.max(canvas_Height, subHeight);
        }
        if (canvas_Width < 4.0) {
            throw new ImageGenerator.NoColumnsToDrawException(nameOfFirstRoot, noRootsSelected);
        }
        this.setCanvasSize(canvas_Width, canvas_Height);
        this.settings = settingsBackup;
        if (this.settings.doPopups) {
            this.addMouseOverTexts(this.settings);
            this.addMouseOverStaticStuff();
        }
        this.addBrowserScript();
        if (this.patMan != null) {
            this.patMan.writePatternsToIG(this, patternUsageHolder);
        }
        return this.doc;
    }
}

